/****************************************************************************

  File                  : fmdata.c	
  Date                  : 3-15-91	
  Description           : Global data for the YM3812 libraries
				

  Progammer(s)          : Don Fowler, Lance Williams	
  Last Modifications    : 	

  Additional Notes      : 

****************************************************************************
               Copyright (c) 1991,  Covox, Inc.  All Rights Reserved      
****************************************************************************/

#include "cvxfmsy.h"

// Global array to store the values written to the am-vig-egtype-ksr-multi registers
BYTE        _fmKSRMULTIReg	[ _SLOTS ]	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 
															 0x00, 0x00, 0x00, 0x00, 0x00,
															 0x00, 0x00, 0x00, 0x00, 0x00   };

// Global array to store the values written to the ksl-tl register
BYTE         _fmKSLTLReg	[ _SLOTS ] 	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 
															 0x00, 0x00, 0x00, 0x00, 0x00,
															 0x00, 0x00, 0x00, 0x00, 0x00   };

// Global array to store the values written to the ar-dr register
BYTE         _fmARDRReg		[ _SLOTS ]	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 
															 0x00, 0x00, 0x00, 0x00, 0x00,
															 0x00, 0x00, 0x00, 0x00, 0x00   };

// Global array to store the values written to the sl-rr register
BYTE         _fmSLRRReg	  [ _SLOTS ]	   = { 0x00, 0x00, 0x00, 0x00, 0x00, 
															 0x00, 0x00, 0x00, 0x00, 0x00, 
															 0x00, 0x00, 0x00, 0x00, 0x00  };

// Global array to store the values written to the f-number low register
BYTE         _fmFNUMReg	 [_MEL_VOICES ]    = { 0x00, 0x00, 0x00, 0x00, 0x00, 
														    0x00, 0x00, 0x00, 0x00   };

// Global array to store the values written to the kon-block register
BYTE         _fmKONBLOCKReg  [_MEL_VOICES ]= { 0x00, 0x00, 0x00, 0x00, 0x00, 
															 0x00, 0x00, 0x00, 0x00   };

// Global array to store the values written to the fb-con register
BYTE         _fmFBCReg       [_MEL_VOICES ]={  0x00, 0x00, 0x00, 0x00, 0x00, 
															 0x00, 0x00, 0x00, 0x00   };

// Global array to store the values written to the ws register
BYTE         _fmWSReg        [_MEL_VOICES ]={  0x00, 0x00, 0x00, 0x00, 0x00, 
														    0x00, 0x00, 0x00, 0x00   };

// Global variable to store the values written to the percussion register
BYTE 	      _fmPercussionRegister		  =    0x00;

// Global array to flag that an instrument has been set for the respective voice
BYTE 	      _fmInstrumentSet[ _TOT_VOICES ]={   0x00, 0x00, 0x00, 0x00,  
															  0x00, 0x00, 0x00, 0x00, 
															  0x00, 0x00, 0x00   };
	
// Global array to flag that an instrument has been turned on
BYTE 	      _fmNoteOn		 [ _TOT_VOICES ]={   0x00, 0x00, 0x00, 0x00,  
															  0x00, 0x00, 0x00, 0x00, 
															  0x00, 0x00, 0x00   };

// Structure for the global parameters in the library
_FM_GLOBAL_DATA   _fmGlobalParameters   ={   0x00, 0x00, 0x00   };


// Array for the slots for the melodic	voices
BYTE _fmMelodicSlots	 [ _MEL_VOICES ][ 2 ] ={
																	 { 0x00, 0x03 },  // Voices 0 - 9	
																	 { 0x01, 0x04 },	
																	 { 0x02, 0x05 },	
																	 { 0x08, 0x0b },	
																	 { 0x09, 0x0c },	
																	 { 0x0a, 0x0d },	
																	 { 0x10, 0x13 },	
																	 { 0x11, 0x14 },	
																	 { 0x12, 0x15 }	
																						};
																	
// Array for the slots for the percussive voices
BYTE _fmPercussiveSlots [ _PERC_VOICES ][ 2 ] = {
																	 { 0x00, 0x03 }, // Voices 0 - 5  	
																	 { 0x01, 0x04 },	
																	 { 0x02, 0x05 },	
																	 { 0x08, 0x0b },	
																	 { 0x09, 0x0c },	
																	 { 0x0a, 0x0d },	
																	 { 0x10, 0x13 }, // Bass Drum	
																	 { 0x14, 0xff }, // Snare Drum	
																	 { 0x12, 0xff }, // Tom Tom	
																	 { 0x15, 0xff }, // Cymbal 	
																	 { 0x11, 0xff } // High Hat	
																					  };
																	

