/****************************************************************************

  File                  : fmnoteon.c	
  Date                  : 3-18-91	
  Description           : Turn a voice on the YM3812 on
				

  Progammer(s)          : Don Fowler, Lance Williams	
  Last Modifications    : 	

  Additional Notes      : 

****************************************************************************
               Copyright (c) 1991,  Covox, Inc.  All Rights Reserved      
****************************************************************************/

#include "cvxfmsy.h"

/****************************************************************************

	Function	 : BYTE fmNoteOn(  BYTE Voice, WORD Freq )

	Parameters: Voice, Frequency
					1.) Voice - The voice to turn on
					2.) Frequency - Block, F-NUM high, F-NUM low    

	Actions	 :	 1.) Check for system initialized
					 2.) Check for instrument defined for voice
					 3.) Check for proper voice for mode
					 4.) Turn on note relative to voice

*****************************************************************************/

WORD fmNoteOn( BYTE Voice, WORD Frequency ) 
{
	// Temporary variable
	BYTE Temp;

	// Check for system initialized 
	if( !_fmGlobalParameters.systemInitialized )
		return( _ERROR_SYSTEM_NOT_INITIALIZED );

	// Check for voice out of range
	if( Voice > _TOT_VOICES )
		return( _ERROR_VOICE_OUT_OF_RANGE );

	// Check for instrument defined for voice
	if( !_fmInstrumentSet[ Voice ] )
		return( _ERROR_INSTRUMENT_NOT_DEFINED );

	// Turn on the instrument relative to the mode
	if( ( !_fmGlobalParameters.mode ) || ( _fmGlobalParameters.mode && Voice < 6 ) )
	{
		// Store the rate in the global registers and or in the kon bit
		_fmFNUMReg		[ Voice ] = ( BYTE )Frequency;

		// Setup to turn the note on
		_fmKONBLOCKReg	[ Voice ] = ( BYTE )( Frequency >> 8 ) | _KON; 

		// Write out the FNUM low
		fmSetRegister( ( _FNUM_L + Voice ), _fmFNUMReg[ Voice ] );

		// Turn the note off
		fmSetRegister( ( _KON_FNUM_H + Voice ), ( _fmKONBLOCKReg[ Voice ] & 0xdf ) );

		// Write the fnum high, block, and kon bit( turn the note on )
		fmSetRegister( ( _KON_FNUM_H + Voice ), _fmKONBLOCKReg[ Voice ] );

		// Set the note on for voice flag
		_fmNoteOn[ Voice ] = _TRUE;

		return( _ERROR_NONE );
	}
	else
	{
		// Check for bass drum
		if( Voice == _BASS_DRUM )
		{
			// Store the rate in the global registers and or in the kon bit
			_fmFNUMReg		[ Voice ] = ( BYTE )Frequency;
			_fmKONBLOCKReg	[ Voice ] = ( BYTE )( Frequency >> 8 ); 

			// Write out the FNUM low
			fmSetRegister( ( _FNUM_L + Voice ), _fmFNUMReg[ Voice ] );

			// Write the fnum high, block, and kon bit( turn the note on )
			fmSetRegister( ( _KON_FNUM_H + Voice ), _fmKONBLOCKReg[ Voice ] );
	
			// And off the bit value for the bass drum from the global register
			_fmPercussionRegister &= 0xef;

			// Set the register( turn the bass drum off )
			fmSetRegister( _PERC, _fmPercussionRegister );

			// Or the bit value for the bass drum into the global register
			_fmPercussionRegister |= 0x10;

			// Set the register
			fmSetRegister( _PERC, _fmPercussionRegister );

			// Set the note on for voice flag
			_fmNoteOn[ _BASS_DRUM ] = _TRUE;

			return( _ERROR_NONE );
		}
		// Check for snare drum
		else if( Voice == _SNARE_DRUM )
		{
			// And off the bit value for the snare drum from the global register
			_fmPercussionRegister &= 0xf7;

			// Set the register( turn the snare drum off )
			fmSetRegister( _PERC, _fmPercussionRegister );

			// Or the bit value for the snare drum into the global register
			_fmPercussionRegister |= 0x08;

			// Set the register
			fmSetRegister( _PERC, _fmPercussionRegister );

			// Set the note on for voice flag
			_fmNoteOn[ _SNARE_DRUM ] = _TRUE;

			return( _ERROR_NONE );
		}
		// Check for tom drum
		else if( Voice == _TOM )
		{
			// And off the bit value for the tom drum from the global register
			_fmPercussionRegister &= 0xfb;

			// Set the register( turn the tom drum off )
			fmSetRegister( _PERC, _fmPercussionRegister );

			// Or the bit value for the tom drum into the global register
			_fmPercussionRegister |= 0x04;

			// Set the register
			fmSetRegister( _PERC, _fmPercussionRegister );

			// Set the note on for voice flag
			_fmNoteOn[ _TOM ] = _TRUE;

			return( _ERROR_NONE );
		}
		// Check for cymbal
		else if( Voice == _CYMBAL )
		{
			// And off the bit value for the cymbal from the global register
			_fmPercussionRegister &= 0xfd;

			// Set the register( turn the cymbal off )
			fmSetRegister( _PERC, _fmPercussionRegister );

			// Or the bit value for the cymbal into the global register
			_fmPercussionRegister |= 0x02;

			// Set the register
			fmSetRegister( _PERC, _fmPercussionRegister );

			// Set the note on for voice flag
			_fmNoteOn[ _CYMBAL ] = _TRUE;

			return( _ERROR_NONE );
		}
		// Check for high hat
		else if( Voice == _HIGH_HAT )
		{
			// And off the bit value for the high hat from the global register
			_fmPercussionRegister &= 0xfe;

			// Set the register( turn the high hat off )
			fmSetRegister( _PERC, _fmPercussionRegister );

			// Or the bit value for the high hat into the global register
			_fmPercussionRegister |= 0x01;

			// Set the register
			fmSetRegister( _PERC, _fmPercussionRegister );

			// Set the note on for voice flag
			_fmNoteOn[ _HIGH_HAT ] = _TRUE;

			return( _ERROR_NONE );
		}
		else
			return( _ERROR_INVALID_INSTRUMENT );
	}
}

