// File        : utilhead.c
//
// Description : Function to parse header and return buffer format
//               and playback rate.
//               
//
// Written by : Ryan Hanlon
// Date       : Feb 19, 1992
//
//----------------------------------------------------------------------------
//             Copyright (c) 1992, Covox, Inc. All Rights Reserved                   
//----------------------------------------------------------------------------

#include "cvxdigi.h"
#include "cvxutil.h"

VOID cvxHeaderParse( LPSTR buffer, BYTE * bufferFormat, BYTE * playbackRate )
{
   static BYTE  covoxHeaderID[]    = { 0xFF,0x55,0xFF,0xAA,0xFF,0x55,0xFF,0xAA };
   static BYTE  covoxVMFHeaderID[] = { 0x47,0x45,0x56,0x41,0x54,0x4F,0x53,0x4B,0x59 };
   static BYTE  vocHeaderID[]      = { 0x43,0x72,0x65,0x61,0x74,0x69,0x76,0x65,0x20,0x56,0x6F,0x69,0x63,0x65,0x20,0x46,0x69,0x6C,0x65,0x1A};

   WORD i;

   // Initialize the returned values.
   //
   *bufferFormat = 0;
   *playbackRate = 0;

   // Test for presence of Covox header in buffer.
   //
   for(i = 0; i < sizeof(covoxHeaderID) ; i++)
      if( *( ( HPSTR )buffer + i ) != ( BYTE )covoxHeaderID[i] )
         break;

   // Standard Covox header found in buffer?
   //
   if( i == sizeof(covoxHeaderID) )
   {
      // Set buffer format variable.
      if( !(*bufferFormat) )
         *bufferFormat = *( ( HPSTR )buffer + _HEADER_FORMAT_OFFSET );

      // Set playback rate.
      if( !(*playbackRate) ) 
         *playbackRate = *( ( HPSTR )buffer + _HEADER_RATE_OFFSET );
   }
   else
   {
      // Check for presence of old covox .VMF header.
      //
      for( i=0; i < sizeof(covoxVMFHeaderID) ; i++ )
      {
         // Buffer offset zero so no chance of roll over.
         //
         if( *( ( HPSTR )buffer + i + _HEADER_ID_VMF_OFFSET ) != ( BYTE )covoxVMFHeaderID[ i ] )
            break;
      }
   
      if( i == sizeof(covoxVMFHeaderID) )
      {
         // Covox .VMF header found.
         //
         if( !(*playbackRate) )
         {
            // The location of the rate in a covox .VMF header is
            // byte 4
            //
            ( BYTE )(*playbackRate) = *( ( HPSTR )buffer + _HEADER_RATE_VMF_OFFSET );

            if( !(*playbackRate) )
               ( BYTE )(*playbackRate) = ( BYTE )_CVX_RATE_DEFAULT;
         }
          
         if( !(*bufferFormat) )
         {
            // Set format of sound buffer.
            ( BYTE )(*bufferFormat) = ( BYTE )_FORMAT_VMF;
         }

      }
      else
      {
         // Check for presence of .VOC header. 
         //
         for( i=0; i < sizeof(vocHeaderID) ; i++ )
         {
            // Buffer offset zero so no chance of roll over.
            //
            if( *( ( HPSTR )buffer + i ) != ( BYTE )vocHeaderID[ i ] )
               break;
         }
      
         if( i == sizeof( vocHeaderID ) )
         {
            // Set format and return 
            //
            *bufferFormat = ( BYTE )_FORMAT_VOC;


            // If we find block type 1 in VOC header then 
            // rate is at position 30.
            //
            if( *(buffer + 0x1A) == 0x01 )
            {
               // Get the rate from the header.
               *playbackRate  =  ( BYTE )*( ( HPSTR )buffer + 0x1E );
            }
         }
      }
   }
      
   // Set buffer format variables.
   //
   if( !(*bufferFormat) )
     ( BYTE )(*bufferFormat) = ( BYTE )_FORMAT_V8;
            
   // Set playback rate.
   //
   if( !(*playbackRate) ) 
      ( BYTE )(*playbackRate) = ( BYTE )_CVX_RATE_DEFAULT;
 

} 
