/****************************************************************************
*
*  File              : UTILMEM.C
*  Date Created      : 1/18/92
*  Description       : 
*                      
*
*  Programmer(s)     : Ryan Hanlon
*  Last Modification : 
*
*  Additional Notes  :
*
*****************************************************************************
*            Copyright (c) 1992,  Covox, Inc.  All Rights Reserved          *
****************************************************************************/

#include <dos.h>
#include "cvxutil.h"

// Function to allocate a block of memory using int 21h ah=48
//
LPSTR cvxBufferAlloc  ( LONG bufferSize, PLONG bytesAvailable )
{
   LONG   tempSize = 0L;
   WORD   tempSeg  = _NULL;
   LPSTR  buffer   = _NULL;
 
   BYTE   errorValue;

   // Find largest block of memory available in system.
   _asm   mov   ax, 4800h
   _asm   mov   bx, 0FFFFh
   _asm   int   21h
   _asm   mov   WORD PTR tempSize, bx


   // Max number of segments available in system.
   ( LONG )*bytesAvailable = ( LONG )tempSize;

   // Calculate number of pages to allocate.
   tempSize = ( LONG )( (( LONG )bufferSize >> 4 ) + 1L);

   // If largest block in system is smaller than reqested then
   // return error.
   if( *bytesAvailable >= tempSize )
   {
      // Allocate reqested memory
      _asm   mov   ax, 4800h               // Allocate memory block
      _asm   mov   bx, WORD PTR tempSize   // requires size in BX.
      _asm   int   21h
         
      _asm   mov   tempSeg, ax             // Save segment.

      _asm   lahf                          // Get state of carry flag.
      _asm   and   ah, 1                   //
      _asm   mov   errorValue, ah         //
   
      // If no error during alloc then point segment to buffer.
      //
      if( errorValue == ( BYTE )_ERROR_NONE )
      {
         FP_OFF( buffer ) =  0;
         FP_SEG( buffer ) =  tempSeg;
      }
   }

   // Convert from paragraphs to bytes.
   ( LONG )(*bytesAvailable) = ( LONG )( ((LONG)(*bytesAvailable) - 1L) << 4 );

   return( buffer );
}

// Function to remove allocated block of memory from system.
//
WORD  cvxBufferFree ( LPSTR buffer )
{
   WORD returnValue;
   WORD tempSeg;

   // Move segment of memory into variable accessable to
   // in-line assembly.
   //
   tempSeg = FP_SEG( buffer );

   // Make call to free memory.
   _asm   mov   ah, 49h             // Release memory block
   _asm   mov   es, tempSeg         // requires segment in es.
   _asm   int   21h

   _asm   lahf                      // Get state of carry flag.
   _asm   and   ah, 1               //
   _asm   xor   al, al
   _asm   mov   returnValue, ax     //
  
   return( returnValue );
}
