/****************************************************************************
*
*  File              : UTILRATE.C
*  Date Created      : 1/18/92
*  Description       : 
*                      
*
*  Programmer(s)     : Ryan Hanlon
*  Last Modification : 
*
*  Additional Notes  :
*
*****************************************************************************
*            Copyright (c) 1992,  Covox, Inc.  All Rights Reserved          *
****************************************************************************/

#include "cvxdigi.h"

// Function to convert from the Covox rate to a rate in Hertz.
//
WORD cvxRateToHz( BYTE rateCovox )
{
  if( rateCovox > _CVX_RATE_OUT_MAXIMUM )
  {
    return( 0 );
  }

  return ( (WORD)( 1193180L / (256L - (LONG)rateCovox) ) );

}


// Function to convert a sample rate in Hertz to the Covox rate
// of 1 to 229.
//
BYTE cvxHzToRate( WORD rateHertz )
{
  if( (rateHertz > 44191) || (rateHertz < 4679) )
  {
    return( 0 );
  }

  return ( (BYTE)( 256L - (1193180L / (LONG)rateHertz ) ) );

}
