65000 ' ******************************************************************
65001 ' *             FINDER.BAS - vector finder subroutine              *
65002 ' * This is a subroutine that will find the interrupt vector of    *
65003 ' * the COVOX TSR program that is specified in the string variable *
65004 ' * PROG.NAME$. After MERGING this subroutine with the main BASIC  *
65005 ' * program, call it by simply executing a GOSUB 65000.  See your  *
65006 ' *              "User Manual" for complete details.               *
65007 ' ******************************************************************
65008 '
65009 CLS:PRINT:PRINT"One moment please..."
65010 ' On Entry PROG.NAME$ = Name of the COVOX program to search for.
65011 '
65012 ' Convert any lower case letters of the program name to upper case.
65013 FOR C=1 TO LEN(PROG.NAME$)
65014 L=ASC(MID$(PROG.NAME$,C,1))
65015 IF L>96 THEN L=L-32:MID$(PROG.NAME$,C,1)=CHR$(L)
65016 NEXT C
65017 '
65018 '
65019 ' Search vectors 64 through 127 for the COVOX program address.
65020 FOR VECTOR=(64 * 4) TO (127* 4) STEP 4
65021 DEF SEG=0:' Set to segment zero in order to access vector table.
65022 '
65023 ' Get the segment & offset values for the vector.
65024 OUR.OFFSET =PEEK(VECTOR + 0) + (256 * PEEK(VECTOR + 1))
65025 OUR.SEGMENT=PEEK(VECTOR + 2) + (256 * PEEK(VECTOR + 3))
65026 '
65027 ' If the value for the segment is not valid then look at the next vector.
65028 IF OUR.SEGMENT=0 OR OUR.SEGMENT >65024! THEN 65043
65029 '
65030 ' A segment value was found, so set BASIC's data segment accordingly.
65031 DEF SEG=OUR.SEGMENT
65032 ' Now search for the COVOX program name at the offset address.
65033 ' Each character of the program's name is compared and a flag (FOUND)
65034 ' is set to zero if there is not a complete match.
65035 PROG.FOUND=1:FOR C=0 TO LEN(PROG.NAME$)-1
65036 IF PEEK(OUR.OFFSET+C)<> ASC(MID$(PROG.NAME$,C+1,1)) THEN PROG.FOUND=0
65037 NEXT C:' Compare next character.
65038 '
65039 IF PROG.FOUND=1 THEN 65052:' If this is the vector for the COVOX program,
65040 ' then continue on with the main code of the BASIC program.
65041 '
65042 ' If this was not the COVOX program's vector then
65043 NEXT VECTOR:' examine the next vector location.
65044 '
65045 ' If the COVOX program's vector was not found, the following message
65046 ' is displayed and the BASIC program is terminated.
65047 '
65048 PRINT:PRINT:PRINT PROG.NAME$;" has not been installed in memory."
65049 PRINT"You must exit BASIC and load ";PROG.NAME$;" from the DOS prompt.":PRINT"Then RUN this program again."
65050 END:' Terminate the program.
65051 '
65052 RETURN :' Go back to the main BASIC program.
65053 ' ********************************************************************
