/*
	Sample program for using LOADPLAY.EXE with C programming language.

	Using: MicroSoft Quick C ver 1.0
	       compile with EXE option set.

*/

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <conio.h>

struct BasicStringDescriptor {
	unsigned short length;
	char near *pointer;
	};
/*
*       Data Area
*/

	unsigned char far *byte_pointer;
	unsigned short far *word_pointer;
	void (far pascal *function_pointer)();
	char loadplay_name[] = "LOADPLAY.EXE";
	unsigned short LoadPlaySegment;
	struct BasicStringDescriptor DataString;
	char DataFile[ ] = "CALC.VMF";
	short volume = 8;       /* 1-8 with 1 low and 8 high */
	short speed  = 243;     /* 1-255 with 1 slow and 255 fast */
	short wrap   = 0;       /* 0 for continuous or 1-255 for number of repeats */

/*
*                               Finder subroutine
*       This is a function that will find the interrrupt vector of
*       the COVOX TSR program that is passed in the string prog_name.
*       This function returns a zero if vector not found else it return the
*       segment of the TSR.
*/
unsigned int find_vector(char prog_name[])
{
	int j;
	unsigned short vector,segment,offset;
	unsigned short far *pointer;
	char far *char_pointer;

	/* Search vectors 64 through 127 for the COVOX program address */
	for(vector = 64 * 4 ; vector < 127 * 4 ; vector += 4){
	  pointer = (unsigned short far *)(long)vector;
	  /* Get the segment and offset values for the vector */
	  offset = *pointer;
	  segment = *(pointer + 1);
	  /* if the value of the segment is not valid then try again */
	  if((segment == 0) || (segment > 65024))
	    continue;
	  /* A segment value was found, so see if correct */
	  char_pointer = (char far *)((((long)segment) * 0x10000) + offset);
	  /* Now search for the program name at the offset address */
	  for( j = 0 ; j < strlen(prog_name) ; j++){
	    if(toupper(*(char_pointer+j)) != toupper(prog_name[j]))
	      goto next_vector;
	  }
	  /* if you get to this point there is a good match */
	  return(segment);
next_vector:;
	  /* get here if no match */
	}
	/* return zero because no match */
	return(0);
}

/*
* Main line of program
*/
int main(void)

{
	unsigned int word;

	printf("This is a program which demonstrates using LOADPLAY.EXE with C.\n");
	printf("Before using this program, LOADPLAY must be initialized and resident\n");
	printf("in memory. In order to do so, simply type LOADPLAY at the DOS prompt.\n");
	printf("Also, the file CALC.VMF must be present on the current drive and directory.\n");


	LoadPlaySegment = find_vector(loadplay_name);

	if(LoadPlaySegment == 0){
	  printf("\n\n%s has not been installed in memory.",loadplay_name);
	  printf("\nLoad %s from the DOS prompt. Then RUN this program again.",
	      loadplay_name);
	  goto EndMain;
	}

	DataString.length = strlen(DataFile);
	DataString.pointer = DataFile;
	byte_pointer = (char far *) (((long)LoadPlaySegment) * 0x10000L);
	*(byte_pointer+14) = 0x02;      /* set loadplay for 4 byte string discrpture */

	function_pointer = (void far *)(((long)LoadPlaySegment) * 0x10000L);
	(*function_pointer)(&DataString);
	if(*(byte_pointer+12) != 255) {
	  printf("Disk error #%d has occurred!",*(byte_pointer+12));
	  goto EndMain;
	}

	printf("\n\n\n\nPress any key to HALT playback\n");
	function_pointer = (void far *)((((long)LoadPlaySegment) * 0x10000L) + 3);
	while(!kbhit())
	  (*function_pointer)(&volume,&speed,&wrap);

EndMain:;
	return(0);
} /* end main */



