
{...}

USES DMA;

CONST

  DMA_    = 1;                              { erster DMA-Controller (DMA 1) }
  Channel = 1;                                                { DMA-Kanal 1 }

{===========================================================================}
{ Prozedur InputViaDMA: Ein Beispiel fr eine Routine zur Programmierung    }
{                       des DMA-Controllers (Kanal 1) fr die VOICE-Eingabe }
{                       (Sampling).                                         }
{===========================================================================}
{ Eingabe: Addr  = Anfangsadresse (in Form eines Zeigers) fr die Sample-   }
{                  Daten                                                    }
{          Bytes = Anzahl der zu bertragenden Datenbytes                   }
{ Ausgabe: keine                                                            }
{---------------------------------------------------------------------------}

PROCEDURE InputViaDMA(Addr : Pointer; Bytes : Word);

BEGIN
  SetMaskBit(DMA_, Channel);                  { Kanal 1 maskieren (sperren) }
  SetDMAMode(DMA_, Channel,                               { DMA-Modi setzen }
    dma_ModeReg_Write+                     { Schreiben in den Hauptspeicher }
    dma_ModeReg_AutoInitOn+                  { automatische Initialisierung }
    dma_ModeReg_IncAddr+   { Speicheradr. nach jedem Schreibvorgang erhhen }
    dma_ModeReg_BlockMode);                                    { Blockmodus }
  SetAddrAndSideReg(DMA_, Channel, Addr);           { Anfangsadresse setzen }
  SetBaseCountReg(DMA_, Channel, Bytes);     { Anzahl der Datenbytes setzen }
  ClearMaskBit(DMA_, Channel);                   { Kanal 1 wieder freigeben }

  {...}                         { hier mu noch der DSP programmiert werden }

  StartDMA(DMA_, Channel);                   { DMA-Datenbertragung starten }
END;

{===========================================================================}
{ Prozedur OutputViaDMA: Ein Beispiel fr eine Routine zur Programmierung   }
{                        des DMA-Controllers (Kanal 1) fr die VOICE-Aus-   }
{                        gabe. Die Sample-Daten mssen sich im Hauptspei-   }
{                        cher befinden.                                     }
{===========================================================================}
{ Eingabe: Addr  = Anfangsadresse (in Form eines Zeigers) fr die Sample-   }
{                  Daten                                                    }
{          Bytes = Anzahl der zu bertragenden Datenbytes                   }
{ Ausgabe: keine                                                            }
{---------------------------------------------------------------------------}

PROCEDURE OutputViaDMA(Addr : Pointer; Bytes : Word);

BEGIN
  SetMaskBit(DMA_, Channel);                  { Kanal 1 maskieren (sperren) }
  SetDMAMode(DMA_, Channel,                               { DMA-Modi setzen }
    dma_ModeReg_Read+      { Lesen aus dem Hauptspeicher und zum DSP senden }
    dma_ModeReg_AutoInitOn+                  { automatische Initialisierung }
    dma_ModeReg_IncAddr+      { Speicheradr. nach jedem Lesevorgang erhhen }
    dma_ModeReg_BlockMode);                                    { Blockmodus }
  SetAddrAndSideReg(DMA_, Channel, Addr);           { Anfangsadresse setzen }
  SetBaseCountReg(DMA_, Channel, Bytes);     { Anzahl der Datenbytes setzen }
  ClearMaskBit(DMA_, Channel);                   { Kanal 1 wieder freigeben }

  {...}                         { hier mu noch der DSP programmiert werden }

  StartDMA(DMA_, Channel);                   { DMA-Datenbertragung starten }
END;

{...}
