
{===========================================================================}
{ Konzept        : DATA BECKERs Sound Blaster Superbuch                     }
{ Prog. IntrVec  : Ein Beispielprogramm, das zeigt, wie man einen Inter-    }
{                  rupt-Vektor umleitet (in dem Fall Timer-Interrupt, das   }
{                  hufig in Verbindung mit der Sound-Blaster-Programmie-   }
{                  rung umgeleitet wird).                                   }
{===========================================================================}
{ Autor          : Arthur Burda                                             }
{ Dateiname      : INTRVEC.PAS                                              }
{ entwickelt am  : 20.07.1993                                               }
{ letztes Update : 01.09.1993                                               }
{ Version        : 1.01                                                     }
{ Compiler       : Turbo Pascal 6.0 und hher                               }
{===========================================================================}

PROGRAM IntrVec;

USES CRT, DOS;                                { CRT- und DOS-Unit einbinden }

VAR
  TimerOld : Pointer;                               { alter Timer-Interrupt }
  Count    : Word;                                             { ein Zhler }

{===========================================================================}
{ Prozedur NewTimerInt: Neuer Timer-Interrupt                               }
{===========================================================================}
{ Eingabe: keine                                                            }
{ Ausgabe: keine                                                            }
{---------------------------------------------------------------------------}

PROCEDURE NewTimerInt; INTERRUPT;

BEGIN
  IF Count = 100 THEN                                    { Zhlerstand 100? }
    WriteLn('Timer-Handler wird wieder auf Standard-Routine gesetzt.') { ja }
  ELSE                                                 { nein, Count <> 100 }
    WriteLn('Benutzerdefinierter Timer-Handler ist installiert.');
  Inc(Count);                                         { Zhler um 1 erhhen }
  Port[$20] := $20;                             { Interrupt-Routine beenden }
END;

{---------------------------------------------------------------------------}
{ Hauptprogramm                                                             }
{---------------------------------------------------------------------------}

BEGIN
  ClrScr;                                              { Bildschirm lschen }
  Count := 0;                                         { Zhler auf 0 setzen }
  GetIntVec($08, TimerOld);                    { alten Timer-Vektor sichern }
  SetIntVec($08, @NewTimerInt);                { neuen Handler installieren }

  { wiederholen, bis Count > 100 }

  REPEAT
  UNTIL Count > 100;

  SetIntVec($08, TimerOld);                     { alten Timer-Vektor setzen }
END.
