
/*=========================================================================*/
/* Konzept        : DATA BECKERs Sound Blaster Superbuch                   */
/* Programm Timer : Ein einfaches Beispiel fr die Timer-Programmierung    */
/*=========================================================================*/
/* Autor          : Arthur Burda                                           */
/* Dateiname      : TIMER.C                                                */
/* entwickelt am  : 20.07.1993                                             */
/* letztes Update : 01.09.1993                                             */
/* Version        : 1.01                                                   */
/* Compiler       : Turbo C, Turbo C++, Borland C++                        */
/*=========================================================================*/

#include <stdio.h>
#include <conio.h>

/*-------------------------------------------------------------------------*/
/* main: Hauptprogramm                                                     */
/*-------------------------------------------------------------------------*/

void main()

{
  int Freq;                                               /* akt. Frequenz */
  int Factor;                             /* Frequenz-Faktor fr den Timer */

  clrscr();                                          /* Bildschirm lschen */
  outportb(0x43, 0x36);                                    /* Steuerbefehl */
  for (Freq = 100; Freq <= 2000; Freq++) /* Frequenzen von 100 bis 2000 Hz */
    {
      Factor = 1193180/Freq;                  /* Frequenz-Faktor bestimmen */
      outportb(0x40, Factor & 0xFF); /* Low-Byte fr den Timer-Wert setzen */
      outportb(0x40, (Factor >> 0x08) & 0xFF);         /* High-Byte setzen */
      printf("Akt. Frequenz: %2d Hz    Faktor: %2d", Freq, Factor);
      printf("\n");
    }

  /* Original-Frequenz von 18,2 Hz einstellen */

  Factor = 0xFFFF;
  outportb(0x40, Factor & 0xFF);        /* Low-Byte fr die Timer-Frequenz */
  outportb(0x40, (Factor >> 0x08) & 0xFF);                    /* High-Byte */
};
