             .286
DATA         SEGMENT BYTE PUBLIC
             Assume DS:DATA

      MpxInt equ 2Fh                   ; Multiplex-Interrupt

EXTRN XMSDrv    : dword                ; Einsprungadresse XMS-Treiber
EXTRN XMSResult : byte                 ; Fehlerkode bei XMM-Aufrufen

DATA         ENDS


; ----- Routinen -------------------------------------------------------------

CODE         SEGMENT WORD PUBLIC
             Assume CS:CODE
             PUBLIC MPXCall            ; Multiplex-Interrupt-Funktionsaufruf
             PUBLIC XMSCall  ; MM-Funktionsaufrufe


; ----------------------------------------------------------------------------
; MPXCall - Aufruf einer Multiplex-Interrupt-Funktion
; ----------------------------------------------------------------------------

; Pascal-Deklaration: procedure MPXCall(var XRegs : xregisters);

; Der in der bergebenen Recordvariablen enthaltene Wert fr AX wird in das
; entsprechende CPU-Register geladen. Danach erfolgt ein Aufruf des
; Multiplex-Interrupts 2Fh. Anschlieend werden die entsprechenden CPU-
; Register fr AX, BX und ES wieder in die Recordvariable zurckgeschrieben.
; Das ES-Register wird in XRegs.SI abgelegt!

MPXCall      PROC NEAR

             push bp
             mov  bp,sp

             les  di,[bp+4]            ; Adresse des Parameters
             mov  ax,es:[di]           ; Inhalt von XRegs.ax in AX

             int  MPXInt               ; Aufruf des Mpx-Interrupts

             mov  si,es                ; ES-Registerergebnis in SI
             les  di,[bp+4]            ; Adresse des Parameters
             mov  es:[di],ax           ; Inhalt von AX in XRegs.ax
             mov  es:[di+2],bx         ; Inhalt von BX in XRegs.bx
             mov  es:[di+6],si         ; Inhalt von SI (=ES) in XRegs.si

             pop  bp
             ret  4h

MPXCall      ENDP


; ----------------------------------------------------------------------------
; XMSCall - Aufruf einer XMM-Funktion
; ----------------------------------------------------------------------------

; Pascal-Deklaration: procedure XMSCall(var XRegs : xregisters);

; Die in der bergebenen Recordvariablen enthaltenen Werte werden in die
; einzelnen CPU-Register geladen. Danach erfolgt ein Aufruf des XMM ber
; indirekten far Call. Die Einsprungadresse mu dazu in der Variablen XMSDrv
; abgelegt sein. Danach werden die entsprechenden CPU-Registerergebnisse
; wieder in die Recordvariable zurckgeschrieben.
; Ein eventueller, vom XMM zurckgelieferter Fehlerkode wird in der globalen
; Variablen XMSResult gespeichert.

XMSCall      PROC NEAR

             push bp
             mov  bp,sp

             les  di,[bp+4]            ; Adresse des Parameters
             mov  ax,es:[di]           ; Inhalt von XRegs.ax in AX
             mov  bx,es:[di+2]         ; Inhalt von XRegs.bx in BX
             mov  dx,es:[di+4]         ; Inhalt von XRegs.dx in DX
             mov  si,es:[di+6]         ; Inhalt von XRegs.si in SI

             call [XMSDrv]             ; Aufruf XMS-Funktion

             cmp  ax,0                 ; Fehler aufgetreten?
             jne  XMSCall_1            ; Sprung, wenn nein
             mov  XMSResult,bl         ; Fehlerkode festhalten

XMSCall_1:   les  di,[bp+4]            ; Adresse des Parameters
             mov  es:[di],ax           ; Inhalt von AX in XRegs.ax
             mov  es:[di+2],bx         ; Inhalt von BX in XRegs.bx
             mov  es:[di+4],dx         ; Inhalt von DX in XRegs.dx
             mov  es:[di+6],si         ; Inhalt von SI in XRegs.si

             leave
             ret  4h

XMSCall      ENDP

CODE         ENDS

             END
