/********************************************************************************
*-------------------------------------------
* COPYRIGHT (c) GUILLEMOT CORPORATION. 1999
*-------------------------------------------
*			     _______________
*				|	            |
*				|	API ISIS    | 
*				|_______________|
*				
*	
*		To use these API in an application, add the directive :
*		#include "Isis32Api.h" in your source code (for compilation)	
*		and, add the file GC0079X.lib to your project
*
***********************************************************************************/

typedef  WORD ISISRESULT;


// Constant values

// Dream Error Codes

#define ISISERR_NOERROR				0
#define ISISERR_UNREF				1
#define ISISERR_OUTOFMEM			2
#define ISISMERR_INVADD				3
#define ISISERR_INVCOUNT			4
#define ISISERR_ABORT				5
#define ISISERR_NOTSUPPORTED		6
#define ISISERR_INVCOM				7
#define ISISERR_FILENOTFOUND		8
#define	ISISERR_CANNOTDELETE		9

// Error codes for bankLoad Function
//

#define ISIS_BANK_LOAD_ERROR_MASK						0xFFF0
#define ISIS_BANK_LOAD_BANKNB_MASK						0x000F

#define ISIS_BANK_LOAD_ERROR_OFFSET						0x0010
#define ISIS_BANK_LOAD_UNKNOWN_ERROR					ISIS_BANK_LOAD_ERROR_OFFSET
#define ISIS_BANK_LOAD_RMI_NO_SNDBNK					(ISIS_BANK_LOAD_ERROR_OFFSET + 0x01)
#define ISIS_BANK_LOAD_HARDWARE_NOT_RESPONDING			(ISIS_BANK_LOAD_ERROR_OFFSET + 0x02)
#define ISIS_BANK_LOAD_INVALID_FILE_FORMAT_PRIO_CHUNK	(ISIS_BANK_LOAD_ERROR_OFFSET + 0x03)
#define ISIS_BANK_LOAD_INVALID_FILE_FORMAT_IMAP_CHUNK	(ISIS_BANK_LOAD_ERROR_OFFSET + 0x04)
#define ISIS_BANK_LOAD_MEM_MAP_ADD_NOT_FOUND			(ISIS_BANK_LOAD_ERROR_OFFSET + 0x05)
#define ISIS_BANK_LOAD_BAD_MEM_MAP_SIZE					(ISIS_BANK_LOAD_ERROR_OFFSET + 0x06)
#define ISIS_BANK_LOAD_CANT_INSERT_MIDI_MAP_BLOCK		(ISIS_BANK_LOAD_ERROR_OFFSET + 0x07)
#define ISIS_BANK_LOAD_FILE_NOT_FOUND					(ISIS_BANK_LOAD_ERROR_OFFSET + 0x08)// See DREAMERR_FILE_NOT_FOUND for compatibility.
#define ISIS_BANK_LOAD_CANT_REALLOC_MEM_MAP				(ISIS_BANK_LOAD_ERROR_OFFSET + 0x09)
#define ISIS_BANK_LOAD_8_SNDBNK_IN_MEM					(ISIS_BANK_LOAD_ERROR_OFFSET + 0x0A)
#define ISIS_BANK_LOAD_CANT_ALLOC_BLOCK_LIST			(ISIS_BANK_LOAD_ERROR_OFFSET + 0x0B)
#define ISIS_BANK_LOAD_ERROR_WHILE_SEEKING_PARAMS		(ISIS_BANK_LOAD_ERROR_OFFSET + 0x0C)
#define ISIS_BANK_LOAD_CANT_DO_REALLOC					(ISIS_BANK_LOAD_ERROR_OFFSET + 0x0D)
#define ISIS_BANK_LOAD_CARD_MEM_TRANSFER_ERROR			(ISIS_BANK_LOAD_ERROR_OFFSET + 0x0E)
#define ISIS_BANK_LOAD_ERROR_WHILE_SEEKING_PCM			(ISIS_BANK_LOAD_ERROR_OFFSET + 0x0F)
#define ISIS_BANK_LOAD_NO_MIDI_MAP_BLOCK				(ISIS_BANK_LOAD_ERROR_OFFSET + 0x10)
#define ISIS_BANK_LOAD_CANT_ALLOC_MIDI_MAP				(ISIS_BANK_LOAD_ERROR_OFFSET + 0x11)
#define ISIS_BANK_LOAD_INVALID_FILE_FORMAT_SB_NAME		(ISIS_BANK_LOAD_ERROR_OFFSET + 0x12)
#define ISIS_BANK_LOAD_CANT_ALLOC_INST_TAB				(ISIS_BANK_LOAD_ERROR_OFFSET + 0x13)
#define ISIS_BANK_LOAD_CANT_ALLOC_BKP_INST_TAB			(ISIS_BANK_LOAD_ERROR_OFFSET + 0x14)
#define ISIS_BANK_LOAD_ERROR_WHILE_SPLITTING_MIDI_MAP	(ISIS_BANK_LOAD_ERROR_OFFSET + 0x15)
#define ISIS_BANK_LOAD_ERROR_WHILE_REDOING_MIDI_MAP		(ISIS_BANK_LOAD_ERROR_OFFSET + 0x16)
#define ISIS_BANK_LOAD_ERROR_WHILE_NOTIFYING_MEM_MAP_CHGE (ISIS_BANK_LOAD_ERROR_OFFSET + 0x17)
#define ISIS_BANK_LOAD_ERROR_WHILE_SEEKING_SAMPLES		(ISIS_BANK_LOAD_ERROR_OFFSET + 0x18)
#define ISIS_BANK_LOAD_ERROR_IN_MEMOR_ALLOC				(ISIS_BANK_LOAD_ERROR_OFFSET + 0x19)
#define ISIS_BANK_LOAD_BLOCK_TO_LARGE_FOR_AVAILABLE_MEM	(ISIS_BANK_LOAD_ERROR_OFFSET + 0x1A)
#define ISIS_BANK_LOAD_ERROR_IN_MEMOR_UPDATE_MEM_BLOCK	(ISIS_BANK_LOAD_ERROR_OFFSET + 0x1B)
#define ISIS_BANK_LOAD_MORE_THAN_2_PAGES_PARAMS			(ISIS_BANK_LOAD_ERROR_OFFSET + 0x1C)

// Option for IsisBankUnload
#define ISIS_BANK_UNLOAD_ALL	0xFFFF

// Option for IsisHwReset
#define FIHR_DEFAULT						0x00
#define IHRF_DONT_LOAD_FIRMWARE				0x01
#define IHRF_DONT_LOAD_SOUNDBANK			0x02

// Option for IsisSetInputDevice
#define ISIS_SET_INPUT_CODEC_OUT			0x00
#define ISIS_SET_INPUT_RACK_ANALOG_78_IN	0x01
#define ISIS_SET_INPUT_RACK_SPDIF_IN		0x02

// Option for IsisSetClockFrequency
#define ISIS_SET_FREQ_32K_CLOCK				0x00
#define ISIS_SET_FREQ_44K_CLOCK				0x01
#define ISIS_SET_FREQ_48K_CLOCK				0x02
#define ISIS_SET_FREQ_SPDIF_IN_SLAVE		0x03


// Option for IsisGetSpdifFrequency
#define ISIS_GET_SPDIF_FREQ_OUTOFRANGE		0x00
#define ISIS_GET_SPDIF_FREQ_48_4PCT			0x01
#define ISIS_GET_SPDIF_FREQ_44_10_4PCT		0x02
#define ISIS_GET_SPDIF_FREQ_32_4PCT			0x03
#define ISIS_GET_SPDIF_FREQ_48_400PPM		0x04
#define ISIS_GET_SPDIF_FREQ_44_10_400PPM	0x05
#define ISIS_GET_SPDIF_FREQ_44_05_400PPM	0x06
#define ISIS_GET_SPDIF_FREQ_32_400PPM		0x07

// Option for IsisGetInputDevice
#define ISIS_INPUT_CODEC_OUT				0x00
#define ISIS_INPUT_RACK_ANALOG_78_IN		0x01
#define ISIS_INPUT_RACK_SPDIF_IN			0x02


// Option for IsisSwitchConfig
#define ISC_TO_MUSIC						0x0000
#define ISC_TO_MMEDIA						0x0001

// Option for IsisGetFirmwareVersion
#define ISIS_GET_FIRMWARE_VERSION_ERROR		0x0001
#define	FIGFV_FIRMWARE_SUPPORTS_DLS			0x0002
#define FIGFV_FIRMWARE_SUPPORTS_64_BLOCKS	0x0004
#define FIGFV_FIRMWARE_SUPPORTS_128_BLOCKS	0x0008
#define FIGFV_ISIS_UNKNOWN_FIRMWARE_TYPE	0x0010
#define FIGFV_ISIS_MMEDIA_FIRMWARE_TYPE		0x0020
#define FIGFV_ISIS_MUSIC_FIRMWARE_TYPE		0x0040

// Option for IsisGetClockFrequency
#define ISIS_FREQ_32K_CLOCK					0x00
#define ISIS_FREQ_44K_CLOCK					0x01
#define ISIS_FREQ_48K_CLOCK					0x02


// Option for IsisSwitchConfig
#define ISIS_SW_CONFIG_ERROR		(WORD)-1
#define ISIS_SW_CONFIG_MUSIC		0x00
#define ISIS_SW_CONFIG_MMEDIA		0x01
#define ISIS_SW_CONFIG_DEFAULT		ISIS_SW_CONFIG_MUSIC
#define ISIS_SW_CONFIG_NO_REBOOT	0x0100

// Sturctures for IsisBankGetCaps API
typedef struct sSoundDef {
	char Name[16];
	DWORD Prio;
	DWORD Size;
	DWORD SBnb;
	} SOUNDDEF, *LPSOUNDDEF;

typedef struct sBankCaps {
	DWORD TotalSize;
	DWORD FreeSize;
	DWORD	BanksNb;
	SOUNDDEF SBankDef[8];
	} BANKCAPS, *LPBANKCAPS;


#ifdef __cplusplus
extern "C" {            /* Assume C declarations for C++ */
#endif	/* __cplusplus */


/***************************************************************
*
*	ISISRESULT APIENTRY IsisBankLoad(PCHAR pBankFileName,LPWORD pwBankIndex)
*                                      
*	Param :		pBankFileName	: Name of the sound bank file to load (.94b)
*				pwBankIndex : Index of the Sound Bank in memory (8 banks max)
*
*	Return :	ISISERR_NOERROR if succeed,
*				error code if failed
*
****************************************************************/

ISISRESULT APIENTRY  IsisBankLoad(PCHAR pBankFileName,LPWORD pwBankIndex);

/***************************************************************
*
*	ISISRESULT APIENTRY  IsisBankUnLoad(WORD wBankIndex)
*                                   
*	Removes the sound bank from board memory
*
*	Param :		wBankIndex Index of the bank to unload
*
*	Return :	ISISERR_NOERROR if succeed,
*				error code if failed
*
****************************************************************/

ISISRESULT APIENTRY  IsisBankUnload(WORD wBankIndex);

/***************************************************************
*
*	ISISRESULT APIENTRY IsisBankGetCaps(LPBANKCAPS lpBankCaps)
*
*	Fills the lpBankCaps structure with the informations
*	describing Sound Banks in memory
*                                      
*	Param :		BANKCAPS structure to fill
*
*	Return :	ISISERR_NOERROR if succeed,
*				error code if failed
*
****************************************************************/

ISISRESULT APIENTRY  IsisBankGetCaps(LPBANKCAPS lpBankCaps);


/***************************************************************
*
*	ISISRESULT APIENTRY  IsisBankSetPriority(WORD wBankIndex,WORD wBankPriority)
*                                      
*	Change the priority of the sound bank
*
*	Param :		wBankIndex Index of the bank for priority change
*				wBankPriority New priority of the bank
*
*	Return :	ISISERR_NOERROR if succeed,
*				error code if failed
*
****************************************************************/

ISISRESULT APIENTRY  IsisBankSetPriority(WORD wBankIndex, WORD wBankPriority);

/****************************************************************************
*
*    ISISRESULT APIENTRY IsisHwResetDream(WORD wOption)
*
*    Reset the Dream in Hardware
*    
*	Param :		wOption :	combination of the following flags
*							FIHR_DONT_LOAD_FIRMWARE don't Load default firmware
*							FIHR_DONT_LOAD_SOUNDBANK don't Load default sound bank
*							FIHR_DEFAULT default: Load default firmware and sound bank
*    		
*	Return :	ISISERR_NOERROR if succeed,
*				error code if failed
*
****************************************************************************/

ISISRESULT APIENTRY IsisHwReset(WORD wOption);

/****************************************************************************
*
*    ISISRESULT APIENTRY IsisSetInputDevice(WORD wEntry)
*
*    Select the Input device for the ISIS 7/8 entry
*    
*	Param :		wEntry :		ISIS_SET_INPUT_CODEC_OUT :			Maestro Main Out
*								ISIS_SET_INPUT_RACK_ANALOG_78_IN :	Rack Analog In 7/8
*								ISIS_SET_INPUT_RACK_SPDIF_IN :		SPDIF IN
*    		
*	Return :	ISISERR_NOERROR if succeed,
*				error code if failed
*
****************************************************************************/

ISISRESULT APIENTRY  IsisSetInputDevice(WORD wEntry);

/****************************************************************************
*
*    ISISRESULT APIENTRY IsisSetClockFrequency(WORD wClock)
*    Set the Clock Frequency for the DSP 
*	 BE CAREFUL Do not Switch to SPDIF IN Clock if there is not Valid SPDIF Clock
*	 So use IsisGetSpdifFrequency before switching to SPDIF IN Clock
*    
*	Param :		wClock	ISIS_SET_FREQ_32K_CLOCK :		32 Khz
*						ISIS_SET_FREQ_44K_CLOCK :		44.1 Khz
*						ISIS_SET_FREQ_48K_CLOCK :		48 Khz
*						ISIS_SET_FREQ_SPDIF_IN_SLAVE :	SPDIF IN
*    		
*	Return :	ISISERR_NOERROR if succeed,
*				error code if failed
*
****************************************************************************/

ISISRESULT APIENTRY  IsisSetClockFrequency(WORD wClock);

/****************************************************************************
*
*    ISISRESULT APIENTRY IsisGetSpdifFrequency(LPWORD pwSpdifFreq)
*    Get the Frequency of the SPDIF entry
*    
*	
*	Return :	Param : *pSpdifFreq :	ISIS_GET_SPDIF_FREQ_OUTOFRANGE :	Out of Range ( no Valid SPDIF Entry )
*										ISIS_GET_SPDIF_FREQ_48_4PCT :		48 Khz  4%
*										ISIS_GET_SPDIF_FREQ_44_10_4PCT :	44.1 Khz  4%
*										ISIS_GET_SPDIF_FREQ_32_4PCT :		32 Khz  4%
*										ISIS_GET_SPDIF_FREQ_48_400PPM :		48 Khz  400 ppm
*										ISIS_GET_SPDIF_FREQ_44_10_400PPM :	44.1 Khz  400 ppm
*										ISIS_GET_SPDIF_FREQ_44_05_400PPM :	44.056 Khz  400 ppm
*										ISIS_GET_SPDIF_FREQ_32_400PPM :		32 Khz  400 ppm
*    		
*	Return :	
				ISISERR_NOERROR if succeed,
*				error code if failed
*
****************************************************************************/

ISISRESULT APIENTRY IsisGetSpdifFrequency(LPWORD pwSpdifFreq );

/****************************************************************************
*
*    ISISRESULT APIENTRY IsisSwitchConfig(WORD wOption)
*		Switch to MUSIC or MULTIMEDIA Configuration 	
*
*	Param :		ISC_TO_MUSIC :		Music Configuration
*				ISC_TO_MMEDIA :		Multimedia	Configuration    		
*
*	Return :	ISISERR_NOERROR if succeed,
*				error code if failed
*
****************************************************************************/

ISISRESULT APIENTRY IsisSwitchConfig(WORD wOption);

/****************************************************************************
*
*    ISISRESULT APIENTRY IsisGetInputDevice(LPWORD pwSelectEntry)
*    Get the Select Input device for the ISIS 7/8 entry
*
*	Param :		*pwSelectEntry	ISIS_INPUT_CODEC_OUT :			Maestro Main Out
*								ISIS_INPUT_RACK_ANALOG_78_IN :	Rack Analog In 7/8
*								ISIS_INPUT_RACK_SPDIF_IN :		SPDIF IN
*
*	Return :	ISISERR_NOERROR if succeed,
*				error code if failed
*
****************************************************************************/

ISISRESULT APIENTRY IsisGetInputDevice(LPWORD pwSelectEntry);

/****************************************************************************
*
*    ISISRESULT APIENTRY IsisGetClockFrequency(LPWORD pwClock)
*    Get the Clock Frequency od the DSP 
*    
*	Param :		*pwClock	ISIS_FREQ_32K_CLOCK : 32 Khz
*							ISIS_FREQ_44K_CLOCK : 44.1 Khz
*							ISIS_FREQ_48K_CLOCK : 48 Khz
*
*	Return :	ISISERR_NOERROR if succeed,
*				error code if failed
*
****************************************************************************/

ISISRESULT APIENTRY IsisGetClockFrequency(LPWORD pwClock);


#ifdef __cplusplus
}                       /* End of extern "C" { */
#endif	/* __cplusplus */   				