;----------------------------------------
;	EQUATES USED BY POST AND BIOS	:
;----------------------------------------

SYSTEM		EQU	0		; 0 PC-XT, 1 PC-AT
MODEL_BYTE	EQU	0FBH		; SYSTEM MODEL BYTE
SUB_MODEL_BYTE	EQU	000H		; SYSTEM SUB-MODEL TYPE
BIOS_LEVEL	EQU	001H		; BIOS REVISION LEVEL

;--------- KEYBOARD INTERFACE AND DIAGNOSTIC CONTROL REGISTERS ------------
PORT_A		EQU	060H		; KEYBOARD SCAN CODE/CONTROL PORT
PORT_B		EQU	061H		; PORT B READ/WRITE DIAGNOSTIC REGISTER
PORT_C		EQU	062H		; 8255 PORT C ADDR
CMD_PORT	EQU	063H


KB_DATA 	EQU	060H		; KEYBOARD SCAN CODE PORT
KB_CTL		EQU	061H		; CONTROL BITS FOR KEYBOARD SENSE DATA
ID_2A		EQU	054H		; ALTERNATE 2ND ID CHAR FOR KBX
MC_E0		EQU	224		; GENERAL MARKER CODE
MC_E1		EQU	225		; PAUSE KEY MARKER CODE


RAM_PAR_ON	EQU	11110011B	; AND MASK FOR PARITY CHECKING ENABLE ON
RAM_PAR_OFF	EQU	00001100B	; OR MASK FOR PARITY CHECKING ENABLE OFF
PARITY_ERR	EQU	11000000B	; R/W MEMORY - I/O CHANNEL PARITY ERROR
GATE2		EQU	00000001B	; TIMER 2 INPUT GATE CLOCK BIT
SPK2		EQU	00000010B	; SPEAKER OUTPUT DATA ENABLE BIT
REFRESH_BIT	EQU	00010000B	; REFRESH TEST BIT
OUT2		EQU	00100000B	; SPEAKER TIMER OUT2 INPUT BIT
IO_CHECK	EQU	01000000B	; I/O (MEMORY) CHECK OCCURRED BIT MASK
PARITY_CHECK	EQU	10000000B	; MEMORY PARITY CHECK OCCURRED BIT MASK
PAGE
;---------- KEYBOARD RESPONSE ---------------------------------------------
KB_OK		EQU	0AAH		; RESPONSE FROM SELF DIAGNOSTIC
KB_ACK		EQU	0FAH		; ACKNOWLEDGE FROM TRANSMISSION
KB_RESEND	EQU	0FEH		; RESEND REQUEST
KB_OVER_RUN	EQU	0FFH		; OVER RUN SCAN CODE

;---------- FLAG EQUATES WITHIN  @KB_FLAG --------------------------------------
RIGHT_SHIFT	EQU	00000001B	; RIGHT SHIFT KEY DEPRESSED
LEFT_SHIFT	EQU	00000010B	; LEFT SHIFT KEY DEPRESSED
CTL_SHIFT	EQU	00000100B	; CONTROL SHIFT KEY DEPRESSED
ALT_SHIFT	EQU	00001000B	; ALTERNATE SHIFT KEY DEPRESSED
SCROLL_STATE	EQU	00010000B	; SCROLL LOCK STATE HAS BEEN TOGGLED
NUM_STATE	EQU	00100000B	; NUM LOCK STATE HAS BEEN TOGGLED
CAPS_STATE	EQU	01000000B	; CAPS LOCK STATE HAS BEEN TOGGLED
INS_STATE	EQU	10000000B	; INSERT STATE IS ACTIVE

;---------- FLAG EQUATES WITHIN  @KB_FLAG_1 ------------------------------------
SYS_SHIFT	EQU	00000100B	; SYSTEM KEY DEPRESSED AND HELD
HOLD_STATE	EQU	00001000B	; SUSPEND KEY HAS BEEN TOGGLED
SCROLL_SHIFT	EQU	00010000B	; SCROLL LOCK KEY IS DEPRESSED
NUM_SHIFT	EQU	00100000B	; NUM LOCK KEY IS DEPRESSED
CAPS_SHIFT	EQU	01000000B	; CAPS LOCK KEY IS DEPRESSED
INS_SHIFT	EQU	10000000B	; INSERT KEY IS DEPRESSED

;---------- FLAGS EQUATES WITHIN  @KB_FLAG_2 -----------------------------------
KB_LEDS 	EQU	00000111B	; KEYBOARD LED STATE BITS
;		EQU	00001000B	; RESERVED (MUST BE ZERO)
KB_FA		EQU	00010000B	; ACKNOWLEDGMENT RECEIVED
KB_FE		EQU	00100000B	; RESEND RECEIVED FLAG
KB_PR_LED	EQU	01000000B	; MODE INDICATOR UPDATE
KB_ERR		EQU	10000000B	; REYBOARD TRANSMIT ERROR FLAG

;---------- FLAGS EQUATES WITHIN  @KB_FLAG_3 -----------------------------------
LC_E1		EQU	00000001B	; LAST CODE WAS THE E1 HIDDEN CODE
LC_E0		EQU	00000010B	; LAST CODE WAS THE E0 HIDDEN CODE
R_CTL_SHIFT	EQU	00000100B	; RIGHT CTL KEY DOWN
GRAPH_ON	EQU	00001000B	; ALT GRAPHICS KEY DOWN (WT ONLY)
;		EQU	00011000B	; RESERVED (MUST BE ZERO)
KBX		EQU	00010000B	; ENHANCED KEYBOARD INSTALLED
SET_NUM_LK	EQU	00100000B	; FORCE NUM LOCK IF READ ID AND KBX
LC_AB		EQU	01000000B	; LAST CHARACTER WAS FIRST ID CHARACTER
RD_ID		EQU	10000000B	; DOING A READ ID (MUST BE BIT0)

;---------- KEYBOARD SCAN CODES ------------------------------------------------
ID_1		EQU	0ABH		; 1ST ID CHARACTER FOR KBX
ID_2		EQU	041H		; 2ND ID CHARACTER FOR KBX
ALT_KEY 	EQU	56		; SCAN CODE FOR  ALTERNATE SHIFT KEY
CTL_KEY 	EQU	29		; SCAN CODE FOR  CONTROL KEY
CAPS_KEY	EQU	58		; SCAN CODE FOR  SHIFT LOCK KEY
DEL_KEY 	EQU	83		; SCAN CODE FOR  DELETE KEY
INS_KEY 	EQU	82		; SCAN CODE FOR  INSERT KEY
LEFT_KEY	EQU	42		; SCAN CODE FOR  LEFT SHIFT
NUM_KEY 	EQU	69		; SCAN CODE FOR  NUMBER LOCK KEY
RIGHT_KEY	EQU	54		; SCAN CODE FOR  RIGHT SHIFT
SCROLL_KEY	EQU	70		; SCAN CODE FOR  SCROLL LOCK KEY
SYS_KEY 	EQU	84		; SCAN CODE FOR  SYSTEM KEY
F11_M		EQU	87		; F11 KEY MAKE
F12_M		EQU	88		; F12 KEY MAKE
PAGE
;---------- DISKETTE EQUATES ---------------------------------------------------
CARD_ID 	EQU	01010000B	; CONTROLLER CARD I.D. BIT
DUAL		EQU	00000001B	; MASK FOR FDC ADAPTER I.D.
INT_FLAG	EQU	10000000B	; INTERRUPT OCCURRENCE FLAG
DSK_CHG 	EQU	10000000B	; DISKETTE CHANGE FLAG MASK BIT
DETERMINED	EQU	00010000B	; SET STATE DETERMINED IN STATE BITS
HOME		EQU	00010000B	; TRACK 0 MASK
SENSE_DRV_ST	EQU	00000100B	; SENSE DRIVE STATUS COMMAND
TRK_SLAP	EQU	030H		; CRASH STOP (48 TPI DRIVES)
QUIET_SEEK	EQU	00AH		; SEEK TO TRACK 10
MAX_DRV 	EQU	2		; MAX NUMBER OF DRIVES
HD12_SETTLE	EQU	15		; 1.2 M HEAD SETTLE TIME
HD320_SETTLE	EQU	20		; 320 K HEAD SETTLE TIME
MOTOR_WAIT	EQU	37		; 2 SECONDS OF COUNTS FOR MOTOR TURN OFF

;---------- DISKETTE ERRORS ----------------------------------------------------
TIME_OUT	EQU	080H		; ATTACHMENT FAILED TO RESPOND
BAD_SEEK	EQU	040H		; SEEK OPERATION FAILED
BAD_NEC 	EQU	020H		; DISKETTE CONTROLLER HAS FAILED
BAD_CRC 	EQU	010H		; BAD CRC ON DISKETTE READ
MED_NOT_FND	EQU	00CH		; MEDIA TYPE NOT FOUND
DMA_BOUNDARY	EQU	009H		; ATTEMPT TO DMA ACROSS 64K BOUNDARY
BAD_DMA 	EQU	008H		; DMA OVERRUN ON OPERATION
MEDIA_CHANGE	EQU	006H		; MEDIA REMOVED ON DUAL ATTACH CARD
RECORD_NOT_FND	EQU	004H		; REQUESTED SECTOR NOT FOUND
WRITE_PROTECT	EQU	003H		; WRITE ATTEMPTED ON WRITE PROTECT DISK
BAD_ADDR_MARK	EQU	002H		; ADDRESS MARK NOT FOUND
BAD_CMD 	EQU	001H		; BAD COMMAND PASSED TO DISKETTE I/O

;---------- DISK CHANGE LINE EQUATES -------------------------------------------
NOCHGLN 	EQU	001H		; NO DISK CHANGE LINE AVAILABLE
CHGLN		EQU	002H		; DISK CHANGE LINE AVAILABLE

;---------- MEDIA/DRIVE STATE INDICATORS ---------------------------------------
TRK_CAPA	EQU	00000001B	; 80 TRACK CAPABILITY
FMT_CAPA	EQU	00000010B	; MULTIPLE FORMAT CAPABILITY (1.2M)
DRV_DET 	EQU	00000100B	; DRIVE DETERMINED
MED_DET 	EQU	00010000B	; MEDIA DETERMINED BIT
DBL_STEP	EQU	00100000B	; DOUBLE STEP BIT
RATE_MSK	EQU	11000000B	; MASK FOR CLEARING ALL BUT RATE
RATE_500	EQU	00000000B	; 500 KBS DATA RATE
RATE_300	EQU	01000000B	; 300 KBS DATA RATE
RATE_250	EQU	10000000B	; 250 KBS DATA RATE
STRT_MSK	EQU	00001100B	; OPERATION START RATE MASK
SEND_MSK	EQU	11000000B	; MASK FOR SEND RATE BITS

;---------- MEDIA/DRIVE STATE INDICATORS COMPATIBILITY -------------------------
M3D3U		EQU	00000000B	; 360 MEDIA/DRIVE NOT ESTABLISHED
M3D1U		EQU	00000001B	; 360 MEDIA,1.2DRIVE NOT ESTABLISHED
M1D1U		EQU	00000010B	; 1.2 MEDIA/DRIVE NOT ESTABLISHED
MED_UNK 	EQU	00000111B	; NONE OF THE ABOVE
PAGE
;---------- INTERRUPT EQUATES --------------------------------------------------
EOI		EQU	020H		; END OF INTERRUPT COMMAND TO 8259
INTA00		EQU	020H		; 8259 PORT
INTA01		EQU	021H		; 8259 PORT
INTB00		EQU	0A0H		; 2ND 8259
INTB01		EQU	0A1H		;
INT_TYPE	EQU	070H		; START OF 8259 INTERRUPT TABLE LOCATION
INT_VIDEO	EQU	010H		; VIDEO VECTOR
;-------------------------------------------------------------------------------
DMA08		EQU	008H		; DMA STATUS REGISTER PORT ADDRESS
DMA		EQU	000H		; DMA CH.0 ADDRESS REGISTER PORT ADDRESS
DMA18		EQU	0D0H		; 2ND DMA STATUS PORT ADDRESS
DMA1		EQU	0C0H		; 2ND DMA CH.0 ADDRESS REGISTER ADDRESS
;-------------------------------------------------------------------------------
TIMER		EQU	040H		; 8253 TIMER - BASE ADDRESS
TIM_CTL 	EQU	043H		; 8253 TIMER CONTROL PORT ADDR
TIMER0		EQU	040H		; 8253 TIMER/CNTER 0 PORT ADDR

;--------- MANUFACTURING PORT --------------------------------------------------
MFG_PORT	EQU	80H		; MANUFACTURING AND POST CHECKPOINT PORT
					;  DMA CHANNEL 0 PAGE REGISTER ADDRESS

;--------- MANUFACTURING BIT DEFINITION FOR @MFG_ERR_FLAG+1 --------------------
MEM_FAIL	EQU	00000001B	; STORAGE TEST FAILED	     (ERROR 20X)
PRO_FAIL	EQU	00000010B	; VIRTUAL MODE TEST FAILED   (ERROR 104)
LMCS_FAIL	EQU	00000100B	; LOW MEG CHIP SELECT FAILED (ERROR 109)
KYCLK_FAIL	EQU	00001000B	; KEYBOARD CLOCK TEST FAILED (ERROR 304)
KY_SYS_FAIL	EQU	00010000B	; KEYBOARD OR SYSTEM FAILED  (ERROR 303)
KYBD_FAIL	EQU	00100000B	; KEYBOARD FAILED	     (ERROR 301)
DSK_FAIL	EQU	01000000B	; DISKETTE TEST FAILED	     (ERROR 601)
KEY_FAIL	EQU	10000000B	; KEYBOARD LOCKED	     (ERROR 302)

;-------------------------------------------------------------------------------
DMA_PAGE	EQU	081H		; START OF DMA PAGE REGISTERS
LAST_DMA_PAGE	EQU	08FH		; LAST DMA PAGE REGISTER

;-------------------------------------------------------------------------------
;X287		 EQU	 0F0H		 ; MATH COPROCESSOR CONTROL PORT

;-------------------------------------------------------------------------------
POST_SS 	EQU	00000H		; POST STACK SEGMENT
POST_SP 	EQU	08000H		; POST STACK POINTER
STACK_SS	EQU	30H		; STACK SEGMENT USED DURING POST
TOS		EQU	100H		; STACK -- USED DURING POST ONLY
					;   USE WILL OVERLAY INTERRUPT VECTORS

;-------------------------------------------------------------------------------
CR		EQU	000DH		; CARRIAGE RETURN CHARACTER
LF		EQU	000AH		; LINE FEED CHARACTER
RVRT		EQU	00001000B	; VIDEO VERTICAL RETRACE BIT
RHRZ		EQU	00000001B	; VIDEO HORIZONTAL RETRACE BIT
H		EQU	256		; HIGH BYTE FACTOR (X 100H)
X		EQU	H+1		; HIGH AND LOW BYTE FACTOR (X 101H)
