/*-----------------------------------------------------------------------*/
/*                                   TIGA                                */
/*      Copyright (C) 1990-1991  Texas Instruments Incorporated.         */
/*                           All Rights Reserved                         */
/*-----------------------------------------------------------------------*/
#define TMS34010            0
#define TMS34020            1
#define MAGIC               0x8214
#define MAX_STR             64

//#define NAME_TIGA           "TIGA"
#define NAME_OF_TIGA        "TIGA"
#define TIGACFG_FILE        "tiga.cfg"
#define MAX_TIGACFG_SIZE    8192
#define READ_MODES          -6

int SetMode( int );  /* function prototype for the setmode function */
int TiCFG( int );

typedef struct
{
	unsigned short disp_hres;
	unsigned short disp_vres;
	unsigned long  palet_size;
	unsigned short num_pages;
	unsigned long  pixel_mask;
	unsigned long  pixel_size;
} MODE;

typedef struct
{
    unsigned short      magic_num;
    unsigned short      proc_id;
    unsigned short      mode_count;
    unsigned short      irq_count;
    unsigned short      busw_count;
    unsigned short      iob_count;
    unsigned short      mem1b_count;
    unsigned short      mem2b_count;
    unsigned short      gta_count;
    unsigned short      mon_count;
    unsigned short      mem_count;
    unsigned short      io_range;
    unsigned long       mem1_range;
    unsigned long       mem2_range;
    unsigned char       text[MAX_STR];
    unsigned long       offset_irq;
    unsigned long       offset_busw;
    unsigned long       offset_iob;
    unsigned long       offset_mem1b;
    unsigned long       offset_mem2b;
    unsigned long       offset_gta;
    unsigned long       offset_aux_config;
    unsigned long       offset_mon;
    unsigned long       offset_mem;
    unsigned long       offset_mode[1];
} CL_HDR;

typedef struct
{
    unsigned short       irq[1];
} IRQ_SECT;

typedef struct
{
    unsigned short       busw[1];
} BUSW_SECT;

typedef struct
{
    unsigned short       iob[1];
} IOB_SECT;

typedef struct
{
    unsigned long        mem1b[1];
} MEM1B_SECT;

typedef struct
{
    unsigned long        mem2b[1];
} MEM2B_SECT;

typedef struct
{
    unsigned short       gta[1];
} GTA_SECT;

typedef struct
{
    struct {
            unsigned short      width;
            unsigned short      height;
            unsigned char       text[MAX_STR];
           } monitor[1];
} MON_SECT;

typedef struct
{
    struct {
            unsigned short      mem_id;
            unsigned char       text[MAX_STR];
           } memory[1];
} MEM_SECT;

typedef struct
{
    unsigned short      alt_video;
    unsigned short      emulation;
    short               mem_mapped;
    struct   {
                 unsigned long   base;
                 unsigned long   range;
             } mem[8];
    short               io_mapped;
    struct   {
                 unsigned short  base;
                 unsigned short  range;
             } io[8];
} AUX_CONFIG;

typedef struct
{
    unsigned short      x_aspect;
    unsigned short      y_aspect;
    unsigned short      diag_aspect;
    unsigned short      hesync;
    unsigned short      heblnk;
    unsigned short      hsblnk;
    unsigned short      htotal;
    unsigned short      vesync;
    unsigned short      veblnk;
    unsigned short      vsblnk;
    unsigned short      vtotal;
    unsigned short      dpyctl;
    unsigned short      sync_delay;
    unsigned short      flags;
} MON_DATA10;

typedef struct
{
    unsigned short      x_aspect;
    unsigned short      y_aspect;
    unsigned short      diag_aspect;
    unsigned short      vesync;
    unsigned short      hesync;
    unsigned short      veblnk;
    unsigned short      heblnk;
    unsigned short      vsblnk;
    unsigned short      hsblnk;
    unsigned short      vtotal;
    unsigned short      htotal;
    unsigned short      dpyctl;
    unsigned short      dinclo;
    unsigned short      dinchi;
    unsigned short      heserr;
    unsigned short      dpymsk;
    unsigned short      sync_delay;
    unsigned short      flags;
} MON_DATA20;

typedef struct
{
    unsigned long       size;
    unsigned short      mem_id;
    unsigned short      page_count;
    unsigned short      os_count;
    unsigned short      overlay_mask_count;
    unsigned long       offset_mem;
    unsigned long       offset_mode;
    unsigned long       offset_mon;
    unsigned long       offset_page;
    unsigned long       offset_os;
    unsigned long       offset_oem;
} MODE_HDR;

typedef struct
{
    unsigned short      dram;
    unsigned short      vram;
    unsigned long       data[2];
} MODE_MEM;

typedef struct
{
    unsigned long       dpitch;
    unsigned short      hres;
    unsigned short      vres;
    unsigned short      pix_size;
    unsigned long       pix_mask;
    unsigned short      pal_gun_depth;
    unsigned long       pal_size;
    unsigned short      pal_inset;
    unsigned short      silicon;
    unsigned short      c_class;
    unsigned long       r_mask;
    unsigned long       g_mask;
    unsigned long       b_mask;
    unsigned long       wkspc_addr;
    unsigned long       wkspc_pitch;
    unsigned long       overlay_masks[8];
} MODE_MODE;

typedef struct
{
    struct   {
                 unsigned short  dpyctl;
                 unsigned long   offset;
             } mon[1];
} MODE_MON;

typedef struct
{
    unsigned long    addr;
    unsigned long    dpystrt;
} MODE_PAGE;

typedef struct
{
    unsigned long    addr;
    unsigned short    x;
    unsigned short    y;
} MODE_OS;

typedef struct
{
    unsigned short      magic_num;
    unsigned long       file_len;
    unsigned short      proc_id;
    unsigned short      mode_count;
    unsigned short      default_mode;
    unsigned long       offset_setup;
    unsigned long       offset_mon;
    unsigned long       offset_cd;
    unsigned long       offset_mode[1];
} CFG_HDR;

typedef struct
{
    unsigned short  width;
    unsigned short  height;
} CFG_MON;

typedef struct
{
    unsigned short  int_level;
    unsigned short  io_base;
    unsigned short  bus_width;
    unsigned short  gta_pages;
    unsigned long   hostseg_addr;
    unsigned long   hostseg2_addr;
    AUX_CONFIG      aux;
} CFG_CD;

typedef struct
{
    unsigned char   oem_text[MAX_STR];
    short           mon_choice;
    short           mon_count;
    short           irq_choice;
    short           busw_choice;
    short           iob_choice;
    short           mem1b_choice;
    short           mem2b_choice;
    short           gta_choice;
    short           mem_choice;
} CFG_SETUP;
