/***************************************************************************
 File: sxapp.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.
			  
 You may use this Sample Code any way you please provided you do not resell 
 the code and that this notice (including the above copyright notice) is 
 reproduced on all copies.  THIS SAMPLE CODE IS PROVIDED "AS IS", WITHOUT 
 WARRANTY OF ANY KIND, AND GO CORPORATION EXPRESSLY DISCLAIMS ALL IMPLIED 
 WARRANTIES, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF 
 MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT WILL GO 
 CORPORATION BE LIABLE TO YOU FOR ANY CONSEQUENTIAL,INCIDENTAL, OR INDIRECT 
 DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THIS SAMPLE CODE.

 $Revision:   1.0  $
   $Author:   aloomis  $
     $Date:   13 Aug 1992 12:13:54  $

 This file contains the definitions & structures for clsSX and its subtask

****************************************************************************/
#ifndef SXAPP_INCLUDED
#define SXAPP_INCLUDED

#ifndef APP_INCLUDED
#include <app.h>
#endif

#ifndef APPMGR_INCLUDED
#include <appmgr.h>
#endif

#ifndef CLSMGR_INCLUDED
#include <clsmgr.h>
#endif

#ifndef DEBUG_INCLUDED
#include <debug.h>
#endif

#ifndef GO_INCLUDED
#include <go.h>
#endif

#ifndef INTL_INCLUDED
#include <intl.h>
#endif

#ifndef OS_INCLUDED
#include <os.h>
#endif

#ifndef OSHEAP_INCLUDED
#include <osheap.h>
#endif

#ifndef RESUTIL_INCLUDED
#include <resutil.h>
#endif

#ifndef SIO_INCLUDED
#include <sio.h>
#endif

#ifndef TXTVIEW_INCLUDED
#include <txtview.h>
#endif

#ifndef WIN_INCLUDED
#include <win.h>
#endif

/* OS version to compile for, define for 1.0 */
#define PP1_0

STATUS EXPORTED ClsSXViewInit(void);
//P_CHAR EXPORTED SXGetResString(U16);

/* Class UIDs */
#define clsSX MakeWKN(4827, 1, wknGlobal)
#define clsSXView MakePrivateWKN(clsSX, 1)

/* SX messages */
#define msgSXOpenSerial		MakeMsg(clsSX, 1)
#define msgSXCloseSerial	MakeMsg(clsSX, 2)
#define msgSXSendSerial		MakeMsg(clsSX, 3)
#define msgSXSetSerialMetrics	MakeMsg(clsSX, 4)
#define msgSXResizeCard		MakeMsg(clsSX, 5)
#define msgSXIPCommand		MakeMsg(clsSX, 6)
#define msgSXSetConnectStatusId	MakeMsg(clsSX, 7)

/* Serial Option sheet tags */
#define tagSXAppSerialCard	MakeTag(clsSX, 1)
#define tagSXPortOption		MakeTag(clsSX, 2)
#define tagSXBaudRateOption	MakeTag(clsSX, 3)
#define tagSXParityOption	MakeTag(clsSX, 4)
#define tagSXDataBitsOption	MakeTag(clsSX, 5)
#define tagSXStopBitsOption	MakeTag(clsSX, 6)
#define tagSXFlowControlOption	MakeTag(clsSX, 7)
#define tagSXConnected		MakeTag(clsSX, 8)

/* Serial preferences structure */
typedef struct SX_SER_PREFS {
	CHAR spSerServ[nameBufLength];
	U32 spBaudRate;
	SIO_PARITY spParity;
	SIO_DATA_BITS spDataBits;
	SIO_STOP_BITS spStopBits;
	SIO_FLOW_TYPE spFlowControl;
} SX_SER_PREFS, *P_SX_SER_PREFS, **PP_SX_SER_PREFS;

/* structure passed along to subtask */
typedef struct SX_SUBTASK_DATA {
	OS_SEMA_ID sdEventSemaphore;
	OBJECT sdSIOService;
	WIN sdTextObject;
} SX_SUBTASK_DATA, *P_SX_SUBTASK_DATA;

/* SX Instance Data */
typedef struct SX_APP_DATA {
	OBJECT sxWin;
	OBJECT sxOptWin;
	OBJECT sxIPWin;
	P_SX_SUBTASK_DATA sxSubTaskData;
	OS_TASK_ID sxSubTaskID;
	OBJECT sxSerialNameList;
	U32 sxSerServIndex;	/* Which name to use */
	OBJECT sxSIOService;
	OBJECT sxSIOHandle;
	BOOLEAN sxSerConnected;
	SX_SER_PREFS sxSerPrefs;

} SX_APP_DATA, *P_SX_APP_DATA, **PP_SX_APP_DATA;

/* SetSerialMetrics 'commands' */
Enum16(SETSERIAL) {SET_SERIAL_ALL, SET_SERIAL_BAUDRATE, 
		SET_SERIAL_LINECONTROL, SET_SERIAL_FLOWCONTROL};


/* RES_ID for toolkit strings */
#define resSXToolKit MakeListResId(clsSX, resGrpTK, 0)

/* Toolkit res-strings tags... */
/* Serial option sheet */
#define tagSXSerialStr		MakeTag(clsSX, 99)
#define tagSXPortStr		MakeTag(clsSX, 100)
#define tagSXBaudRateStr	MakeTag(clsSX, 101)
#define tagSX300Str		MakeTag(clsSX, 102)
#define tagSX1200Str		MakeTag(clsSX, 103)
#define tagSX2400Str		MakeTag(clsSX, 104)
#define tagSX4800Str		MakeTag(clsSX, 105)
#define tagSX9600Str		MakeTag(clsSX, 106)
#define tagSX19200Str		MakeTag(clsSX, 107)
#define tagSXParityStr		MakeTag(clsSX, 108)
#define tagSXNoneStr		MakeTag(clsSX, 109)
#define tagSXOddStr		MakeTag(clsSX, 110)
#define tagSXEvenStr		MakeTag(clsSX, 111)
#define tagSXDataBitsStr	MakeTag(clsSX, 112)
#define tagSX7Str		MakeTag(clsSX, 113)
#define tagSX8Str		MakeTag(clsSX, 114)
#define tagSXStopBitsStr	MakeTag(clsSX, 115)
#define tagSX1Str		MakeTag(clsSX, 116)
#define tagSX2Str		MakeTag(clsSX, 117)
#define tagSXFlowControlStr	MakeTag(clsSX, 118)
#define tagSXXOnXOffStr		MakeTag(clsSX, 119)
#define tagSXHardwareStr	MakeTag(clsSX, 120)
#define tagSXStatusStr		MakeTag(clsSX, 121)
#define tagSXConnectedStr	MakeTag(clsSX, 122)
#define tagSXNotConnectedStr	MakeTag(clsSX, 123)

/* IP Buttons */
#define tagSXSendStr		MakeTag(clsSX, 124)
#define tagSXClearStr		MakeTag(clsSX, 125)

/* OK string for error notes */
#define tagSXOKStr		MakeTag(clsSX, 126)

/* Tx error note */
#define tagSXTxErrorStr		MakeTag(clsSX, 127)

/* AppOpen failed-to-open notes */
#define tagSXNoWindowErrorStr	MakeTag(clsSX, 128)
#define tagSXNoServiceErrorStr	MakeTag(clsSX, 129)
#define tagSXServMgrErrorStr	MakeTag(clsSX, 130)
#define tagSXSerialErrorStr	MakeTag(clsSX, 131)

#endif /* ifndef SXAPP_INCLUDED */
