/*
 *  sys/timeb.h     timeb structure used with ftime()
 *
 *  Copyright (C) by WATCOM Systems Inc. 1988-1992.  All rights reserved.
 */
#ifndef __TIMEB_H_INCLUDED
#ifndef _TIME_T_DEFINED_
 #define _TIME_T_DEFINED_
 typedef unsigned long time_t;	 /* time value */
#endif

struct timeb {
    time_t		time;		/* seconds since Jan 1, 1970 UTC */
    unsigned short 	millitm;	/* milliseconds */
    short		timezone;	/* difference in minutes from UTC */
    short		dstflag;	/* nonzero if daylight savings time */
};

void ftime( struct timeb *__timeptr );

#define __TIMEB_H_INCLUDED
#endif
