/*******************************************************************************

  
  Copyright(c) 1999 - 2002 Intel Corporation. All rights reserved.
  
  This program is free software; you can redistribute it and/or modify it 
  under the terms of the GNU General Public License as published by the Free 
  Software Foundation; either version 2 of the License, or (at your option) 
  any later version.
  
  This program is distributed in the hope that it will be useful, but WITHOUT 
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
  more details.
  
  You should have received a copy of the GNU General Public License along with
  this program; if not, write to the Free Software Foundation, Inc., 59 
  Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
  The full GNU General Public License is included in this distribution in the
  file called LICENSE.
  
  Contact Information:
  Linux NICS <linux.nics@intel.com>
  Intel Corporation, 5200 N.E. Elam Young Parkway, Hillsboro, OR 97124-6497
*******************************************************************************/

/* Macros to make drivers compatible with 2.2, 2.4 Linux kernels
 *
 * In order to make a single network driver work with all 2.2, 2.4 kernels
 * these compatibility macros can be used.
 * They are backwards compatible implementations of the latest APIs.
 * The idea is that these macros will let you use the newest driver with old
 * kernels, but can be removed when working with the latest and greatest.
 */

#ifndef __E100_KCOMPAT_H__
#define __E100_KCOMPAT_H__

#include <linux/version.h>

/******************************************************************
 *#################################################################
 *#
 *# General definitions, not related to a specific kernel version.
 *#
 *#################################################################
 ******************************************************************/
#ifndef __init
#define __init
#endif

#ifndef __devinit
#define __devinit
#endif

#ifndef __exit
#define __exit
#endif

#ifndef __devexit
#define __devexit
#endif

#ifndef __devinitdata
#define __devinitdata
#endif

#ifndef __devexit_p
#define __devexit_p(x) x
#endif

#ifndef MODULE_LICENSE
#define MODULE_LICENSE(license)
#endif

#ifndef MOD_INC_USE_COUNT
#define MOD_INC_USE_COUNT do {} while (0)
#endif

#ifndef MOD_DEC_USE_COUNT
#define MOD_DEC_USE_COUNT do {} while (0)
#endif

#ifndef min_t
#define min_t(type,x,y) \
        ({ type __x = (x); type __y = (y); __x < __y ? __x: __y; })
#endif

#ifndef max_t
#define max_t(type,x,y) \
        ({ type __x = (x); type __y = (y); __x > __y ? __x: __y; })
#endif

#ifndef cpu_relax
#define cpu_relax() do {} while (0)
#endif

#ifndef ETHTOOL_GWOL
/* Wake-On-Lan options. */
#define WAKE_PHY                (1 << 0)
#define WAKE_UCAST              (1 << 1)
#define WAKE_ARP                (1 << 4)
#define WAKE_MAGIC              (1 << 5)
#endif

/******************************************************************
 *#################################################################
 *#
 *# Kernels before 2.2.18
 *#
 *#################################################################
 ******************************************************************/
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,2,18)

typedef unsigned long dma_addr_t;
typedef struct wait_queue *wait_queue_head_t;

#define init_waitqueue_head(x)      *(x)=NULL
#define set_current_state(status)   { current->state = (status); mb(); }

#ifdef MODULE

#define module_init(fn) int  init_module(void) { return fn(); }
#define module_exit(fn) void cleanup_module(void) { return fn(); }

#else /* MODULE */

#define module_init(fn) int  e100_probe(void) { return fn(); }
#define module_exit(fn)		/* NOTHING */

#endif /* MODULE */

#define list_add_tail(new,head)	__list_add(new, (head)->prev, head)

#define list_for_each(pos, head) \
        for (pos = (head)->next; pos != (head); pos = pos->next)

#endif /* LINUX_VERSION_CODE < KERNEL_VERSION(2,2,18) */

/******************************************************************
 *#################################################################
 *#
 *# Kernels before 2.3.0
 *#
 *#################################################################
 ******************************************************************/
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,0)

#ifdef MODVERSIONS
#include <linux/modversions.h>
#endif
#include <linux/types.h>
#include <linux/pci.h>
#include <linux/slab.h>
#include <asm/io.h>

#define SET_MODULE_OWNER(x) do {} while (0)

#define skb_queue_walk(queue, skb)                        \
                 for (skb = (queue)->next;                \
                      (skb != (struct sk_buff *)(queue)); \
                      skb = skb->next)

#define pci_resource_start(dev, bar)                            \
    (((dev)->base_address[(bar)] & PCI_BASE_ADDRESS_SPACE_IO) ? \
    ((dev)->base_address[(bar)] & PCI_BASE_ADDRESS_IO_MASK) :   \
    ((dev)->base_address[(bar)] & PCI_BASE_ADDRESS_MEM_MASK))

#define pci_enable_device(dev) 0

#define __constant_cpu_to_le32 cpu_to_le32
#define __constant_cpu_to_le16 cpu_to_le16

#define PCI_DMA_TODEVICE   1
#define PCI_DMA_FROMDEVICE 2

extern inline void *
pci_alloc_consistent(struct pci_dev *dev, size_t size, dma_addr_t *dma_handle)
{
	void *vaddr = kmalloc(size, GFP_ATOMIC);

	if (vaddr != NULL) {
		*dma_handle = virt_to_bus(vaddr);
	}

	return vaddr;
}

#define pci_dma_sync_single(dev,dma_handle,size,direction)   do{} while(0)
#define pci_dma_supported(dev, addr_mask)                    (1)
#define pci_free_consistent(dev, size, cpu_addr, dma_handle) kfree(cpu_addr)
#define pci_map_single(dev, addr, size, direction)           virt_to_bus(addr)
#define pci_unmap_single(dev, dma_handle, size, direction)   do{} while(0)

#define spin_lock_bh            spin_lock_irq
#define spin_unlock_bh	        spin_unlock_irq
#define del_timer_sync(timer)   del_timer(timer)
#define net_device              device

#define netif_start_queue(dev)   ( clear_bit(0, &(dev)->tbusy))
#define netif_stop_queue(dev)    (   set_bit(0, &(dev)->tbusy))
#define netif_wake_queue(dev)    { clear_bit(0, &(dev)->tbusy); \
                                   mark_bh(NET_BH); }
#define netif_running(dev)       (  test_bit(0, &(dev)->start))
#define netif_queue_stopped(dev) (  test_bit(0, &(dev)->tbusy))

#define dev_kfree_skb_irq(skb) dev_kfree_skb(skb)
#define dev_kfree_skb_any(skb) dev_kfree_skb(skb)

#define PCI_ANY_ID (~0U)

struct pci_device_id {
	unsigned int vendor, device;
	unsigned int subvendor, subdevice;
	unsigned int class, classmask;
	unsigned long driver_data;
};

#define MODULE_DEVICE_TABLE(bus, dev_table)
#define PCI_MAX_NUM_NICS 256

struct pci_driver {
	char *name;
	struct pci_device_id *id_table;
	int (*probe) (struct pci_dev * dev, const struct pci_device_id * id);
	void (*remove) (struct pci_dev * dev);
	void (*suspend) (struct pci_dev * dev);
	void (*resume) (struct pci_dev * dev);
	/* Track devices on 2.2.x, used by module_init and unregister_driver.
	 * Not to be used by the driver directly.
	 * Assumes single function device with function #0 to simplify. */
	struct pci_dev *pcimap[PCI_MAX_NUM_NICS];
};

extern int pci_module_init(struct pci_driver *drv);
extern void pci_unregister_driver(struct pci_driver *drv);

/********** e100 specific code **********/
#define pci_get_drvdata(pcid)           e100_get_drvdata(pcid)
#define pci_set_drvdata(pcid,dev)       e100_set_drvdata(pcid,dev)

#ifdef E100_RX_CONGESTION_CONTROL
#undef E100_RX_CONGESTION_CONTROL
#endif

#define netif_carrier_ok(dev) (((struct e100_private *)((dev)->priv))->flags & DF_LINK_UP)
#define netif_carrier_on(dev) (((struct e100_private *)((dev)->priv))->flags |= DF_LINK_UP)
#define netif_carrier_off(dev) (((struct e100_private *)((dev)->priv))->flags &= ~DF_LINK_UP)

#ifndef pci_resource_len
#define pci_resource_len e100_pci_resource_len
extern unsigned long e100_pci_resource_len(struct pci_dev *dev, int bar);
#endif

#endif /* LINUX_VERSION_CODE < KERNEL_VERSION(2,3,0) */

/******************************************************************
 *#################################################################
 *#
 *# Kernels before 2.4.3
 *#
 *#################################################################
 ******************************************************************/
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,3)
#include <linux/pci.h>
#include <linux/netdevice.h>
#include <linux/ioport.h>

#ifndef pci_request_regions
#define pci_request_regions e100_pci_request_regions
extern int e100_pci_request_regions(struct pci_dev *pdev, char *res_name);
#endif

#ifndef pci_release_regions
#define pci_release_regions e100_pci_release_regions
extern void e100_pci_release_regions(struct pci_dev *pdev);
#endif

#endif /* LINUX_VERSION_CODE < KERNEL_VERSION(2,4,3) */

/******************************************************************
 *#################################################################
 *#
 *# Kernels before 2.4.4
 *#
 *#################################################################
 ******************************************************************/
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,4)

#define pci_disable_device(dev) do{} while(0)

#endif /* LINUX_VERSION_CODE < KERNEL_VERSION(2,4,4) */

/******************************************************************
 *#################################################################
 *#
 *# Kernels before 2.4.5
 *#
 *#################################################################
 ******************************************************************/
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,5)

#define skb_linearize(skb, gfp_mask) ({     \
    struct sk_buff *tmp_skb;                \
    tmp_skb = skb;                          \
    skb = skb_copy(tmp_skb, gfp_mask);      \
    dev_kfree_skb_any(tmp_skb); })

/* MII constants */

/* MDI register set*/
#define MII_BMCR		0x00	/* MDI control register */
#define MII_BMSR		0x01	/* MDI Status regiser */
#define MII_PHYSID1		0x02	/* Phy indentification reg (word 1) */
#define MII_PHYSID2		0x03	/* Phy indentification reg (word 2) */
#define MII_ADVERTISE		0x04	/* Auto-negotiation advertisement */
#define MII_LPA			0x05	/* Auto-negotiation link partner ability */
#define MII_EXPANSION		0x06	/* Auto-negotiation expansion */
#define MII_NCONFIG		0x1c	/* Network interface config   (MDI/MDIX) */

/* MDI Control register bit definitions*/
#define BMCR_RESV		0x007f	/* Unused...                   */
#define BMCR_CTST	        0x0080	/* Collision test              */
#define BMCR_FULLDPLX		0x0100	/* Full duplex                 */
#define BMCR_ANRESTART		0x0200	/* Auto negotiation restart    */
#define BMCR_ISOLATE		0x0400	/* Disconnect DP83840 from MII */
#define BMCR_PDOWN		0x0800	/* Powerdown the DP83840       */
#define BMCR_ANENABLE		0x1000	/* Enable auto negotiation     */
#define BMCR_SPEED100		0x2000	/* Select 100Mbps              */
#define BMCR_LOOPBACK		0x4000	/* TXD loopback bits           */
#define BMCR_RESET		0x8000	/* Reset the DP83840           */

/* MDI Status register bit definitions*/
#define BMSR_ERCAP		0x0001	/* Ext-reg capability          */
#define BMSR_JCD		0x0002	/* Jabber detected             */
#define BMSR_LSTATUS		0x0004	/* Link status                 */
#define BMSR_ANEGCAPABLE	0x0008	/* Able to do auto-negotiation */
#define BMSR_RFAULT		0x0010	/* Remote fault detected       */
#define BMSR_ANEGCOMPLETE	0x0020	/* Auto-negotiation complete   */
#define BMSR_RESV		0x07c0	/* Unused...                   */
#define BMSR_10HALF		0x0800	/* Can do 10mbps, half-duplex  */
#define BMSR_10FULL		0x1000	/* Can do 10mbps, full-duplex  */
#define BMSR_100HALF		0x2000	/* Can do 100mbps, half-duplex */
#define BMSR_100FULL		0x4000	/* Can do 100mbps, full-duplex */
#define BMSR_100BASE4		0x8000	/* Can do 100mbps, 4k packets  */

/* Auto-Negotiation advertisement register bit definitions*/
#define ADVERTISE_10HALF	0x0020	/* Try for 10mbps half-duplex  */
#define ADVERTISE_10FULL	0x0040	/* Try for 10mbps full-duplex  */
#define ADVERTISE_100HALF	0x0080	/* Try for 100mbps half-duplex */
#define ADVERTISE_100FULL	0x0100	/* Try for 100mbps full-duplex */
#define ADVERTISE_100BASE4	0x0200	/* Try for 100mbps 4k packets  */

/* Auto-Negotiation expansion register bit definitions*/
#define EXPANSION_NWAY		0x0001	/* Can do N-way auto-nego      */

#endif /* LINUX_VERSION_CODE < KERNEL_VERSION(2,4,5) */

/******************************************************************
 *#################################################################
 *#
 *# Kernels before 2.4.6
 *#
 *#################################################################
 ******************************************************************/
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,6)

#include <linux/types.h>
#include <linux/pci.h>

/* Power Management */
#define PMCSR		0xe0
#define PM_ENABLE_BIT	0x0100
#define PM_CLEAR_BIT	0x8000
#define PM_STATE_MASK	0xFFFC
#define PM_STATE_D1	0x0001

static inline int
pci_enable_wake(struct pci_dev *dev, u32 state, int enable)
{
	u16 p_state;

	pci_read_config_word(dev, PMCSR, &p_state);
	pci_write_config_word(dev, PMCSR, p_state | PM_CLEAR_BIT);

	if (enable == 0) {
		p_state &= ~PM_ENABLE_BIT;
	} else {
		p_state |= PM_ENABLE_BIT;
	}
	p_state &= PM_STATE_MASK;
	p_state |= state;

	pci_write_config_word(dev, PMCSR, p_state);

	return 0;
}
#endif /* LINUX_VERSION_CODE < KERNEL_VERSION(2,4,6) */

#if ( LINUX_VERSION_CODE < KERNEL_VERSION(2,4,6) )
#ifndef pci_set_power_state
#define pci_set_power_state _kc_pci_set_power_state
extern int _kc_pci_set_power_state(struct pci_dev *dev, int state);
#endif
#ifndef pci_save_state
#define pci_save_state _kc_pci_save_state
extern int _kc_pci_save_state(struct pci_dev *dev, u32 *buffer);
#endif
#ifndef pci_restore_state
#define pci_restore_state _kc_pci_restore_state
extern int _kc_pci_restore_state(struct pci_dev *pdev, u32 *buffer);
#endif
/* PCI PM entry point syntax changed, so don't support suspend/resume */
#undef CONFIG_PM
#endif

#ifndef pci_for_each_dev
#define pci_for_each_dev(dev) for(dev = pci_devices; dev; dev = dev->next)
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,0)
#ifndef pci_dev_driver
#define pci_dev_driver _kc_pci_dev_driver
extern struct pci_driver *_kc_pci_dev_driver(struct pci_dev *dev);
#endif
#endif /* LINUX_VERSION_CODE < KERNEL_VERSION(2,4,0) */

#endif /* __E100_KCOMPAT_H__ */
