


CYRIX(8)             Linux Programmers Manual            CYRIX(8)


NNAAMMEE
       cyrix - change configuration of Cyrix 486 DLC/SLC CPU

SSYYNNOOPPSSIISS
       ccyyrriixx [[--aa]][[--]] [[--bb]][[--]] [[--cc]][[dd]] [[--dd]] [[--ee]][[--]] [[--ff]][[--]] ......


WWAARRNNIINNGG
       You  are  changing low level hardware parameters with this
       program, and can easily crash your  system  by  giving  it
       parameters  that  your  system can not fully support.  You
       _R_E_A_L_L_Y should go single user and re-mount all  filesystems
       as read-only before experimenting.


DDEESSCCRRIIPPTTIIOONN
       ccyyrriixx  is  a program to view/change the configuration set-
       tings of the Cyrix 486 DLC/SLC line of CPUs. This includes
       the DLC/SLC chips produced by Texas Instruments.


OOPPTTIIOONNSS
       Some  options  to ccyyrriixx can be followed by an optional "-"
       which will invert the behaviour of the  described  option.
       These  options will be marked with a [-] after the option.

       --aa[[--]] Enable [disable] A20M input.


       --bb[[--]] Enable [disable] BARB input.

       --cc Select two-way assoc. cache format.

       --ccdd Select direct-mapped cache format.

       --dd Dump contents of control registers and exit.

       --ee[[--]] Enable [disable] 1k cache via CR0.

       --ff[[--]] Enable [disable] FLUSH input.

       --hh Print a help message and exit.

       --ii<<nn>> Inhibit non-cachable region <n>, where  n={1,2,3,4}.

       --kk[[--]] Enable [disable] KEN input.

       --mm[[--]] Enable [disable] cache of 1st 64k of each MB.

       --oo Override check for existence of Cyrix DLC chip.

       --pp Disable all power saving modes.

       --qq Query DLC configuration status and exit.



Cyrix 1.00                  26 Aug 94                           1





CYRIX(8)             Linux Programmers Manual            CYRIX(8)


       --rr[[--]] Disable [enable] cache of 640k -> 1M ROM area.

       --ss[[--]] Enable [disable] SUSP i/o.

       --vv Print program version information and exit.

       --xx<<hheexx>>,,<<ssiizzee>> Don't cache <size>kb from segment <hex>.


BBAACCKKGGRROOUUNNDD
       This  program is to be used to set the Cyrix specific reg-
       isters on the DLC and  SLC  line  of  386  pin  compatible
       CPU's.  If  you have a "Cyrix aware" motherboard, then you
       may not need this. This is intended for  those  users  who
       have  replaced  an existing 386DX/SX chip with a Cyrix (or
       Texas Instruments) 486DLC/SLC chip. These chips have 1  kb
       of  internal cache, which is disabled by default on power-
       up. Either the BIOS (hence the "cyrix aware" motherboards)
       or  the user must enable this cache to get maximum perfor-
       mance from the chip. (Note that users who  have  either  a
       Cx486DRu2 or a Cx486DRx2 or the SX part Cx486SRu2 can also
       make use of this program, as these are essentially DLC/SLC
       based parts.

       Note  that  the  chip  that  IBM is presently selling as a
       "slc" is entirely different, and this is  of  no  use  for
       that chip.

       However,  there  is  more  to  it  then just "enabling the
       cache". The cache holds a small part of the sytems  memory
       in  close reach to the CPU.  But during DMA (Direct Memory
       Access), things like floppy drives can access the  systems
       memory  directly, and hence the image of the system memory
       stored in the cache memory is no longer up to date. As you
       can  guess, this can lead to memory corruption, especially
       if the cache memory (with "old" data) is written  back  to
       the  system  memory. So, to get around this, the Cyrix DLC
       has a FLUSH input, which (if  enabled)  will  flush  (i.e.
       invalidate) the cache contents after a DMA event.

       But on most old 386 boards the FLUSH pin is not respected.
       So what now? Well, there is another input: the BARB input.
       This  input  is  raised  when the CPU enters a HOLD state,
       which happens when a DMA transfer occurs. But it  also  is
       raised  on  every memory refresh, which is 15us (microsec-
       onds) by default. (Your memory forgets what it  is  remem-
       bering unless you give it a jab (refresh) every so often.)
       This means that you will be  dumping  the  cache  contents
       *all* the time, and it will slow performance. This is your
       only choice though, if your motherboard does  not  respect
       the  FLUSH  input.  However,  there is a work-around. Some
       motherboards have a  BIOS  option  "Slow  Refresh",  which
       changes  the refresh from 15us to a more reasonable value,
       like 120us.  (The "standard" of 15us was  set  in  the  XT



Cyrix 1.00                  26 Aug 94                           2





CYRIX(8)             Linux Programmers Manual            CYRIX(8)


       days  when  memory  was  pretty  poor quality. Todays DRAM
       chips on SIMM memory seem capable of having a refresh only
       once  every  500  --> 1000 us.) Even if your BIOS does not
       have this option, you can sometimes change the time period
       of  the refresh timer via a simple program. I have written
       such a program, namely ddrraamm((88))  so  you  can  use  it,  if
       required.  You  will know when you have exceeded a reason-
       able refresh time for your memory, as you will  get  NMI's
       (Non   Maskable  Interrupts)  which  will  report  "parity
       errors" meaning that your memory  is  starting  to  forget
       stuff.


EEXXAAMMPPLLEESS
       The  cache  is  activated by default, *but* the first non-
       cacheable region is set from 0x0000 to 4 Gigabytes,  which
       is  the  _e_n_t_i_r_e memory space of the PC. (32 bit --> 2^32 =
       4*1024*1024*1024 = 4 Gb) So, as you can see, the cache  is
       effectively  disabled.  (Cache activation is controlled by
       the 486 specific 32 bit register called ccrr00 which is  usu-
       ally  set  so  that  the cache is enabled.) Most users can
       enable the cache on their machine by simply using

       ccyyrriixx --ii11 --ff --rr

       This inhibits non-cacheable region one,  and  enables  the
       flush input.  Also, the 640k --> 1MB region is set as non-
       cacheable, as this area is not used with Linux, except for
       access  to  devices  on  the AT/ISA bus (such as video and
       shared memory cards), which shouldn't be cached anyway.

       You can see what you have done by typing:

       ccyyrriixx --qq

       which will display the present configuration of the  Cyrix
       chip.  It doesn't modify anything. It does probe to see if
       there is a Cyrix in the machine though.

       ccyyrriixx --ii22 --ii33 --ii44 --rr --ccdd --ff-- --bb --kk-- --ee --xxCCCC0000,,1166

       This sets the  first  non  cacheable  region  starting  at
       0xCC000 and with a size of 16kb. The other 3 non-cacheable
       regions are set inactive. The 640k --> 1Mb RAM area is not
       cached. The cache mode is set to direct- mapped. The flush
       input is disabled and the barb input is enabled.  The  ken
       input  is disabled, and the 1k cache is set active via the
       CPU register cr0.

       ccyyrriixx --ee--

       This turns off the 1k internal cache via the  CPU  control
       register 0.




Cyrix 1.00                  26 Aug 94                           3





CYRIX(8)             Linux Programmers Manual            CYRIX(8)


       ccyyrriixx --xx00000000,,44GGbb

       This  disables the 1k internal cache by setting all of the
       PC's memory space as non-cacheable. This is like the  con-
       figuration  you  get  when  you boot up with a motherboard
       that isn't "Cyrix aware"

       ccyyrriixx --xxcc000000,,44 --xxdd000000,,88 --xxEE000000,,3322 --xxFF000000,,6644

       This sets four non-cacheable  regions  of  various  sizes.
       Note that the hex address can be upper or lower case. Note
       that the size must be one of 4,8,16,32,64,....16384,32768,
       or 4Gb


BBUUGGSS
       Linux  does  not allow access to the CPU register ccrr00 even
       with iiooppll((33)) and uid=0. This means that  we  can't  safely
       disable  the cache, once activated, and hence can't change
       the cache settings safely  after  enabling  it.  So  _d_o_n_'_t
       change the settings after enabling it. (Note that the code
       is all there to do things properly if/once iiooppll(()) is fixed
       to allow ccrr00 access.)

       Since  you are doing all sorts of low level I/O when using
       this program, you must be root to read or write any of the
       configuration  parameters.  If  you do not have root priv.
       you will be told so, and the program will exit.

       Also, selecting parametrs that your hardware can not fully
       support will most likely crash the machine.

       The  program  attempts  to  determine if a DLC/SLC chip is
       present, however with all the new 486 chips  now  present,
       it  may falsely detect one as a DLC.  The superuser should
       be well aware of what CPU they have anyway.

       The command line processing is  not  ggeettoopptt((33))  compliant.
       That  is to say that "cyrix -abc" will fail, wheras "cyrix
       -a -b -c" will work as expected. Also the memory arguments
       to the "-x" option are to be segment addresses, and not 32
       bit flat addresses. This is a hangover from  the  original
       DOS version.


AAUUTTHHOORR
       The  program  was adapted from the DOS version of the same
       program.   Program  and  man  page   by   Paul   Gortmaker
       (Paul.Gortmaker@anu.edu.au)








Cyrix 1.00                  26 Aug 94                           4


