/*
 * Decompiled with CFR 0.152.
 */
package scala.actors.threadpool;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractQueue;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import scala.actors.threadpool.BlockingQueue;
import scala.actors.threadpool.TimeUnit;

public final class LinkedBlockingQueue<E>
extends AbstractQueue<E>
implements Serializable,
BlockingQueue<E> {
    private final int capacity;
    private final AtomicInteger count = new AtomicInteger(0);
    private transient Node<E> head;
    private transient Node<E> last;
    private final ReentrantLock takeLock = new ReentrantLock();
    private final Condition notEmpty = this.takeLock.newCondition();
    private final ReentrantLock putLock = new ReentrantLock();
    private final Condition notFull = this.putLock.newCondition();

    /*
     * WARNING - void declaration
     */
    private void signalNotFull() {
        ReentrantLock putLock = this.putLock;
        putLock.lock();
        try {
            this.notFull.signal();
            putLock.unlock();
            return;
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private E dequeue() {
        void var1_1;
        Node<E> h = this.head;
        Node first = h.next;
        h.next = h;
        this.head = first;
        Object x = first.item;
        var2_2.item = null;
        return var1_1;
    }

    final void fullyLock() {
        this.putLock.lock();
        this.takeLock.lock();
    }

    final void fullyUnlock() {
        this.takeLock.unlock();
        this.putLock.unlock();
    }

    public LinkedBlockingQueue() {
        this(Integer.MAX_VALUE);
    }

    private LinkedBlockingQueue(int capacity) {
        this.capacity = Integer.MAX_VALUE;
        this.head = new Node<Object>(null);
        this.last = this.head;
    }

    @Override
    public final int size() {
        return this.count.get();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean offer(E e) {
        void var3_5;
        ReentrantLock reentrantLock;
        LinkedBlockingQueue linkedBlockingQueue;
        if (e == null) {
            throw new NullPointerException();
        }
        AtomicInteger count = this.count;
        if (count.get() == this.capacity) {
            return false;
        }
        int c = -1;
        ReentrantLock putLock = this.putLock;
        putLock.lock();
        try {
            if (count.get() < this.capacity) {
                void var2_4;
                reentrantLock = linkedBlockingQueue;
                linkedBlockingQueue = this;
                linkedBlockingQueue.last.next = new Node<void>((void)reentrantLock);
                this.last = linkedBlockingQueue.last.next;
                c = var2_4.getAndIncrement();
                if (c + 1 < this.capacity) {
                    this.notFull.signal();
                }
            }
        }
        finally {
            putLock.unlock();
        }
        if (c == 0) {
            linkedBlockingQueue = this;
            reentrantLock = linkedBlockingQueue.takeLock;
            reentrantLock.lock();
            try {
                linkedBlockingQueue.notEmpty.signal();
            }
            finally {
                reentrantLock.unlock();
            }
        }
        return var3_5 >= 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final E take() throws InterruptedException {
        void var1_4;
        void var2_2;
        AtomicInteger count = this.count;
        ReentrantLock takeLock = this.takeLock;
        takeLock.lockInterruptibly();
        try {
            while (count.get() == 0) {
                this.notEmpty.await();
            }
            E x = this.dequeue();
            int c = count.getAndDecrement();
            if (c > 1) {
                this.notEmpty.signal();
            }
            takeLock.unlock();
        }
        catch (Throwable x) {
            void var3_3;
            var3_3.unlock();
            throw x;
        }
        if (var2_2 == this.capacity) {
            this.signalNotFull();
        }
        return var1_4;
    }

    /*
     * Exception decompiling
     */
    @Override
    public final E poll(long timeout, TimeUnit unit) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[UNCONDITIONALDOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final E poll() {
        void var2_3;
        void var3_4;
        AtomicInteger count = this.count;
        if (count.get() == 0) {
            return null;
        }
        Object x = null;
        int c = -1;
        ReentrantLock takeLock = this.takeLock;
        takeLock.lock();
        try {
            if (count.get() > 0) {
                void var1_1;
                x = this.dequeue();
                c = var1_1.getAndDecrement();
                if (c > 1) {
                    this.notEmpty.signal();
                }
            }
        }
        finally {
            takeLock.unlock();
        }
        if (var3_4 == this.capacity) {
            this.signalNotFull();
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final E peek() {
        Object e;
        ReentrantLock takeLock;
        block4: {
            if (this.count.get() == 0) {
                return null;
            }
            takeLock = this.takeLock;
            takeLock.lock();
            try {
                Node first = this.head.next;
                if (first != null) break block4;
                takeLock.unlock();
            }
            catch (Throwable throwable) {
                void var1_1;
                var1_1.unlock();
                throw throwable;
            }
            return null;
        }
        e = ((Node)e).item;
        takeLock.unlock();
        return e;
    }

    /*
     * WARNING - void declaration
     */
    final void unlink(Node<E> p, Node<E> trail) {
        void var1_1;
        p.item = null;
        trail.next = p.next;
        if (this.last == var1_1) {
            void var2_2;
            this.last = var2_2;
        }
        if (this.count.getAndDecrement() == this.capacity) {
            this.notFull.signal();
        }
    }

    @Override
    public final boolean remove(Object o) {
        if (o == null) {
            return false;
        }
        this.fullyLock();
        try {
            Node<E> trail = this.head;
            Node p = trail.next;
            while (p != null) {
                if (o.equals(p.item)) {
                    this.unlink(p, trail);
                    return true;
                }
                trail = p;
                p = p.next;
            }
            return false;
        }
        finally {
            this.fullyUnlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object[] toArray() {
        this.fullyLock();
        try {
            void var1_2;
            int n = this.count.get();
            Object[] a2 = new Object[n];
            int k = 0;
            Node p = this.head.next;
            while (p != null) {
                a2[k++] = p.item;
                p = p.next;
            }
            void var3_5 = var1_2;
            return var3_5;
        }
        finally {
            this.fullyUnlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T> T[] toArray(T[] a2) {
        this.fullyLock();
        try {
            void var1_1;
            int size2 = this.count.get();
            if (a2.length < size2) {
                a2 = (Object[])Array.newInstance(a2.getClass().getComponentType(), size2);
            }
            int k = 0;
            Node p = this.head.next;
            while (p != null) {
                a2[k++] = p.item;
                p = p.next;
            }
            if (a2.length > k) {
                a2[var2_3] = null;
            }
            void var3_4 = var1_1;
            return var3_4;
        }
        finally {
            this.fullyUnlock();
        }
    }

    @Override
    public final String toString() {
        this.fullyLock();
        try {
            String string = super.toString();
            return string;
        }
        finally {
            this.fullyUnlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void clear() {
        this.fullyLock();
        try {
            Node p;
            Node<E> h = this.head;
            while ((p = h.next) != null) {
                void var1_2;
                h.next = h;
                p.item = null;
                h = var1_2;
            }
            this.head = this.last;
            if (this.count.getAndSet(0) == this.capacity) {
                this.notFull.signal();
            }
            return;
        }
        finally {
            this.fullyUnlock();
        }
    }

    @Override
    public final Iterator<E> iterator() {
        return new Itr(this);
    }

    final class Itr
    implements Iterator<E> {
        private Node<E> current;
        private Node<E> lastRet;
        private E currentElement;
        private /* synthetic */ LinkedBlockingQueue this$0;

        Itr(LinkedBlockingQueue linkedBlockingQueue) {
            this.this$0 = linkedBlockingQueue;
            linkedBlockingQueue.fullyLock();
            try {
                this.current = ((LinkedBlockingQueue)linkedBlockingQueue).head.next;
                if (this.current != null) {
                    this.currentElement = this.current.item;
                }
                return;
            }
            finally {
                linkedBlockingQueue.fullyUnlock();
            }
        }

        @Override
        public final boolean hasNext() {
            return this.current != null;
        }

        /*
         * WARNING - void declaration
         */
        private Node<E> nextNode(Node<E> p) {
            Node s2;
            while ((s2 = p.next) != p) {
                void var2_2;
                if (s2 == null || s2.item != null) {
                    return s2;
                }
                p = var2_2;
            }
            return ((LinkedBlockingQueue)this.this$0).head.next;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final E next() {
            this.this$0.fullyLock();
            try {
                void var1_1;
                if (this.current == null) {
                    throw new NoSuchElementException();
                }
                Object x = this.currentElement;
                this.lastRet = this.current;
                this.current = this.nextNode(this.current);
                this.currentElement = this.current == null ? null : this.current.item;
                return var1_1;
            }
            finally {
                this.this$0.fullyUnlock();
            }
        }

        @Override
        public final void remove() {
            if (this.lastRet == null) {
                throw new IllegalStateException();
            }
            this.this$0.fullyLock();
            try {
                Node node = this.lastRet;
                this.lastRet = null;
                Node trail = this.this$0.head;
                Node p = trail.next;
                while (p != null) {
                    if (p == node) {
                        this.this$0.unlink(p, trail);
                        break;
                    }
                    trail = p;
                    p = p.next;
                }
                return;
            }
            finally {
                this.this$0.fullyUnlock();
            }
        }
    }

    static final class Node<E> {
        E item;
        Node<E> next;

        /*
         * WARNING - void declaration
         */
        Node(E x) {
            void var1_1;
            this.item = var1_1;
        }
    }
}

