/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.forkjoin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import scala.concurrent.forkjoin.CountedCompleter;
import scala.concurrent.forkjoin.ForkJoinTask;
import scala.concurrent.forkjoin.ForkJoinWorkerThread;
import sun.misc.Unsafe;

public class ForkJoinPool
extends AbstractExecutorService {
    public static final ForkJoinWorkerThreadFactory defaultForkJoinWorkerThreadFactory;
    private static ThreadLocal<Submitter> submitters;
    private static final RuntimePermission modifyThreadPermission;
    static final ForkJoinPool common;
    private static int poolNumberSequence;
    volatile long stealCount;
    volatile long ctl;
    volatile int plock;
    volatile int indexSeed;
    private int config;
    private WorkQueue[] workQueues;
    private ForkJoinWorkerThreadFactory factory;
    private Thread.UncaughtExceptionHandler ueh;
    private String workerNamePrefix;
    private static final Unsafe U;
    private static final long CTL;
    private static final long PARKBLOCKER;
    private static final int ABASE;
    private static final int ASHIFT;
    private static final long STEALCOUNT;
    private static final long PLOCK;
    private static final long INDEXSEED;
    private static final long QLOCK;

    /*
     * WARNING - void declaration
     */
    private static void checkPermission() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            void var0;
            var0.checkPermission(modifyThreadPermission);
        }
    }

    private static final synchronized int nextPoolId() {
        return ++poolNumberSequence;
    }

    /*
     * WARNING - void declaration
     */
    private int acquirePlock() {
        int spins = 256;
        boolean r = false;
        int nps;
        int ps;
        while (((ps = this.plock) & 2) != 0 || !U.compareAndSwapInt(this, PLOCK, ps, nps = ps + 2)) {
            void var3_6;
            int n;
            if (!r) {
                void var3_7;
                WorkQueue w2;
                Thread t = Thread.currentThread();
                if (t instanceof ForkJoinWorkerThread && (w2 = ((ForkJoinWorkerThread)var3_7).workQueue) != null) {
                    int w2 = w2.seed;
                    continue;
                }
                Submitter z = submitters.get();
                if (z != null) {
                    void var2_5;
                    n = var2_5.seed;
                    continue;
                }
                n = 1;
                continue;
            }
            if (spins >= 0) {
                n ^= n << 1;
                n ^= n >>> 3;
                if ((n ^= n << 10) < 0) continue;
                --spins;
                continue;
            }
            if (!U.compareAndSwapInt(this, PLOCK, (int)var3_6, var3_6 | 1)) continue;
            ForkJoinPool forkJoinPool = this;
            synchronized (forkJoinPool) {
                if ((this.plock & 1) != 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        try {
                            Thread.currentThread().interrupt();
                        }
                        catch (SecurityException securityException) {}
                    }
                } else {
                    this.notifyAll();
                }
            }
        }
        return nps;
    }

    /*
     * WARNING - void declaration
     */
    private void releasePlock(int ps) {
        void var1_1;
        this.plock = var1_1;
        ForkJoinPool forkJoinPool = this;
        synchronized (forkJoinPool) {
            this.notifyAll();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void tryAddWorker() {
        long c;
        int u;
        while ((u = (int)((c = this.ctl) >>> 32)) < 0 && (u & 0x8000) != 0 && (int)c == 0) {
            void var2_7;
            void var3_5;
            long nc = (long)(u + 1 & 0xFFFF | u + 65536 & 0xFFFF0000) << 32;
            if (!U.compareAndSwapLong(this, CTL, c, nc)) continue;
            Throwable ex = null;
            ForkJoinWorkerThread wt = null;
            try {
                ForkJoinWorkerThreadFactory fac = this.factory;
                if (fac != null) {
                    void var1_2;
                    wt = var1_2.newThread(this);
                    wt.start();
                    return;
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                ex = throwable;
            }
            this.deregisterWorker((ForkJoinWorkerThread)var3_5, (Throwable)var2_7);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    final WorkQueue registerWorker(ForkJoinWorkerThread wt) {
        void var1_1;
        int s2;
        int n;
        wt.setDaemon(true);
        Thread.UncaughtExceptionHandler handler = this.ueh;
        if (handler != null) {
            wt.setUncaughtExceptionHandler(handler);
        }
        while (!U.compareAndSwapInt(this, INDEXSEED, n = this.indexSeed, s2 = n + 1640531527) || s2 == 0) {
        }
        WorkQueue w = new WorkQueue(this, wt, this.config >>> 16, s2);
        int ps = this.plock;
        if ((ps & 2) != 0 || !U.compareAndSwapInt(this, PLOCK, ps, ps += 2)) {
            ps = this.acquirePlock();
        }
        int nps = ps & Integer.MIN_VALUE | ps + 2 & Integer.MAX_VALUE;
        try {
            WorkQueue[] ws = this.workQueues;
            if (this.workQueues != null) {
                int n2 = ws.length;
                int m = n2 - 1;
                int r = s2 << 1 | 1;
                if (ws[r &= m] != null) {
                    int step;
                    int probes = 0;
                    int n3 = step = n2 <= 4 ? 2 : (n2 >>> 1 & 0xFFFE) + 2;
                    while (ws[r = r + step & m] != null) {
                        if (++probes < n2) continue;
                        this.workQueues = ws = Arrays.copyOf(ws, n2 <<= 1);
                        m = n2 - 1;
                        probes = 0;
                    }
                }
                w.eventCount = w.poolIndex = r;
                var2_3[n] = w;
            }
        }
        finally {
            if (!U.compareAndSwapInt(this, PLOCK, ps, nps)) {
                this.releasePlock(nps);
            }
        }
        var1_1.setName(this.workerNamePrefix.concat(Integer.toString(w.poolIndex)));
        return w;
    }

    /*
     * WARNING - void declaration
     */
    final void deregisterWorker(ForkJoinWorkerThread wt, Throwable ex) {
        void var2_4;
        long c;
        WorkQueue w = null;
        if (wt != null && (w = wt.workQueue) != null) {
            long l;
            w.qlock = -1;
            long ns = w.nsteals;
            while (!U.compareAndSwapLong(this, STEALCOUNT, l = this.stealCount, l + ns)) {
            }
            int ps = this.plock;
            if ((ps & 2) != 0 || !U.compareAndSwapInt(this, PLOCK, ps, ps += 2)) {
                ps = this.acquirePlock();
            }
            int nps = ps & Integer.MIN_VALUE | ps + 2 & Integer.MAX_VALUE;
            try {
                int idx = w.poolIndex;
                WorkQueue[] ws = this.workQueues;
                if (this.workQueues != null && idx >= 0 && idx < ws.length && ws[idx] == w) {
                    ws[idx] = null;
                }
            }
            finally {
                if (!U.compareAndSwapInt(this, PLOCK, ps, nps)) {
                    this.releasePlock(nps);
                }
            }
        }
        while (!U.compareAndSwapLong(this, CTL, c = this.ctl, c - 0x1000000000000L & 0xFFFF000000000000L | c - 0x100000000L & 0xFFFF00000000L | c & 0xFFFFFFFFL)) {
        }
        if (!this.tryTerminate(false, false) && w != null && w.array != null) {
            int e;
            int u;
            void var3_5;
            var3_5.cancelAll();
            while ((u = (int)((c = this.ctl) >>> 32)) < 0 && (e = (int)c) >= 0) {
                void var1_3;
                if (e > 0) {
                    WorkQueue v;
                    int i;
                    WorkQueue[] ws = this.workQueues;
                    if (this.workQueues == null || (i = e & 0xFFFF) >= ws.length || (v = ws[i]) == null) break;
                    long nc = (long)(v.nextWait & Integer.MAX_VALUE) | (long)(u + 65536) << 32;
                    if (v.eventCount != (e | Integer.MIN_VALUE)) break;
                    if (!U.compareAndSwapLong(this, CTL, c, nc)) continue;
                    v.eventCount = e + 65536 & Integer.MAX_VALUE;
                    Thread p = v.parker;
                    if (p == null) break;
                    U.unpark(p);
                    break;
                }
                if ((short)var1_3 >= 0) break;
                this.tryAddWorker();
                break;
            }
        }
        if (ex == null) {
            ForkJoinTask.helpExpungeStaleExceptions();
            return;
        }
        ForkJoinTask.rethrow((Throwable)var2_4);
    }

    /*
     * WARNING - void declaration
     */
    final void externalPush(ForkJoinTask<?> task) {
        ForkJoinPool forkJoinPool;
        Submitter z = submitters.get();
        if (z != null && this.plock > 0) {
            WorkQueue q;
            int m;
            WorkQueue[] ws = this.workQueues;
            if (this.workQueues != null && (m = ws.length - 1) >= 0 && (q = ws[m & z.seed & 0x7E]) != null && U.compareAndSwapInt(q, QLOCK, 0, 1)) {
                int n;
                int an;
                int b2 = q.base;
                int s2 = q.top;
                ForkJoinTask<?>[] a2 = q.array;
                if (q.array != null && (an = a2.length) > (n = s2 + 1 - b2)) {
                    void var3_3;
                    int j = ((an - 1 & s2) << ASHIFT) + ABASE;
                    U.putOrderedObject(var3_3, j, task);
                    q.top = s2 + 1;
                    q.qlock = 0;
                    if (n <= 2) {
                        this.signalWork(q);
                    }
                    return;
                }
                var2_5.qlock = 0;
            }
        }
        void var2_5 = forkJoinPool;
        forkJoinPool = this;
        int n = 0;
        Submitter submitter = submitters.get();
        while (true) {
            int n2;
            int n3;
            Object[] objectArray;
            int n4;
            block25: {
                int n5;
                block24: {
                    if (submitter == null) {
                        n = forkJoinPool.indexSeed;
                        if (!U.compareAndSwapInt(forkJoinPool, INDEXSEED, n, n = n + 1640531527) || n == 0) continue;
                        submitter = new Submitter(n);
                        submitters.set(submitter);
                        continue;
                    }
                    if (n == 0) {
                        n = submitter.seed;
                        n ^= n << 13;
                        n ^= n >>> 17;
                        submitter.seed = n ^ n << 5;
                        continue;
                    }
                    n4 = forkJoinPool.plock;
                    if (n4 < 0) {
                        throw new RejectedExecutionException();
                    }
                    if (n4 == 0) break block24;
                    objectArray = forkJoinPool.workQueues;
                    if (forkJoinPool.workQueues != null && (n3 = objectArray.length - 1) >= 0) break block25;
                }
                n4 = (n5 = forkJoinPool.config & 0xFFFF) > 1 ? n5 - 1 : 1;
                n4 = n4 | n4 >>> 1;
                n4 |= n4 >>> 2;
                n4 |= n4 >>> 4;
                n4 |= n4 >>> 8;
                n4 |= n4 >>> 16;
                n4 = n4 + 1 << 1;
                WorkQueue[] workQueueArray = forkJoinPool.workQueues;
                WorkQueue[] workQueueArray2 = forkJoinPool.workQueues == null || workQueueArray.length == 0 ? new WorkQueue[n4] : null;
                n4 = forkJoinPool.plock;
                if ((n4 & 2) != 0 || !U.compareAndSwapInt(forkJoinPool, PLOCK, n4, n4 += 2)) {
                    n4 = forkJoinPool.acquirePlock();
                }
                workQueueArray = forkJoinPool.workQueues;
                if ((forkJoinPool.workQueues == null || workQueueArray.length == 0) && workQueueArray2 != null) {
                    forkJoinPool.workQueues = workQueueArray2;
                }
                if (U.compareAndSwapInt(forkJoinPool, PLOCK, n4, n2 = n4 & Integer.MIN_VALUE | n4 + 2 & Integer.MAX_VALUE)) continue;
                forkJoinPool.releasePlock(n2);
                continue;
            }
            n2 = n & n3 & 0x7E;
            WorkQueue workQueue = objectArray[n2];
            if (workQueue != null) {
                if (workQueue.qlock == 0 && U.compareAndSwapInt(workQueue, QLOCK, 0, 1)) {
                    objectArray = workQueue.array;
                    n4 = workQueue.top;
                    try {
                        if (objectArray == null || objectArray.length <= n4 + 1 - workQueue.base) {
                            objectArray = workQueue.growArray();
                        }
                        n2 = ((objectArray.length - 1 & n4) << ASHIFT) + ABASE;
                        U.putOrderedObject(objectArray, n2, var2_5);
                        workQueue.top = n4 + 1;
                    }
                    finally {
                        workQueue.qlock = 0;
                    }
                    forkJoinPool.signalWork(workQueue);
                    return;
                }
                n = 0;
                continue;
            }
            if ((forkJoinPool.plock & 2) == 0) {
                int n6;
                workQueue = new WorkQueue(forkJoinPool, null, -1, n);
                n4 = forkJoinPool.plock;
                if ((n4 & 2) != 0 || !U.compareAndSwapInt(forkJoinPool, PLOCK, n4, n4 += 2)) {
                    n4 = forkJoinPool.acquirePlock();
                }
                objectArray = forkJoinPool.workQueues;
                if (forkJoinPool.workQueues != null && n2 < objectArray.length && objectArray[n2] == null) {
                    objectArray[n2] = workQueue;
                }
                if (U.compareAndSwapInt(forkJoinPool, PLOCK, n4, n6 = n4 & Integer.MIN_VALUE | n4 + 2 & Integer.MAX_VALUE)) continue;
                forkJoinPool.releasePlock(n6);
                continue;
            }
            n = 0;
        }
    }

    final void incrementActiveCount() {
        long l;
        while (!U.compareAndSwapLong(this, CTL, l = this.ctl, l + 0x1000000000000L)) {
        }
    }

    /*
     * WARNING - void declaration
     */
    final void signalWork(WorkQueue q) {
        long c;
        int u;
        int hint = q.poolIndex;
        while ((u = (int)((c = this.ctl) >>> 32)) < 0) {
            int e = (int)c;
            if (e > 0) {
                void var1_1;
                void var3_3;
                WorkQueue w;
                int i;
                WorkQueue[] ws = this.workQueues;
                if (this.workQueues == null || ws.length <= (i = e & 0xFFFF) || (w = ws[i]) == null || w.eventCount != (e | Integer.MIN_VALUE)) break;
                long nc = (long)(w.nextWait & Integer.MAX_VALUE) | (long)(u + 65536) << 32;
                if (U.compareAndSwapLong(this, CTL, (long)var3_3, nc)) {
                    w.hint = hint;
                    w.eventCount = e + 65536 & Integer.MAX_VALUE;
                    Thread p = w.parker;
                    if (p == null) break;
                    U.unpark(var1_1);
                    return;
                }
                if (var1_1.top - var1_1.base <= 0) break;
                continue;
            }
            if ((short)u >= 0) break;
            this.tryAddWorker();
            break;
        }
    }

    final void runWorker(WorkQueue w) {
        w.growArray();
        do {
            ForkJoinTask forkJoinTask;
            block27: {
                WorkQueue workQueue = w;
                ForkJoinPool forkJoinPool = this;
                int n = forkJoinPool.plock;
                if (workQueue != null) {
                    int n2;
                    Object object = forkJoinPool.workQueues;
                    if (forkJoinPool.workQueues != null && (n2 = ((WorkQueue[])object).length - 1) >= 0) {
                        int n3;
                        int n4 = workQueue.eventCount;
                        int n5 = workQueue.seed;
                        n5 ^= n5 << 13;
                        n5 ^= n5 >>> 17;
                        n5 ^= n5 << 5;
                        workQueue.seed = n5;
                        workQueue.hint = -1;
                        int n6 = (n2 + n2 + 1 | 0x1FF) & 0x1FFFF;
                        do {
                            WorkQueue workQueue2;
                            if ((workQueue2 = object[n5 + n6 & n2]) == null || (n3 = workQueue2.base) - workQueue2.top >= 0) continue;
                            ForkJoinTask<?>[] forkJoinTaskArray = workQueue2.array;
                            if (workQueue2.array == null) continue;
                            int n7 = ((forkJoinTaskArray.length - 1 & n3) << ASHIFT) + ABASE;
                            ForkJoinTask forkJoinTask2 = (ForkJoinTask)U.getObjectVolatile(forkJoinTaskArray, n7);
                            if (workQueue2.base == n3 && n4 >= 0 && forkJoinTask2 != null && U.compareAndSwapObject(forkJoinTaskArray, n7, forkJoinTask2, null)) {
                                workQueue2.base = n3 + 1;
                                if (workQueue2.base - workQueue2.top < 0) {
                                    forkJoinPool.signalWork(workQueue2);
                                }
                                forkJoinTask = forkJoinTask2;
                                break block27;
                            }
                            if (n4 >= 0 && n6 >= n2 || (int)(forkJoinPool.ctl >> 48) > 0) continue;
                            workQueue.hint = n5 + n6 & n2;
                            break;
                        } while (--n6 >= 0);
                        n3 = workQueue.nsteals;
                        if (n3 != 0) {
                            long l = forkJoinPool.stealCount;
                            if (U.compareAndSwapLong(forkJoinPool, STEALCOUNT, l, l + (long)n3)) {
                                workQueue.nsteals = 0;
                            }
                        } else if (forkJoinPool.plock == n) {
                            long l = forkJoinPool.ctl;
                            int n8 = (int)l;
                            if (n8 < 0) {
                                workQueue.qlock = -1;
                            } else {
                                int n9 = workQueue.hint;
                                if (n9 < 0) {
                                    if (n4 >= 0) {
                                        long l2 = (long)n4 | l - 0x1000000000000L & 0xFFFFFFFF00000000L;
                                        workQueue.nextWait = n8;
                                        workQueue.eventCount = n4 | Integer.MIN_VALUE;
                                        if (forkJoinPool.ctl != l || !U.compareAndSwapLong(forkJoinPool, CTL, l, l2)) {
                                            workQueue.eventCount = n4;
                                        } else if ((int)(l >> 48) == 1 - (forkJoinPool.config & 0xFFFF)) {
                                            long l3 = l;
                                            long l4 = l2;
                                            WorkQueue workQueue3 = workQueue;
                                            object = forkJoinPool;
                                            if (workQueue3 != null && workQueue3.eventCount < 0 && !super.tryTerminate(false, false) && (int)l3 != 0 && ((ForkJoinPool)object).ctl == l4) {
                                                short s2 = -((short)(l4 >>> 32));
                                                n4 = s2;
                                                long l5 = s2 < 0 ? 200000000L : (long)(n4 + 1) * 2000000000L;
                                                long l6 = System.nanoTime() + l5 - 2000000L;
                                                Thread thread = Thread.currentThread();
                                                while (((ForkJoinPool)object).ctl == l4) {
                                                    Thread.interrupted();
                                                    U.putObject(thread, PARKBLOCKER, object);
                                                    workQueue3.parker = thread;
                                                    if (((ForkJoinPool)object).ctl == l4) {
                                                        U.park(false, l5);
                                                    }
                                                    workQueue3.parker = null;
                                                    U.putObject(thread, PARKBLOCKER, null);
                                                    if (((ForkJoinPool)object).ctl == l4) {
                                                        if (l6 - System.nanoTime() > 0L || !U.compareAndSwapLong(object, CTL, l4, l3)) continue;
                                                        workQueue3.eventCount = workQueue3.eventCount + 65536 | Integer.MAX_VALUE;
                                                        workQueue3.hint = -1;
                                                        workQueue3.qlock = -1;
                                                    }
                                                    break;
                                                }
                                            }
                                        }
                                    } else if (workQueue.eventCount < 0 && forkJoinPool.ctl == l) {
                                        Thread thread = Thread.currentThread();
                                        Thread.interrupted();
                                        U.putObject(thread, PARKBLOCKER, forkJoinPool);
                                        workQueue.parker = thread;
                                        if (workQueue.eventCount < 0) {
                                            U.park(false, 0L);
                                        }
                                        workQueue.parker = null;
                                        U.putObject(thread, PARKBLOCKER, null);
                                    }
                                }
                                if (n9 >= 0 || (n9 = workQueue.hint) >= 0) {
                                    WorkQueue workQueue4;
                                    object = forkJoinPool.workQueues;
                                    if (forkJoinPool.workQueues != null && n9 < ((WorkQueue[])object).length && (workQueue4 = object[n9]) != null) {
                                        n6 = (forkJoinPool.config & 0xFFFF) - 1;
                                        do {
                                            Object object2;
                                            n4 = workQueue.eventCount < 0 ? 0 : -1;
                                            n4 = n4 - workQueue4.base + workQueue4.top;
                                            if (n4 <= n6 && (n6 = n4) <= 0 || (n4 = (int)((l = forkJoinPool.ctl) >>> 32)) >= 0 || (n8 = (int)l) <= 0 || n2 < (n5 = n8 & 0xFFFF) || (object2 = object[n5]) == null) break;
                                            long l7 = (long)(((WorkQueue)object2).nextWait & Integer.MAX_VALUE) | (long)(n4 + 65536) << 32;
                                            if (((WorkQueue)object2).eventCount != (n8 | Integer.MIN_VALUE) || !U.compareAndSwapLong(forkJoinPool, CTL, l, l7)) break;
                                            ((WorkQueue)object2).hint = n9;
                                            ((WorkQueue)object2).eventCount = n8 + 65536 & Integer.MAX_VALUE;
                                            Thread thread = ((WorkQueue)object2).parker;
                                            if (thread == null) continue;
                                            U.unpark(thread);
                                        } while (--n6 > 0);
                                    }
                                }
                            }
                        }
                    }
                }
                forkJoinTask = null;
            }
            w.runTask(forkJoinTask);
        } while (w.qlock >= 0);
    }

    /*
     * WARNING - void declaration
     */
    private void helpSignal(ForkJoinTask<?> task, int origin) {
        int u;
        if (task != null && task.status >= 0 && (u = (int)(this.ctl >>> 32)) < 0 && u >> 16 < 0) {
            int m;
            WorkQueue[] ws = this.workQueues;
            if (this.workQueues != null && (m = ws.length - 1) >= 0) {
                int k = origin;
                block0: for (int j = m; j >= 0; --j) {
                    WorkQueue q = ws[k++ & m];
                    int n = m;
                    while (task.status >= 0) {
                        WorkQueue w;
                        int i;
                        int e;
                        int s2;
                        if (q == null || (s2 = -q.base + q.top) <= n && (n = s2) <= 0) continue block0;
                        long c = this.ctl;
                        u = (int)(c >>> 32);
                        if (u >= 0 || (e = (int)c) <= 0 || m < (i = e & 0xFFFF) || (w = ws[i]) == null) break block0;
                        long nc = (long)(w.nextWait & Integer.MAX_VALUE) | (long)(u + 65536) << 32;
                        if (w.eventCount != (e | Integer.MIN_VALUE)) break block0;
                        if (!U.compareAndSwapLong(this, CTL, c, nc)) continue;
                        w.eventCount = e + 65536 & Integer.MAX_VALUE;
                        Thread p = w.parker;
                        if (p != null) {
                            void var2_3;
                            U.unpark(var2_3);
                        }
                        if (--n > 0) continue;
                        continue block0;
                    }
                    break block0;
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private int tryHelpStealer(WorkQueue joiner, ForkJoinTask<?> task) {
        stat = 0;
        steps = 0;
        if (joiner != null && task != null) {
            block0: while (true) {
                subtask = task;
                j = joiner;
                while (true) {
                    block8: {
                        if ((s = task.status) < 0) {
                            stat = s;
                            break block0;
                        }
                        ws = this.workQueues;
                        if (this.workQueues == null || (m = ws.length - 1) <= 0) break block0;
                        h = (j.hint | 1) & m;
                        v = ws[h];
                        if (v == null || v.currentSteal != subtask) {
                            origin = h;
                            do {
                                if (((h = h + 2 & m) & 15) == 1 && (subtask.status < 0 || j.currentJoin != subtask)) continue block0;
                                v = ws[h];
                                if (v == null || v.currentSteal != subtask) continue;
                                j.hint = h;
                                break block8;
                            } while (h != origin);
                            break block0;
                        }
                    }
                    while (true) {
                        if (subtask.status < 0) continue block0;
                        b = v.base;
                        if (b - v.top >= 0) break;
                        a = v.array;
                        if (v.array == null) break;
                        i = ((a.length - 1 & b) << ForkJoinPool.ASHIFT) + ForkJoinPool.ABASE;
                        t = (ForkJoinTask)ForkJoinPool.U.getObjectVolatile(a, i);
                        if (subtask.status < 0 || j.currentJoin != subtask || v.currentSteal != subtask) continue block0;
                        stat = 1;
                        if (t != null && v.base == b && ForkJoinPool.U.compareAndSwapObject(a, i, t, null)) {
                            v.base = b + 1;
                            joiner.runSubtask(t);
                            continue;
                        }
                        if (v.base == b && ++steps == 64) break block0;
                    }
                    next = v.currentJoin;
                    if (subtask.status >= 0 && j.currentJoin == subtask && v.currentSteal == subtask) ** break;
                    continue block0;
                    if (next == null || ++steps == 64) break block0;
                    subtask = next;
                    j = v;
                }
                break;
            }
        }
        return (int)var3_3;
    }

    private int helpComplete(ForkJoinTask<?> task, int mode) {
        if (task != null) {
            int m;
            WorkQueue[] ws = this.workQueues;
            if (this.workQueues != null && (m = ws.length - 1) >= 0) {
                int j = 1;
                int origin = 1;
                while (true) {
                    int s2;
                    if ((s2 = task.status) < 0) {
                        return s2;
                    }
                    WorkQueue q = ws[j & m];
                    if (q != null && q.pollAndExecCC(task)) {
                        int u;
                        origin = j;
                        if (mode != -1 || (u = (int)(this.ctl >>> 32)) < 0 && u >> 16 < 0) continue;
                        break;
                    }
                    if ((j = j + 2 & m) == origin) break;
                }
            }
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    final boolean tryCompensate() {
        long c;
        int e;
        int pc = this.config & 0xFFFF;
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null && (e = (int)(c = this.ctl)) >= 0) {
            WorkQueue w;
            int i;
            if (e != 0 && (i = e & 0xFFFF) < ws.length && (w = ws[i]) != null && w.eventCount == (e | Integer.MIN_VALUE)) {
                long nc = (long)(w.nextWait & Integer.MAX_VALUE) | c & 0xFFFFFFFF00000000L;
                if (U.compareAndSwapLong(this, CTL, c, nc)) {
                    w.eventCount = e + 65536 & Integer.MAX_VALUE;
                    Thread p = w.parker;
                    if (p != null) {
                        U.unpark(p);
                    }
                    return true;
                }
            } else {
                long nc;
                void p;
                short tc = (short)(c >>> 32);
                if (tc >= 0 && (int)(c >> 48) + p > 1) {
                    long nc2 = c - 0x1000000000000L & 0xFFFF000000000000L | c & 0xFFFFFFFFFFFFL;
                    if (U.compareAndSwapLong(this, CTL, c, nc2)) {
                        return true;
                    }
                } else if (tc + p < Short.MAX_VALUE && U.compareAndSwapLong(this, CTL, c, nc = c + 0x100000000L & 0xFFFF00000000L | c & 0xFFFF0000FFFFFFFFL)) {
                    void var2_8;
                    void var3_11;
                    Throwable ex = null;
                    ForkJoinWorkerThread wt = null;
                    try {
                        ForkJoinWorkerThreadFactory fac = this.factory;
                        if (fac != null) {
                            void var1_3;
                            wt = var1_3.newThread(this);
                            wt.start();
                            return true;
                        }
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        ex = throwable;
                    }
                    this.deregisterWorker((ForkJoinWorkerThread)var3_11, (Throwable)var2_8);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    final int awaitJoin(WorkQueue joiner, ForkJoinTask<?> task) {
        void var3_4;
        int s2 = 0;
        if (joiner != null && task != null && (s2 = task.status) >= 0) {
            ForkJoinTask<?> prevJoin = joiner.currentJoin;
            joiner.currentJoin = task;
            while ((s2 = task.status) >= 0 && !joiner.isEmpty() && joiner.tryRemoveAndExec(task)) {
            }
            if (s2 >= 0 && (s2 = task.status) >= 0) {
                this.helpSignal(task, joiner.poolIndex);
                s2 = task.status;
                if (s2 >= 0 && task instanceof CountedCompleter) {
                    s2 = this.helpComplete(task, 0);
                }
            }
            while (s2 >= 0 && (s2 = task.status) >= 0) {
                long l;
                if (joiner.isEmpty() && (s2 = this.tryHelpStealer(joiner, task)) != 0 || (s2 = task.status) < 0) continue;
                this.helpSignal(task, joiner.poolIndex);
                s2 = task.status;
                if (s2 < 0 || !this.tryCompensate()) continue;
                if (task.trySetSignal() && (s2 = task.status) >= 0) {
                    ForkJoinTask<?> forkJoinTask = task;
                    synchronized (forkJoinTask) {
                        if (task.status >= 0) {
                            try {
                                task.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        } else {
                            task.notifyAll();
                        }
                    }
                }
                while (!U.compareAndSwapLong(this, CTL, l = this.ctl, l + 0x1000000000000L)) {
                }
            }
            var1_1.currentJoin = prevJoin;
        }
        return (int)var3_4;
    }

    /*
     * WARNING - void declaration
     */
    final void helpJoinOnce(WorkQueue joiner, ForkJoinTask<?> task) {
        if (joiner != null && task != null && task.status >= 0) {
            void var3_4;
            int s2;
            ForkJoinTask<?> prevJoin = joiner.currentJoin;
            joiner.currentJoin = task;
            while ((s2 = task.status) >= 0 && !joiner.isEmpty() && joiner.tryRemoveAndExec(task)) {
            }
            if (s2 >= 0 && (s2 = task.status) >= 0) {
                this.helpSignal(task, joiner.poolIndex);
                s2 = task.status;
                if (s2 >= 0 && task instanceof CountedCompleter) {
                    s2 = this.helpComplete(task, 0);
                }
            }
            if (var3_4 >= 0 && joiner.isEmpty()) {
                while (task.status >= 0 && this.tryHelpStealer(joiner, task) > 0) {
                }
            }
            var1_1.currentJoin = prevJoin;
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean tryTerminate(boolean now, boolean enable) {
        if (this == ForkJoinPool.common) {
            return false;
        }
        ps = this.plock;
        if (ps >= 0) {
            if (!enable) {
                return false;
            }
            if ((ps & 2) != 0 || !ForkJoinPool.U.compareAndSwapInt(this, ForkJoinPool.PLOCK, ps, ps += 2)) {
                ps = this.acquirePlock();
            }
            if (!ForkJoinPool.U.compareAndSwapInt(this, ForkJoinPool.PLOCK, ps, nps = ps + 2 & 0x7FFFFFFF | -2147483648)) {
                this.releasePlock(nps);
            }
        }
        block5: while (true) {
            if (((c = this.ctl) & 0x80000000L) != 0L) {
                if ((short)(c >>> 32) == -(this.config & 65535)) {
                    enable = this;
                    synchronized (enable) {
                        this.notifyAll();
                    }
                }
                return true;
            }
            if (!now) {
                if ((int)(c >> 48) != -(this.config & 65535)) {
                    return false;
                }
                ws = this.workQueues;
                if (this.workQueues != null) {
                    for (i = 0; i < ws.length; ++i) {
                        w = ws[i];
                        if (w == null) continue;
                        if (!w.isEmpty()) {
                            this.signalWork(w);
                            return false;
                        }
                        if ((i & 1) == 0 || w.eventCount < 0) continue;
                        return false;
                    }
                }
            }
            if (!ForkJoinPool.U.compareAndSwapLong(this, ForkJoinPool.CTL, c, c | 0x80000000L)) continue;
            pass = 0;
            while (true) {
                if (pass < 3) ** break;
                continue block5;
                ws = this.workQueues;
                if (this.workQueues != null) {
                    n = ws.length;
                    for (i = 0; i < n; ++i) {
                        w = ws[i];
                        if (w == null) continue;
                        w.qlock = -1;
                        if (pass <= 0) continue;
                        w.cancelAll();
                        if (pass <= 1 || (wt = w.owner) == null) continue;
                        if (!wt.isInterrupted()) {
                            try {
                                wt.interrupt();
                            }
                            catch (Throwable v0) {}
                        }
                        ForkJoinPool.U.unpark(wt);
                    }
                    while ((e = (int)(cc = this.ctl) & 0x7FFFFFFF) != 0 && (i = e & 65535) < n && i >= 0 && (w = ws[i]) != null) {
                        nc = (long)(w.nextWait & 0x7FFFFFFF) | cc + 0x1000000000000L & -281474976710656L | cc & 0xFFFF80000000L;
                        if (w.eventCount != (e | -2147483648) || !ForkJoinPool.U.compareAndSwapLong(this, ForkJoinPool.CTL, cc, nc)) continue;
                        w.eventCount = e + 65536 & 0x7FFFFFFF;
                        w.qlock = -1;
                        p = w.parker;
                        if (p == null) continue;
                        ForkJoinPool.U.unpark(p);
                    }
                }
                ++pass;
            }
            break;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void externalHelpJoin(ForkJoinTask<?> t) {
        ForkJoinTask<?>[] forkJoinTaskArray;
        long j;
        Object q;
        int m;
        Submitter z;
        if (t == null || (z = submitters.get()) == null) return;
        Object p = common;
        WorkQueue[] ws = ((ForkJoinPool)p).workQueues;
        if (((ForkJoinPool)p).workQueues == null || (m = ws.length - 1) < 0 || (q = ws[m & z.seed & 0x7E]) == null) return;
        ForkJoinTask<?>[] a2 = ((WorkQueue)q).array;
        if (((WorkQueue)q).array == null) return;
        int am = a2.length - 1;
        int s2 = ((WorkQueue)q).top;
        if (s2 != ((WorkQueue)q).base && U.getObject(a2, j = (long)(((am & s2 - 1) << ASHIFT) + ABASE)) == t && U.compareAndSwapInt(q, QLOCK, 0, 1)) {
            if (((WorkQueue)q).array == a2 && ((WorkQueue)q).top == s2 && U.compareAndSwapObject(forkJoinTaskArray, j, t, null)) {
                ((WorkQueue)q).top = s2 - 1;
                ((WorkQueue)q).qlock = 0;
                ((ForkJoinTask)t).doExec();
            } else {
                ((WorkQueue)q).qlock = 0;
            }
        }
        if (((ForkJoinTask)t).status < 0) return;
        if (t instanceof CountedCompleter) {
            Object object;
            int n;
            ForkJoinPool forkJoinPool = p;
            WorkQueue workQueue = q;
            q = t;
            p = workQueue;
            t = forkJoinPool;
            if (p == null) return;
            forkJoinTaskArray = ((WorkQueue)p).array;
            if (((WorkQueue)p).array == null || (n = forkJoinTaskArray.length - 1) < 0 || q == null || ((ForkJoinTask)q).status < 0) return;
            do {
                long l;
                Object object2;
                object = null;
                int n2 = ((WorkQueue)p).top;
                if (n2 - ((WorkQueue)p).base > 0 && (object2 = U.getObject(forkJoinTaskArray, l = (long)(((n & n2 - 1) << ASHIFT) + ABASE))) != null && object2 instanceof CountedCompleter) {
                    object2 = (CountedCompleter)object2;
                    CountedCompleter countedCompleter = object2;
                    if (object2 == q && U.compareAndSwapInt(p, QLOCK, 0, 1)) {
                        if (((WorkQueue)p).array == forkJoinTaskArray && ((WorkQueue)p).top == n2 && U.compareAndSwapObject(forkJoinTaskArray, l, object2, null)) {
                            ((WorkQueue)p).top = n2 - 1;
                            object = object2;
                        }
                        ((WorkQueue)p).qlock = 0;
                    }
                }
                if (object != null) {
                    ((ForkJoinTask)object).doExec();
                }
                if (((ForkJoinTask)q).status < 0 || (n2 = (int)(((ForkJoinPool)t).ctl >>> 32)) >= 0 || n2 >> 16 >= 0) return;
            } while (object != null);
            super.helpSignal((ForkJoinTask<?>)q, ((WorkQueue)p).poolIndex);
            if (((ForkJoinTask)q).status < 0) return;
            super.helpComplete((ForkJoinTask<?>)q, -1);
            return;
        } else {
            void var2_3;
            ForkJoinTask<?> forkJoinTask;
            void var1_2;
            super.helpSignal(forkJoinTask, var2_3.poolIndex);
        }
    }

    public ForkJoinPool() {
        this(Math.min(Short.MAX_VALUE, Runtime.getRuntime().availableProcessors()), defaultForkJoinWorkerThreadFactory, null, false);
    }

    /*
     * WARNING - void declaration
     */
    public ForkJoinPool(int parallelism, ForkJoinWorkerThreadFactory factory, Thread.UncaughtExceptionHandler handler, boolean asyncMode) {
        void var2_2;
        void var1_1;
        ForkJoinPool.checkPermission();
        if (factory == null) {
            throw new NullPointerException();
        }
        if (parallelism <= 0 || parallelism > Short.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        this.factory = factory;
        this.ueh = null;
        this.config = parallelism | (asyncMode ? 65536 : 0);
        long np = -parallelism;
        this.ctl = np << 48 & 0xFFFF000000000000L | np << 32 & 0xFFFF00000000L;
        int pn = ForkJoinPool.nextPoolId();
        StringBuilder sb = new StringBuilder("ForkJoinPool-");
        sb.append(Integer.toString((int)var1_1));
        sb.append("-worker-");
        this.workerNamePrefix = var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    private ForkJoinPool(int parallelism, long ctl, ForkJoinWorkerThreadFactory factory, Thread.UncaughtExceptionHandler handler) {
        void var2_2;
        void var1_1;
        this.config = var1_1;
        this.ctl = var2_2;
        this.factory = factory;
        this.ueh = handler;
        this.workerNamePrefix = "ForkJoinPool.commonPool-worker-";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void execute(Runnable task) {
        void var1_1;
        ForkJoinTask job;
        if (task == null) {
            throw new NullPointerException();
        }
        job = task instanceof ForkJoinTask ? (ForkJoinTask)((Object)task) : new ForkJoinTask.AdaptedRunnableAction((Runnable)((Object)job));
        this.externalPush((ForkJoinTask<?>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private <T> ForkJoinTask<T> submit(Callable<T> task) {
        void var1_1;
        ForkJoinTask.AdaptedCallable<T> job = new ForkJoinTask.AdaptedCallable<T>(task);
        this.externalPush(job);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private <T> ForkJoinTask<T> submit(Runnable task, T result2) {
        void var1_1;
        void var2_2;
        ForkJoinTask.AdaptedRunnable<void> job = new ForkJoinTask.AdaptedRunnable<void>(task, var2_2);
        this.externalPush(job);
        return var1_1;
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) {
        ArrayList<Future<T>> futures = new ArrayList<Future<T>>(tasks.size());
        boolean done = false;
        try {
            for (Callable<T> t : tasks) {
                ForkJoinTask.AdaptedCallable<T> f = new ForkJoinTask.AdaptedCallable<T>(t);
                futures.add(f);
                this.externalPush(f);
            }
            int size2 = futures.size();
            for (int i = 0; i < size2; ++i) {
                ((ForkJoinTask)futures.get(i)).quietlyJoin();
            }
            done = true;
            ArrayList<Future<T>> arrayList = futures;
            return arrayList;
        }
        catch (Throwable throwable) {
            if (!done) {
                int size3 = futures.size();
                for (int i = 0; i < size3; ++i) {
                    ((Future)futures.get(i)).cancel(false);
                }
            }
            throw throwable;
        }
    }

    public final int getParallelism() {
        return this.config & 0xFFFF;
    }

    public final boolean isQuiescent() {
        return (int)(this.ctl >> 48) + (this.config & 0xFFFF) == 0;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var3_2;
        void var1_1;
        long qt = 0L;
        long qs = 0L;
        int rc = 0;
        long st = this.stealCount;
        long c = this.ctl;
        WorkQueue[] ws = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 0; i < ws.length; ++i) {
                Thread.State state;
                int size22;
                WorkQueue w = ws[i];
                if (w == null) continue;
                WorkQueue workQueue = w;
                int n = workQueue.base - workQueue.top;
                int n2 = size22 = n >= 0 ? 0 : -n;
                if ((i & 1) == 0) {
                    qs += (long)size22;
                    continue;
                }
                qt += (long)size22;
                st += (long)w.nsteals;
                Object size22 = w;
                if (!(((WorkQueue)size22).eventCount >= 0 && (size22 = ((WorkQueue)size22).owner) != null && (state = ((Thread)size22).getState()) != Thread.State.BLOCKED && state != Thread.State.WAITING && state != Thread.State.TIMED_WAITING)) continue;
                ++rc;
            }
        }
        int pc = this.config & 0xFFFF;
        int tc = pc + (short)(c >>> 32);
        int ac = pc + (int)(c >> 48);
        if (ac < 0) {
            ac = 0;
        }
        String level = (c & 0x80000000L) != 0L ? (tc == 0 ? "Terminated" : "Terminating") : (this.plock < 0 ? "Shutting down" : "Running");
        return super.toString() + "[" + level + ", parallelism = " + pc + ", size = " + tc + ", active = " + ac + ", running = " + rc + ", steals = " + st + ", tasks = " + (long)var1_1 + ", submissions = " + (long)var3_2 + "]";
    }

    @Override
    public void shutdown() {
        ForkJoinPool.checkPermission();
        this.tryTerminate(false, true);
    }

    @Override
    public List<Runnable> shutdownNow() {
        ForkJoinPool.checkPermission();
        this.tryTerminate(true, true);
        return Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isTerminated() {
        void var1_1;
        long c = this.ctl;
        return (c & 0x80000000L) != 0L && (short)(var1_1 >>> 32) == -(this.config & 0xFFFF);
    }

    @Override
    public boolean isShutdown() {
        return this.plock < 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        void var1_2;
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (this == common) {
            this.awaitQuiescence(timeout, unit);
            return false;
        }
        long nanos = unit.toNanos(timeout);
        if (this.isTerminated()) {
            return true;
        }
        long startTime = System.nanoTime();
        ForkJoinPool forkJoinPool = this;
        synchronized (forkJoinPool) {
            boolean terminated;
            long waitTime = nanos;
            long millis = 0L;
            while (!(terminated = this.isTerminated() || waitTime <= 0L || (millis = unit.toMillis(waitTime)) <= 0L)) {
                this.wait(millis);
                waitTime = nanos - (System.nanoTime() - startTime);
            }
        }
        return (boolean)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    private boolean awaitQuiescence(long timeout, TimeUnit unit2) {
        long nanos2 = unit2.toNanos(timeout);
        Thread thread = Thread.currentThread();
        if (thread instanceof ForkJoinWorkerThread) {
            Object wt = (ForkJoinWorkerThread)thread;
            if (((ForkJoinWorkerThread)wt).pool == this) {
                WorkQueue workQueue = ((ForkJoinWorkerThread)wt).workQueue;
                wt = this;
                boolean unit2 = true;
                while (true) {
                    long l;
                    WorkQueue workQueue2;
                    int n;
                    Object nanos2;
                    block17: {
                        int n2;
                        nanos2 = workQueue;
                        ForkJoinTask<?> forkJoinTask = ((WorkQueue)nanos2).mode == 0 ? ((WorkQueue)nanos2).pop() : ((WorkQueue)nanos2).poll();
                        if (forkJoinTask != null) {
                            if (workQueue.base - workQueue.top < 0) {
                                ((ForkJoinPool)wt).signalWork(workQueue);
                            }
                            forkJoinTask.doExec();
                            continue;
                        }
                        nanos2 = workQueue;
                        n = ((WorkQueue)nanos2).seed;
                        n ^= n << 13;
                        n ^= n >>> 17;
                        n = ((WorkQueue)nanos2).seed = n ^ n << 5;
                        nanos2 = wt;
                        do {
                            int n3;
                            n2 = ((ForkJoinPool)nanos2).plock;
                            WorkQueue[] workQueueArray = ((ForkJoinPool)nanos2).workQueues;
                            if (((ForkJoinPool)nanos2).workQueues == null || (n3 = workQueueArray.length - 1) < 0) continue;
                            for (int i = n3 + 1 << 2; i >= 0; --i) {
                                WorkQueue workQueue3 = workQueueArray[(n + i << 1 | 1) & n3];
                                if (workQueue3 == null || workQueue3.base - workQueue3.top >= 0) continue;
                                workQueue2 = workQueue3;
                                break block17;
                            }
                        } while (((ForkJoinPool)nanos2).plock != n2);
                        workQueue2 = null;
                    }
                    nanos2 = workQueue2;
                    if (workQueue2 != null) {
                        ForkJoinTask<?> forkJoinTask;
                        if (!unit2) {
                            unit2 = true;
                            while (!U.compareAndSwapLong(wt, CTL, l = ((ForkJoinPool)wt).ctl, l + 0x1000000000000L)) {
                            }
                        }
                        if ((n = ((WorkQueue)nanos2).base) - ((WorkQueue)nanos2).top >= 0 || (forkJoinTask = ((WorkQueue)nanos2).pollAt(n)) == null) continue;
                        if (((WorkQueue)nanos2).base - ((WorkQueue)nanos2).top < 0) {
                            ((ForkJoinPool)wt).signalWork((WorkQueue)nanos2);
                        }
                        workQueue.runSubtask(forkJoinTask);
                        continue;
                    }
                    if (unit2) {
                        l = ((ForkJoinPool)wt).ctl;
                        long l2 = l - 0x1000000000000L;
                        if ((int)(l2 >> 48) + (((ForkJoinPool)wt).config & 0xFFFF) == 0) break;
                        if (!U.compareAndSwapLong(wt, CTL, l, l2)) continue;
                        unit2 = false;
                        continue;
                    }
                    l = ((ForkJoinPool)wt).ctl;
                    if ((int)(l >> 48) + (((ForkJoinPool)wt).config & 0xFFFF) == 0 && U.compareAndSwapLong(wt, CTL, l, l + 0x1000000000000L)) break;
                }
                return true;
            }
        }
        long startTime = System.nanoTime();
        int r = 0;
        boolean found = true;
        block4: while (!this.isQuiescent()) {
            int m;
            WorkQueue[] ws = this.workQueues;
            if (this.workQueues == null || (m = ws.length - 1) < 0) break;
            if (!found) {
                if (System.nanoTime() - startTime > nanos2) {
                    return false;
                }
                Thread.yield();
            }
            found = false;
            for (int j = m + 1 << 2; j >= 0; --j) {
                void var1_2;
                int b2;
                WorkQueue q;
                if ((q = ws[r++ & m]) == null || (b2 = q.base) - q.top >= 0) continue;
                found = true;
                ForkJoinTask<?> t = q.pollAt(b2);
                if (t == null) continue block4;
                if (q.base - q.top < 0) {
                    this.signalWork(q);
                }
                var1_2.doExec();
                continue block4;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static void managedBlock(ManagedBlocker blocker) throws InterruptedException {
        Thread t = Thread.currentThread();
        if (t instanceof ForkJoinWorkerThread) {
            ForkJoinPool p = ((ForkJoinWorkerThread)t).pool;
            while (!blocker.isReleasable()) {
                int m;
                WorkQueue[] ws = p.workQueues;
                if (p.workQueues != null && (m = ws.length - 1) >= 0) {
                    for (int i = 0; i <= m; ++i) {
                        void var3_5;
                        if (blocker.isReleasable()) {
                            return;
                        }
                        WorkQueue q = ws[i];
                        if (q == null || q.base - q.top >= 0) continue;
                        p.signalWork(q);
                        int u = (int)(p.ctl >>> 32);
                        if (u >= 0 || var3_5 >> 16 >= 0) break;
                    }
                }
                if (!p.tryCompensate()) continue;
                try {
                    while (!blocker.isReleasable() && !blocker.block()) {
                    }
                    break;
                }
                finally {
                    p.incrementActiveCount();
                }
            }
            return;
        }
        while (!blocker.isReleasable() && !blocker.block()) {
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value2) {
        void var2_2;
        void var1_1;
        return new ForkJoinTask.AdaptedRunnable<void>((Runnable)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        void var1_1;
        return new ForkJoinTask.AdaptedCallable(var1_1);
    }

    static /* synthetic */ Unsafe access$000() {
        return scala.concurrent.util.Unsafe.instance;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var2_4;
        void var0;
        void var1_3;
        void var3_6;
        try {
            U = scala.concurrent.util.Unsafe.instance;
            Class<ForkJoinPool> k = ForkJoinPool.class;
            CTL = U.objectFieldOffset(k.getDeclaredField("ctl"));
            STEALCOUNT = U.objectFieldOffset(k.getDeclaredField("stealCount"));
            PLOCK = U.objectFieldOffset(k.getDeclaredField("plock"));
            INDEXSEED = U.objectFieldOffset(k.getDeclaredField("indexSeed"));
            Class<Thread> tk = Thread.class;
            PARKBLOCKER = U.objectFieldOffset(tk.getDeclaredField("parkBlocker"));
            Class<WorkQueue> wk = WorkQueue.class;
            QLOCK = U.objectFieldOffset(wk.getDeclaredField("qlock"));
            Class<ForkJoinTask[]> ak = ForkJoinTask[].class;
            ABASE = U.arrayBaseOffset(ak);
            int scale = U.arrayIndexScale(ak);
            if ((scale & scale - 1) != 0) {
                throw new Error("data type scale not a power of two");
            }
            ASHIFT = 31 - Integer.numberOfLeadingZeros(scale);
        }
        catch (Exception e) {
            throw new Error(e);
        }
        submitters = new ThreadLocal();
        ForkJoinWorkerThreadFactory fac = defaultForkJoinWorkerThreadFactory = new ForkJoinWorkerThreadFactory();
        modifyThreadPermission = new RuntimePermission("modifyThread");
        int par = 0;
        Thread.UncaughtExceptionHandler handler = null;
        try {
            String pp = System.getProperty("java.util.concurrent.ForkJoinPool.common.parallelism");
            String hp = System.getProperty("java.util.concurrent.ForkJoinPool.common.exceptionHandler");
            String fp = System.getProperty("java.util.concurrent.ForkJoinPool.common.threadFactory");
            if (fp != null) {
                fac = (ForkJoinWorkerThreadFactory)ClassLoader.getSystemClassLoader().loadClass(fp).newInstance();
            }
            if (hp != null) {
                handler = (Thread.UncaughtExceptionHandler)ClassLoader.getSystemClassLoader().loadClass(hp).newInstance();
            }
            if (pp != null) {
                par = Integer.parseInt(pp);
            }
        }
        catch (Exception exception) {}
        if (par <= 0) {
            par = Runtime.getRuntime().availableProcessors();
        }
        if (par > Short.MAX_VALUE) {
            par = Short.MAX_VALUE;
        }
        long np = -par;
        long ct = np << 48 & 0xFFFF000000000000L | var3_6 << 32 & 0xFFFF00000000L;
        common = new ForkJoinPool((int)var1_3, ct, (ForkJoinWorkerThreadFactory)var0, (Thread.UncaughtExceptionHandler)var2_4);
    }

    public static abstract class ManagedBlocker {
        private final scala.concurrent.ManagedBlocker blocker$1;

        public boolean block() throws InterruptedException {
            return this.blocker$1.block();
        }

        public boolean isReleasable() {
            return this.blocker$1.isReleasable();
        }

        /*
         * WARNING - void declaration
         */
        public ManagedBlocker(scala.concurrent.ManagedBlocker blocker$1) {
            void var1_1;
            this.blocker$1 = var1_1;
        }
    }

    static final class WorkQueue {
        int seed;
        volatile int eventCount;
        int nextWait;
        int hint;
        int poolIndex;
        final int mode;
        int nsteals;
        volatile int qlock;
        volatile int base;
        int top;
        ForkJoinTask<?>[] array;
        private ForkJoinPool pool;
        final ForkJoinWorkerThread owner;
        volatile Thread parker;
        volatile ForkJoinTask<?> currentJoin;
        ForkJoinTask<?> currentSteal;
        private static final Unsafe U;
        private static final int ABASE;
        private static final int ASHIFT;

        /*
         * WARNING - void declaration
         */
        WorkQueue(ForkJoinPool pool, ForkJoinWorkerThread owner, int mode, int seed) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.pool = var1_1;
            this.owner = var2_2;
            this.mode = var3_3;
            this.seed = seed;
            this.top = 4096;
            this.base = 4096;
        }

        /*
         * WARNING - void declaration
         */
        final boolean isEmpty() {
            block3: {
                block2: {
                    void var3_1;
                    void var2_4;
                    void var1_3;
                    int m;
                    int s2 = this.top;
                    int n = this.base - s2;
                    if (n >= 0) break block2;
                    if (n != -1) break block3;
                    ForkJoinTask<?>[] a2 = this.array;
                    if (this.array != null && (m = a2.length - 1) >= 0 && U.getObject(var1_3, (long)((var2_4 & var3_1 - true) << ASHIFT) + (long)ABASE) != null) break block3;
                }
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        final void push(ForkJoinTask<?> task) {
            int s2 = this.top;
            ForkJoinTask<?>[] a2 = this.array;
            if (this.array != null) {
                void var1_2;
                void var3_4;
                void var2_5;
                int m = a2.length - 1;
                int j = ((m & s2) << ASHIFT) + ABASE;
                U.putOrderedObject(var2_5, j, task);
                this.top = var3_4 + true;
                void n = this.top - this.base;
                if (n <= 2) {
                    ForkJoinPool p = this.pool;
                    if (p != null) {
                        void var1_3;
                        var1_3.signalWork(this);
                        return;
                    }
                } else if (var1_2 >= m) {
                    this.growArray();
                }
            }
        }

        final ForkJoinTask<?>[] growArray() {
            int b2;
            int t;
            int oldMask;
            ForkJoinTask<?>[] oldA = this.array;
            int size2 = this.array != null ? oldA.length << 1 : 8192;
            if (size2 > 0x4000000) {
                throw new RejectedExecutionException("Queue capacity exceeded");
            }
            this.array = new ForkJoinTask[size2];
            ForkJoinTask[] a2 = this.array;
            if (oldA != null && (oldMask = oldA.length - 1) >= 0 && (t = this.top) - (b2 = this.base) > 0) {
                int mask = size2 - 1;
                do {
                    int oldj = ((b2 & oldMask) << ASHIFT) + ABASE;
                    int j = ((b2 & mask) << ASHIFT) + ABASE;
                    ForkJoinTask x = (ForkJoinTask)U.getObjectVolatile(oldA, oldj);
                    if (x == null || !U.compareAndSwapObject(oldA, oldj, x, null)) continue;
                    U.putObjectVolatile(a2, j, x);
                } while (++b2 != t);
            }
            return a2;
        }

        /*
         * WARNING - void declaration
         */
        final ForkJoinTask<?> pop() {
            int m;
            ForkJoinTask<?>[] a2 = this.array;
            if (this.array != null && (m = a2.length - 1) >= 0) {
                long j;
                ForkJoinTask t;
                int s2;
                while ((s2 = this.top - 1) - this.base >= 0 && (t = (ForkJoinTask)U.getObject(a2, j = (long)(((m & s2) << ASHIFT) + ABASE))) != null) {
                    void var2_3;
                    if (!U.compareAndSwapObject(a2, j, t, null)) continue;
                    this.top = s2;
                    return var2_3;
                }
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        final ForkJoinTask<?> pollAt(int b2) {
            void var3_2;
            int j;
            ForkJoinTask t;
            ForkJoinTask<?>[] a2 = this.array;
            if (this.array != null && (t = (ForkJoinTask)U.getObjectVolatile(a2, j = ((a2.length - 1 & b2) << ASHIFT) + ABASE)) != null && this.base == b2 && U.compareAndSwapObject(var3_2, j, t, null)) {
                void var2_4;
                void var1_1;
                this.base = var1_1 + true;
                return var2_4;
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        final ForkJoinTask<?> poll() {
            int b2;
            while ((b2 = this.base) - this.top < 0) {
                void var2_2;
                ForkJoinTask<?>[] a2 = this.array;
                if (this.array == null) break;
                int j = ((a2.length - 1 & b2) << ASHIFT) + ABASE;
                ForkJoinTask t = (ForkJoinTask)U.getObjectVolatile(a2, j);
                if (t != null) {
                    void var3_3;
                    void var1_1;
                    if (this.base != b2 || !U.compareAndSwapObject(var1_1, j, t, null)) continue;
                    this.base = b2 + 1;
                    return var3_3;
                }
                if (this.base != b2) continue;
                if (var2_2 + true == this.top) break;
                Thread.yield();
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        final boolean tryUnpush(ForkJoinTask<?> t) {
            void var1_1;
            void var2_2;
            int s2;
            ForkJoinTask<?>[] a2 = this.array;
            if (this.array != null && (s2 = this.top) != this.base && U.compareAndSwapObject(a2, ((((void)var2_2).length - 1 & --s2) << ASHIFT) + ABASE, var1_1, null)) {
                void var3_3;
                this.top = var3_3;
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        final void cancelAll() {
            ForkJoinTask<?> t;
            ForkJoinTask.cancelIgnoringExceptions(this.currentJoin);
            ForkJoinTask.cancelIgnoringExceptions(this.currentSteal);
            while ((t = this.poll()) != null) {
                void var1_1;
                ForkJoinTask.cancelIgnoringExceptions(var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        final boolean tryRemoveAndExec(ForkJoinTask<?> task) {
            void var2_2;
            void var3_3;
            int b2;
            int s2;
            int n;
            int m;
            boolean stat = true;
            boolean removed = false;
            boolean empty = true;
            ForkJoinTask<?>[] a2 = this.array;
            if (this.array != null && (m = a2.length - 1) >= 0 && (n = (s2 = this.top) - (b2 = this.base)) > 0) {
                int j;
                ForkJoinTask t;
                while ((t = (ForkJoinTask)U.getObjectVolatile(a2, j = ((--s2 & m) << ASHIFT) + ABASE)) != null) {
                    if (t == task) {
                        if (s2 + 1 == this.top) {
                            if (!U.compareAndSwapObject(a2, j, task, null)) break;
                            this.top = s2;
                            removed = true;
                            break;
                        }
                        if (this.base != b2) break;
                        removed = U.compareAndSwapObject(a2, j, task, new EmptyTask());
                        break;
                    }
                    if (t.status >= 0) {
                        empty = false;
                    } else if (s2 + 1 == this.top) {
                        if (!U.compareAndSwapObject(a2, j, t, null)) break;
                        this.top = s2;
                        break;
                    }
                    if (--n != 0) continue;
                    if (empty || this.base != b2) break;
                    stat = false;
                    break;
                }
            }
            if (var3_3 != false) {
                void var1_1;
                var1_1.doExec();
            }
            return (boolean)var2_2;
        }

        /*
         * WARNING - void declaration
         */
        final boolean pollAndExecCC(ForkJoinTask<?> root) {
            int b2;
            while ((b2 = this.base) - this.top < 0) {
                void var3_3;
                void var2_2;
                CountedCompleter t;
                long j;
                Object o;
                ForkJoinTask<?>[] a2 = this.array;
                if (this.array == null || (o = U.getObject(a2, j = (long)(((a2.length - 1 & b2) << ASHIFT) + ABASE))) == null || !(o instanceof CountedCompleter)) break;
                CountedCompleter countedCompleter = t = (CountedCompleter)o;
                if (t != root) break;
                if (this.base != b2 || !U.compareAndSwapObject(var2_2, j, t, null)) continue;
                this.base = var3_3 + true;
                t.doExec();
                return true;
            }
            return false;
        }

        final void runTask(ForkJoinTask<?> t) {
            if (t != null) {
                WorkQueue workQueue;
                this.currentSteal = workQueue;
                this.currentSteal.doExec();
                this.currentSteal = null;
                ++this.nsteals;
                if (this.base - this.top < 0) {
                    ForkJoinTask<?> forkJoinTask;
                    if (this.mode == 0) {
                        workQueue = this;
                        while (true) {
                            long l;
                            ForkJoinTask forkJoinTask2;
                            int n;
                            int n2;
                            ForkJoinTask<?>[] forkJoinTaskArray = workQueue.array;
                            if (workQueue.array == null || (n2 = forkJoinTaskArray.length - 1) < 0 || (n = workQueue.top - 1) - workQueue.base < 0 || (forkJoinTask2 = (ForkJoinTask)U.getObject(forkJoinTaskArray, l = (long)(((n2 & n) << ASHIFT) + ABASE))) == null) break;
                            if (!U.compareAndSwapObject(forkJoinTaskArray, l, forkJoinTask2, null)) continue;
                            workQueue.top = n;
                            forkJoinTask2.doExec();
                        }
                        return;
                    }
                    workQueue = this;
                    while ((forkJoinTask = workQueue.poll()) != null) {
                        forkJoinTask.doExec();
                    }
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        final void runSubtask(ForkJoinTask<?> t) {
            if (t != null) {
                void var2_2;
                void var1_1;
                ForkJoinTask<?> ps = this.currentSteal;
                this.currentSteal = var1_1;
                this.currentSteal.doExec();
                this.currentSteal = var2_2;
            }
        }

        /*
         * WARNING - void declaration
         */
        static {
            try {
                void var1_3;
                U = ForkJoinPool.access$000();
                Class<WorkQueue> k = WorkQueue.class;
                Class<ForkJoinTask[]> ak = ForkJoinTask[].class;
                U.objectFieldOffset(k.getDeclaredField("qlock"));
                ABASE = U.arrayBaseOffset(ak);
                int scale = U.arrayIndexScale((Class<?>)var1_3);
                if ((scale & scale - 1) != 0) {
                    throw new Error("data type scale not a power of two");
                }
                ASHIFT = 31 - Integer.numberOfLeadingZeros(scale);
                return;
            }
            catch (Exception e) {
                void var0_2;
                throw new Error((Throwable)var0_2);
            }
        }
    }

    static final class EmptyTask
    extends ForkJoinTask<Void> {
        EmptyTask() {
            this.status = -268435456;
        }

        @Override
        public final boolean exec() {
            return true;
        }
    }

    static final class Submitter {
        int seed;

        /*
         * WARNING - void declaration
         */
        Submitter(int s2) {
            void var1_1;
            this.seed = var1_1;
        }
    }

    public static abstract class ForkJoinWorkerThreadFactory {
        /*
         * WARNING - void declaration
         */
        public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
            void var1_1;
            return new ForkJoinWorkerThread((ForkJoinPool)var1_1);
        }

        ForkJoinWorkerThreadFactory() {
        }
    }
}

