/*
    filename: dmfbarea.c

COPYRIGHT (c) 1989, 1990, 1991  Matrox Electronic Systems Ltd.
All Rights Reserved

*/

/*/
*
*   Function:   iodmfbarea()
*
*   Date:       May 15, 1990
*
*   Returns:    0 if error, 1 if no error
*
*/

#include "imseries.h"
#include "imbind.h"
#include "proto.h"
#include "i_head.h"

#ifndef I_UNIX
#include <io.h>
#endif

extern  I_IMGLOB    i_glob;

extern unsigned short i_v_factable[I_N_OF_FBORGS];
extern unsigned short i_v_sizetable[I_N_OF_FBORGS];

/*------------*/
/* PROTOTYPES */
/*------------*/

#ifdef __DLL__
/* This prototype is usefull for Windows function _lwrite() that is used
   instead of write() */
int far pascal _lwrite(int, char far *, int );
#endif

#ifdef PHAR_LAP
_far unsigned long *AllocSegment(unsigned long, unsigned long);
_far unsigned long OpenHighFBWindow(unsigned short window_sel,unsigned long fb);
void FTYPE movsdw (_far void *sbuf, _far void *dbuf, unsigned short count);
#endif

#ifdef  ANSI
short FTYPE iodmfbarea(short fb, int handle, unsigned short xstart,
                       unsigned short ystart, unsigned short xend,
                       unsigned short yend, void _I_PTYPE *buf,
                       unsigned long bufsize)
#else
short FTYPE iodmfbarea(fb, handle, xstart, ystart, xend, yend, buf, bufsize)
short   fb;
int     handle;
unsigned short  xstart, ystart, xend, yend;
void    _I_PTYPE *buf;
unsigned long   bufsize;
#endif
    {
    unsigned long block_height,num_of_blocks;

#ifndef PHAR_LAP
    unsigned long i,lines_left;
#endif

#ifdef PHAR_LAP
    unsigned long pitch,longs_per_line,block_size,j,k,remaining_lines;
    _far unsigned long *host_ptr, *start;
    void _far *bufptr;
#endif /* PHAR_LAP */

    unsigned long height,width;

    short fborg;

    /* get frame buffer organisation */
    if ( fb == I_OVL_SURF )
        fborg = I_OVL_2KX1K;
    else
        fborg = i_glob.vramhra->tappt & I_TAPPT_FBORG_MSK;

    height = yend - ystart + 1;
    width = xend - xstart + 1;


#ifdef PHAR_LAP

   OpenHighFBWindow(1,fb);

   host_ptr = AllocSegment(i_glob.high_map,0x200);

      /* initialise host pointer */
   pitch = i_v_factable[fborg]*256;  /* fb width in long words */
   host_ptr += ystart * pitch + (xstart<<i_v_sizetable[fborg])/4;
   /* get number of 32-bit accesses in each line */
   /* (number of bytes should be a factor of 4   */
   /*  otherwise some accesses will be missing)  */
   longs_per_line = (width<<i_v_sizetable[fborg])/4;
   bufsize /= 4; /* bufsize now in longs */

   if (longs_per_line)
      {
         /* num of full lines in buf */
      block_height = bufsize / longs_per_line;
      block_size = block_height*longs_per_line;
      }
   else
      return(0);
   if (block_height)
      num_of_blocks = height / block_height;
   else
      num_of_blocks = 0;

                        /* dump complete blocks (if any) */
   bufptr = (void _far *)buf;
   for (k = 0; k < num_of_blocks; k++)
      {
      for (j = 0; j < block_height; j++)
         {
         start = host_ptr;

          movsdw(host_ptr,bufptr,longs_per_line);
          *(long **)&bufptr += longs_per_line;
/*!!!
         for (i = 0; i < longs_per_line; i++)
            *(*(unsigned long **)&bufptr)++ = *host_ptr++;
!!!*/
         host_ptr = start + pitch; /* go to next line */
         }

      bufptr = (void _far *)buf;
      if (write(handle,buf,block_size*4) == -1)
         return(0);
      }
                        /* dump remaining pixels */

   remaining_lines = height%block_height;
   for (j = 0; j < remaining_lines; j++)
      {
      start = host_ptr;
      movsdw(host_ptr,bufptr,longs_per_line);
      *(long **)&bufptr += longs_per_line;
/*!!!
      for (i = 0; i < longs_per_line; i++)
         *(*(unsigned long **)&bufptr)++ = *host_ptr++;
!!!*/
      host_ptr = start + pitch; /* go to next line */
      }
   write(handle,buf,remaining_lines*width<<i_v_sizetable[fborg]);

#else

    if (bufsize > 0xF000)
        bufsize = 0xF000;

    /* num of full lines in buf */
    block_height = bufsize/(width<<i_v_sizetable[fborg]);

    if (block_height)
        {
        /* align bufsize to block height */
        bufsize = block_height*(width<<i_v_sizetable[fborg]);
        num_of_blocks = height/block_height;

        /* dump all full blocks */
        for (i = 0; i < num_of_blocks; i++)
            {

            if (!iordfbarea(fb,(short)xstart,(short)ystart,(short)xend,
             (short) (ystart+block_height-1),buf))
                return(0);

            ystart += (unsigned short) block_height;

#ifdef __DLL__
            if (_lwrite(handle,(char far *)buf,(unsigned)bufsize) == -1)
#else
            if (write(handle,buf,(unsigned)bufsize) == -1)
#endif
                {
                i_glob.ioerror = I_IOERR_FILEWR;
                return(0);
                }

            }
        /* dump all leftover lines (if any) */
        lines_left = height%block_height;
        if (lines_left)
            {
            if (!iordfbarea(fb,(short)xstart,(short)ystart,(short)xend,
             (short) (ystart+lines_left-1),buf))
                return(0);

#ifdef __DLL__
            if (_lwrite(handle,(char far *)buf,
             (unsigned)(lines_left*(width<<i_v_sizetable[fborg]))) == -1)
#else
            if (write(handle,buf,
             (unsigned)(lines_left*(width<<i_v_sizetable[fborg]))) == -1)
#endif
                {
                i_glob.ioerror = I_IOERR_FILEWR;
                return(0);
                }
            }
        }

    else /* buf smaller than one line */
        /* so call iodmfbarea() recursively for half lines */
        for (i = (unsigned long)ystart; i <= (unsigned long)yend ; i++)
            {
            iodmfbarea(fb,handle,xstart,(unsigned short)i,
             (unsigned short)(xend-width/2),(unsigned short)i,buf,bufsize);
            iodmfbarea(fb,handle,(unsigned short)(xend-width/2+1),(unsigned short)i,
             xend,(unsigned short)i,buf,bufsize);
            }

#endif /* PHAR_LAP */

    /* hstctll register bit 14 indicates a bus fault error */
    if (i_glob.vramhra -> hstctll & 0x4000)
        {
        /* reset bit */
        i_glob.vramhra -> hstctll &= 0xBFFF;

        /* return error message */
        i_glob.ioerror = I_IOERR_BUSERR;
        return(0);
        }

    /* otherwise, return success message */
    return (1);

} /* iodmfbarea() */


