/*
    filename:   ls_ls.h
    Synopsis:   functions prototypes for graphics ls module
    Date:       March the 19th 1991
                                            
COPYRIGHT (c) 1991  Matrox Electronic Systems Ltd.
All Rights Reserved

*/

#ifndef __I_LS_LS_H__
#define __I_LS_LS_H__

/* Need imseries.h for I_UNIX defines */
#ifndef __I_IMSERIES_H__
#include "imseries.h"
#endif /* __I_IMSERIES_H__ */

/* Need i_dll.h for FTYPE */
#ifndef __I_I_DLL_H__
#ifdef I_UNIX
#include <im_series/i_dll.h>
#else
#include "i_dll.h"
#endif /* I_UNIX */
#endif /* __I_I_DLL_H__ */

/* Need def.h for definitions */
#ifndef __I_DEF_H__
#ifdef I_UNIX
#include <im_series/def.h>
#else
#include "def.h"
#endif /* I_UNIX */
#endif /* __I_DEF_H */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

void FTYPE lsbmarmsk(short spx,short spy,short dpx,short dpy,
                     unsigned short sizex,unsigned short sizey);
void FTYPE lscbm(unsigned short bm_id,struct Bitmap _I_PTYPE *bm_spec_ptr);
void FTYPE lsclappend(unsigned short command_list_num,
                      unsigned short execute_flag);
void FTYPE lsclclose(void );
void FTYPE lscldel(short command_list_num);
void FTYPE lsclexec(unsigned short command_list_num);
void FTYPE lsclloop(unsigned short command_list_num,short number_times);
void FTYPE lsclmodify(unsigned short command_list_num,short word_offset,
                      short num_words,short _I_PTYPE *wordptr);
void FTYPE lsclopen(unsigned short command_list_num,
                    unsigned short execute_flag);
void FTYPE lsclpos(void );
void FTYPE lsclread(unsigned short command_list_num);
void FTYPE lsclrealloc(unsigned short realloc_flag);
void FTYPE lsclsblksz(unsigned long blk_size);
void FTYPE lscpbmms(short spx,short spy,short dpx,short dpy,
                    unsigned short sizex,unsigned short sizey);
void FTYPE lscpbmsm(short spx,short spy,short dpx,short dpy,
                    unsigned short sizex,unsigned short sizey);
void FTYPE lscpbmzm(short spx,short spy,short dpx,short dpy,
                    unsigned short sizex,unsigned short sizey,float zoomx,
                    float zoomy);
void FTYPE lsdapat(unsigned short fillpat_id,struct Bitmap _I_PTYPE *fillpat_ptr);
void FTYPE lsdclpl(short id,unsigned short num_clpr,short _I_PTYPE *clip_ptr);
void FTYPE lsdfont(unsigned short font_id,struct Font _I_PTYPE *font_ptr);
void FTYPE lsdgc(unsigned short cursor_id,short xhot,short yhot,
                 struct Bitmap _I_PTYPE *gc_bmapptr);
void FTYPE lsegaen(unsigned short mode);
void FTYPE lsegasw(unsigned short mode);
void FTYPE lsemulen(unsigned short restore_flag);
void FTYPE lserror(unsigned short flag);
void FTYPE lsfbm(unsigned short bm_length,unsigned short _I_PTYPE *bm_data_ptr);
void FTYPE lsinq(unsigned short inq_code);
void FTYPE lsinqgcp(void );
void FTYPE lsinqmem(void );
void FTYPE lsinqsys(void );
void FTYPE lslutblink(unsigned short phy_lut,unsigned short index,
                      unsigned short r,unsigned short g,unsigned short b,
                      unsigned short offtime,unsigned short ontime);
void FTYPE lslutflash(unsigned long phylut_id,unsigned short index,
                      unsigned short r,unsigned short g,unsigned short b,
                      unsigned short off_time,unsigned short on_time);
void FTYPE lslutmd(unsigned short log_lut,unsigned short first_entry,
                   unsigned short nentries,struct Lutval _I_PTYPE *colors);
void FTYPE lslutpm(unsigned short phy_lut,unsigned short bitmask);
void FTYPE lslutrd(unsigned short log_lut,unsigned short first_entry,
                   unsigned short nentries);
void FTYPE lslutrs(short def_lut,unsigned short log_lut);
void FTYPE lslutsblink(void );
void FTYPE lslutsl(unsigned short log_lut,unsigned short phy_lut);
void FTYPE lslutsync(unsigned short sync_fct);
void FTYPE lsnoop(void );
void FTYPE lspkdi(void );
void FTYPE lspken(short x,short y,unsigned short half_xsize,
                  unsigned short half_ysize);
void FTYPE lspksidh(unsigned short hi_id);
void FTYPE lspksidl(unsigned short low_id);
void FTYPE lsrapat(unsigned short apat_id);
void FTYPE lsrbm(unsigned short bm_id);
void FTYPE lsrclpl(short id);
void FTYPE lsrdrst(short left,short top,short right,short bottom,
                   char _I_PTYPE *dest_filename);
void FTYPE lsrfont(unsigned short font_id);
void FTYPE lsrgc(unsigned short cursor_id);
void FTYPE lsrlrdrst(short left,short top,short right,short bottom,
                     char _I_PTYPE *dest_filename);
short FTYPE lsrlwrrst(short left,short top,short right,short bottom,
                      char _I_PTYPE *src_filename);
void FTYPE lssafapat(short apat_id);
void FTYPE lssbm(short bm_id);
void FTYPE lssclpl(short id);
void FTYPE lssfont(short font_id);
void FTYPE lssgc(short cursor_id);
void FTYPE lsskip(unsigned short num_words);
void FTYPE lsswlapat(short apat_id);
void FTYPE lsswpvar(short tot_space,short no_words);
void FTYPE lsvsint(unsigned short frames);
void FTYPE lswait(unsigned short frames);
short FTYPE lswrrst(short left,short top,short right,short bottom,
                    char _I_PTYPE *src_filename);

#ifdef  __cplusplus
}
#endif /* __cplusplus */
#endif /* ___I_LS_LS_H_ */

