/*
    filename:   opcode.h
    Synopsis:   Definition of indexes for 'C' functions to be acessed
                from the secondary command decoder.
    Date:       August the 8th 1989

COPYRIGHT (c) 1989, 1990, 1991  Matrox Electronic Systems Ltd.
All Rights Reserved

*/

#ifndef __I_OPCODE_H__
#define __I_OPCODE_H__

/**** V2:   Virtual 2D routines. ****/

#define V2MDID                  0x009A  /* file V2MDID.c  */
#define V2MDSET                 0x0099  /* file V2MDSET.c */
#define V2MDORG                 0x009B  /* file V2MDORG.c */
#define V2MDROT                 0x009C  /* file V2MDROT.c */


/* This is the secondary command decoder opcode list definition. */

#define SECOND_DEC              0x000001FFL
#define TEST_INTS               0x00FE01FFL
#define SEXT_TAG                0x00FF01FFL

/**** ST:    Statistical Processing Image-series routines. ****/

#define STCCHIST                0x000000L    /* file STCCHIST.c */
#define STCCPROF                0x010000L    /* file STCPROF.c  */
#define STCCECOUNT              0x020000L    /* file STECOUNT.c */
#define STCCFASTCEN             0x030000L    /* file FASTCEN.c  */
#define STCCFBSTAT              0x040000L    /* file STFBSTAT.c */
#define STLDLUT                 0x050000L    /* file STLDLUT.c  */
#define STGTFBSTAT              0x060000L    /* file GTFBSTAT.c */

/**** GSP:    ****/

#define GSPCCHIST               0x100000L    /* file GSPFCT.c   */
#define GSPDOCONV               0x110000L    /* file GSPFCT.c   */

/**** FB:    ****/

#define FBCPBTOB                0x200000L    /* file FBCPBTOP.c */
#define FBCPBTODEV              0x260000L    /* file FBCPBTOD.c */
#define FBCMCCITT3              0xF50000L    /* file CMCCITT3.c */
#define FBDCCCITT3              0xF60000L    /* file DCCCITT3.c */

/**** UT:   ****/

#define UTCCLUTEXTR             0x210000L    /* file CCLUTEXT.c */
#define UTGNLUTTRAN             0x220000L    /* file GNLUTTRA.c */
#define UTGNGLUT                0x230000L    /* file UTGNGLUT.c */
#define UTCCLUTSTAT             0x240000L    /* file CCLUTSTA.c */
#define UTCMLUT                 0x250000L    /* file UTCMLUT.c  */


/**** SPL: (staic processing lists) ****/

#define PCSCCRLIST              0X280000L    /* file PCCRLST.c */
#define PCSCCLLIST              0X290000L	 /* file PCCLLST.c */
#define PCSCRMLIST              0X2A0000L	 /* file PCRMLST.c */
#define PCSCEXECLIST            0X2B0000L	 /* file PCEXELST.c */
#define PCSCSTCOND              0X2C0000L	 /* file PCSCCOND.c */
#define PCSCSTPAGOFFSET         0X2D0000L	 /* file PCSCPAG.c */
#define PCSCST2COND             0X300000L	 /* file PCSC2CON.c */
#define PCSCHALT                0X290000L	 /* file PCSCHALT.c */


/**** NB:    Spatial Filtering Image-series routines. ****/

#define NBDFKER                 0x400000L    /* file DFKER.c    */
#define NBDFMKER                0x410000L    /* file DFMKER.c   */
#define NBDOCONV                0x420000L    /* file DOCONV.c   */
#define NBDOMCONV               0x430000L    /* file DOMCONV.c  */
#define NBDORNOISE              0x440000L    /* file DORNOISE.c */
#define NBDORANK                0x450000L    /* file DORANK.c   */
#define NBDOIZOOM               0x460000L    /* file DOIZOOM.C  */

/**** CO:    Color processing Image-series routines. ****/

#define COCVTOGREY              0x500000L    /* file COCVGREY.C */
#define CODODISTANCE            0x510000L    /* file CODIST.C   */
#define COCVTO555               0x520000L    /* file COCV555.C  */
#define CODOHSIGRAB             0x530000L    /* file COHSIGRA.C */

/**** MO:    Morphological Image-series routines. ****/

#define MODFMSTRUCT             0x600000L    /* file DFMSTRUC.c */
#define MODFSTRUCT              0x610000L    /* file DFSTRUCT.c */
#define MODLSTRUCT              0x620000L    /* file DLSTRUCT.c */
#define MODOCMAP                0x630000L    /* file DOCMAP.c   */
#define MODODISTANCE            0x640000L    /* file DODIST.c   */
#define MODOERODIL              0x650000L    /* file DOERODIL.c */
#define MODOFASTTHIN            0x660000L    /* file DOFASTTH.c */
#define MODOLABEL               0x670000L    /* file DOLABEL.c  */
#define MODOMARKER              0x680000L    /* file DOMARKER.c */
#define MODOMATCH               0x690000L    /* file DOMATCH.c  */
#define MODORCDIL               0x6A0000L    /* file DORCDIL.c  */
#define MODOTHICKTHIN           0x6B0000L    /* file DOTHICK.c  */
#define MODOZONE                0x6C0000L    /* file DOOZONE.c  */
#define MODOCOMPLAB             0x6D0000L    /* file DOCOMPLA.c */
#define MOGNTHINLUT             0x6E0000L    /* file GNTHINLU.c */
#define MODOGREYTHIN            0x6F0000L    /* file GREYTHIN.c */
#define MODORECTHIN             0x700000L    /* file RECTHIN.c  */
#define MODORECERODIL           0x710000L    /* file RCERODIL.c */
#define MOIQSTRUCT              0x720000L    /* file IQSTRUCT.c */

/**** PT:    Point-to-Point Image-series routines. ****/

#define PTDOALUMAP              0x800000L    /* file ALUMAP.c   */
#define PTDODLUTMAP             0x810000L    /* file DLUTMAP.c  */
#define PTDOSOLUTMAP            0x820000L    /* file SOLUTMAP.c */
#define PTDOCTHRESH             0x830000L    /* file THRESH.c   */
#define PTDOWLEVEL              0x840000L    /* file WLEVEL.c   */
#define PTDOWTSUM               0x850000L    /* file WTSUM.c    */
#define PTDOMUL16               0x860000L    /* file MUL16.c    */

#define DISTVERPARM             0x890000L    /* file DISTHPAR.c */
#define DISTHORPARM             0x8A0000L    /* file DISTHPAR.c */
#define DISTCOLORSPACE          0x8B0000L    /* file DISTCOSP.c */
#define DILDLOGCAM              0x8C0000L       /* file DILDLCAM.c */
#define DISTDOUBLESCAN          0x8D0000L    /* file DISTDBSC.c */
#define DISTCOLORFMT            0x8E0000L    /* file DISTCLFM.c */
#define DISTDECBRIGHT           0x8F0000L    /* file DISTBRIT.c */
#define DISTDECCONT             0x900000L    /* file DISTCONT.c */
#define DISTDECSATUR            0x910000L    /* file DISTSAT.c  */
#define DISTDECHUE              0x920000L    /* file DISTHUE.c  */

#define DISLGAIN                0x940000L    /* file DISLGAIN.c */
#define DISLBOARD               0x950000L    /* file DISLBRD.c  */
#define DISTEXPOSURE            0x960000L    /* file DISTEXP.c  */
#define DISLPALETTE             0x970000L    /* file DISLPAL.c  */
#define DISNGRAB                0x980000L    /* file DISNGRAB.c */
#define DIDOMGRAB               0x990000L    /* file DIMGRAB.c  */
#define DISTREFBLACK            0x9A0000L    /* file DISTREFB.c */
#define DISTREFWHITE            0x9B0000L    /* file DISTREFW.c */
#define DISLCHANNEL             0x9C0000L    /* file DISLCHAN.c */
#define DIDODSATFILTER          0x9D0000L    /* file DSATFILT.c */
#define DIDOTFILTER             0x9E0000L    /* file TFILTER.c  */
#define DIDOGRAB                0x9F0000L    /* file DIGRAB.c   */

/**** DC:    Display Control Image-series routines. ****/

#define LSDCSTDMODE             0xA00000L    /* file DCHLFCT.c  */
#define LSDCSTRGB555            0xA10000L    /* file DCHLFCT.c  */
#define LSDCSTRGB888            0xA20000L    /* file DCHLFCT.c  */
#define LSDCSTOPAL              0xA30000L    /* file DCHLFCT.c  */
#define LSDCSTOMASK             0xA40000L    /* file DCHLFCT.c  */
#define LSDCSTFBMPLANE          0xA50000L    /* file DCHLFCT.c  */
#define LSDCSTOVRSOURCE         0xA60000L    /* file DCHLFCT.c  */
#define LSDCSTMSBSOURCE         0xA70000L    /* file DCHLFCT.c  */
#define LSDCSTPZSCROLL          0xA80000L    /* file DCHLFCT.c  */
#define LSDCSTWACTIVE           0xA90000L    /* file DCHLFCT.c  */
#define LSDCSTBDCOLOR           0xAA0000L    /* file DCHLFCT.c  */
#define LSDCINITVDO             0xAB0000L    /* file DCHLFCT.c  */
#define LSDCSTPORTRAIT          0xAC0000L    /* file DCHLFCT.c  */
#define LSDCSTBDMODE            0xAD0000L    /* file DCHLFCT.c  */
#define LSDCSTAOSOURCE          0xAE0000L    /* file DCHLFCT.c  */
#define LSDCSTVGAMODE           0xAF0000L    /* file DCHLFCT.c  */
#define LSDCSTUNDERLAY          0xB00000L    /* file DCHLFCT.c  */
#define LSDCSTSYNCGUN           0xB10000L    /* file DCHLFCT.c  */
#define LSDCSTRDMASK            0xB20000L    /* file DCHLFCT.c  */
#define LSDCSTVIEWMODE          0xB30000L    /* file DCHLFCT.c  */
#define LSDCSTVIEWPRG           0xB40000L    /* file DCHLFCT.c  */
#define LSDCSTVIEWSEQ           0xB50000L    /* file DCHLFCT.c  */
#define LSDCSTVIEWCPY           0xB60000L    /* file DCHLFCT.c  */
#define LSDCSTINTERLUT          0xB70000L    /* file DCHLFCT.c  */
#define LSDCSTALPHA             0xB80000L    /* file DCHLFCT.c  */
#define LSDCLDVIDEO             0xB90000L    /* file DCLDVID.c  */
#define LSDCSTCOLKEY            0xBA0000L    /* file DCHLFCT.c  */
#define LSDCSTOSYNC             0x1D0000L    /* file DCHLFCT.c  */

/***** LM:   Lut Management Image-series routines.  ****/
#define LSLMSLBOARD             0xBC0000L    /* file LMHLFCT.c  */
#define UTLMGNLUT               0xBF0000L    /* file UTLMFCT.c  */

/**** IO:    */
#define IOSTRDMASK              0xDD0000L    /* file IOSTRMSK.c */
#define IOSTWRMASK              0xDE0000L    /* file IOSTWMSK.c */
#define IOSTOVRDMASK            0x1E0000L    /* file IOSTOMSK.c */
#define IOSTOVWRMASK            0x1F0000L    /* file IOSTOMSK.c */
#define LLEEPROM                0x1C0000L    /* file EEPROM.c   */

/**** OA:    Object Analysis Image-series routines. ****/

#define FTCCCORNER              0xC00000L
#define FTCCMASS                0xC10000L
#define FTCCNPIXELS             0xC20000L
#define FTCCPER                 0xC30000L
#define FTCCSPIXELS             0xC40000L
#define FTFDCONFIG              0xC50000L
#define FTFDFPOINT              0xC60000L
#define FTSTCONFIG              0xC70000L
#define FTSTOBJECT              0xC80000L

/**** PC:    Process Control Image-series routines. ****/

#define PCIQUSR                 0xDF0000L    /* file PCIQUSR.c  */
#define PCSTBINARIZE            0xE00000L    /* file PCBINZE.c  */
#define PCSTFBORG               0xE10000L    /* file PCFBORG.c  */
#define PCSTFORMAT              0xE20000L    /* file PCFORMAT.c */
#define PCSLSYNC                0xE30000L    /* file PCSLSYNC.c */
#define PCSTCOND                0xE40000L    /* file PCSTCOND.c */
#define PCSTKCEN                0xE50000L    /* file PCSTKEN.c  */
#define PCSTLATTICE             0xE60000L    /* file PCSTLATT.c */
#define PCSTSRCMSK              0xE70000L    /* file PCSTMSK.c  */
#define PCSTDSTMSK              0xE80000L    /* file PCSTMSK.c  */
#define PCSTOOI                 0xE90000L    /* file PCSTOOI.c  */
#define PCSTOVERSCAN            0xEA0000L    /* file PCSTOVER.c */
#define PCSTROISIZ              0xEB0000L    /* file PCSTROI.c  */
#define PCSTROIPOS              0xEC0000L    /* file PCSTROI.c  */
#define PCSTSUBSAMP             0xED0000L    /* file PCSTSSP.c  */
#define PCSLLOGCAM              0xEE0000L    /* file PCSLCAM.c  */
#define PCHLPROCESS             0xEF0000L    /* file PCHLPRO.c  */
#define PCIQSYS                 0xF00000L    /* file PCIQSYS.c  */
#define PCSTFPUFORMAT           0xF10000L    /* file DLFPUCOD.c */
#define PCSLPROCMODE            0xF20000L    /* file PCSLPROC.c */
#define PCSTDIR                 0xF30000L    /* file PCSTDIR.c  */

/**** FP:    Standard FPU Image-series routines. ****/

#define FPUTLDFPUCOD            0x1000000L  /* file DLFPUCOD.c */

#define FPFDCVFLTINT            0x1080000L  /* file CVFLINT.c */
#define FPFDDOFFT1D             0x1090000L  /* file DOFFT1D.c */
#define FPFDDOFFT2D             0x10A0000L  /* file DOFFT2D.c */
#define FPFDCVRECTEXP           0x10B0000L  /* file CVRECPOL.c */
#define FPFDDOARITHMETIC        0x10C0000L  /* file DOARITHM.c */
#define FPFDDOARITHCONST        0x10D0000L  /* file ARITHCTE.c */

#define FPGTDFGTRAN             0x1140000L  /* file DFGTRAN.c */
#define FPGTDFPERSP             0x1150000L  /* file DFPERSP.c */
#define FPGTDOGTRAN             0x1160000L  /* file DOGTRAN.c */
#define FPGTDOPERSP             0x1170000L  /* file DOPERSP.c */
#define FPGTDOPTGTRAN           0x1180000L  /* file DOPTGTRA.c */

/**** JPEG routines. */

#define FPJPENCODE              0x1200000L  /* file */
#define FPJPDECODE              0X1210000L  /* file */
#define FPJPCRBUFFER            0x1220000L  /* file */
#define FPJPDLBUFFER            0x1230000L  /* file */
#define FPJPRDMEM               0x1240000L  /* file */
#define FPJPWRMEM               0x1250000L  /* file */
#define FPJPRSREAD              0x1260000L  /* file */
#define FPJPDFQUANTBL           0x1270000L  /* file */
#define FPJPSLQUANTBL           0x1280000L  /* file */
#define FPJPDFACHUFFTBL         0x1290000L  /* file */
#define FPJPSLACHUFFTBL         0x12A0000L  /* file */
#define FPJPDFDCHUFFTBL         0x12B0000L  /* file */
#define FPJPSLDCHUFFTBL         0x12C0000L  /* file */
#define FPJPDFSMPRTIO           0x12D0000L  /* file */
#define FPJPDFRSTINT            0x12E0000L  /* file */

/* interrupt messages */

#define I_INTIN             0x08 /* INTIN bit in hstctll register */
#define I_INTOUT            0x80 /* INTOUT bit in hstctll register */
#define I_MSGINMSK          0x07 /* mask for hstctll MSGIN field */

#define I_MSG_PCHLPROCESS   0    /* message 0, pchlprocess() */
#define I_MSG_ETAG_ACK      1    /* message 1, iowtetag(), ioiqetag() */
#define I_MSG_CLEXEC        2    /* message 2, interrupt to execute clist */
#define I_MSG_ETAG_VERIFY   3    /* message 3, iowtetag(), ioiqetag() */
                                 /* temporary, for compatibility with */
                                 /* previous bindings (up to 2.00B) */ 
#define I_MSG_SET_NSAAG_ACCESS 4 /* message 4, vram access */
#define I_MSG_FLUSH 		5    /* message 5, pchlprocqueue() */

#endif /* __I_OPCODE_H__ */
