
#include "imseries.h"
#include "imbind.h"
#include "proto.h"

#include "i_head.h"

/*
 Copyright (c) Matrox Electronics 1989. All rights reserved
 FUNCTION DEF : _pciqusr
*/

extern unsigned long i_buff[];

#ifdef ANSI
void FTYPE pciqusr(unsigned short option, void _I_PTYPE * retval)
#else
FTYPE pciqusr( option, retval )
unsigned short option;
void _I_PTYPE * retval;
#endif
{
    unsigned long *p;

    p = i_buff;

    *p++ = (SECOND_DEC | PCIQUSR);
    *p++ = (unsigned long) option;

    ioputbuf((short *) i_buff, 4);

    switch( option )
    {
        case I_IQ_ROI_XSIZE:    	/* (short) roi xsize			*/
        case I_IQ_ROI_YSIZE:    	/* (short) roi ysize			*/
		case I_IQ_FBORG:			/* (short) fb_org				*/
		case I_IQ_SRC1_MSK:			/* (short) src 1 mask			*/
		case I_IQ_SRC2_MSK:			/* (short) src 2 mask			*/
		case I_IQ_COND_STAT:		/* (short) cond stat			*/
		case I_IQ_COND:				/* (short) terminating condition*/
		case I_IQ_COND_VAL:			/* (short) cond value			*/
		case I_IQ_SUB_SAMP:			/* (short) subsampling factor	*/
		case I_IQ_OOI_FB:			/* (short) OOI usage			*/
		case I_IQ_OOI_MASK:			/* (short) OOI mask				*/
		case I_IQ_OOI_VAL:			/* (short) OOI value			*/
		case I_IQ_OOI_COND:			/* (short) OOI condition		*/
		case I_IQ_LATTICE:			/* (short) lattice shape		*/
		case I_IQ_KCEN_X:			/* (short) kernel x center		*/
		case I_IQ_KCEN_Y:			/* (short) kernel y center		*/
		case I_IQ_SYNC:				/* (short) synchronisation mode	*/
		case I_IQ_LOGCAM:			/* (short) logical camera		*/

                * (short _I_PTYPE *) retval = iogetw();
                break;

        case I_IQ_ROI0:         	/* (long) roi0 start position	*/
        case I_IQ_ROI1:         	/* (long) roi1 start position	*/
        case I_IQ_ROI2:         	/* (long) roi2 start position	*/
        case I_IQ_ROI3:         	/* (long) roi3 start position	*/
        case I_IQ_ROI4:         	/* (long) roi4 start position	*/
        case I_IQ_ROI5:         	/* (long) roi5 start position	*/
        case I_IQ_ROI6:         	/* (long) roi6 start position	*/
        case I_IQ_ROI7:         	/* (long) roi7 start position	*/
		case I_IQ_IN_TYPE1:			/* (long) in type 1				*/
		case I_IQ_IN_TYPE2:			/* (long) in type 1				*/
		case I_IQ_OUT_TYPE:			/* (long) out type				*/
		case I_IQ_DST_MSK:			/* (long) dst mask				*/
		case I_IQ_SRC1_BIN_COND:	/* (long) src 1 bin cond		*/
		case I_IQ_SRC1_BIN_MASK:	/* (long) src 1 bin mask		*/
		case I_IQ_SRC1_BIN_VAL:		/* (long) src 1 bin val 		*/
		case I_IQ_SRC2_BIN_COND:	/* (long) src 2 bin cond		*/
		case I_IQ_SRC2_BIN_MASK:	/* (long) src 2 bin mask		*/
		case I_IQ_SRC2_BIN_VAL:		/* (long) src 2 bin val 		*/

                iogetbuf( (short _I_PTYPE *) retval, 2 );
                break;

        default:
                break;
    }
}

