/*
    filename :  itag.c

COPYRIGHT (c) 1989, 1990, 1991  Matrox Electronic Systems Ltd.
All Rights Reserved

*/

#include "imseries.h"
#include "imbind.h"
#include "proto.h"

extern short  buff[];
extern short  *ptrbuff;

/*/     Function:   iosditag()
*       Synopsis:   Sends an synchronisation tag to a ressource.
*       Date:       Febuary the 17th 1990.
*       params:     short resource : I_GSP or I_PROC.
*
*       returns:    --- none ---
**/

#ifdef  ANSI
void FTYPE iosditag(short device)
#else
FTYPE iosditag(device)
short device;
#endif
    {
    ptrbuff = buff;

    *ptrbuff++ = 0x01FC;
    *ptrbuff   = device;

    ioputbuf( buff, 2 );

    }


/*/     Function:   iowtitag()
*       Synopsis:   Forces the image to synchronise internally to a ressource.
*       Date:       Febuary the 17th 1990.
*       params:     short resource : I_GSP or I_PROC.
*
*       returns:    --- none ---
*       Anything requiring clarification:   Waiting for a tag that was
*                                           never sent (see iosditag() ) will
*                                           hang the system.
**/

#ifdef  ANSI
void    FTYPE iowtitag(short device)
#else
FTYPE iowtitag(device)
short device;
#endif
    {
    ptrbuff = buff;

    *ptrbuff++ = 0x01FD;
    *ptrbuff   = device;

    ioputbuf( buff, 2 );

    }
