/*
    filename :  rdline.c

COPYRIGHT (c) 1989, 1990, 1991  Matrox Electronic Systems Ltd.
All Rights Reserved

*/

#include <stdio.h>
#include "imseries.h"
#include "imbind.h"
#include "proto.h"
#include "i_head.h"

extern  I_IMGLOB    i_glob;

extern unsigned short i_v_adrtable [ I_N_OF_FBORGS ] [ I_N_OF_FBS ];
extern unsigned short i_v_factable [ I_N_OF_FBORGS ];
extern unsigned short i_v_sizetable [ I_N_OF_FBORGS ];

/* use for dummy read */
static short    dummy;

#ifdef I_USE_ASM
#ifdef ANSI
void FTYPE _i_s_movmem386 ( void far *src, void far *dst,
 unsigned short count, unsigned short sizefactor );
extern void (FTYPE  * _i_s_movmem ) ( void far *src, void far * dst,
 unsigned short count, unsigned short sizefactor );
#else
FTYPE _i_s_movmem386 ();
extern void (FTYPE  * _i_s_movmem ) ( );
#endif
#endif

/*/     Function:   iordline()
*       Synopsis:   write frame buffer wintow from host ram
*
*       Date:       March 6, 1990
*
*       Parameter:  short fb : destination frame buffer
*                   short xstart, ysrtart, xend, yend : window coordinates
*                   void *buf : pointer to host ram buffer.
*
*       Return value:   1 if operation succeeded, 0 otherwise;
**/

#ifdef  ANSI
short FTYPE iordline(short fb, short dir, short xstart, short ystart,
short lenght, void _I_PTYPE *buf)
#else
short FTYPE iordline(fb, dir, xstart, ystart, lenght, buf)
short fb;
short dir;
short xstart;
short ystart;
short lenght;
void _I_PTYPE *buf;
#endif
{
    /* SHey 94/03/07 Changed nptr for WATCOM compiler support */
    /* It was defined as I_TYPE_PTR before */
    #ifdef WATCOM
     I_TYPE_FPTR     nptr;
    #else
     I_TYPE_PTR      nptr;
    #endif
    void far        *ptr;
    unsigned short  base, sizefactor, regval;
    unsigned long   nleft, count;
    short           fborg, surfn;

    /* new pointer use for byte, word or longword access */
    nptr.vptr = buf;

    /* mask surface parameter to get only surface number */
    surfn = fb & 0x07;

    /* get frame buffer organisation */
    if ( fb == I_OVL_SURF )
        fborg = I_OVL_2KX1K;
    else
        fborg = i_glob.vramhra->tappt & I_TAPPT_FBORG_MSK;

    /* get base address from table */
    base = i_v_adrtable[fborg][surfn];


    /* conversion factor */
    sizefactor = i_v_sizetable [ fborg ];

    /* return error message if surfn/fborg combination is invalid */
    if (base == 0)
        {
        i_glob.ioerror = I_IOERR_SURF;
        return(0);
        }

    /* add y offset to base address */
    base += ystart * i_v_factable[fborg];

    nleft = lenght;

    /* interrupt gsp to select fb/ovl nsaag access */

    /* loop while last interrupt remain unserviced */
    while (( i_glob.vramhra->hstctll ) & I_INTIN );

    /* send message */
    i_glob.vramhra -> dpystrt = ( fb == I_OVL_SURF ) ? 1 : 0;

    /* send interrupt to GSP with message */
    regval = i_glob.vramhra->hstctll;

    /* set MSGIN field to zero */
    regval &= ~I_MSGINMSK;

    /* set INTIN and MSGIN */
    i_glob.vramhra->hstctll = regval | I_INTIN | I_MSG_SET_NSAAG_ACCESS;

    /* loop until interrupt routine has finished */
    while (( i_glob.vramhra->hstctll ) & I_INTIN );

    /* enable NA mode */
    i_glob.vramhra->hctrl &= I_SA_EN_MASK;
    i_glob.vramhra->hctrl |= I_NA_EN;

    /* set SAAG registers */
    i_glob.vramhra -> nsaag_xsa = xstart << sizefactor;
    ioFlushIndexInADR((short _I_HRDWTYPE *)&(i_glob.vramhra -> nsaag_xsa));
    i_glob.vramhra -> nsaag_ysa = base;
    ioFlushIndexInADR((short _I_HRDWTYPE *)&(i_glob.vramhra -> nsaag_ysa));

    dummy = i_glob.vramhra -> nsaag_ysa;

    while(nleft)
    {
        if ( nleft > (unsigned long) ( I_NAAG_MAXC >> sizefactor ))
            count = I_NAAG_MAXC >> sizefactor;
        else
            count = nleft;

        nleft -= count;

        /* SHey 94/03/07 Changed cast to FAR pointer for WATCOM compiler support */
        /* It was casted as (char _I_PTYPE *) */
        ptr = (void far *) ( (char far *) i_glob.vrammap->haa.naag + dir );

#ifdef I_USE_ASM

#if defined ( I_UNIX ) || defined ( I_386_ONLY )

        _i_s_movmem386 ( ptr, nptr.bptr, (unsigned short)count, sizefactor );

#else

        _i_s_movmem ( ptr, nptr.bptr, (unsigned short)count, sizefactor );

#endif

        nptr.bptr += (unsigned short)count << sizefactor;
#else

        switch ( sizefactor )
            {
            case 0 :
                while(count--)
                    *nptr.bptr++ = *(*(char far **)&ptr)++;
                break;

            case 1 :
                while(count--)
                    *nptr.wptr++ = *(*(short far **)&ptr)++;
                break;

            case 2 :
#ifdef  __TURBOC__
                while(count--)
                    {
                    *nptr.wptr++ = *((short far *)ptr)++;
                    *nptr.wptr++ = *((short far *)ptr)++;
                    }
#else

                while(count--)
                    *nptr.lptr++ = *(*(long far **)&ptr)++;

#endif /* __TURBOC__ */

                break;

            default :
                i_glob.ioerror = I_IOERR_SURF;
                return(0);
            }
#endif

    }

    /* hstctll register bit 14 indicates a bus fault error */
    if (i_glob.vramhra -> hstctll & 0x4000)
        {
        /* reset bit */
        i_glob.vramhra -> hstctll &= 0xBFFF;

        /* return error message */
        i_glob.ioerror = I_IOERR_BUSERR;
        return(0);
        }

    /* otherwise, return success message */
    return (1);

} /* iordline() */








