#
# makefile to build the im-1280 C-binding libraries under Borland C++ 2.0
#
# library made : image floating point , fpu_l.lib

# Path for the destination library
LIBPATH= ..\..\library\bc

# Path for the sources
.PATH.c = ..\..\fpu

# Path for the include files
INC = ..\..\include

# Path for object files
.PATH.obj = ..\..\obj\bc\fpu

# librarie name
LIBNAME = fpu_l

# C compiler
CC = bcc

# C compiler flags
CFLAGS = -c -2 -ml -K -ff- -I$(INC) 

# librarian
LIB = tlib

# librarian flags
LFLAGS =

# implicit rules
.c.obj:
    $(CC) $(CFLAGS) -o$(.PATH.obj)\$& $<
    $(LIB) $(LIBPATH)\$(LIBNAME).lib $(LFLAGS) -+$(.PATH.obj)\$&

# objects modules for the image floating point library
FPUOBJ = cvfltint.obj \
         dofft1d.obj \
         dofft2d.obj \
         cvrecpol.obj \
         doarithm.obj \
         dfpersp.obj \
         dlfpucod.obj \
         dfgtran.obj \
         dogtran.obj \
         dopersp.obj \
         doptgtra.obj \
         pcfpufor.obj \
         v2mdid.obj \
         v2mdset.obj \
         v2mdorg.obj \
         v2mdrot.obj \
         arithcte.obj

# make the image floating point library
$(LIBPATH)\$(LIBNAME).lib : $(FPUOBJ)
