#include "imseries.h"
#include "imbind.h"
#include "proto.h"

/* 
Copyright (c) Matrox Electronics 1989. All rights reserved
 FUNCTION DEF : lsdcldvideo()
*/ 

extern unsigned long i_buff[];
extern unsigned short _I_PTYPE *i_buffers[];
extern unsigned short i_ns[];

#define  SIZEOF_PARMS  70  /* in bytes */

#define BUFFER_SIZE 4 		/* parameters buffer size in words */

#ifdef ANSI
void FTYPE lsdcldvideo(unsigned long _I_PTYPE *p0)
#else
FTYPE lsdcldvideo(p0)
unsigned long _I_PTYPE *p0;
#endif
{
	unsigned long *p;
	unsigned short _I_PTYPE * _I_PTYPE *buffers, *ns;

	/* set buffer for parameters */
    p = i_buff;

    *p++ = (SECOND_DEC | LSDCLDVIDEO);
    *p++ = (unsigned long) (SIZEOF_PARMS >> 1);

    /* set buffer for buffers */
    buffers = i_buffers;
    /* first send  parameters */
    *buffers++ = (unsigned short *)i_buff;
    /* then the kernel values */
    *buffers = (unsigned short _I_PTYPE *)p0;

    /* set buffer for buffer sizes */
    ns = i_ns;
    /* parameter buffer size ( in words ) */
    *ns++ = BUFFER_SIZE;
    /* kernel array size ( in words ) */
    *ns = (unsigned short)(SIZEOF_PARMS >> 1);

    /* send buffers */
    ioputmbuf (i_buffers, i_ns, 2);

}
