/*/
* cls.c -- Image-1280 Windows 3.0 demo
*
* (c) Matrox Electronic Systems    April 1992
*/

#include <windows.h>
#include <imseries.h>
#include <i_head.h>
#include <proto.h>
#include "cls.h"


HANDLE hInst;
char lpNewMenuStr[] = "Clear Main FBs";
char szBuffer[100];
short dcmasks[6];

HANDLE hAccTable;   	   // handle to accelerator table
HWND hwnd;           	// handle to main window

int PASCAL WinMain(hInstance, hPrevInstance, lpCmdLine, nCmdShow)
HANDLE hInstance;
HANDLE hPrevInstance;
LPSTR lpCmdLine;
int nCmdShow;
	{
   MSG msg;
   int imhdl;

   imhdl = ioopdevice(I_LIN_AIN_LOW,0);
   iosldevice(imhdl);
   ioslmemdevice(imhdl);

   // Inquire for masks on FBs and overlay
   // im1280 win driver set overlay masks and they do0 not need to be changed!
   //  dcmask[0] for FB red         dcmask[3] for overlay red      
   //  dcmask[1] for FB green       dcmask[4] for overlay green    
   //  dcmask[2] for FB blue        dcmask[5] for overlay blue     
   pciqsys(I_IQ_DCMASKS,dcmasks);


	// set up the FBs properly. Keep overlay masks untoutched!
	lsdcstrdmask(-1, -1, -1, dcmasks[3], dcmasks[4], dcmasks[5]);

   if (!hPrevInstance)
	   if (!InitApplication(hInstance))
	      return (FALSE);

   if (!InitInstance(hInstance, nCmdShow))
      return (FALSE);

   while (GetMessage(&msg, NULL, NULL, NULL))
	   {
	   TranslateMessage(&msg);
	   DispatchMessage(&msg);
   	}

   return (msg.wParam);
	} // WinMain

BOOL InitApplication(hInstance)
HANDLE hInstance;
	{
   WNDCLASS  wc;

   wc.style         = CS_HREDRAW | CS_VREDRAW;
   wc.lpfnWndProc   = clsWindowProc;
   wc.cbClsExtra    = 0;
   wc.cbWndExtra    = 0;
   wc.hInstance     = hInstance;
   wc.hIcon         = LoadIcon(hInstance, "clsIcon");
   wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
   wc.hbrBackground = GetStockObject(WHITE_BRUSH); 
   wc.lpszMenuName  = NULL;
   wc.lpszClassName = "Cls";

   if (!RegisterClass(&wc))
		return(FALSE);

	return(TRUE);
	} // InitApplication


BOOL InitInstance(hInstance, nCmdShow)
HANDLE hInstance;
int nCmdShow;
	{
   RECT Rect;
	short i;
	HMENU hMenu;

   hInst = hInstance;

   hwnd = CreateWindow( "cls",
                        "Cls",
                        WS_OVERLAPPEDWINDOW,
                        0,
                        0,
                        0,
                        0,
                        NULL,
                        NULL,
                        hInstance,
                        NULL
    	                );

   if (!hwnd)
      return (FALSE);

	// Modify system menu 'Restore' to 'Clear Main FBs'
	hMenu = GetSystemMenu(hwnd, FALSE);
	ModifyMenu(hMenu, SC_RESTORE, MF_BYCOMMAND, SC_RESTORE, lpNewMenuStr);
	DeleteMenu(hMenu, SC_MINIMIZE, MF_BYCOMMAND);
	DeleteMenu(hMenu, SC_MAXIMIZE, MF_BYCOMMAND);

	// Display as icon
	ShowWindow(hwnd, SW_SHOWMINNOACTIVE); 
	UpdateWindow(hwnd);

   return (TRUE);
	} // InitInstance


long FAR PASCAL clsWindowProc(hWnd, message, wParam, lParam)
HWND hWnd;
UINT message;
WPARAM wParam;
LPARAM lParam;
	{

    switch (message)
		{
		case WM_SYSCOMMAND:
			switch (wParam)
				{
				case SC_RESTORE:
					lsdcstrdmask(-1, -1, -1, dcmasks[3], dcmasks[4], dcmasks[5]);

					// Clear the FBs, but do not open
					ShowCursor(FALSE);
					krgcdi();
					krhwslfborg(I_1FB_1KX1KX32);		// 32-bit
					krhwslcsurf(I_FB_SURF0);
					krhwsclr(0);
					krhwslfborg(I_4FB_1KX1KX8);		      // 8-bit
					krhwslcsurf(I_OVL_SURF);	// Overlay
					krgcen();
					ShowCursor(TRUE);

					lsdcstrdmask(0, 0, 0, dcmasks[3], dcmasks[4], dcmasks[5]);
					break;
				}

		    return (DefWindowProc(hWnd, message, wParam, lParam));
			break;

		case WM_QUERYOPEN:
			break;

		case WM_DESTROY:
		    PostQuitMessage(0);
		    break;

		default:
		    return (DefWindowProc(hWnd, message, wParam, lParam));
    	}
    return (NULL);
	} // MainWinProc
