/*/
* fbcp.c -- Image-1280 Windows 3.0 demo
*
* (c) Matrox Electronic Systems    April 1992
*
* This demo reads an image from disk (from the same directory as the
* executable) into FB1, and opens a window in the overlay.  As the window
* is moved, fbcpbtob() is used to copy the image from FB1 to FB0.  The
* copied image can be seen through the window since the window client area
* is painted in index 0.
*/

#include <windows.h>
#include <imseries.h>
#include <i_head.h>
#include <proto.h>
#include "fbcp.h"

#define FILE_LISTBOX	2001

#define MAXBUFSIZE		0xf000

long far PASCAL StaticWndProc(HWND, UINT, WPARAM, LPARAM);
void OkMessageBox(HWND, char *, char *);

char *button[] =
	{
	"Image File",
	};

#define NBUTTON (sizeof(button) / sizeof(button[0]))

char ImgFile[15];

#define StatWndROI		I_ROI0
#define VideoWndROI		I_ROI3

#define IDB_FILE		0

HANDLE hInst;

HANDLE hAccTable;   	// handle to accelerator table
HWND hDemoWnd;		 	// handle to demo window
HWND hwnd;           	// handle to main window
HWND hBWnd;				// handle to button area
HWND hWndButton[NBUTTON];
HWND hWndGroup;
HWND hStaticWnd;		// handle to static-image-window
HWND hWndList;

BOOL FirstTime = TRUE;
static short xChar = 7;
static short yChar = 16;

static short StatWndOld_x = 0;
static short StatWndOld_y = 39;

short dcmasks[6];


int PASCAL WinMain(hInstance, hPrevInstance, lpCmdLine, nCmdShow)
HANDLE hInstance;
HANDLE hPrevInstance;
LPSTR lpCmdLine;
int nCmdShow;
	{
   MSG msg;
   int imhdl;

   imhdl = ioopdevice(I_LIN_AIN_LOW,0);
   iosldevice(imhdl);
   ioslmemdevice(imhdl);

   // Inquire for masks on FBs and overlay
   // im1280 win driver set overlay masks and they do not need to be changed!
   //  dcmask[0] for FB red         dcmask[3] for overlay red      
   //  dcmask[1] for FB green       dcmask[4] for overlay green    
   //  dcmask[2] for FB blue        dcmask[5] for overlay blue     
   pciqsys(I_IQ_DCMASKS,dcmasks);


	// set up the FBs properly
	ShowCursor(FALSE);
	krgcdi();
	lsdcstopal(1);
	lsdcstbdmode(7L);	      // no wrap-around of display
	krhwslcsurf(I_FB_SURF1);
	krhwsclr(0);
	krhwslcsurf(I_FB_SURF0);
	krhwsclr(0);
	pcstfborg(I_FB4X1KX1KX8);
	krhwslcsurf(I_OVL_SURF);

	// set up the FBs properly. Keep overlay masks untoutched!
	lsdcstrdmask(-1, -1, -1, dcmasks[3], dcmasks[4], dcmasks[5]);
	krgcen();
	ShowCursor(TRUE);

   if (!hPrevInstance)
		if (!InitApplication(hInstance))
		    return (FALSE);

   if (!InitInstance(hInstance, nCmdShow))
      return (FALSE);

   while (GetMessage(&msg, NULL, NULL, NULL))
		{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
    	}

   return (msg.wParam);
	} // WinMain


BOOL InitApplication(hInstance)
HANDLE hInstance;
	{
   WNDCLASS  wc;

   wc.style          = CS_HREDRAW | CS_VREDRAW;
   wc.lpfnWndProc    = MainWndProc;
   wc.cbClsExtra     = 0;
   wc.cbWndExtra     = 0;
   wc.hInstance      = hInstance;
   wc.hIcon          = LoadIcon(NULL, IDI_APPLICATION);
   wc.hCursor        = LoadCursor(NULL, IDC_ARROW);
   wc.hbrBackground  = GetStockObject(WHITE_BRUSH); 
   wc.lpszMenuName   = "DemoMenu";
   wc.lpszClassName  = "DemoWClass";

   if (!RegisterClass(&wc))
		return(FALSE);

	// StaticWin class
   wc.style          = NULL;
   wc.lpfnWndProc    = StaticWndProc;
   wc.cbClsExtra     = 0;
   wc.cbWndExtra     = 0;
   wc.hInstance      = hInstance;
   wc.hIcon          = NULL;
   wc.hCursor        = LoadCursor(NULL, IDC_ARROW);

   // Check if transparent color is black or dark green
   //  im1280 win driver sets masks on r,g and b for overlay to 0x1d
   //  when it is a driver used with WinSel strap
   if (dcmasks[3]==0x1d) /* Is green transparent? */
      wc.hbrBackground  = CreateSolidBrush(RGB(0,128,0));
   else
      wc.hbrBackground  = GetStockObject(BLACK_BRUSH);


   wc.lpszMenuName   = NULL;
   wc.lpszClassName  = "Staticwin";

    if (!RegisterClass(&wc))
		return(FALSE);

	// set processing fborg for 1K x 1K x 8
	ShowCursor(FALSE);
	krgcdi();
	pcstfborg(I_FB4X1KX1KX8);
	krhwslcsurf(I_OVL_SURF);

	// set ROI size and pos of hidden FB image
	pcstroisiz(512, 480);
	pcstroipos(I_ROI1, 0, 0);
	krgcen();
	ShowCursor(TRUE);

	return(TRUE);
	} // InitApplication


BOOL InitInstance(hInstance, nCmdShow)
HANDLE hInstance;
int nCmdShow;
	{
   RECT Rect;
	short i;

   hInst = hInstance;

   hwnd = CreateWindow( "DemoWClass",
                        "Matrox Image-Window Demo",
                        WS_OVERLAPPEDWINDOW,
                        50,
                        40,
                        30 * xChar * NBUTTON,
                        18 * yChar,
                        NULL,
                        NULL,
                        hInstance,
                        NULL
    	               );

   if (!hwnd)
      return (FALSE);

   GetClientRect(hwnd, (LPRECT) &Rect);

	// create grey static window for button area
 	hBWnd = CreateWindow(   "static",
				               NULL,
				               WS_CHILD | WS_VISIBLE | SS_WHITERECT,
				               0, 0, 0, 0,
				               hwnd, 9,
				               hInstance,
				               NULL
				           );

   if (!hBWnd)
		{
		DestroyWindow(hwnd);
		return (NULL);
    	}

	// create push buttons
	for (i = 0; i < NBUTTON; ++i)
		{
		hWndButton[i] = 
			CreateWindow(  "button",
				            button[i],
				            WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
		  		            xChar + (20 * xChar * i), yChar,
				            20 * xChar, 2 * yChar,
				            hwnd,
				            i,
				            hInst,
				            NULL
				         );
		}

	hWndGroup = 
		CreateWindow(  "button",
            			"",
			   			WS_CHILD | WS_VISIBLE | BS_GROUPBOX,
			   			0, 0, 20 * xChar * NBUTTON + 20, 4 * yChar,
			   			hwnd,
			   			10,
			   			hInst,
			   			NULL
			 			);

   ShowWindow(hwnd, nCmdShow);
   UpdateWindow(hwnd);

   return (TRUE);
	} // InitInstance


long FAR PASCAL MainWndProc(hWnd, message, wParam, lParam)
HWND hWnd;
UINT message;
WPARAM wParam;
LPARAM lParam;
	{
   FARPROC lpProcAbout;
	short xClientSize, yClientSize;
	short i;
	HDC hDC;
	TEXTMETRIC tm;
	RECT rect;
	OFSTRUCT of;
	short xOffset, yOffset;

   switch (message)
		{
		case WM_CREATE:
			// create list box for 'File'
			hDC = GetDC(hWnd);
			GetTextMetrics(hDC, &tm);
			ReleaseDC(hWnd, hDC);

			hWndList = CreateWindow("listbox",
				                     "Image files",
				                     WS_CHILDWINDOW | WS_CAPTION | 
				                     	LBS_STANDARD | LBS_NOREDRAW,
				                     tm.tmAveCharWidth, tm.tmHeight * 4,
				                     tm.tmAveCharWidth * 13 + GetSystemMetrics(SM_CXVSCROLL),
				                     tm.tmHeight * 10,
				                     hWnd,
				                     FILE_LISTBOX,
				                     hInst,
				                     NULL
				                    );

			break;
		case WM_COMMAND:
		    switch (wParam)
				{
				case IDM_ABOUT:
    	        	lpProcAbout = MakeProcInstance(About, hInst);
    	        	DialogBox(hInst, "AboutBox", hWnd, lpProcAbout);
    	        	FreeProcInstance(lpProcAbout);
					break;

				case FILE_LISTBOX:
					if (HIWORD(lParam) == LBN_DBLCLK)
						{
						if ((i = (WORD )SendMessage(hWndList,
													LB_GETCURSEL, 0, 0L)) !=
								LB_ERR)
							{
							char *ptr;

							SendMessage(hWndList, LB_GETTEXT, i,
										(LONG )(LPSTR)ImgFile);

							// clear the list box and remove it
							SendMessage(hWndList, LB_RESETCONTENT, 0, 0L);
							ShowWindow(hWndList, SW_HIDE);

							// load the image
							SetCursor(LoadCursor(NULL, IDC_WAIT));
							ReadFile(hInst, hWnd, &of, ImgFile);
							SetCursor(LoadCursor(NULL, IDC_ARROW));

							hDC = GetDC(hWnd);
							GetTextMetrics(hDC, &tm);
							ReleaseDC(hWnd, hDC);
						
							xChar = tm.tmAveCharWidth;
							yChar = tm.tmHeight + tm.tmExternalLeading;

							// create static win
							GetWindowRect(hwnd, &rect);
							xOffset = rect.left + 10;
							yOffset = ((rect.bottom - rect.top) / 5) + rect.top +
										50;

							hStaticWnd = CreateWindow("Staticwin",
    			    				                    ImgFile,
    			    				                    WS_POPUP | WS_OVERLAPPED |
                                                WS_CAPTION | WS_SYSMENU,
    			    				                    xOffset,
    			    				                    yOffset,
    			    				                    512 + 2 * GetSystemMetrics(SM_CXBORDER),
    			    				                    480 + 2 * GetSystemMetrics(SM_CYBORDER)
									                    		+ GetSystemMetrics(SM_CYCAPTION),
    			    				                    hwnd,
    			    				                    NULL,
    			    				                    hInst,
    			    				                    NULL
    								                    );

    						ShowWindow(hStaticWnd, SW_SHOWNORMAL);
    						UpdateWindow(hStaticWnd);
							}
						}
					break;

				case IDB_FILE:
					if (HIWORD(lParam) == BN_CLICKED)
						{
						// display list box
						SendMessage(hWndList, LB_DIR, 0, (LONG)(LPSTR)"*.img");
						SendMessage(hWndList, WM_SETREDRAW, TRUE, 0L);
						ShowWindow(hWndList, SW_SHOWNORMAL);
						}

					break;
				}

			break;

    	case WM_SETFOCUS:
    	    SetFocus (hDemoWnd);
    	    break;

    	case WM_SIZE:
			if (FirstTime)
				FirstTime = FALSE;
			else
				{
			    hDC = GetDC(hWnd);
			    GetTextMetrics(hDC, &tm);
			    ReleaseDC(hWnd, hDC);
			    xChar = tm.tmAveCharWidth;
			    yChar = tm.tmHeight + tm.tmExternalLeading;

			    xClientSize = LOWORD(lParam);
			    yClientSize = HIWORD(lParam);

			    MoveWindow(hBWnd, 0, 0, xClientSize, 4 * yChar, TRUE);

             MoveWindow(hDemoWnd, 0, 4 * yChar, 
			    			   xClientSize, yClientSize - (4 * yChar), TRUE);

			    for (i = 0; i < NBUTTON; ++i)
			    	{
			    	MoveWindow(hWndButton[i], 
			    		  		xChar + (20 * xChar * i), yChar,
			    				20 * xChar, 2 * yChar, TRUE);
			    	}

			    MoveWindow(hWndGroup, 0, 0, 20 * xChar * NBUTTON + 20, 4 * yChar, 
			               TRUE);
                }
    	    break;

		case WM_DESTROY:
	      ShowCursor(FALSE);
			krgcdi();
			krhwslcsurf(I_FB_SURF1);
			krhwsclr(0);
			krhwslcsurf(I_FB_SURF0);
			krhwsclr(0);
			pcstfborg(I_FB4X1KX1KX8);
			krhwslcsurf(I_OVL_SURF);
			krgcen();
	      ShowCursor(TRUE);

   	   PostQuitMessage(0);
		   break;

		default:
		    return (DefWindowProc(hWnd, message, wParam, lParam));
    	}

   return (NULL);
	} // MainWinProc


BOOL FAR PASCAL About(hDlg, message, wParam, lParam)
HWND hDlg;
UINT message;
WPARAM wParam;
LPARAM lParam;
	{
   switch (message)
		{
		case WM_INITDIALOG:
		    return (TRUE);

		case WM_COMMAND:
		    if (wParam == IDOK || wParam == IDCANCEL)
				{
				EndDialog(hDlg, TRUE);
				return (TRUE);
		    	}

		    break;
    	}

   return (FALSE);
	} // About


long far PASCAL StaticWndProc(hWnd, message, wParam, lParam)
HWND hWnd;
UINT message;
WPARAM wParam;
LPARAM lParam;
	{
	PAINTSTRUCT ps;
	POINT cur_point;

	cur_point.x = 0;
	cur_point.y = 39;

	switch (message)
		{
      case WM_CREATE:
	      lsdcstrdmask(-1, -1, -1, dcmasks[3], dcmasks[4], dcmasks[5]);
         break;

		case WM_DESTROY:
			// set ROI for destination
			pcstroipos(StatWndROI,
						((cur_point.x + 2) & 0xfffc), cur_point.y);

			// do the copy to clean up FB
			fbcpbtob(I_CONSTANT, I_FB0 | StatWndROI, 0x0fffL, 0L, 1);

			// more redundant cleanup.
	      lsdcstrdmask(0, 0, 0, dcmasks[3], dcmasks[4], dcmasks[5]);
	      ShowCursor(FALSE);
			krgcdi();
			krhwslcsurf(I_FB_SURF1);
			krhwsclr(0);
			krhwslcsurf(I_FB_SURF0);
			krhwsclr(0);
			pcstfborg(I_FB4X1KX1KX8);
			krhwslcsurf(I_OVL_SURF);
			krgcen();
	      ShowCursor(TRUE);

			break;

		case WM_PAINT:
			// invalidate entire client area (which also erases background
			InvalidateRect(hWnd, NULL, TRUE);
			BeginPaint(hWnd, &ps);

	      ShowCursor(FALSE);
			krgcdi();
			// set ROI for destination
			pcstroipos(StatWndROI, StatWndOld_x, StatWndOld_y);

			// do the copy
			fbcpbtob(I_FB1 | I_ROI1, I_FB0 | StatWndROI, 0L, 0L, 1);
			krgcen();
	      ShowCursor(TRUE);

			EndPaint(hWnd, &ps);
			break;

		case WM_MOVE:
			// invalidate the entire client area (which also erases background
			InvalidateRect(hWnd, NULL, TRUE);

			BeginPaint(hWnd, &ps);

			// send code to 1280 to update FB contents beneath client area
			// ROI 0 is foreground FB to display
			// ROI 1 is hidden FB to copy from
			// set new roi position
			// get current (x, y) of client's top left corner
			cur_point = MAKEPOINT(lParam);

	      ShowCursor(FALSE);
			krgcdi();
			// clear old area
			pcstroipos(StatWndROI, StatWndOld_x, StatWndOld_y);
			fbcpbtob(I_CONSTANT, I_FB0 | StatWndROI, 0x0fffL, 0L, 1); // force 0

			// set ROI for destination
			pcstroipos(StatWndROI,
						((cur_point.x + 2) & 0xfffc), cur_point.y);

			// do the copy
			fbcpbtob(I_FB1 | I_ROI1, I_FB0 | StatWndROI, 0L, 0L, 1);
			krgcen();
	      ShowCursor(TRUE);

			StatWndOld_x = (cur_point.x + 2) & 0xfffc;
			StatWndOld_y = cur_point.y;

			EndPaint(hWnd, &ps);
			break;

		default:
			return(DefWindowProc(hWnd, message, wParam, lParam));
		}

	return(NULL);
	} // StaticWndProc


BOOL ReadFile(HANDLE hInstance, HWND hwnd, POFSTRUCT pof, char *szFileName)
	{
	DWORD dwLength;
	HANDLE hFile, hImgBuffer;
	LPSTR lpImgBuffer;

	if (-1 == OpenFile(szFileName, pof, OF_READ | OF_EXIST))
		{
		MessageBeep(0);
		OkMessageBox(hwnd, "Cannot open file %s", szFileName);
		return(FALSE);
		}

	if (-1 == (hFile = OpenFile(szFileName, pof, OF_READ)))
		{
		OkMessageBox(hwnd, "Cannot open file %s", szFileName);
		return(FALSE);
		}

   dwLength = MAXBUFSIZE;

	if (NULL == (hImgBuffer = GlobalAlloc(GHND, (DWORD )dwLength)))
		{
		_lclose(hFile);
		OkMessageBox(hwnd, "Cannot allocate memory for %s", szFileName);
		return(FALSE);
		}

	lpImgBuffer = GlobalLock(hImgBuffer);

	ShowCursor(FALSE);
	krgcdi();
	krhwslfborg(0);
	krhwslcsurf(I_FB_SURF1);

	// Read image into FB1
	ioldfbarea(I_FB_SURF1, hFile, 0, 0, 511, 479, lpImgBuffer, dwLength);

	krhwslcsurf(I_OVL_SURF);
	krgcen();
	ShowCursor(TRUE);

	_lclose(hFile);
	GlobalUnlock(hImgBuffer);
	GlobalFree(hImgBuffer);
	return(TRUE);
	} // ReadFile


void OkMessageBox(hwnd, szStr, szFileName)
HWND hwnd;
char *szStr;
char *szFileName;
	{
	char szBuffer[40];

	wsprintf(szBuffer, szStr, (LPSTR)szFileName);
	MessageBox(hwnd, szBuffer, "FileIO", MB_OK | MB_ICONEXCLAMATION);
	} // OkMessageBox


