/*
    filename :  iqwrfifo.c

COPYRIGHT (c) 1989, 1990, 1991  Matrox Electronic Systems Ltd.
All Rights Reserved

*/

/* all conditionnal compilations switches in imseries.h */

#ifndef  I_NOPRINTF
#include <stdio.h>
#endif

#include "imseries.h"
#include "imbind.h"
#include "proto.h"

#ifdef I_OS2
#include "process.h"
#endif

extern  I_IMGLOB    i_glob;

/*/     Function:   ioiqwrfifo()
*       Synopsis:   inquire write fifo status
*
*       Date:       February 15, 1990
*
*       Parameter:  none.
*                                               
*       Return value:   true if fifo is empty, false otherwise
**/

#ifdef  ANSI
short FTYPE ioiqwrfifo(void)
#else
short FTYPE ioiqwrfifo()
#endif
{
#if ( defined ( I_UNIX ) && !defined ( I_PHYSMAP ))

    ioctl(i_glob.board, I_IQWRFIFO, NULL);

#endif

#if ( defined ( I_MS_DOS ) || ( defined ( I_UNIX ) && defined ( I_PHYSMAP )))

    short count;

    do
        {
        count = IOwrite_count;
        }
    while ( count != IOwrite_count );
    
    return( count == 0 );
#endif

#ifdef I_OS2

   USHORT  count;
   PUSHORT pcount=&count;

   /* get number of words available to read */
   if ( DosDevIOCtl((PUSHORT)  pcount,
                     0L,
                    (USHORT) I_WRFIFO_CNT,
                    (USHORT) 0x80,
                    (HFILE)  i_glob.board ) != 0) {
#ifndef  I_NOPRINTF
# ifdef I_INTEL		/* fprintf buggy under INTEL Vr4 */
      printf( "\nIM-Series: failed reading write fifo count\n");
# else
      fprintf( stderr, "\nIM-Series: failed reading write fifo count\n");
# endif /* I_INTEL    */
#else	  /* !I_NOPRINTF */
		;
#endif  /* I_NOPRINTF */
      exit(1);
   }
	if (count == MAXFIFOCNT)
        return(1);
   else
   return(0);
#endif /* I_OS2 */
}
