
#include "imseries.h"
#include "imbind.h"
#include "proto.h"

/* 
Copyright (c) Matrox Electronics 1989. All rights reserved
 FUNCTION DEF : _pchlprocqueue
*/


extern I_IMGLOB i_glob;

#ifdef ANSI
void FTYPE pchlprocqueue(unsigned short p0)
#else
FTYPE pchlprocqueue(p0)
unsigned short p0;
#endif
{

#ifdef  I_MS_DOS

    unsigned short regval;

    /* loop while last interrupt remain unserviced */
    while (( i_glob.imghra->hstctll ) & I_INTIN );

    /* send interrupt to GSP with pchlprocess message */
    regval = i_glob.imghra->hstctll;

    /* set MSGIN field to zero */
    regval &= ~I_MSGINMSK;

	/* The 16 bits parameter is passed through the GSP register HSTDATA */
    i_glob.imghra->hstdata= p0;


    /* set INTIN and MSGIN */
    i_glob.imghra->hstctll = regval | I_INTIN | I_MSG_FLUSH;

#endif

#ifdef I_OS2

unsigned short out_buf;

DosDevIOCtl(&p0,&out_buf,
            (unsigned short)I_ABORT_PROCESS,
            (unsigned short)0x80,
            (HFILE)i_glob.board);

#endif


#ifdef  I_UNIX

    ioctl ( i_glob.board, IMG_PCHLPROCQUEUE, p0 );
   
#endif


} /* pchlprocqueue() */ 
