/*/  Function name:   v2gpswdw
*
*    Author:   Jean Dupre
*    Date:     March 17, 1988
*
*    Modification history:  
*
*    Calls:  ioputbuf:  send a buffer of words to the board.
*
*    Uses:  FIXPT data type.
*
*    Return value:   None
*/

#include "imseries.h"
#include "imbind.h"
#include "proto.h"

IMPORT  short  buff[];
IMPORT  short  *ptrbuff;


#ifdef ANSI
void FTYPE v2gpswdw(FIXPT xmin, FIXPT xmax, FIXPT ymin, FIXPT ymax)
#else
FTYPE v2gpswdw(xmin, xmax, ymin, ymax)
FIXPT  xmin, xmax;
FIXPT  ymin, ymax;
#endif

    {
	ptrbuff = buff;

    *ptrbuff++ = 0x008F;

    LDFBUFF(ptrbuff, xmin);
    LDFBUFF(ptrbuff, xmax);
    LDFBUFF(ptrbuff, ymin);
    LDFBUFF(ptrbuff, ymax);

    ioputbuf(buff, 9);
    }


