/*
    filename:  i_head.h

COPYRIGHT (c) 1989, 1990, 1991, 1992  Matrox Electronic Systems Ltd.
All Rights Reserved

*/

#ifndef __I_NEWDLL_H__
#define __I_NEWDLL_H__

/*/
*       Synopsis:     Header file to help users port code from older version
*                     of C-Binding DLL to newest version.
*       Date:         92.04.03
*                                               
*       Anything requiring clarification:
**/


/************************************************************************/
/* Section for C-Binding DLL version 3.01 to C-Binding DLL version 3.30 */
/************************************************************************/

/*  This section will introduce macros of functions that no longer exist
    in version 3.30 */


/* Prototype:  void iOpenDevice(Strap);
               short Strap;   Image-Series-to-Host mapping address

               This function does not exist in version 3.30. It has to be
               replaced with ioopdevice(), iosldevice() and ioslmemdevice().
               These functions are the normal C-Binding functions to open
               communication with the board. */
               
#define iOpenDevice(Strap)                                  \
            {                                               \
            unsigned long  device;                          \
            int            filehandle;                      \
                                                            \
            switch (Strap)                                  \
               {                                            \
               case 0: device = I_LOUT_AIN_LOW;  break;     \
               case 1: device = I_LIN_AIN_LOW;   break;     \
               case 2: device = I_LOUT_AOUT_LOW; break;     \
               case 3: device = I_LIN_AOUT_LOW;  break;     \
               }                                            \
                                                            \
            filehandle = ioopdevice(device,0);              \
            iosldevice(filehandle);                         \
            ioslmemdevice(filehandle);                      \
            }



/* Prototype:  void wfifo(lpBuffer, Length);
               short far *lpBuffer; Array of data or opcodes
               WORD       Length;   Number of words into Array

               This function does not exist in version 3.30. It has to be
               replaced with ioputbuf(). */

#define wfifo(lpBuffer,Length)  ioputbuf(lpBuffer,Length)




/* This section lists functions that is now the same as the C-Binding. For
   Each function we will list what is different from DLL version 3.01 to
   DLL version 3.30 */


/* Function:   void ioputtxt(buffer,nchar)

               This function does not have a return value.
               SAME AS C-BINDING */

/* Function:   void iorsdevice(handle,type)

               This function uses handle parameter. It the system identifier
               obtained with ioopdevice().
               SAME AS C-BINDING */

/* Function:   void lsdapat(fillpat_id,fillpat_ptr)

               This function uses the fillpat_ptr as the C-Bindind does.
               The last element of the structure pointed by fillpat_ptr is 
               used for the pattern definition. Note that this last element 
               is a pointer which is a far pointer in the DLL.
               SAME AS C-BINDING */

/* Function:   void lsdfont(font_id,font_ptr)

               This function uses the font_ptr as the C-Binding does.
               The last three elements of the structure pointed by font_ptr
               are used for the font definition. Note that these pointers
               are far pointers int he DLL.
               SAME AS C-BINDING */

/* Functions:  void lsrdrst(left,top,right,bottom,dest_filename)
               void lswrrst(left,top,right,bottom,src_filename)
               void lsrlrdrst(left,top,right,bottom,dest_filename)
               void lsrlwrrst(left,top,right,bottom,src_filename)

               These functions use a filename as the last parameter.
               SAME AS C-BINDING */

/* Function:   void sctxbstring(x,y,strptr)

               This function does not have a return value.
               SAME AS C-BINDING */

/* Function:   void v2txbstring(x,y,strptr)

               This function does not have a return value.
               SAME AS C-BINDING */

#endif /* __I_NEWDLL_H__ */
