/*
    filename:   imgreg.h

COPYRIGHT (c) 1989, 1990, 1991  Matrox Electronic Systems Ltd.
All Rights Reserved

*/

#ifndef __I_IMGREG_H__
#define __I_IMGREG_H__

/* typedef struct
    {
    unsigned char data;
    unsigned long addr;
    } IMGDATA; */

typedef struct hra
    {

    /* Write fifo (HOST to IM1280)*/

    short wrfifo[256];


    /* GSP 34020 registers */

    short   vesync;
    short   hesync;
    short   veblnk;
    short   heblnk;
    short   vsblnk;
    short   hsblnk;
    short   vtotal;
    short   htotal;
    short   dpyctl;
    short   dpystrt;
    short   dpyint;
    short   control;
    short   hstdata;
    short   hstadrl;
    short   hstadrh;
    unsigned short   hstctll;
    unsigned short   hstctlh;
    short   intenb;
    short   intend;
    short   convsp;
    short   convdp;
    short   psize;
    short   pmaskl;
    short   pmaskh;
    short   convmp;
    short   control2;
    short   config;
    short   tappt;
    short   vcount;
    short   hcount;
    short   dpyadr;
    short   refadr;


    /* Unused space */

    char    hole_0[224];


    /* Read fifo (IM1280 to HOST)*/

    short   rdfifo[64];


    /* ADR-1024 registers */

    short   fifo_hwcnt;			/* 0x63a0 */
    short   fifo_hrcnt;			/* 0x63a2 */
    char    host_iid;			/* 0x63a4 */
    char    host_imask;			/* 0x63a5 */
    char    host_iidpoll;		/* 0x63a6 */
    char    hole_1[1];			/* ------ */
    short   mouse_x;			/* 0x63a8 */
    short   mouse_y;			/* 0x63aa */
    short   mlb3lr;			/* 0x63ac */
    char    hctrl;			/* 0x63ae */
    char    hole_2[1];			/* ------ */
    char    error;			/* 0x63b0 */
    char    hole_3[15];			/* ------ */
    long    naag_cp;			/* 0x63c0 */
    short   nsaag_xsa;			/* 0x63c4 */
    short   nsaag_ysa;			/* 0x63c6 */
    short   saag_wxs;			/* 0x63c8 */
    short   saag_wxe;			/* 0x63ca */
    char    hole_4[4];			/* ------ */
    short   gcdapr;			/* 0x63d0 */
    short   mlb1lr;			/* 0x63d2 */
    short   hole_5[2];			/* ------ */
    short   olblr;			/* 0x63d8 */
    char    fbw0p;			/* 0x63da */
    char    fbw1p;			/* 0x63db */
    char    hole_6;			/* 0x63dc */
    char    fbw0ba;			/* 0x63dd */
    char    fbw1ba;			/* 0x63de */
    char    fifoba;			/* 0x63df */
    short   winsel;			/* 0x63e0 */
    short   windid_low;			/* 0x63e2 */
    short   windid_high;		/* 0x63e4 */
    char    hole_8[6];			/* ------ */
    short   obwpda;			/* 0x63ec */
    char    hole_9[18];			/* ------ */
					/* 0x6400 */
    }   HRA;

typedef union
    {

    short   saag[4096];
    short   naag[4096];
    short   mlb [4096];
    short   cda [4096];
    
    }   HAA;


struct  img_map 
    {
    HAA     haa;            /*  8K host access port.     */
    HRA     hra[2];         /*   2 Regsiters area.       */
    char    ovr[2048];      /*  2K overlay line buffer.  */
    char    mfb[4096];      /*  4K main frame buffer.    */
    };

#endif /* __I_IMGREG_H__ */
