/* 
    filename:   misc.h
    Synopsis:   functions prototypes for image
    Date:       March the 19th 1991

COPYRIGHT (c) 1990, 1991  Matrox Electronic Systems Ltd.
All Rights Reserved

*/

#ifndef __I_MISC_H__
#define __I_MISC_H__

/******************************************************************************
 This could very well fit into imgreg.h !
 ******************************************************************************/

/* constants for compilation of vram access routine */
#define I_NAAG_MAXC    0x400        /* max count for naag accesses */
#define I_SAAG_MAXC    8 * 1024     /* max count for saag accesses */
#define I_N_OF_FBORGS 15
#define I_N_OF_FBS    4
#define I_SA_EN_MASK  0x1F
#define I_NA_EN       0x20
#define I_TAPPT_FBORG_MSK 0x00FF    /* extract fborg freo tappt reg */
#define I_TAPPT_BTYPE_MSK 0xFF00    /* extract board type from tappt */

/* Used to fit in imgreg.h */

/* Some very usefull macros */
#define IOread          (((IMGMAP *)i_glob.imgmap)->hra[i_glob.img_unit].rdfifo[0])
#define IOread_count    (( i_glob.imghra -> fifo_hrcnt ) & I_FIFO_CNT_MASK)
#define IOwrite         (((IMGMAP *)i_glob.imgmap)->hra[i_glob.img_unit].wrfifo[0])
#define IOwrite_count   (( i_glob.imghra -> fifo_hwcnt ) & I_FIFO_CNT_MASK)

#define IMG_ENABLE(x)   IOselect(x) = IOselect(x) | I_ENABLE_IMG
#define IMG_DISABLE(x)  IOselect(x) = IOselect(x) & ~I_ENABLE_IMG

#ifndef I_OS2
#define IOselect(x)     ( i_glob.img_addr[x] -> hra[((x)-1)&1].hctrl )
#else   /* will only work for current device */
#define IOselect(x)     ( i_glob.imghra->hctrl )
#endif

#define I_FIFO_CNT_MASK 0x1FFF

#define I_HRASIZE 1024      /* constant for internal byte alignement test */

/***************************************************************************/

/* Constants used  to select the board */
#define I_ENABLE_IMG    0x10		/* used in slmemdevice() */

/* Constants used  to reset the board */
#define RESET_HSTCTLH   0x0080
#define RESET_HCTRL     0x01
#define RESET_CHECK     (short) 0x8010

/* Constants used to halt the board */
#define HALT_HSTCTLH    0xc000
#define HALT_CHECK      0xc010

/* Constants used to init the board */
#define INIT_HCTRL      0x70
#define INIT_CONFIG     0x0c02

/* Constants used to start execution */
#define EXEC_VECTPAGE   0xfff
#define EXEC_RSTVECT    0x1ffc
#define EXEC_NMIVECT    0x1fdc
#define EXEC_HSTCTLH    0x0300
#define EXEC_CONFIG     0x02

/* Constants used to inquire fifo status */
#define WRFIFO_EMPTY    0x04
#define RDFIFO_EMPTY    0x20

#define BITS_16TO27(l)  ((unsigned short) ((l >> 16) & 0x00000fffL))
#define BITS_03TO15(l)  ((unsigned short) ((l >>  3) & 0x00001fffL))
#define MAP_SIZE        (sizeof(struct img_map))

/* Constants defining the FIFOs */

/* Because reading any FIFO count in the PC low map may cause erronious
    result, the write FIFO is temporarly declared as a (4096-256) wide
    FIFO.

 */

#define WRITE_FIFO_SIZE     3839
#define WRITE_FIFO_WINDOW   256

#define READ_FIFO_SIZE     3840
#define READ_FIFO_WINDOW   64

#ifdef  I_MS_DOS
#define PC_LOW_MAP	/* Patches wrong FIFO count in iogetbuf() */
#endif

#define IMG_PRI             (PZERO-1)

/* Main line buffer */

#define MLB12_EN_MASK   0x50
#define MLB_SIZE        4096L
#define MLB_MASK        0x07FF8000L
#define FBSEL_MASK      0x8000

#define FLOATfactor 65536.0

/******************************************************************************
 Host CPU identification returned by _cpuid()
 Needed by ioopendevice() & DOS.
 ******************************************************************************/

#define CPU_8088       0
#define CPU_8086       1
#define CPU_V20        2
#define CPU_V30        3
#define CPU_80188      4
#define CPU_80186      5
#define CPU_80286      6
#define CPU_80386      7
#define CPU_80486      8
#define MYSTERY_CPU    0xFF

/******************************************************************************
 This could very well fit into im_bcdll.h ! / imglob.h !
 ******************************************************************************/

#define     CBUFFLENGTH   1024		/* C-binding <=> IM-Series transfers */
#define     I_BUFFLENGTH    64		/* size of i_buff, in longs. */
#define     I_MAXMBUF       10		/* max buffers for ioputmbuf() */
#define     SHELLBITMAP   BITMAP

#endif /* __I_MISC_H__ */
