/***************************************************************/
/*                      GRABTEST.H                             */
/***************************************************************/
/*
*  By:		Michel Pelletier
*		Matrox Electronic Systems ltd.
*
*  Date:	May 4, 1993.
*
*  Synopsys:	This is the #include file for the GRABTEST program.
*
*  Copyright (C) 1993.  Matrox Electronic Systems, Ltd.
*  All rights reserved
*/
/*****************************************************************/

/************************/
/* Inclusion statements */
/************************/
#include <conio.h>
#include <direct.h>
#include <dos.h>
#include <graph.h>
#include <malloc.h>
#include <memory.h>
#include <signal.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include <imseries.h>
#include <imbind.h>
#include <proto.h>
#include <i_head.h>

/***********************/
/* Function prototypes */
/***********************/
void	CtrlC_Handler(int signal_num);
void	init_image_series( void );
void 	init_overlay_luts( void );
void 	OVR_Draw3DRect(int, int, int, int, int, int, int, int, int, int, int );
void 	OVR_PushButton(int);
void 	OVR_DrawLabel(int);
int  	OVR_Print(int, int,int, int, int, int, int, int, char *, ...);
int  	ggetch( void );
void 	GrabImages( int );
void 	StopTheProcess( void );
void 	StartTheProcess( void );
int	GetNumLabels( void );
int	GetNumButtons( void );
void	DrawHistogram( void );
void	RemoveHistogram( void );
void 	Message(char *format,...);
void	ShowMessage( int );
void 	RemoveMessage( void );
int	AutomaticCalibration( void );
void 	InitMouseDriver( void );
void 	ShowTheMouse( void );
void	HideTheMouse( void );
void	DeinitMouse( void );
void	UpdateMouseInfo( void );
void	Termination( void );

/************************************************************/
/* Macros for synchronisation between host and IMAGE SERIES */
/************************************************************/
#define GSPWait4Proc  iosditag( I_PROC );iowtitag( I_PROC );
#define HostWait4Proc iosdetag( I_PROC );iowtetag( I_PROC )
#define HostWait4Gsp  iosdetag( I_GSP );iowtetag( I_GSP )
#define HostWait4All  iosdetag( I_PROC );iowtetag( I_PROC );iosdetag( I_GSP );iowtetag( I_GSP )

/***************************/
/* structure definitions.. */
/***************************/
/* BUTTON - The button structure is used to define a rectangle using
* the following format.
*
*  left, top, width and height define the position and size of the rectangle.
*
*  1111111111111111111   0- interior color 
*  1222222222222222224   1- outside_top_left_color
*  1222222222222222254   2- top_left_color
*  1223333333333333554   3- inside_top_left_color
*  1223000000000006554   4- outside_bottom_right
*  1223000000000006554   5- bottom_right
*  1223000000000006554   6- inside_bottom_right
*  1223000000000006554
*  1223000000000006554
*  1223666666666666554
*  1225555555555555554
*  1255555555555555554
*  1444444444444444444
*
*
*  Note:
*     1- 2 colors are used for every rectangle color 
*        (ie. interior_color[2]).
*
*       color[0] - is used for the nonactive color (ie. depressed)
*       color[1] - is used for the active color    (ie. pressed)
*
*     2- if ((*function)() != NULL) it will be called by OVR_PushButton.
*  
*  This structure is used by OVR_PushButton().
*/
typedef struct {
      int left, top, width, height;
      int interior_color[2];
      int outside_top_left_color[2];
      int top_left_color[2];
      int inside_top_left_color[2];
      int outside_bottom_right_color[2];
      int bottom_right_color[2];
      int inside_bottom_right_color[2];

      void (*function)(int num);
} BUTTON;


/* LABEL - The label structure is used to define a location and color
* for drawing a label.
*
*  code           - key code associated with this label
*  state          - current state of this label (ON if button depressed, OFF if button released)
*  log_state      - current logical state (ENABLED or DISABLED)
*  left, top      - position of label
*  color[0]       - is used for the nonactive color
*  color[1]       - is used for the active color
*  *text[]        - string to use as label
*  (*function)()  - if ((*function)() != NULL) it will
*                       be called by OVR_DrawLabel().
*  
*  This structure is used by OVR_DrawLabel().
*/
typedef struct {
      int  code;
      int  state, log_state;
      int  left, top;
      int  color[2];
      char *text[2];

      void (*function)(int num);
} LABEL;

/*******************/
/* General defines */
/*******************/
#define	IMAGE_1280	1
#define	IMAGE_640	2
#define	IMAGE_LC	3
#define MAXCAM		40

/* defines for special chars */
#define HOME            199
#define END             207
#define PGUP            201
#define PGDN            209
#define LEFT            203
#define RIGHT           205
#define UP              200
#define DOWN            208
#define INS             210
#define DEL             211
#define CTRL_HOME       247
#define CTRL_END        245
#define ENTER_KEY	'\r'

#define F1              187
#define F2              188
#define F3              189
#define F4              190
#define F5              191
#define F6              192
#define F7              193
#define F8              194
#define F9              195
#define F10             196
#define F11             133
#define F12             134

/* The following defines are used for accessing the 'BUTTON' tables.
 * Each BUTTON contains information about the size and color of a
 * BUTTON. */
#define B_F1    0
#define B_F2    1
#define B_F3    2
#define B_F4    3

#define B_F5    4
#define B_F6    5
#define B_F7    6
#define B_F8    7
                      
#define B_F9    8
#define B_F10   9
#define B_F11   10
#define B_F12   11

#define B_LEFT  12
#define B_RIGHT 13
#define B_UP    14
#define B_DOWN  15

/* The following defines are used for the position of the
 * OVR menu blackboard. The blackboard is used as an area for drawing
 * BUTTONS and DISPLAY rectangles. */
#define BX_BLACKBOARD  10       /* Blackboard x origin */
#define BY_BLACKBOARD  10       /* Blackboard y origin */
#define BW_BLACKBOARD  208      /* blackboard width  */

/* The following defines are used for the position and size of the
 * title output (ie. "GRABTEST"). */
#define DX_TITLE       (BX_BLACKBOARD + 7 + 5)
#define DY_TITLE       (BY_BLACKBOARD + 5)
#define DW_TITLE       (BW_BLACKBOARD - 7 - 5 - 5)
#define DH_TITLE       48

/* The following defines are used for the position and size of the
 * function key BUTTONS. */
#define BX_F1      (BX_BLACKBOARD + 5)
#define BY_F1      (DY_TITLE + DH_TITLE + 26)
#define BW_F1      55
#define BH_F1      26

#define BX_F2      (BX_F1 + BW_F1)
#define BY_F2      BY_F1
#define BW_F2      BW_F1
#define BH_F2      BH_F1

#define BX_F3      BX_F1
#define BY_F3      (BY_F1 + BH_F1)
#define BW_F3      BW_F1
#define BH_F3      BH_F1

#define BX_F4      (BX_F3 + BW_F3)
#define BY_F4      BY_F3
#define BW_F4      BW_F3
#define BH_F4      BH_F3

/* These following positionnal and size information        */
/* are valid, for buttons F5 and F6, when grabbing_mode is */
/* set to NORMAL only.                                     */
#define BX_F5      BX_F1
#define BY_F5      (BY_F3 + BH_F1)
#define BW_F5      (BW_BLACKBOARD - 5 - 5)
#define BH_F5      BH_F1
#define BX_F6      BX_F1
#define BY_F6      (BY_F5 + BH_F5 + BH_F5)
#define BW_F6      (BW_BLACKBOARD - 5 - 5)
#define BH_F6      BH_F1

/* These following positionnal and size information        */
/* are valid, for buttons F5 and F6, when grabbing_mode is */
/* set to another mode than NORMAL.                        */
#define SBX_F5      BX_F1
#define SBY_F5      (BY_F3 + BH_F1 + BH_F1)
#define SBW_F5      BW_F1
#define SBH_F5      BH_F1
#define SBX_F6      (SBX_F5 + SBW_F5)
#define SBY_F6      SBY_F5
#define SBW_F6      BW_F4
#define SBH_F6      SBH_F5

#define BX_F7      BX_F1
#define BY_F7      (BY_F6 + BH_F6)
#define BW_F7      (BW_BLACKBOARD - 5 - 5)
#define BH_F7      BH_F1

#define BX_F8      BX_F1
#define BY_F8      (BY_F7 + BH_F7)
#define BW_F8      BW_F7
#define BH_F8      BH_F7

#define BX_F9      BX_F1
#define BY_F9      (BY_F8 + BH_F8)
#define BW_F9      BW_F7
#define BH_F9      BH_F7

#define BX_F10     BX_F1
#define BY_F10     (BY_F9 + BH_F9)
#define BW_F10     BW_F9
#define BH_F10     BH_F9

#define BH_BLACKBOARD  (BY_F10 + BH_F10 + 5 - BY_BLACKBOARD)      /* blackboard height */

/* The following defines are used for the message output box. */
#define DX_MGS     BX_BLACKBOARD
#define DY_MGS     (BY_BLACKBOARD + BH_BLACKBOARD + 10)
#define DW_MGS     BW_BLACKBOARD
#define DH_MGS     55

/* The following defines are used for the position and size of the
 * Black/White references and exposure DISPLAY rectangles. A DISPLAY rectangle
 * is used to output text to the screen. */
#define DX_TREF     (BX_BLACKBOARD + 5)
#define DY_TREF     (DY_TITLE + DH_TITLE)
#define DW_TREF     (BW_BLACKBOARD - 5 - 5)
#define DH_TREF     BH_F1

#define DX_WREF     (BX_F2 + BW_F2 + 1)
#define DY_WREF     BY_F1
#define DW_WREF     (BW_BLACKBOARD - BW_F1 - BW_F2 - 5 - 5 - 1)
#define DH_WREF     BH_F1

#define DX_BREF     (BX_F4 + BW_F4 + 1)
#define DY_BREF     BY_F3
#define DW_BREF     (BW_BLACKBOARD - BW_F3 - BW_F4 - 5 - 5 - 1)
#define DH_BREF     BH_F1

#define DX_TEXP     (BX_BLACKBOARD + 5)
#define DY_TEXP     (BY_F3 + BH_F3)
#define DW_TEXP     (BW_BLACKBOARD - 5 - 5)
#define DH_TEXP     BH_F1

#define DX_EXPOS    (SBX_F6 + SBW_F6 + 1)
#define DY_EXPOS    SBY_F5
#define DW_EXPOS    (BW_BLACKBOARD - SBW_F5 - SBW_F6 - 5 - 5 - 1)
#define DH_EXPOS    BH_F1

/* Position and size of the histogram window */
#define	DX_HISTO    (BX_BLACKBOARD + BW_BLACKBOARD + 15)
#define	DY_HISTO    BY_BLACKBOARD
#define DW_HISTO    (256 + 10 + 10)
#define	DH_HISTO    ((256 * 3 / 4) + 20 + 20)

/* Overlay colors */
#define	OVR_TRANSPARENT		0
#define	OVR_BLUE		1
#define	OVR_GREEN		2
#define	OVR_CYAN		3
#define	OVR_RED			4
#define	OVR_MAGENTA		5
#define	OVR_BROWN		6
#define	OVR_WHITE		7
#define	OVR_GRAY		8
#define	OVR_LIGHTBLUE		9
#define	OVR_LIGHTGREEN		10
#define	OVR_LIGHTCYAN		11
#define	OVR_LIGHTRED		12
#define	OVR_LIGHTMAGENTA	13
#define	OVR_YELLOW		14
#define	OVR_BRIGHTWHITE		15

/* Miscellaneous defines */
#define	IM_OVERLAY	1
#define	VGA_OVERLAY	2

/* Different grabbing operations */
#define NORMAL_GRAB	1
#define SMOOTHING_GRAB	2
#define SHARPENING_GRAB 3
#define TRIGGERED_GRAB	4

/* Boolean definitions */
#define	TRUE	 1
#define	FALSE	 0
#define	ON	 1
#define	OFF	 0
#define ENABLED  1
#define DISABLED 0

#define	WHITE_LEVEL			245
#define	BLACK_LEVEL			10
#define	E_OK			 0
#define	E_CANT_SET_PREAMP	-1
#define	E_CANT_SET_WHITE	-2
#define	E_CANT_SET_BLACK	-3

/* Message output parameters */
#define MAX_MESSAGE_LINES	20
#define	MAX_CHARS_PER_LINE	128
#define	WITH_PAUSE		1
#define	WITHOUT_PAUSE		2

/* Grabbing mode specification */
#define	NORMAL			1
#define	SOFTTRIG		2
#define	TTL_HARDTRIG		3
#define	OPTO_HARDTRIG		4
#define	MAX_MODE		4

/* Font specification for use when drawing overlay information */
/* on the VGA (Image-LC only)                                  */
#define	FONTSPEC	"ROMAN.FON"

/* Mouse driver defines */
#define	MOUSE_CLICK	0xff
#define MOUSE_INT       0x33
#define IRET_INSTR      0xcf
#define	TIME_DELAY	15

/* Mouse driver functions: */
#define RESET_MOUSE     0
#define SHOW_MOUSE      1
#define HIDE_MOUSE      2
#define	MOUSE_INFO	3
#define	SET_HCLIP	7
#define	SET_VCLIP	8

/* Mouse type: */
#define TWO_BUTTON      2
#define THREE_BUTTON    3
