/*****************************************************************************/
/*                             MESSAGE.C                                     */
/*****************************************************************************/
/*                                                                           */
/* Designed by: Michel Pelletier                                             */
/* Date: 	April 30, 1993                                               */
/*                                                                           */
/*****************************************************************************/
/* Inclusions */

#include <grabtest.h>

extern int	font_xsize, font_ysize, OVRLocation;
extern short	screen_w, screen_h;
extern char	*message_text[MAX_MESSAGE_LINES];
extern char	temp_buffer[MAX_CHARS_PER_LINE + 1];
extern int	num_message_lines;
extern int	max_message_width;
extern int	wleft, wtop, wright, wbottom, wwidth, wheight;

void		*sav_buffer = NULL;

/* Message()
*
* Designed by: Henry Hurdon      Date: Mar.  26, 1989
* Reviewed by: ................. Date: ..............
* Modified by: Michel Pelletier  Date: Apr.  30, 1993
*
*    Calls: --------
*
*     Uses: -----
* Modifies: -----
*  Returns: nothing.
*
*/

/*===================================================*/
/* This function uses strdup() to allocate space for */
/* message strings.                                  */
/*===================================================*/
void Message(char *format,...)
{
va_list arg_marker;

va_start( arg_marker, format );
vsprintf( temp_buffer, format, arg_marker );
va_end( arg_marker );

if( num_message_lines < MAX_MESSAGE_LINES ) 
	{
	message_text[num_message_lines] = strdup( temp_buffer );
	max_message_width = max( max_message_width, (int)strlen( temp_buffer ) );
	num_message_lines++;
	}
}

/*=======================================================*/
/* This function displays the message on the screen      */
/* pause_mode must be set to WITH_PAUSE or WITHOUT_PAUSE */
/* If set to WITH_PAUSE, this function will print a      */
/* pause message and wait for a key to be pressed by the */
/* user.                                                 */
/*=======================================================*/
void ShowMessage( int pause_mode )
{
int     si;
int     ch;

HideTheMouse();

/* calculate how big the message window should be */
/* allowing 2 spaces on each side of longest line */
if( pause_mode == WITH_PAUSE )
	{
	Message( "Press any key to continue..." );
	}
wwidth = (max_message_width + 4) * font_xsize;
wheight = (num_message_lines + 2) * font_ysize;

/* Calculate position of message window */
/* so it appears in the middle of the   */
/* visible screen.                      */
wleft    =  (screen_w - wwidth) / 2;
wright   =  wleft + wwidth - 1;
wtop     =  (screen_h - wheight) / 2;
wbottom  =  wtop + wheight - 1;

/* Save what's already on the screen at that location */
if( OVRLocation == IM_OVERLAY )
   {
   /******************************************************/
   /* Use Image-Shell graphics functions for drawing in  */
   /* the IM-1280 or IM-640 overlay frame buffer.        */
   /******************************************************/
   sav_buffer = malloc( wwidth * wheight );
   if( sav_buffer != NULL )
	{
	iordfbarea( I_OVL_SURF, wleft, wtop, wright, wbottom, sav_buffer );
	}
   }
else
   {
   /*****************************************************/
   /* Use Microsoft C graphics functions for drawing in */
   /* the VGA's frame buffer.                           */
   /*****************************************************/
   sav_buffer = malloc( (int)_imagesize( wleft, wtop, wright, wbottom ) );
   if( sav_buffer != NULL )
	{
	_getimage( wleft, wtop, wright, wbottom, sav_buffer );
	}
   }

/* ok.. display message */
OVR_Draw3DRect( wleft, wtop, wwidth, wheight,
                  OVR_BRIGHTWHITE,
                  OVR_GRAY,
                  OVR_WHITE, OVR_WHITE,
                  OVR_GRAY,    
                  OVR_GRAY,  OVR_GRAY);

for( si = 0; si < num_message_lines; si++ )
	{
	OVR_Print( wleft + (font_xsize * 2), wtop + (font_ysize * (1 + si)),
		1, 1, wleft + (font_xsize * 2), wtop + (font_ysize * (1 + si)),
		OVR_RED, OVR_BRIGHTWHITE, message_text[si] );
	}
if( pause_mode == WITH_PAUSE )
	{
	ch = ggetch();
	RemoveMessage();
	}
ShowTheMouse();
}

/*============================================*/
/* This function removes the message from the */
/* screen and releases associated memory      */
/*============================================*/
void RemoveMessage( void )
{
int	si;

HideTheMouse();

/* free up the messages */
for( si = 0; si < num_message_lines; si++ ) 
	{
	free( message_text[si] );
	}
num_message_lines  = 0;
max_message_width  = 10;

if( OVRLocation == IM_OVERLAY )
   {
   /******************************************************/
   /* Use Image-Shell graphics functions for drawing in  */
   /* the IM-1280 or IM-640 overlay frame buffer.        */
   /******************************************************/
   if( sav_buffer != NULL )
	{
	/* Write back previously saved image */
	iowrfbarea( I_OVL_SURF, wleft, wtop, wright, wbottom, sav_buffer );
	free( sav_buffer );
	sav_buffer = NULL;
	}
   else
	{
	/* Select overlay buffer */
	krhwslcsurf( I_OVL_SURF );

	/* clear rectangle background */
	krhwsfcol( OVR_TRANSPARENT );
	scarrect( wleft, wtop, wright, wbottom );
	}
   }
else
   {
   /*****************************************************/
   /* Use Microsoft C graphics functions for drawing in */
   /* the VGA's frame buffer.                           */
   /*****************************************************/
   if( sav_buffer != NULL )
	{
	/* Write back previously saved image */
	_putimage( wleft, wtop, sav_buffer, _GPSET );
	free( sav_buffer );
	sav_buffer = NULL;
	}
   else
	{
	/* clear rectangle background */
	_setcolor( OVR_TRANSPARENT );
	_rectangle(_GFILLINTERIOR, wleft, wtop, wright, wbottom );
	}
   }
ShowTheMouse();
}

