/*
    filename:  i_head.h

COPYRIGHT (c) 1989, 1990, 1991  Matrox Electronic Systems Ltd.
All Rights Reserved

*/

#ifndef __I_I_HEAD_H__
#define __I_I_HEAD_H__


/*/
*       Synopsis:     Header file of low-level defines given to the User.
*       Date:         89.05.16
*                                               
*       Anything requiring clarification:  
**/

/* Includes */

#include "camlist.h"

/* Synchronisation queues */

#define   I_GSP                0
#define   I_PROC               1

/* Data type defines.  These values must be long. */

#define I_UNSIGNED_8           0x011C0800L
#define I_UNSIGNED_12          0x015A0900L
#define I_UNSIGNED_16          0x00080A00L

#define I_SIGNED_8             0x013C5C10L
#define I_SIGNED_12            0x017A3D10L
#define I_SIGNED_16            0x00081E10L


/* EBI src bus defines */

#define I_SRC1                 0x0000
#define I_SRC2                 0x0006


/* Lattice defines */

#define I_RECT                 0x0000     /* used in _ttocgtvbporch */
#define I_RECT8                0x0000
#define I_RECT4                0x0080
#define I_HEX                  0x001B


/* Operation defines */

#define I_ADD                  0x0000       /* Alu-X, Core */

#define I_A_MINUS_B            0x0001       /* Alu-X, Core */
#define I_SUB                  I_A_MINUS_B

#define I_PASS_A               0x0002       /* Alu-X, Core */
#define I_PASS_B               0x0003       /* Alu-X, Core */
#define I_PASS                 I_PASS_A
#define I_PASS_S1              I_PASS_A
#define I_PASS_S2              I_PASS_B

#define I_GEQUAL               0x0004       /* Prepro, Core */
#define I_EQUAL                0x0005       /* Prepro, Core */
#define I_LESS                 0x0006       /* Prepro, Core */
#define I_NEQUAL               0x0007       /* Prepro, Core */
#define I_GREATER              0x0008
#define I_LEQUAL               0x0009

#define I_B_MINUS_A            0x000A
#define I_NEG_SUB              I_B_MINUS_A

#define I_MINUS_A_MINUS_B      0x000B
#define I_NEG_ADD              I_MINUS_A_MINUS_B
                              
#define I_ABS_A                0x000C
#define I_ABS_B                0x000D
#define I_ABS                  I_ABS_A
#define I_ABS_S1               I_ABS_A
#define I_ABS_S2               I_ABS_B

#define I_NEG_ABS_A            0x000E
#define I_NEG_ABS_B            0x000F
#define I_NEG_ABS              I_NEG_ABS_A
#define I_NEG_ABS_S1           I_NEG_ABS_A
#define I_NEG_ABS_S2           I_NEG_ABS_B

#define I_ABS_ADD              0x0010

#define I_ABS_A_MINUS_B        0x0011
#define I_ABS_SUB              I_ABS_A_MINUS_B

#define I_MIN                  0x0012
#define I_MAX                  0x0013

#define I_NOT_A                0x0014
#define I_NOT_B                0x0015
#define I_NOT                  I_NOT_A
#define I_NOT_S1               I_NOT_A
#define I_NOT_S2               I_NOT_B

#define I_OR                   0x0016
#define I_AND                  0x0017
#define I_XOR                  0x0018
#define I_NOR                  0x0019
#define I_NAND                 0x001A
#define I_XNOR                 0x001B

#define I_NEG_A                0x0023
#define I_NEG_B                0x0024
#define I_NEG                  I_NEG_A
#define I_NEG_S1               I_NEG_A
#define I_NEG_S2               I_NEG_B
                               
/* Variations for combing source and results for neighbourhood routines */

#define I_SBUF                 128

#define I_ADD_SBUF             (I_ADD | I_SBUF)
#define I_SUB_SBUF             (I_SUB | I_SBUF)
#define I_NEG_SUB_SBUF         (I_NEG_SUB | I_SBUF)
#define I_NEG_ADD_SBUF         (I_NEG_ADD | I_SBUF)
#define I_ABS_ADD_SBUF         (I_ABS_ADD | I_SBUF)
#define I_ABS_SUB_SBUF         (I_ABS_SUB | I_SBUF)
#define I_MIN_SBUF             (I_MIN | I_SBUF)
#define I_MAX_SBUF             (I_MAX | I_SBUF)
#define I_OR_SBUF              (I_OR | I_SBUF)
#define I_AND_SBUF             (I_AND | I_SBUF)
#define I_XOR_SBUF             (I_XOR | I_SBUF)
#define I_NOR_SBUF             (I_NOR | I_SBUF)
#define I_NAND_SBUF            (I_NAND | I_SBUF)
#define I_XNOR_SBUF            (I_XNOR | I_SBUF)


/* OOi operations */
#define I_EVERYWHERE           0x0000
#define I_INSIDE               0x0FFF
#define I_OUTSIDE              0x00F0

/* to use with fbcpbtob() */
#define I_DONT_FORCE           0L        /* long version of I_EVERYWHERE */
#define I_FORCE_IN_OOI         0x0FFFL   /* long version of I_INSIDE     */
#define I_FORCE_OUT_OOI        0x00F0L   /* long version of I_OUTSIDE    */

/* To be used with stccprof(); direction: */
#define I_XDIR                 0 /* Use X direction for profile.  OBSOLETE */
#define I_YDIR                 1 /* Use Y direction for profile.  OBSOLETE */
#define I_CAL_COL              0 /* Calculate an X profile (ie constant X) */
#define I_CAL_ROW              1 /* Calculate a Y profile (ie constant Y)  */

/* Parameter 'size' allowed H-defines :                                   */

#define I_Size_FIELD_POS       8

#define I_PAL_IS_64K           ( 0 << I_Size_FIELD_POS )
#define I_PAL_IS_32K           ( 1 << I_Size_FIELD_POS )
#define I_PAL_IS_16K           ( 2 << I_Size_FIELD_POS )
#define I_PAL_IS_8K            ( 3 << I_Size_FIELD_POS )
#define I_PAL_IS_4K            ( 4 << I_Size_FIELD_POS )
#define I_PAL_IS_2K            ( 5 << I_Size_FIELD_POS )
#define I_PAL_IS_1K            ( 6 << I_Size_FIELD_POS )
#define I_PAL_IS_512           ( 7 << I_Size_FIELD_POS )
#define I_PAL_IS_256           ( 8 << I_Size_FIELD_POS )
#define I_NO_LUT              -1         /* LUT palette not used */


/* Event counter control */
#define I_INRANGE              0x0001
#define I_OUTRANGE             0x0002

/* Binarizarion control */
#define I_DONT_BINARIZE        0x0000

/* Parameter 'abs' for NP clip */
#define I_ABSOLUTE             ( 0x0008L << 20 )   /* Must be long */

/* pcstcond() defines */
#define I_DIFF          I_ADD  /* must not be the same as I_MIN or I_MAX    */
#define I_FOREVER       I_ADD  /* must not be same as conditional operators */
#define I_FOR           I_SUB  /*                 -- " --                   */


/*************************************************************************/
/* Defined constants used by the high level neighbourhood routines.      */
/*************************************************************************/

/* User-tunable parameters defining the amount of storage reserved */
/* for convolution kernels and morphological structuring elements. */

/* The number of user-definable kernels  (0 to I_NUSERKERNELS - 1) */
#define I_NUSERKERNELS         200

/* The number of system kernels (starting from I_NUSERKERNELS) */
#define I_NSYSKERNELS          400
#define I_FIRST_IMVIS_KERNEL   (I_NUSERKERNELS + 100)

/* The maximum number of kernels that can be made into a multiple kernel */
#define I_MAXKERLIST           50

/* The kernel ids of system (pre-defined) kernels. */
#define I_MIN3X3               (I_NUSERKERNELS + 0)
#define I_MAX3X3               (I_NUSERKERNELS + 1)
#define I_LP1                  (I_NUSERKERNELS + 2)
#define I_LP2                  (I_NUSERKERNELS + 3)
#define I_SHARP1               (I_NUSERKERNELS + 4)
#define I_SHARP2               (I_NUSERKERNELS + 5)
#define I_HOREDGE              (I_NUSERKERNELS + 6)
#define I_VERTEDGE             (I_NUSERKERNELS + 7)

/* The kernel ids of system (pre-defined) compass gradient kernels. */
#define I_SOBEL_1              (I_NUSERKERNELS + 8)
#define I_SOBEL_2              (I_NUSERKERNELS + 9)
#define I_SOBEL_3              (I_NUSERKERNELS + 10)
#define I_SOBEL_4              (I_NUSERKERNELS + 11)
#define I_SOBEL                (I_NUSERKERNELS + 12)

#define I_APP_SOBEL            (I_NUSERKERNELS + 13)

#define I_PREWITT_1            (I_NUSERKERNELS + 14)
#define I_PREWITT_2            (I_NUSERKERNELS + 15)
#define I_PREWITT_3            (I_NUSERKERNELS + 16)
#define I_PREWITT_4            (I_NUSERKERNELS + 17)
#define I_PREWITT              (I_NUSERKERNELS + 18)

#define I_APP_PREWITT          (I_NUSERKERNELS + 19)

#define I_KIRSCH_1             (I_NUSERKERNELS + 20)
#define I_KIRSCH_2             (I_NUSERKERNELS + 21)
#define I_KIRSCH_3             (I_NUSERKERNELS + 22)
#define I_KIRSCH_4             (I_NUSERKERNELS + 23)
#define I_KIRSCH               (I_NUSERKERNELS + 24)

#define I_MORPHGRAD            (I_NUSERKERNELS + 25)

/* Struct_ids of system structuring elements. */
#define I_3X3HEX               (I_NUSERKERNELS + 40)
#define I_3X3RECT              (I_NUSERKERNELS + 41)

/* Struct_ids of system structuring element lists. */
#define I_THICKHEX             (I_NUSERKERNELS + 42)
#define I_THICKRECT            (I_NUSERKERNELS + 43)
#define I_PRUNEHEX             (I_NUSERKERNELS + 44)
#define I_PRUNERECT            (I_NUSERKERNELS + 45)
#define I_CONVHULLHEX          (I_NUSERKERNELS + 46)
#define I_CONVHULLRECT         (I_NUSERKERNELS + 47)
#define I_LSKELHEX             (I_NUSERKERNELS + 48)
#define I_LSKELRECT            (I_NUSERKERNELS + 49)
#define I_DSKELHEX             (I_NUSERKERNELS + 50)
#define I_DSKELRECT            (I_NUSERKERNELS + 51)
#define I_FERET_0_RECT         (I_NUSERKERNELS + 52)
#define I_FERET_90_RECT        (I_NUSERKERNELS + 53)
#define I_FERET_30_HEX         (I_NUSERKERNELS + 54)
#define I_FERET_90_HEX         (I_NUSERKERNELS + 55)


/* Overscan mode used by neighbourhood routines. */
#define I_TRANSPARENT          1
#define I_REPLACE              2

/* Polarity for modomarker() */
#define I_WHITE                0
#define I_BLACK                1

/* Type of convolution kernel.  Used by nbdfker(). */
#define I_CONV          I_ADD  /* must not be the same as I_MIN or I_MAX */

/* How convolution results are combined with dbuf.  Used by nbdoconv(), */
/* nbdomconv(), and modomatch(). */
#define I_OVERWRITE     I_PASS_B

/* Extra values for nbdfker() 'kercomb' parameter */
#define I_MERGE               64
#define I_DUAL               128

/* Extra conditional operator for conditional functions */
#define I_ALWAYS               0

/* Extra data types for convolution results */
#define I_ABS_UNSIGNED_8       (I_UNSIGNED_8  | I_ABSOLUTE)
#define I_ABS_SIGNED_8         (I_SIGNED_8    | I_ABSOLUTE)
#define I_ABS_UNSIGNED_12      (I_UNSIGNED_12 | I_ABSOLUTE)
#define I_ABS_SIGNED_12        (I_SIGNED_12   | I_ABSOLUTE)
#define I_ABS_UNSIGNED_16      (I_UNSIGNED_16 | I_ABSOLUTE)
#define I_ABS_SIGNED_16        (I_SIGNED_16   | I_ABSOLUTE)

/* Can be ORed with 'kernel' to cause rounding instead of truncation
 * during normalization (if nbdfker 'shift' parameter used).
 */
#define I_ROUND 0x8000

/* Types of structuring element. */
#define I_GREY                 1
#define I_BINARY               2
#define I_GRAY                 I_GREY

/* Indicates that a structuring element value is to be ignored. */
#define I_DONT_CARE           -32768
#define I_X                    I_DONT_CARE

/* Speed of the modocomplab() function */
#define I_FAST                 0
#define I_SLOW                 1

/* Functions performed by modomatch(). */
#define I_MATCH                0
#define I_HITORMISS            1
#define I_ERODE                2
#define I_DILATE               3
#define I_THICK                4
#define I_THIN                 5

/* Recursive and greyscale variations */
#define I_GREYSCALE            128
#define I_RECURSIVE            64
#define I_GREYTHICK            (I_THICK | I_GREYSCALE)
#define I_GREYTHIN             (I_THIN  | I_GREYSCALE)
#define I_RECTHICK             (I_THICK | I_RECURSIVE)
#define I_RECTHIN              (I_THIN  | I_RECURSIVE)

/* One of the functions performed by mododistance(). */
#define I_DISTANCE             100

/* Selects 4- or 8-connectivity for the distance function. */
/* ie, func = I_DISTANCE+I_CONNECT4 */
#define I_CONNECT4             128
#define I_CONNECT8             0

/* A value to persuade nbdorank() to output the rank (1-9) of the centre */
/* pixel in each filter window (in 1 pass).   Give rank = I_RANK_OUTPUT. */
#define I_RANK_OUTPUT         -1

/* Control of parallel statistical operation. */
/* (set by pcststatop()) */
#define I_NOOP        0
#define I_HISTOGRAM   1
#define I_STORE       2
#define I_LUTMAP      3

#define I_SOURCE      0
#define I_RESULT      1

/* 'retval' argument to stccfastcen() */
#define I_XYCEN                1
#define I_XYCEN_FLOAT          2
#define I_SUM                  4
#define I_XPROF                8
#define I_YPROF             0x10
#define I_XYPROF     (I_XPROF | I_YPROF)
#define I_ABS_DIFF        0x1000
#define I_RETRIEVE        0x2000
#define I_24BIT_LUT       0x4000
/* 0x8000 is reserved for test mode */

/* Error messages returned by nbdfker(), nbdfmker(), nbdoconv(), */
/* and nbdomconv().  These will be replaced eventually (I guess).*/
#define I_SUCCESS              0

#define I_NB_ERR               0    /* Base for all nb errors */
#define I_KERNEL_ID_INVALID    (I_NB_ERR - 1)
#define I_KERNEL_ID_IN_USE     (I_NB_ERR - 2)
#define I_INSUFFICIENT_MEMORY  (I_NB_ERR - 3)
#define I_KERNEL_ID_NOTDEFINED (I_NB_ERR - 4)
#define I_KERNEL_NULL          (I_NB_ERR - 5)

/*************************************************************************/
/* End of convolution and morphology definitions.                        */
/*************************************************************************/


/* ROI ids */
#define I_ROI0                 0x0000
#define I_ROI1                 0x0200
#define I_ROI2                 0x0400
#define I_ROI3                 0x0600
#define I_ROI4                 0x0800
#define I_ROI5                 0x0a00
#define I_ROI6                 0x0c00
#define I_ROI7                 0x0e00


/* for log_fb */

#define I_NO_BUF               0x0007

#define I_CONSTANT             0x8006            /* = TRI_STATE */
#define I_DIGITIZER            0x8007
#define I_DIG_8                0x8007
#define I_DIG_16               0x8017
#define I_DIG_24               0x8037

#define I_FB0                  0x0000
#define I_FB1                  0x0009
#define I_FB2                  0x0002
#define I_FB3                  0x000b
#define I_FBOVL                0x0004
#define I_OVL                  0x0004

#define I_FB01                 0x0010
#define I_FB23                 0x0012

#define I_FB0123               0x0020


/* frame buffer organizations */
/* NOTE: tested for in ttocstaddr()! */

#define I_FB4X1KX1KX8          1
#define I_FB4X1KX512X8        -1

#define I_FB2X1KX1KX16         2
#define I_FB2X1KX512X16       -2

#define I_FB1X1KX1KX32         3
#define I_FB1X4KX1KX8          4
#define I_FB1X2KX1KX16         5

#define I_FB1X2KX2KX8          6

#define I_FB2X2KX1KX8          7
#define I_FB2X2KX512X8        -7

/* the following is for case of optional memory */
#define I_FB4X2KX1KX8          9
#define I_FB4X2KX512X8        -9

#define I_FB2X2KX1KX16         10
#define I_FB2X2KX512X16       -10

#define I_FB1X2KX1KX32         11
#define I_FB1X8KX1KX8          12
#define I_FB1X2KX4KX8          13
#define I_FB1X4KX2KX8          14
#define I_FB1X2KX2KX16         15

/* the following are for the case of 640 without optional memory */
#define I_FB1X1KX512X32         3
#define I_FB1X4KX512X8          4
#define I_FB1X2KX512X16         5
#define I_FB1X2KX1KX8           6

#define I_FB1X1KX2KX16         21      /* for IM/SC, will remap to 1 */
#define I_FB1X1KX1KX16         2       /* for IM/SC, will remap to 1 */
#define I_OVL2KX1K             8       /* for IM/SC */
#define I_OVL1KX2K             22      /* for IM/SC */

/* FB organization values for krhwslfborg() */

#define I_4FB_1KX1KX8          0
#define I_2FB_1KX1KX16         1
#define I_1FB_1KX1KX32         2
#define I_1FB_4KX1KX8          3
#define I_1FB_2KX1KX16         4
#define I_1FB_2KX2KX8          5
#define I_2FB_2KX1KX8          6
#define I_OVL_2KX1K            7      /* overlay FB */

/* Optional memory */

#define I_4FB_2KX1KX8          8
#define I_2FB_2KX1KX16         9
#define I_1FB_2KX1KX32         10
#define I_1FB_8KX1KX8          11
#define I_1FB_2KX4KX8          12
#define I_1FB_4KX2KX8          13
#define I_1FB_2KX2KX16         14

/* 640 without optional memory */
#define I_4FB_1KX512X8          0
#define I_2FB_1KX512X16         1
#define I_1FB_1KX512X32         2
#define I_1FB_4KX512X8          3
#define I_1FB_2KX512X16         4
#define I_1FB_2KX1KX8           5
#define I_2FB_2KX512X8          6
#define I_OVL_1KX1K             7      /* overlay FB */


/* for sync modes */
#define I_PROC_ALONE                0
#define I_PROC_DISP                 4
#define I_PROC_CAMERA               3
#define I_PROC_CAM_DISP             2
#define I_PROC_ALONE_DISP_CAMERA    5

/* For parameter "pass" of function ptdocthresh() */

#define I_PASS_VAL             0x0
#define I_PASS_PIXEL           0x18

/* Permitted oversample values for fbcpbtob() are simply the integers */
/* 1 to 16.  However, the name I_NOZOOM may be given for no oversampling . */

#define I_NOZOOM               1


/* display related #defines */

/* Defines for the assemblies of the IM-1280 STD memory and IM-640 OPT memory */

#define I_FB0_1K_1K_8      0x00000000L
#define I_FB1_1K_1K_8      0x11111111L
#define I_FB2_1K_1K_8      0x22222222L
#define I_FB3_1K_1K_8      0x33333333L
#define I_FB01_2K_1K_8     0x44444444L
#define I_FB23_2K_1K_8     0x77777777L
#define I_FB03_2K_2K_8     0x74747474L
#define I_FB03_4K_1K_8     0x55555555L
#define I_FB01_1K_1K_16    0x00000000L
#define I_FB23_1K_1K_16    0x22222222L
#define I_FB03_2K_1K_16    0x66666666L /* Use should be avoided - 2B ZAPPED */


#define I_FB02_2K_1K_16    0x66666666L
#define I_FB13_2K_1K_16    0x99999999L
#define I_FB03_1K_1K_32    0x00000000L

/* Defines for the assemblies of the IM-1280 with Optional memory */

#define I_FB0_2K_1K_8      0x00000000L
#define I_FB1_2K_1K_8      0x11111111L
#define I_FB2_2K_1K_8      0x22222222L
#define I_FB3_2K_1K_8      0x33333333L
#define I_FB01_2K_1K_16    0x00000000L
#define I_FB23_2K_1K_16    0x22222222L
#define I_FB03_2K_1K_32    0x00000000L
#define I_FB03_8K_1K_8     0x88888888L
#define I_FB03_2K_4K_8     0x32103210L
#define I_FB03_4K_2K_8     0xcacacacaL
#define I_FB03_2K_2K_16    0x20202020L

/* Defines for the assemblies of the IM-640 with STD memory */

#define I_FB0_1K_512_8      0x00000000L
#define I_FB1_1K_512_8      0x11111111L
#define I_FB2_1K_512_8      0x22222222L
#define I_FB3_1K_512_8      0x33333333L
#define I_FB01_2K_512_8     0x44444444L
#define I_FB23_2K_512_8     0x77777777L
#define I_FB03_2K_1K_8      0x74747474L
#define I_FB03_4K_512_8     0x55555555L
#define I_FB01_1K_512_16    0x00000000L
#define I_FB23_1K_512_16    0x22222222L
#define I_FB03_2K_512_16    0x66666666L /* Use should be avoided - 2B ZAPPED */
#define I_FB02_2K_512_16    0x66666666L
#define I_FB13_2K_512_16    0x99999999L
#define I_FB03_1K_512_32    0x00000000L

#define I_FB01_RGB555        0x00000000L
#define I_FB23_RGB555        0x22222222L
#define I_FBCOMP_RGB555      0x11111111L
#define I_FB02_2K_512_RGB555 0x66666666L
#define I_FB02_2K_1K_RGB555  0x66666666L
#define I_FB03_2K_2K_RGB555  0x20202020L
                                  
/* Defines for MSB and OVR assemblies */

#define I_VDO_FB0_LOW      0x00000000L  /* obsolete csts - avoid usage */
#define I_VDO_FB0_HIGH     0x00242424L  /* obsolete csts - avoid usage */
#define I_VDO_FB1_LOW      0x00090909L  /* obsolete csts - avoid usage */
#define I_VDO_FB1_HIGH     0x002d2d2dL  /* obsolete csts - avoid usage */
#define I_VDO_FB2_LOW      0x00121212L  /* obsolete csts - avoid usage */
#define I_VDO_FB2_HIGH     0x00363636L  /* obsolete csts - avoid usage */
#define I_VDO_FB3_LOW      0x001b1b1bL  /* obsolete csts - avoid usage */
#define I_VDO_FB3_HIGH     0x003f3f3fL  /* obsolete csts - avoid usage */
#define I_VDO_FBPAL        0x00121212L  /* obsolete csts - avoid usage */
#define I_VDO_FBOVR        0x00763636L  /* obsolete csts - avoid usage */
                                  
#define I_NIB_FB0          0x00000000L
#define I_NIB_FB1          0x00001111L
#define I_NIB_FB2          0x00002222L
#define I_NIB_FB3          0x00003333L
#define I_NIB_FB01         0x00004444L
#define I_NIB_FB13         0x00009999L
#define I_NIB_FB23         0x00007777L
#define I_NIB_FB01_OPT     0x0000aaaaL
#define I_NIB_FB13_OPT     0x00003131L
#define I_NIB_FB23_OPT     0x0000ccccL

#define I_NOAO             0x00002222L
#define I_FBPAL            0x00002222L
#define I_FBOVR            0x64642222L
#define I_LOWNIB           0x00000000L
#define I_HIGHNIB          0x24240000L

/* Defines for other High Level constants */

#define I_VDO_RED              0x0              /* Red component            */
#define I_VDO_GREEN            0x20             /* Green component          */
#define I_VDO_BLUE             0x40             /* Blue Component           */
#define I_VDO_MONO             0x60             /* Monochrome               */

#define I_VDO_HORZMOS          0x01             /* Mosaic horizontal        */
#define I_VDO_VERTMOS          0x02             /* Mosaic vertical          */
#define I_VDO_HORZZOM          0x10             /* Enable comparator horz   */
#define I_VDO_VERTZOM          0x20             /* Enable comparator vert   */
#define I_VDO_NOMOS            0                /* No mosaic                */
#define I_VDO_MFB              0                /* Main Frame Buffer        */
#define I_VDO_OVR              2                /* Overlay buffer           */

#define I_VDO_PASS_THRU        0xffffffffL
#define I_VDO_WHITE            0xffffffffL
#define I_VDO_PASS_NONE        0x00000000L
#define I_VDO_PASS_RED555      0x7c             /* old 0x1f */
#define I_VDO_PASS_GRN555      0xe3
#define I_VDO_PASS_BLU555      0x1f             /* old 0x7c */ 
#define I_VDO_PASS_OVR555      0x08

#define I_VDO_RGB_MONO         0                /* Mode mono                */
#define I_VDO_RGB_555          1                /* Mode RGB 555             */
#define I_VDO_RGB_888          2                /* Mode RGB 888             */

#define I_PORTRAIT             0x19c4709cL      /* Mode Portrait ON         */
#define I_NOPORTRAIT           0x25a668daL      /* Mode Portrait OFF        */
#define I_CROPPING             0x3              /* 2B ZAPPED                */
#define I_NOCROPPING           0x0              /* 2B ZAPPED                */
#define I_BORDER               0x3L             /* Border turned ON         */
#define I_NOBORDER             0x0L             /* Border turned OFF        */
#define I_UNDERLAY             0x4              /* Underlay enabled         */
#define I_NOUNDERLAY           0x0              /* Underlay disabled        */
#define I_VIEW0                0x0L             /* View 0                   */
#define I_VIEW1                0x1L             /* View 1                   */
#define I_VIEW2                0x2L             /* View 2                   */
#define I_VIEW3                0x3L             /* View 3                   */
#define I_STATIC              -1L               /* No more View             */
#define I_SYNCFRAME            0x10000000L      /* Request for sync         */
#define I_TEKTMONITOR          0x20000000L     /* Request to en. Tekt signal*/

/* lsdcstvgamode() */
#define I_NOVGA                0x0 /* Display IMAGE output only           */
#define I_VGA                  0x1 /* Display VGA card output only        */
#define I_COLOR                0x2 /* IMAGE-LC color comparator           */
#define I_LSB                  0x3 /* IMAGE-LC keying bit (bit 0 of DFB)  */
#define I_BOTH                 0x4 /* IMAGE-LC color comp. and keying bit */

/* lsdcstcolkey() - IMAGE-LC */
#define I_VGA_NEQUAL           0x0 /* Display VGA pixel if equal     */
#define I_VGA_EQUAL            0x1 /* Display VGA pixel if not equal */

/* lsdcstsyncgun() - IMAGE-1280                    */
/* ("red_gun", "green_gun" and "blue_gun" values)  */

#define I_SYNCON               0x80  /* Sync enabled on gun      */
#define I_SYNCOFF              0x00  /* Sync disabled on gun     */

/* lsdcstsyncgun() - IMAGE-640 and IMAGE-LC ("red_gun" values) */

#define I_CSYNC_ON_GREEN       0x0
#define I_CSYNC_ON_GREEN_ALPHA 0x1
#define I_NOCSYNC              0x2
#define I_CSYNC_EVERYWHERE     0x3
#define I_CSYNC_ON_MONO        0x4 
#define I_CSYNC_ON_RGB         0x5 

/* lsdcstosync() - IMAGE-1280, IMAGE-640 and IMAGE-SC */

#define I_HSYNC                0
#define I_CSYNC                1
#define I_SYNC_POSITIVE        1
#define I_SYNC_NEGATIVE        0

/* Display masks for RGB555 mode */
#define DCSTRGB555MASK(rp,gp,bp,ro,go,bo) lsdcstrdmask( \
                                          (rp<<2) & 0x7c, \
                                          ((gp<<5) & 0xe0) | ((gp>>3) & 3), \
                                          bp & 0x1f, \
                                          ro, go, bo)

/* UTLMGNLUT function code */
#define I_PHYRAMP              0L
#define I_LOGRAMP              4L
#define I_S24RAMP              5L
#define I_555RAMP              9L
#define I_PHYCSTE              1L
#define I_LOGCSTE              11L
#define I_S24CSTE              10L
#define I_888CSTE              2L
#define I_PHYINVR              6L
#define I_LOGINVR              7L
#define I_S24INVR              8L
#define I_PSEUDO               3L
#define I_STEPVAL              12L

/* lut management related symbols */
#define I_LUT_COPY_DIRECT      0x2L
#define I_LUT_COPY_LOCK        0xCL
#define I_LUT_COPY_DUPLICATE   0x7L

#define I_LUT_OUTL_RGB555      0xFFF00000L
#define I_LUT_OUTL_RGB888      0xFFF10000L
#define I_LUT_OUTL_MONO        0xFFF20000L
#define I_LUT_OUTL_OVRLAY      0xFFF30000L
#define I_LUT_OUTL_RED         0xFFF40000L
#define I_LUT_OUTL_GREEN       0xFFF50000L
#define I_LUT_OUTL_BLUE        0xFFF60000L
#define I_LUT_STAT_16B         0xFF800000L
#define I_LUT_STAT_24B         0xFF810000L
#define I_LUT_DIGIT            0xFF600000L
#define I_LUT_PROC             0xFF500000L
#define I_LUT_FIFO_16B         0xFF400000L
#define I_LUT_FIFO_32B         0xFF410000L
#define I_LUT_BT251            0xFF200000L
#define I_LUT_ALTP_RGB555      0xFF100000L
#define I_LUT_ALTP_RGB888      0xFF110000L
#define I_LUT_ALTP_MONO        0xFF120000L
#define I_LUT_ALTP_RED         0xFF140000L
#define I_LUT_ALTP_GREEN       0xFF150000L
#define I_LUT_ALTP_BLUE        0xFF160000L
#define I_LUT_OVRL_RGB888      0xFF110100L
#define I_LUT_OVRL_MONO        0xFF120100L
#define I_LUT_OVRL_OVRLAY      0xFF130100L
#define I_LUT_OVRL_RED         0xFF140100L
#define I_LUT_OVRL_GREEN       0xFF150100L
#define I_LUT_OVRL_BLUE        0xFF160100L
#define I_LUT_CLD_RED          0xFEA00000L
#define I_LUT_CLD_GREEN        0xFEA00100L
#define I_LUT_CLD_BLUE         0xFEA00200L
#define I_LUT_INTER            0xFE900000L
#define I_LUT_ALPHA            0xFE800000L

#define I_LUT_16B              0x0          /* obsolete csts - avoid usage */
#define I_LUT_32B              0x1          /* obsolete csts - avoid usage */
#define I_LUT_8B               0x2          /* obsolete csts - avoid usage */
#define I_LUT_OVRLAY           0x3          /* obsolete csts - avoid usage */
#define I_LUT_BYT0_32B         0x4          /* obsolete csts - avoid usage */
#define I_LUT_BYT1_32B         0x5          /* obsolete csts - avoid usage */
#define I_LUT_BYT2_32B         0x6          /* obsolete csts - avoid usage */
#define I_LUT_BYT3_32B         0x7          /* obsolete csts - avoid usage */
#define I_LUT_32B_FLOAT        0x8          /* obsolete csts - avoid usage */
#define I_LUT_64B_FLOAT        0x9          /* obsolete csts - avoid usage */
#define I_LUT_BYT0_16B         0xA          /* obsolete csts - avoid usage */
#define I_LUT_BYT1_16B         0xB          /* obsolete csts - avoid usage */
#define I_LUT_WRD0_32B         0xC          /* obsolete csts - avoid usage */
#define I_LUT_WRD1_32B         0xD          /* obsolete csts - avoid usage */

#define I_LUT_16B_LG           0x00000000L
#define I_LUT_32B_LG           0x00010000L
#define I_LUT_8B_LG            0x00020000L
#define I_LUT_OVRLAY_LG        0x00030000L
#define I_LUT_BYT0_32B_LG      0x00040000L
#define I_LUT_BYT1_32B_LG      0x00050000L
#define I_LUT_BYT2_32B_LG      0x00060000L
#define I_LUT_BYT3_32B_LG      0x00070000L
#define I_LUT_32B_FLOAT_LG     0x00080000L
#define I_LUT_64B_FLOAT_LG     0x00090000L
#define I_LUT_BYT0_16B_LG      0x000A0000L
#define I_LUT_BYT1_16B_LG      0x000B0000L
#define I_LUT_WRD0_32B_LG      0x000C0000L
#define I_LUT_WRD1_32B_LG      0x000D0000L

#define I_FIRST_USER_LUT       0x40L
#define I_LAST_USER_LUT        0x7ffL
#define I_FIRST_USER_LUT_LG    0x04000000L
#define I_LAST_USER_LUT_LG     0x7ff00000L

#define I_LUT_TOBLOCK          8L          /* nb pos to align to block     */
#define I_LUT_TODATTYPE        16L         /* nb pos to align to dattype   */
#define I_LUT_TONUMBER         20L         /* nb pos to align to number    */

#define I_LUT_SRC              0           /* LUT is source                */
#define I_LUT_DEST             128         /* LUT is destination           */

#define I_PACK                 1L          /* Require memory package       */
#define I_NOPACK               0L          /* No memory */

#define I_RTP                  0
#define I_ASD                  1L
#define I_CLD                  2L

/****************************************************************************/
/* ( OBJECT ANALYSIS ) CONTROL FUNCTION DEFINES                             */
/****************************************************************************/
#define FIELD_POS              16

#define I_NOTEQUAL_VL          ( 4L << FIELD_POS  )
#define I_EQUAL_VL             ( 5L << FIELD_POS  )
#define I_GEQUAL_VH            ( 0L << FIELD_POS  )
#define I_LESS_VH              ( 6L << FIELD_POS  )
#define I_GEQUAL_VL            ( 7L << FIELD_POS  )
#define I_LESS_VL              ( 3L << FIELD_POS  )
#define I_INRANGE_VLH          ( 1L << FIELD_POS  )
#define I_OUTRANGE_VLH         ( 2L << FIELD_POS  )
#define I_SET_NEIGHBORHOOD     I_EQUAL_VL  

#define I_SHORT_TYPE           1
#define I_LONG_TYPE            2
#define I_FLOAT_TYPE           4

/* set config vall and masks for predifined operation */

/* vall */
#define I_INTERCEPT_RECT       0x100
#define I_INTERCEPT_HEX        0x040
#define I_ISOLATED_RECT        0x100
#define I_ISOLATED_HEX         0x040
#define I_EULER_RECT1          0x100
#define I_EULER_RECT2          0x120
#define I_EULER_HEX1           0x040
#define I_EULER_HEX2           0x41

/* mask */
#define I_MASK_INTERCEPT_0     0x110
#define I_MASK_INTERCEPT_45    0x120
#define I_MASK_INTERCEPT_60    0x42
#define I_MASK_INTERCEPT_90    0x140
#define I_MASK_INTERCEPT_120   0x44
#define I_MASK_INTERCEPT_135   0x108
#define I_MASK_ISOLATED_RECT   0x1ff
#define I_MASK_ISOLATED_HEX    0x7f
#define I_MASK_EULER_RECT1     0x1c1
#define I_MASK_EULER_RECT2     0x160
#define I_MASK_EULER_HEX1      0x70
#define I_MASK_EULER_HEX2      0x41

/****************************************************************************/
/* ( OBJECT ANALYSIS ) DO FUNCTION DEFINES                                  */
/****************************************************************************/

/* selection of the moments in the function ftccbmom() */
#define I_NUMX                 0
#define I_NUMY                 1
#define I_SUMX                 2
#define I_M11TRUE              3

/* selection of the minimum enclosing rectangle coordinates */
#define I_TOP_LEFT_CORNER      0x25   /* MIN_X | MIN_Y */
#define I_BOTTOM_RIGHT_CORNER  0x2A   /* MAX_X | MAX_Y */
#define I_FERET                3
#define I_TLC_FERET            4      /* compute BOTTOM_RIGHT and FERET */
          
/* selection of the first point of the object */
#define I_TOP_RIGHT            1L        /* pack16( BOTTOMUP, LEFTRIGHT ) */  
#define I_TOP_LEFT             0L        /* pack16( BOTTOMUP, RIGHTLEFT ) */  
#define I_BOTTOM_LEFT          0x10000L  /* pack16( TOPDOWN , RIGHTLEFT ) */  
#define I_BOTTOM_RIGHT         0x10001L  /* pack16( TOPDOWN , LEFTRIGHT ) */  

/* selection for the LUT action */
#define I_LUT_NOCLEAR          0
#define I_LUT_CLEAR            1

/****************************************************************************/
/* JPEG FUNCTION DEFINES                                                    */
/****************************************************************************/

#define I_COMP_0               0
#define I_COMP_1               1
#define I_COMP_2               2
#define I_COMP_3               3

#define I_QUANTBL_0            0
#define I_QUANTBL_1            1
#define I_QUANTBL_2            2
#define I_QUANTBL_3            3

#define I_QU_8BITS        0x0000
#define I_QU_16BITS       0x0010

#define I_ACHUFFTBL_0          0
#define I_ACHUFFTBL_1          1
#define I_ACHUFFTBL_2          2
#define I_ACHUFFTBL_3          3

#define I_DCHUFFTBL_0          0
#define I_DCHUFFTBL_1          1
#define I_DCHUFFTBL_2          2
#define I_DCHUFFTBL_3          3

#define I_SR_MONO     0x00000011L       /* H3V3H2V2H1V1H0V0 */
#define I_SR_4440     0x00111111L
#define I_SR_4220     0x00111121L
#define I_SR_2420     0x00112111L
#define I_SR_2240     0x00211111L
#define I_SR_4110     0x00111122L
#define I_SR_1410     0x00112211L
#define I_SR_1140     0x00221111L
#define I_SR_4444     0x11111111L

/****************************************************************************/
/*  LOOKUP TABLE GENERATION ROUTINES                                        */
/****************************************************************************/

#define I_AVERAGE             -1
#define I_MINIMUM             -2
#define I_MAXIMUM             -3

#define I_LOG                  0
#define I_EXP                  1
#define I_SIN                  2
#define I_COS                  3
#define I_TAN                  4
#define I_QUAD                 5
#define I_MULT                 6
#define I_DIV                  7

typedef struct i_stat {
  float mean;
  float standard_deviation;
  long min_value;
  long min_location;
  long max_value;
  long max_location;
  } I_STAT;

#define I_UNIFORM              0
#define I_EXP                  1
#define I_RAYLEIGH             2
#define I_HYP_CUBE             3
#define I_HYP_LOG              4

#define I_FIFO                 0
/****************************************************************************/

/* Board reset types */

#define I_COLD                 0
#define I_WARM                 1

/* Parameter for iordline() & iowrline() */

#define I_HOR                  0x1C00   /* horizontal line */
#define I_VERT                 0x0400   /* vertical line */
#define I_45                   0x1800   /* 45 degree */
#define I_315                  0        /* 315 degrees */

/* FPU module */

#define I_FPU_GT_MOD           0L       /* Geometric Transformation module */
#define I_FPU_FD_MOD           1L       /* Frequency Domain module */
#define I_FPU_MS_MOD           2L       /* Miscellaneous module */
#define I_FPU_LS_MOD           3L       /* Libshell module */
#define I_FPU_JP_MOD           4L       /* JPEG module */

/* FFTs */
#define I_HORIZONTAL_PASS      0x0000
#define I_VERTICAL_PASS        0x0001
#define I_FORWARD_XFM          0x0000
#define I_INVERSE_XFM          0x0001
#define I_REAL                 0x0000
#define I_COMPLEX              0x0002
#define I_CENTRE_LOW_FREQ      0x0000
#define I_CENTRE_HIGH_FREQ     0x0002

/* FPU conversions */
#define I_SIGNED_32            0x0011
#define I_UNSIGNED_32          0x0B01
#define I_INT_TO_FLOAT         0x0000
#define I_FLOAT_TO_INT         0x0001
#define I_CLIP                 0x0000
#define I_NO_CLIP              0x0001

#define I_EXP_TO_RECT          0x0000
#define I_MAGNITUDE            0x0001
#define I_MAG_AND_PHASE        0x0002
#define I_ENERGY_SPECTRUM      0x0003

/* pciqsys */
#define I_IQ_LADDR             0
#define I_IQ_SCRW              1
#define I_IQ_SCRH              2
#define I_IQ_GSP_VER           4
#define I_IQ_W                 8
#define I_IQ_H                 9
#define I_IQ_PTCH              10
#define I_IQ_FMT               11
#define I_IQ_TL                12

#define I_IQ_BOARD_TYPE        14
#define I_IQ_VERSION           15
#define I_IQ_PORTRAIT          16
#define I_IQ_FPU_PRESENT       17
#define I_IQ_OPT_MEM           18
#define I_IQ_CLD_QTY           19
#define I_IQ_ASD_QTY           20
#define I_IQ_RTP_QTY           21
#define I_IQ_CPU_SPEED         22
#define I_IQ_COMP_LEN          23
#define I_IQ_DECOMP_STAT       24
#define I_IQ_CAMW              25
#define I_IQ_CAMH              26
#define I_IQ_ALU_QTY           27
#define I_IQ_VGA_STAT          28
#define I_IQ_OEM_ID            29   
#define I_IQ_PROC_CYCLES       30
#define I_IQ_PROC_XSIZE        31
#define I_IQ_PROC_YSIZE        32
#define I_IQ_CAM_TARGET        33
#define I_IQ_CAM_PIXSIZE       34
#define I_IQ_CAM_PCLK          35
#define I_IQ_CAM_TYPE          36
#define I_IQ_CAM_DATATYPE      37
#define I_IQ_CAM_COLFMT        37
#define I_IQ_DCMASKS           38

/* pciqusr */
#define I_IQ_ROI_XSIZE          0
#define I_IQ_ROI_YSIZE          1
#define I_IQ_ROI0               2
#define I_IQ_ROI1               3
#define I_IQ_ROI2               4
#define I_IQ_ROI3               5
#define I_IQ_ROI4               6
#define I_IQ_ROI5               7
#define I_IQ_ROI6               8
#define I_IQ_ROI7               9
#define I_IQ_FBORG             10
#define I_IQ_IN_TYPE1		   11
#define I_IQ_IN_TYPE2		   12
#define I_IQ_OUT_TYPE		   13
#define I_IQ_SRC1_MSK		   14
#define I_IQ_SRC2_MSK		   15
#define I_IQ_DST_MSK		   16
#define I_IQ_SRC1_BIN_COND	   17
#define I_IQ_SRC1_BIN_MASK	   18
#define I_IQ_SRC1_BIN_VAL	   19
#define I_IQ_SRC2_BIN_COND	   20
#define I_IQ_SRC2_BIN_MASK	   21
#define I_IQ_SRC2_BIN_VAL	   22
#define I_IQ_COND_STAT		   23
#define I_IQ_COND			   24
#define I_IQ_COND_VAL		   25
#define I_IQ_SUB_SAMP		   26
#define I_IQ_OOI_FB			   27
#define I_IQ_OOI_MASK		   28
#define I_IQ_OOI_VAL		   29
#define I_IQ_OOI_COND		   30
#define I_IQ_LATTICE		   31
#define I_IQ_KCEN_X			   32
#define I_IQ_KCEN_Y			   33
#define I_IQ_SYNC			   34
#define I_IQ_LOGCAM			   35

/* di functions */
#define I_INDEP_SYNC           0x8000
#define I_SYNC_VCR             0x4000
#define I_SOFTTRIG             1 
#define I_HARDTRIG             2
#define I_TIMEBASETRIG         3

/* color format definition for CLD */
#define I_RGB_TO_RGB           1
#define I_RGB_TO_BGR           2
#define I_RGB_TO_RYBYY         3
#define I_RGB_TO_UVY           4
#define I_RGB_TO_IQY           5
#define I_RGB_TO_HSI           6
#define I_RYYBY_TO_RGB         7
#define I_UYV_TO_RGB           8
#define I_IYQ_TO_RGB           9
#define I_IYQ2_TO_RGB          10
#define I_RGB555               11
#define I_RGB332               12
#define I_RGB_TO_XYZ           13
#define I_RGB_TO_RGB_CORR      14


/* input, output, and range definition for the CLD */
#define I_UNS_NOMUX_NOINT      1
#define I_ANA_NOMUX_NOINT      2
#define I_COMP_NOMUX_NOINT     5
#define I_PSEUDO_COLOR         8

#define I_UNS_NOMUX_NODEC      1
#define I_ANA_NOMUX_NODEC      2
#define I_COMP_NOMUX_NODEC     5

#define I_M7_0                 1
#define I_M8_1                 2
#define I_M9_2                 3
#define I_M10_3                4
#define I_M11_4                5
#define I_BYPASS               8


/* double scan enable and disable */
#define I_DI_DSCAN              0x0001
#define I_EN_DSCAN              0x0002
#define I_DI_FIELD_SCAN         0x8001
#define I_EN_FIELD_SCAN         0x8002

/* for pcslprocmode; used to set usr.proc_mode */
#define I_QUEUED                1      /* clear bit 0 */
#define I_SYNCHRONIOUS          2      /* set bit 0   */
#define I_SYNCHRONOUS           2      /* Correct spelling of above */
#define I_PROCESSING_ORIENTED   4      /* clear bit 1 */
#define I_GRAPHIC_ORIENTED      8      /* set bit 1   */
#define I_NORMAL_SCAN           16     /* used to set usr.scan_speed */
#define I_FAST_SCAN             32     /* NORMAL=0, FAST=1           */
#define I_OVERLAY_ORIENDTED     0x8000 /* Ovl: graphics, Mfb: processing */


/*****************************/
/* Optional packages present */
/*****************************/

#define OA_UNLOCKED             1L



/*****************************************************/
/* IM-SHELL 8-bit error codes (128 to 255 inclusive) */
/*****************************************************/

#define I_ERR_DIVIDE_BY_ZERO    128 /* self-explanatory */
#define I_ERR_NOT_SUPPORTED     129 /* illegal option or out-of-range */
                                    /* parameter selected */
#define I_ERR_ALREADY_ALLOCATED 130 /* reallocation of resource without */
                                    /* previous deallocation */
                                    
#define I_ERR_NOT_ALLOCATED     131 /* unallocated resource referenced */
#define I_ERR_FIELD_SIZE        132 /* field size specified is larger */
                                    /* than allocated storage */

#define I_ERR_NO_SYNC           133 /* digitizer sync-loss */
#define I_ERR_BOARD_NOT_PRESENT 134 /* ebi resource absent */


/********************/
/* Intermediate LUT */
/********************/

#define  I_INTER_LUT_ON     1L
#define  I_INTER_LUT_OFF    0L
#define  I_ON   1L
#define  I_OFF  0L

/***************************/
/* ALPHA channel of IM-640 */
/***************************/

#define  I_ALPHA_OFF        0L
#define  I_ALPHA_ON         1L

/***************************/
/* define for krhwslcsurf  */
/***************************/

#define  I_FB_SURF0     0x200
#define  I_FB_SURF1     0x201
#define  I_FB_SURF2     0x202
#define  I_FB_SURF3     0x203
#define  I_OVL_SURF     0x300

/************************/
/* define for dislgain  */
/************************/

#define  I_GAIN0        0L
#define  I_GAIN1        1L
#define  I_GAIN2        2L
#define  I_GAIN3        3L

/*************************/
/* define for didomgrab  */
/*************************/

#define I_CLDSRC  16
#define I_ASDSRC  32
#define I_BUS_LO  256
#define I_BUS_HI  512
#define I_BUS_0   256
#define I_BUS_1   512
#define I_BUS_2   768
#define I_NOSRC   -1

/***********************/
/* define for dislref  */
/***********************/

#define I_ALLREF  0
#define I_REDREF  64
#define I_GRNREF  128
#define I_BLUREF  192

/***********************/
/* define for pcstdir  */
/***********************/

#define I_NORMAL     1
#define I_REVERSED   2

/***************************/
/* defines for disthorparm */
/***************************/

#define I_NOCHANGE   0xffff
#define I_EN_VCLAMP  1
#define I_DIS_VCLAMP 0


/*****************************/
/* defines for pcscpagoffset */
/*****************************/

#define I_PAG_S1XST 0
#define I_PAG_S1YST 1
#define I_PAG_S2XST 2
#define I_PAG_S2YST 3
#define I_PAG_OXST  4
#define I_PAG_OYST  5
#define I_PAG_DXST  6
#define I_PAG_DYST  7

#define I_PAG_ADD  1
#define I_PAG_SUB  2

/*****************************/
/* defines for pchlprocqueue */
/*****************************/

#define I_HALT_IMMEDIATE         0x00
#define I_STATIC_HALT_INNER_LOOP 0xf0
#define I_STATIC_HALT_OUTER_LOOP 0xf1
					  
/*****************************/
/* defines for pcschalt      */
/*****************************/

#define I_INNER_LOOP 0
#define I_OUTER_LOOP 1

/**************************/
/* defines for fbcpbtodev */
/**************************/

#define I_DIGOUT  0x8007


#endif /* __I_I_HEAD_H__ Keep this as last line of file */
