/*

COPYRIGHT (c) 1989  Matrox Electronic Systems Ltd.
All Rights Reserved

*/
/************************************************************************/
/*                                                                      */
/*                             LLASHEAD.H                               */
/*                                                                      */
/************************************************************************/
/*/
* Name:            llashead.h
*
* synopsis:        This header is needed to use the lowlevel test routines
*                  of the ASD and the CLD.
*                                          
* bugs:
* reviewed:       
* last modified:                  
*M Stedem 89Nov07 Clock source defines has changed
*M Stedem 89Nov25 Clock polarity defines added.
*M Stedem 90Fev07 Monoshot parameter changed to provide independent program-
*M                mation of LFSCAN bit.
*M Stedem 90Fev08 psghsync and psgvsync added in SYNCPOL_BE
*M                Sync. inputted and outputted by both interface is added
*M Stedem 90Mar21 PSG clock polarity defines changed.
*M Stedem 90Mai11 MSHOT() added.
*M Stedem 90Mai16 VSCLMP() added.
*M Stedem 90Jun06 Synchronisation interface defines added.
*M bLem   90Jul04 All definitions for CLD added to this file.
*M                llclhead.h and hlclhead.h now obsoleted.
*M bLem   90Aug22 Define for matrix and range of Bt281 now in i_head.h.
*M                Define for double scan conversion now in i_head.h
*M sDem   90Oct30 Define ADR_ONLY added to separately define the ADR and the 
*M                PSG hvtotal.
*M sDem   90Dec14 Defines added for polarities, adr reset pins, vsync select,
*M                monoshot mode, clock source, user bit state.
*M sDem   91Fev11 Macros for references according to revision.
*/


/*-------------------------------------------------------------------------*/
/* H defines and structure definitions used as parameters to call          */ 
/* low level routines of the file LLASPROG.C and LLCLPROG.C .              */
/*-------------------------------------------------------------------------*/

/*--------------------------------------------------------------------*/
/* IMPORTANT:                                                         */
/* There is no define equals to 0. This value corresponds to NOCHANGE */
/* In all H defines that correspond to the interface (RS422, TTL,     */
/* and ANALOG, The same bits are used:                                */
/*    RS422  bit 0                                                    */
/*    TTL    bit 1                                                    */
/*    ANALOG bit 2                                                    */
/*                                                                    */
/* Some defines are common to ASD and CLD. Refer to each one for more */
/* details.                                                           */
/*--------------------------------------------------------------------*/


#define NOCHANGE              0     /* ASD & CLD */
#define NOT_APPLIED           0     /* ASD & CLD */
#define RESERVED              0     /* ASD & CLD */


/* DEFINES USED FOR LOWLEVEL FUNCTION PARAMETERS */

/* PSG-1024 softinit */

#define HALT_AND_SOFTINIT     2     /* ASD & CLD */
#define RESUME                1     /* ASD & CLD */


/* VDO VRMAS and VREN */

#define VDO_OUTPUT_VRESET     3     /* ASD & CLD */
#define VDO_INPUT_VRESET      2     /* ASD & CLD */
#define VDO_NO_VRESET         1     /* ASD & CLD */


/* BB INTVRST */

#define EXT_VRESET_DISABLE    1     /* ASD & CLD */
#define EXT_VRESET_ENABLE     0     /* ASD & CLD */


/* LOCKING */

#define FAST_LOCK             1     /* ASD & CLD */
#define GENTLE_LOCK           0     /* ASD & CLD */


/* Bus defines */

#define W8BITS                8     /* ASD & CLD */
#define W16BITS               16    /* ASD & CLD */
#define W24BITS               24    /* ASD & CLD */
#define W32BITS               32    /* ASD & CLD */


/* ASD section */

#define ASDSECT               1     /* ASD */
#define PSGSECT               2     /* ASD */
#define BT251SECT             3     /* ASD */


/* CLD section */

#define CLDCNTRLSECT          0x001 /* CLD */
#define PSG1SECT              0x002 /* CLD */
#define PSG2SECT              0x004 /* CLD */
#define BT253SECT             0x008 /* CLD */
#define BT2811SECT            0x010 /* CLD */
#define BT2812SECT            0x020 /* CLD */
#define BT473SECT             0x040 /* CLD */
#define QDACPORTSECT          0x080 /* CLD */
#define QDACDECSECT           0x100 /* CLD */


/* Clock sources */

#define PLLCLK                0x00  /* ASD & CLD */
#define USERCLK               0x01  /* ASD       */
#define EXTCLK                0x02  /* ASD       */
#define EBICLK                0x03  /* ASD & CLD */
#define DEXTCLK               0x04  /* ASD       */
#define USERCLKOUT_EXTCLKIN   0x05  /* ASD       */
#define EBICLKOUT_EXTCLKIN    0x07  /* ASD       */
#define DIRECT_EXTCLKIN       0x05  /* ASD       */

#define DELAY_EXTCLK          0x02
#define DELAY_EXTCLK_NOT      0x0A

#define PLLCLK_TO_OUTCLK                  0x00         /* IMAGE-LC    */
#define USERCLK_TO_OUTCLK                 0x10         /* IMAGE-LC    */
#define DEL_INCLK_TO_OUTCLK(delay)        0x20|(delay) /* IMAGE-LC    */
#define EBICLK_TO_OUTCLK                  0x30         /* IMAGE-LC    */
#define PSGCLKOUT_TO_OUTCLK               0x04         /* IMAGE-LC    */
#define INV_PSGCLKOUT_TO_OUTCLK           0x14         /* IMAGE-LC    */
#define INV_DEL_INCLK_TO_OUTCLK(delay)    0x24|(delay) /* IMAGE-LC    */
#define INCLK_TO_OUTCLK                   0x34         /* IMAGE-LC    */

#define OUTCLK_TO_PSGCLKIN                0x00         /* IMAGE-LC    */
#define USERCLK_TO_PSGCLKIN               0x01         /* IMAGE-LC    */
#define DEL_INCLK_TO_PSGCLKIN(delay)      0x02|(delay) /* IMAGE-LC    */
#define PLLCLK_TO_PSGCLKIN                0x03         /* IMAGE-LC    */
#define INCLK_TO_PSGCLKIN                 0x80         /* IMAGE-LC    */
#define INV_DEL_INCLK_TO_PSGCLKIN(delay)  0x81|(delay) /* IMAGE-LC    */
#define EBICLK_TO_PSGCLKIN                0x83         /* IMAGE-LC    */

#define DL_6ns                0x800 /* IMAGE-LC    */
#define DL_11ns               0x900 /* IMAGE-LC    */
#define DL_16ns               0xA00 /* IMAGE-LC    */
#define DL_21ns               0xB00 /* IMAGE-LC    */
#define DL_26ns               0xC00 /* IMAGE-LC    */
#define DL_31ns               0xD00 /* IMAGE-LC    */
#define DL_36ns               0xE00 /* IMAGE-LC    */
#define DL_41ns               0xF00 /* IMAGE-LC    */

/* Division factor clock (programmed in the PSG-1024) */

#define DIV1                  1     /* ASD & CLD */
#define DIV2                  2     /* ASD & CLD */
#define DIV4                  4     /* ASD & CLD */
#define DIV8                  8     /* ASD & CLD */


/* Interface type (Each source corresponds to a bit) */

#define RS422INT              1     /* ASD */
#define TTLINT                2     /* ASD */
#define ANALOGINT             4     /* ASD */


/* Input clock path (Each source corresponds to a bit) */

#define RS422CLKIN            0x01  /* ASD */
#define TTLCLKIN              0x02  /* ASD */
#define NOCLKIN               0x08  /* ASD */
#define MSYSCLKIN             0x10  /* LC  */
#define INTERNAL_MSYSCLKIN    0x80  /* LC, for test purpose only */

/* Output clock path (Each source corresponds to a bit) */

#define RS422CLKOUT           0x01  /* ASD */
#define TTLCLKOUT             0x02  /* ASD */
#define NOCLKOUT              0x08  /* ASD */


/* Internal PCLK polarity */

#define INCLK_HIGH_EDGE       0     /* ASD & CLD */
#define INCLK_LOW_EDGE        3     /* ASD & CLD */


/* Composite sync. format */

#define BLOCKSYNC             1     /* ASD & CLD */
#define SERRTSYNC             2     /* ASD & CLD */
#define SEREQUSYNC            3     /* ASD & CLD */


/* Data sources (Each source corresponds to a bit) */

#define RS422DT               1     /* ASD       */
#define TTLDT                 2     /* ASD       */
#define ANALOGDT              4     /* ASD & CLD */
#define COUNTERDT             8     /* ASD       */
#define NODT                  16    /* ASD       */
#define TTLOUTDT              32    /* IMAGE-LC  */
#define ANALOGINTTLOUTDT      64    /* IMAGE-LC  */
#define TTLOUTINDT            128   /* IMAGE-LC  */


/* Analog channel for digitization (defines are used in a loop) */

#define CH0DIG                1     /* ASD */
#define CH1DIG                2     /* ASD */
#define CH2DIG                3     /* ASD */
#define CH3DIG                4     /* ASD */


/* Analog channel for digitization */

#define DIGCH0                1     /* CLD */
#define DIGCH1                2     /* CLD */
#define DIGCH2                3     /* CLD */
#define DIGCH3                4     /* CLD */

#define DIGRGB                1     /* CLD */
#define DIGNTSC_PAL           2     /* CLD */
#define DIGYC                 3     /* CLD */
#define DIGSSRGB_0            4     /* CLD */
#define DIGSSRGB_1            5     /* CLD */


/* Monoshot trigger mode */

#define SOFTTRIG         0x0001     /* ASD */
#define HARDTRIG         0x0002     /* ASD */
#define TTLHARDTRIG      0x0002     /* IMAGE-LC */
#define OPTOHARDTRIG     0x0006     /* IMAGE-LC */
#define TIMEBASETRIG     0x0003     /* ASD */
#define SN_ON_LOW_STATE  0x0000     /* ASD */
#define SN_ON_HIGH_STATE 0x0100     /* ASD */
#define SN_ON_LOW_EDGE   0x0200     /* ASD */
#define SN_ON_HIGH_EDGE  0x0300     /* ASD */

#define TRIGGER_OFF           1     /* CLD */
#define TRIGGER_ON            2     /* CLD */


/* Monoshot information */

#define NO_MONOSHOT           0     /* ASD & CLD */
#define NO_MONOSHOT_NIL       4     /* ASD & CLD */
#define LINE_SCAN             5     /* ASD & CLD */
#define FRAME_SCAN            7     /* ASD & CLD */
#define NO_MONOSHOT_MASTER    4     /* ASD & CLD */

#define ADR_VTOTAL_ON         0x10
#define DOUBLE_VS_ON          0x20

#define INTL_FD_SCAN          1     /* ASD & CLD */
#define INTL_FRAME_SCAN       2     /* ASD & CLD */


/* Raster type (Each source corresponds to a bit) */

#define INTRLC                1     /* ASD & CLD */
#define NONINTRLC             2     /* ASD & CLD */


/* Synchronisation interface (Each source corresponds to a bit) */

#define RS422SYINT            0x0001   /* ASD       */
#define TTLSYINT              0x0002   /* ASD       */
#define ANALOGSYINT           0x0004   /* ASD & CLD */
#define BBSYINT               0x0008   /* ASD       */
#define TTLINRSOUTSYINT       0x0010   /* ASD       */
#define RSINTTLOUTSYINT       0x0020   /* ASD       */
#define ANAINTTLOUTSYINT      0x0040   /* ASD       */
#define ANAINRSOUTSYINT       0x0080   /* ASD       */
#define ANAINTTLINSYINT       0x0100   /* LC        */
#define ANAINRSINSYINT        0x0200   /* LC        */


/* Direction of interface */

#define INT_IN                1     /* ASD */
#define INT_OUT               2     /* ASD */
#define INT_IN_OUT            3     /* ASD */


/* TTL/RS422 sync. type. (5 and 6 come from 1 to 4 of Analog sync channel) */

#define CSYNC                 5     /* ASD */
#define HVSYNC                6     /* ASD */


/* Analog sync channel (defines are used in a loop) */

#define CH0SYNC               1     /* ASD */
#define CH1SYNC               2     /* ASD */
#define CH2SYNC               3     /* ASD */
#define CH3SYNC               4     /* ASD */


/* Synchronisation interface */

#define SYNCCH0               1     /* CLD */   /* These sync sources forces */
#define SYNCCH1               2     /* CLD */   /* to grab on the same       */
#define SYNCCH2               3     /* CLD */   /* channel                   */
#define SYNCCH3               4     /* CLD */

#define SYNCCH3DIRECT         5     /* CLD */
#define SYNCYC                6     /* CLD */

#define SYNCVIDEOIN           7     /* CLD */   /* Don't affect channel */
                                                /* previously selected  */


/* Bit fields used to program sync polarity */

typedef union
   {
   unsigned char sh;
   struct
      {
      unsigned hsinpol     : 1;
      unsigned vsinpol     : 1;
      unsigned csinpol     : 1;
      unsigned hsoutpol    : 1;
      unsigned vsoutpol    : 1;
      unsigned csoutpol    : 1;
      unsigned psghrespol  : 1; 
      unsigned psgvrespol  : 1;
      unsigned psghspol    : 1;
      unsigned psgvspol    : 1;
      unsigned reserved    : 6;
      } be;
   } SYNCPOL_BE;
   
typedef union 
   { 
   unsigned short sh; 
   struct 
      {
      unsigned hsinpol     : 1;
      unsigned vsinpol     : 1;
      unsigned csinpol     : 1;
      unsigned hsoutpol    : 1;
      unsigned vsoutpol    : 1;
      unsigned csoutpol    : 1;
      unsigned psghrespol  : 1;
      unsigned psgvrespol  : 1;
      unsigned psghspol    : 1;
      unsigned psgvspol    : 1;
      unsigned reserved    : 6;
      } be;
   } CLD_SYNCPOL_BE;


/* Define for polarity bit */

#define HSP_H                 0x001 /* ASD & CLD */
#define VSP_H                 0x002 /* ASD & CLD */
#define CSP_H                 0x004 /* ASD & CLD */
#define CBP_H                 0x008 /* ASD & CLD */
#define BSP_H                 0x010 /* ASD & CLD */
#define CLP_H                 0x020 /* ASD & CLD */
#define CKIP_H                0x040 /* ASD & CLD */
#define CKOP_H                0x080 /* ASD & CLD */
#define HRP_H                 0x100 /* ASD & CLD */
#define VRP_H                 0x200 /* ASD & CLD */


/* Sync. polarity (bit encoded), ASD & CLD */ 

#define HISYPOL               CKOP_H+CLP_H+BSP_H+CBP_H+CSP_H+VSP_H+HSP_H
#define HISYPOL_CLD           CKOP_H+      BSP_H+CBP_H+CSP_H+VSP_H+HSP_H
#define LOSYPOL               CKOP_H

#define IN_HSYNC_LO           0     /* ASD       */
#define IN_HSYNC_HI           1     /* ASD       */
#define IN_VSYNC_LO           0     /* ASD       */
#define IN_VSYNC_HI           2     /* ASD       */
#define IN_CSYNC_LO           0     /* ASD       */
#define IN_CSYNC_HI           4     /* ASD       */
#define OUT_HSYNC_LO          0     /* ASD       */
#define OUT_HSYNC_HI          8     /* ASD       */
#define OUT_HSYNC_LO          0     /* ASD       */
#define OUT_VSYNC_HI       0x10     /* ASD       */
#define OUT_VSYNC_LO          0     /* ASD       */
#define OUT_CSYNC_HI       0x20     /* ASD       */
#define IN_HRES_LO            0     /* ASD       */
#define IN_HRES_HI         0x40     /* ASD       */
#define IN_VRES_LO            0     /* ASD       */
#define IN_VRES_HI         0x80     /* ASD       */
#define OUT_PSGHSYNC_LO       0     /* ASD       */
#define OUT_PSGHSYNC_HI   0x100     /* ASD       */
#define OUT_PSGVSYNC_LO       0     /* ASD       */
#define OUT_PSGVSYNC_HI   0x200     /* ASD       */


/* PSG-1024 horizontal reset input */

#define ENHRES                1     /* ASD & CLD */
#define DISHRES               2     /* ASD & CLD */
#define ENPCHSYNC2            4     /* ASD & LC  */
#define DISPCHSYNC2           8     /* ASD & LC  */


/* PSG-1024 internal synchronisation mode */

#define PSGINTSYNC            1     /* ASD & CLD */
#define PSGEXTSYNC            2     /* ASD & CLD */


/* PSG-1024 softinit */

#define HALT_AND_SOFTINIT     2     /* ASD & CLD */
#define RESUME                1     /* ASD & CLD */


/* Gain control */

#define GN_3_15               0     /* ASD */
#define GN_2_10               1     /* ASD */
#define GN_1_40               2     /* ASD */
#define GN_0_93               3     /* ASD */

#define GAIN_0_8              1     /* CLD */
#define GAIN_1_0              2     /* CLD */
#define GAIN_1_2              3     /* CLD */


/* Mask setting */

#define MSK8BITS              0xf   /* ASD */
#define MSK9BITS              0xe   /* ASD */
#define MSK10BITS             0xc   /* ASD */
#define MSK11BITS             0x8   /* ASD */
#define MSK12BITS             0x0   /* ASD */


/* General defines */

#define DUMMY                 0L    /* ASD & CLD */
#define INTERLACED	         1     /* ASD */
#define PROGRESSIVE	         0     /* ASD */


/* Start field defines */

/* The 4 next defines are obsolete. They all program the grab like ODDFIELD.
   This enables the compatibility between old logical cameras and new 
   shells. sDem 91/03/19, changed after shell version 2.10
*/

#define STARTNEXTFD	         0     /* ASD */
#define STARTEVENFD	         1     /* ASD */
#define STARTODDFD	         3     /* ASD */
#define EVERYFD		         4     /* ASD */

/* New start field defines */

#define ODDFIELD              0x7   
#define EVENFIELD             0x5
#define NEXTFIELD             0x4

/* Macro used to specify that vtotal is used in monoshot mode */

#define MSHOT(vtotal)         (((vtotal)+2)|0x8000)   /* ASD */


/* Macro used to enable clamping pulses during the vsync interval */

#define VSCLMP(hsclmp)        ((hsclmp)|0x8000)       /* ASD */


/* Define used to force independant h or vtotal */

#define ADR_ONLY              0x4000


/* Section of CLD definition */

#define DECODERSECT           1     /* CLD */
#define ENCODERSECT           2     /* CLD */


/* Source of HSYNC for PLL */

#define VHREFEXTSYNC          1     /* CLD */
#define VHREFINTSYNCBB        2     /* CLD */
#define VHREFINTSYNCDIGIT     3     /* CLD */


/* Index for Bt253 reference register */

#define SETRBLK               1     /* CLD */
#define SETRWHT               2     /* CLD */
#define SETGBLK               3     /* CLD */
#define SETGWHT               4     /* CLD */
#define SETBBLK               5     /* CLD */
#define SETBWHT               6     /* CLD */


/* Define for board type */

#define NTSC_BOARD            0     /* CLD */
#define PAL_BOARD             1     /* CLD */


/* Define for the notch filter in PAL */

#define VRST_EVEN_FLD         0     /* CLD */
#define VRST_NEXT_FLD         1     /* CLD */

/* WARNING: OBSOLETE defines keep it for compatibility with */
/* old logical camera                                       */
/* Define for the notch filter in PAL                       */

#define EN_CHROMA_NOTCH       0     /* CLD */
#define DI_CHROMA_NOTCH       1     /* CLD */


/* Defines for VBSEL - video bus select */

#define ENC_R_VSIN            0     /* CLD */
#define ENC_G_VSIN            0     /* CLD */
#define ENC_B_VSIN            0     /* CLD */
#define ENC_OVL_VSIN          0     /* CLD */
#define ENC_R_VSRC            0x01  /* CLD */
#define ENC_G_VSRC            0x02  /* CLD */
#define ENC_B_VSRC            0x04  /* CLD */
#define ENC_OVL_VSRC          0x08  /* CLD */


/* Defines for VBEN - video bus enable */

#define EN_R_VSIN             0     /* CLD */
#define EN_G_VSIN             0     /* CLD */
#define EN_B_VSIN             0     /* CLD */
#define EN_R_VSRC             0     /* CLD */
#define EN_G_VSRC             0     /* CLD */
#define EN_B_VSRC             0     /* CLD */

#define DI_R_VSIN             0x01  /* CLD */
#define DI_G_VSIN             0x02  /* CLD */
#define DI_B_VSIN             0x04  /* CLD */
#define DI_R_VSRC             0x08  /* CLD */
#define DI_G_VSRC             0x10  /* CLD */
#define DI_B_VSRC             0x20  /* CLD */


/* Defines for test mode */

#define NORMAL_PLLCLK         0     /* CLD */
#define NORMAL_EBICLK         1     /* CLD */
#define PRESET_ALU            3     /* CLD */
#define CLEAR_ALU             4     /* CLD */
#define NOT_A_PLUS_B_ALU      5     /* CLD */
#define NOT_B_PLUS_A_ALU      6     /* CLD */
#define GREYSCALE_ALU         7     /* CLD */


/* Defines for Bt-253 color output select */

#define TRUE_COLOR_24_BIT     1     /* CLD */
#define TRUE_COLOR_15_BIT     2     /* CLD */
#define TRUE_COLOR_8_BIT      3     /* CLD */
#define PSEUDO_COLOR_8_BIT    4     /* CLD */


/* Define for direction of transfert between EEPROM and software copy */

#define READ_FROM_EEPROM      1     /* CLD */
#define WRITE_TO_EEPROM       2     /* CLD */


/* Define to set the mode of the CLD board */

#define RGB_MODE              1     /* CLD */
#define NTSC_MODE             2     /* CLD */
#define YC_NTSC_MODE          3     /* CLD */
#define PAL_MODE              4     /* CLD */
#define YC_PAL_MODE           5     /* CLD */
#define SSRGB0_MODE           6     /* CLD */
#define SSRGB1_MODE           7     /* CLD */


/* Define to access table of matrix conversion */
/* for the COLOR SPACE CONVERTER               */

#define OUT_ON_LOW_BYTE       32    /* CLD */
#define OUT_ON_MED_BYTE       33    /* CLD */
#define OUT_ON_HIGH_BYTE      34    /* CLD */


/* Defines for adr reset bits */

#define ADR_HRES_ON           1     /* ASD & CLD */
#define ADR_HRES_OFF          0     /* ASD & CLD */
#define ADR_VRES_ON           1     /* ASD & CLD */
#define ADR_VRES_OFF          0     /* ASD & CLD */

#define ADR_NORM_RES          0x11  /* IMAGE-LC */
#define ADR_VERT_RES          0x10  /* IMAGE-LC */
#define ADR_HORI_RES          0x01  /* IMAGE-LC */

/* Defines for USER bits on the ASD and the IMAGE-LC */

#define USER1_LO              0     /* ASD */
#define USER1_HI              1     /* ASD */

#define USER2_LO              0     /* IMAGE-LC */
#define USER2_HI              1     /* IMAGE-LC */

#define USERBITON             0     /* IMAGE-LC */
#define USERBITOFF            1     /* IMAGE-LC */

/* Defines for vsync select on the ASD */

#define CAM_VSYNC             0     /* ASD */
#define PSG_VSYNC             1     /* ASD */


/* Macro and define to program the correct blanking on the CLD        */
/* The CLD had a pipe of 12 pixels for Bt281 and 1 pixel for Bt253(4) */
/* 0x8000 is added to duration of blanking to identify a logical      */
/* camera from shell 2.10 and later shell. it keep compatibility      */
/* between logcam and shell.                                          */

#define PIPE_CLD              12+1                          /* CLD */
#define CLDBLNK(blnk)         ((blnk + PIPE_CLD) + 0x8000)  /* CLD */

/* Macro for ASD references */

#define CCIRREFP_R(v)   ( (v) ? ( (v-1) ? 50 : 50 ) : 45 )
#define CCIRREFM_R(v)   ( (v) ? ( (v-1) ? 11 : 12 ) : 31 )

#define RS170REFP_R(v)  ( (v) ? ( (v-1) ? 41 : 42 ) : 39 )
#define RS170REFM_R(v)  ( (v) ? ( (v-1) ? 11 : 12 ) : 31 )

/* Defines used for the capture mode select for the IMAGE-LC */

#define CAPTMODEOFF     0x1   /* capture mode disabled   */
#define CAPTMODELOW     0x2   /* capture mode enabled, 
                                 capture signal polarity low */
#define CAPTMODEHIGH    0x0   /* capture mode enabled,
                                 capture signal polarity high */

/* Defines for the BT251 sync select (IMAGE-LC) */

#define SL_50mV         0x0
#define SL_75mV         0x1
#define SL_100mV        0x2
#define SL_125mV        0x3

/* Defines for the field reset mode (IMAGE-LC) */

#define RES_ON_FRAME    0
#define RES_ON_FIELD    1

/* Defines for PSG-1024 hreset select (IMAGE-LC) */

#define NORM_HRES       0
#define DELAYED_HRES    1

/* Defines for BT261 programming (IMAGE-LC) */

#define BT261_CR0_PCLK        0x78
#define BT261_CR0_15MHZ       0x79

#define BT261_CR1_INTRL       0xC9
#define BT261_CR1_PROG        0x49

#define BT261_CR2_NORM        0xAE

#define BT261_CR3_NORM        0x0A

#define BT261_VS_NORM         10.0  /* Value in uSec */

#define BT261_OSC_CNT_NORM    0x0202

#define BT261_HS_START_NORM   0.0   /* Values in uSec */
#define BT261_HS_STOP_NORM    0.0

#define BT261_ZERO_START_NORM 4.7   /* Start and stop are permutted to have  */
#define BT261_ZERO_STOP_NORM  0.0   /* the proper polarity on ZERO (BTHSYNC) */
                                    /* Values in uSec */

#define BT261_FLD_START_NORM  48.0  /* Start and stop are permutted to have */
#define BT261_FLD_STOP_NORM   16.0  /* a field polarity similar to PSG      */
                                    /* Values in uSec */

#define BT261_NG_START_NORM   20.0  /* Values in uSec */
#define BT261_NG_STOP_NORM    40.0

#define BT261_HCOUNT_NORM     0xffff

#define LINEGRAB              0x2

/* Define for reading value from EEPROM */

#define DEFAULT_VALUE         0xffff

/* Define for burst programming with the CLD */

#define DEFAULT_BURST         0

/* Internal defines */

#define HORIZ                 0
#define VERT                  1
