/**************************************************************************
 *
 *  THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
 *  KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR
 *  PURPOSE.
 *
 *  Copyright (c) 1994  Microsoft Corporation.  All Rights Reserved.
 *
 *  FILE:   MCIMPEG.H
 *      
 *  DESCRIPTION:
 *      Include file extension for the MCI-MPEG Command Set, depends
 *	on digitalv.h
 *	
 *  HISTORY:
 *      September 10, 1994     -Version 1.0 Beta Release
 *	November 3, 1994 -      Version 1.0a Beta
 *
 **************************************************************************/

#ifndef _INC_MCIMPEG
#define _INC_MCIMPEG  100

#ifndef NOMCIMPEG

#ifdef __cplusplus
extern "C" {            /* Assume C declarations for C++ */
#endif	/* __cplusplus */


/* New Commands */

#define MCI_CREATEDC                        0x0890
#define MCI_UPDATEDC                        0x0891
#define MCI_RELEASEDC                       0x0892

/* flags for dwFlags parameter of MCI_RELEASEDC command message  */
#define MCI_MPEG_RELEASEDC_HDC              0x00010000L

/* parameter block for MCI_RELEASEDC */
typedef struct {
    DWORD   dwCallback;
    HDC     hDC;
#ifndef WIN32
    WORD    wReserved0;
#endif
} MCI_MPEG_RELEASEDC_PARMS;
typedef MCI_MPEG_RELEASEDC_PARMS FAR * LPMCI_MPEG_RELEASEDC_PARMS;

/* flags for the dwFlags parameter of MCI_SEEK  */
#define MCI_MPEG_SEEK_OFFSET                0x00010000L
#define MCI_MPEG_SEEK_FRAMEREF              0x00020000L

/* parameter block for extended MCI_SEEK command */
typedef struct MCI_MPEG_SEEK_PARMS {
	DWORD	dwCallback;
	DWORD	dwTo;
	DWORD	dwOffset;
	DWORD	dwFrameRef;
} MCI_MPEG_SEEK_PARMS;
typedef MCI_MPEG_SEEK_PARMS FAR * LPMCI_MPEG_SEEK_PARMS;
    
/* MCI_STATUS - new status items */
#define MCI_MPEG_STATUS_VIDEO_STREAMS       0x00004100L
#define MCI_MPEG_STATUS_VIDEO_BITRATE       0x00004101L
#define MCI_MPEG_STATUS_VIDEO_MAXBITRATE    0x00004102L
#define MCI_MPEG_STATUS_AUDIO_STREAMS       0x00004103L
#define MCI_MPEG_STATUS_AUDIO_BITRATE       0x00004104L
#define MCI_MPEG_STATUS_VIDEO_BRUSH         0x00004105L

/* flags for the dwFlags parameter of MCI_STEP  */
#define MCI_MPEG_STEP_KEY                   0x00040000L 

/* flags for dwFlags parameter of MCI_WHERE command message  */
#define MCI_MPEG_WHERE_MIN                  0x00800000L

/* parameter block and flags for MCI_UPDATEDC, see MCI_DGV_UPDATE_PARMS */
/* parameter block for MCI_CREATEDC, use DGV_RECT flags */

typedef struct {
    DWORD   dwCallback;
    DWORD   dwReturn;
#ifdef MCI_USE_OFFEXT
    POINT   ptOffset;
    POINT   ptExtent;
#else	
    RECT    rc;
#endif  
} MCI_MPEG_CREATEDC_PARMS;
typedef MCI_MPEG_CREATEDC_PARMS FAR * LPMCI_MPEG_CREATEDC_PARMS;



#ifdef __cplusplus
}                       /* End of extern "C" { */
#endif	/* __cplusplus */

#endif  /* !NOMCIMPEG */

#endif  /* !_INC_MCIMPEG */
