/*$Author:   DCODY  $*/
/*$Date:   24 Sep 1992 08:58:52  $*/
/*$Header:   X:/sccs/pcmapps/blockout.c_v   1.4   24 Sep 1992 08:58:52   DCODY  $*/
/*$Log:   X:/sccs/pcmapps/blockout.c_v  $
 * 
 *    Rev 1.4   24 Sep 1992 08:58:52   DCODY
 * changed MVGetHardware to mvGetHardware
 * 
 *    Rev 1.3   20 Jul 1992 11:38:34   DCODY
 * call to mvGetHWVersion now uses active I/O address detection.
 * 
 *    Rev 1.2   13 Jul 1992 19:05:28   DCODY
 * removed initmvsound call. changed pcmstate to add 8 bit pcm parm.
 * 
 *    Rev 1.1   23 Jun 1992 16:09:34   DCODY
 * pas2 update...
 * 
 *    Rev 1.0   15 Jun 1992 09:26:26   BCRANE
 * Initial revision.
*/
/*$Logfile:   X:/sccs/pcmapps/blockout.c_v  $*/
/*$Modtimes$*/
/*$Revision:   1.4  $*/
/*$Workfile:   blockout.c  $*/


/* simple PCM play program - reads the disk & sends the data to the DMA */

#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <signal.h>
#include "pcmio.h"
#include "common.h"

char OurData[4096];
extern int DMARunning;

main(argc,argv)
	int argc;
	char *argv[];
{
FILE *f;
int n;

	/* abort if the hardware is not found								*/

		if (mvGetHWVersion(USE_ACTIVE_ADDR) == -1) {
			printf ("\aThe Pro AudioSpectrum hardware is not installed!\n");
			exit(1);
        }

	/* if not enough parameters, bomb out...							*/

        if (argc < 2) {
			printf ("to use: >BLOCKOUT [FILE.EXT]\n");
			exit(0);
		}

	/* open the input file												*/

		if ((f = fopen(argv[1],"rb")) == 0) {
			printf ("to use: >BLOCKOUT [FILE.EXT]\n");
            exit(0);
		}

	/* open the PCM code												*/

		if (OpenPCMBuffering(-1,-1,16,4)) {
            printf ("\aCannot setup the PCM software!\n");
			exit(1);
        }

	/* setup the sample rate & stereo flag								*/

		PCMState (22050L, 0, 0, 8); 	/* 22050 khz, mono, 8 bit pcm	*/

	/* if the DMA engine starts, keep the data moving from the disk!	*/

		n = fread (OurData, 1, 4096, f);
		while (n < 4096)
			OurData[n++] = 0x80;

		if (StartBlockOutput(OurData)) {

			n = fread (OurData, 1, 4096, f);
			while (n < 4096)
				OurData[n++] = 0x80;

			while (!feof(f)) {

				/* if the new block is passed in, load more...			*/

					if (ContinueBlockOutput(OurData)) {

						/* read the next block of data					*/

							n = fread (OurData, 1, 4096, f);
							while (n < 4096)
								OurData[n++] = 0x80;
					}
			}

			/* EOF now, wait for the DMA to quit... 					*/

			while (DMARunning) ;

        }

	/* exit to DOS														*/

		ClosePCMBuffering();
		close (f);
		exit(0);
}


