;
;   /*\
;---|*|----====< Stereo2OP >====----
;---|*|
;---|*| This program demonstrates how to perform 11 voice stereo with
;---|*| panning on the OPL3. This uses MELODIC mode makes the voice pan
;---|*| from left to right.
;---|*|
;   \*/


#include <stdio.h>



;   /*\
;---|*|----====< main >====----
;   \*/

main()
{

    // initialize the FM interface

		mvFMInitMode(1);				// 1 = split mode

    // Load the FM patch

        outdual3812 (0x20, 0x01, 0x01);     // multiple = 1

        outdual3812 (0x40, 0x1F, 0x00);     // left volume is off

        outdual3812 (0x60, 0xF0, 0xF0);     // Attack  = F, Decay = 0

        outdual3812 (0x80, 0xF1, 0xF1);     // Sustain = F, Release = 1

        outdual3812 (0xA0, 0x6B, 0x6B);     // frequency = 16Bh

        outdual3812 (0xC0, 0x11, 0x21);     // Left connect = 11h, right = 21h

        outdual3812 (0xB0, 0x35, 0x35);     // KEY-ON=1, block=5, f(9,10)=01

        outdual3812 (0xB0, 0x15, 0x15);     // KEY-ON=0, block=5, f(9,10)=01

    // rotate the sound

        pancircle();
        pancircle();
        pancircle();
        pancircle();

}


;   /*\
;---|*|----====< pancircle >====----
;---|*|
;---|*| This routine moves the volumes up and down
;---|*|
;   \*/

pancircle()
{

    // switch to the left side

        delay();
        outdual3812 (0x40, 0x0F, 0x01);     // leftvol = 0x0F, right = 0x01
        delay();
        outdual3812 (0x40, 0x07, 0x03);     // leftvol = 0x0F, right = 0x01
        delay();
        outdual3812 (0x40, 0x03, 0x07);     // leftvol = 0x0F, right = 0x01
        delay();
        outdual3812 (0x40, 0x01, 0x0F);     // leftvol = 0x0F, right = 0x01
        delay();
        outdual3812 (0x40, 0x00, 0x1F);     // leftvol = 0x0F, right = 0x01

    // switch to the right side

        delay();
        outdual3812 (0x40, 0x01, 0x0F);     // leftvol = 0x0F, right = 0x01
        delay();
        outdual3812 (0x40, 0x03, 0x07);     // leftvol = 0x0F, right = 0x01
        delay();
        outdual3812 (0x40, 0x07, 0x03);     // leftvol = 0x0F, right = 0x01
        delay();
        outdual3812 (0x40, 0x0F, 0x01);     // leftvol = 0x0F, right = 0x01
        delay();
        outdual3812 (0x40, 0x1F, 0x00);     // leftvol = 0x0F, right = 0x01
}

;   /*\
;---|*|----====< delay >====----
;---|*|
;---|*| This routine delays for up to three clock tics. Each clock tic
;---|*| occurs at a rate of 18.2 times per second.
;---|*|
;   \*/

delay()
{

        _asm {
            push    si
            mov     si,3        ; wait up to 3 tics in time

            mov     ah,0        ; get the current clock tic
            int     1ah
            mov     bx,dx       ; bx holds the original time
        ;
        delay05:
            mov     ah,0
            int     1ah
            cmp     bx,dx       ; wait while two tics are equal
            jz      delay05

            mov     bx,dx       ; update the original time
            dec     si          ; loop until our tic count expires

            jnz     delay05
        }
}


