
         page    84,132
        title   'EMM driver VLSI Technology, Inc.  '
	subttl  'Device Driver section'

; Ŀ
;  Release History                                               
; ͵
;  version        date                   comments                
; 
;   B.01       February 7 1989      passes EMSTEST upto function 16 01
;   B.02       February 9 1989	    Passes EMSTEST upto function 21 00 (2108)
;   B.03       February 21 1989     Passes EMSTEST With Two Errors
;   B.04       MARCH 30 1989        PASSES EMMTEST - HANGS MEMTEST
;				    Fixed Reading of the Command line from the
;				    Config.Sys File
;   1.00       MAY 11 1989          RUNS ALL
;   1.01       SEPT 5 1989          FIXED BUG WITH WINDOWS - REALLOC. FUNC.
;   1.02       SEPT 26 1989	    FIXED DESQVIEW - REPLACED INT 15h CALLS
; The actual driver subroutines are stubs only and have
; no effect but to return a non-error "Done" status.
;
; Copyright 1989 VLSI TECHNOLOGY, INC.
; Written by Randy Stultz  Moonlighting Software
;
; 
; To assemble, link, and convert this program into
; a BIN file, follow these steps:
;
;       C>MASM VEMM;		Version 5    
;       C>LINK VEMM;
;       C>EXE2BIN VEMM.EXE VEMM.SYS
;       C>DEL VEMM.EXE
;
; Ignore the message "Warning: no stack segment" from the Linker.
;
;
.286                                            
;.xlist

PAGE
;            EXTERNAL EQUATE FILE

LIM_VER		EQU	40H		  ; 4.0
prog_ver	equ	'1.02'
; program_date must	'--use this sp--'
program_date	equ	'  09/26/1989   '; release date.
num_phy_pages	equ	4;		four pages.
emmhi_byte	equ	10h;			EMM base page  address
emmLo_word	equ	0000h;			add 16384 to low word for each page
		;				max address = 440000 hex for total
		;				of 4 meg (1 meg base, 3 meg extened)
maxhandles	EQU	127;			Software max requirments is 254 pages
max_pages	EQU	254;			64 pages per 1 meg , max 3 meg
		;				Software max requirments is 254 = 3.98 meg
page_size	EQU	16384;			16K standard size
lf		equ	0ah
cr		equ	0dh
eom		equ	'$'
beep		equ	7
off_set		equ	0
stk_seg		equ	2
stk_flag	equ	4
HANDL_0_PGS	EQU	0		;INIT. PAGES ASSIGNED TO OS


PAGE
;--------------------------------------------------------------------------
;       structure definitions
;
RHC	STRUC
		DB	?
		DB	?
	RHC_CMD DB	?
	RHC_STA DW	?
		DQ	?
RHC	ENDS
RH0	STRUC
		DB	(TYPE RHC) DUP(?)
	RH0_NUM DB	?
	RH0_ENDO DW	?
	RH0_ENDS DW	?
	RH0_BPBO DW	?
	RH0_BPBS DW	?
	RH0_DRIV DB	?
RH0	ENDS
	RH0_BPBA	EQU	DWORD PTR RH0_BPBO;	AT INIT POINTS TO 
			;				DEVICE= ON CONFIG.SYS STAT
;
; MS-DOS Request Header structure definition
;
; The first 13 bytes of all Request Headers are the same
; and are referred to as the "Static" part of the Header.
; The number and meaning of the following bytes varies.
; In this "Struc" definition we show the Request Header
; contents for Read and Write calls.
;

Request struc                   ; request header template structure
                                ; beginning of "Static" portion
Rlength db      ?               ; length of request header
Unit    db      ?               ; unit number for this request
Command db      ?               ; request header's command code
dStatus  dw      ?               ; driver's return status word
                                ; bit  15    = Error
                               ; bits 10-14 = Reved
                                ; bit  9     = Busy
                                ; bit  8     = Done
                                ; bits 0-7   = Error code if bit 15=1
Reserve db      8 dup (?)       ; reserved area
                                ; end of "Static" portion, the remainder in
                                ; this example is for Read and Write functions
Media   db      ?               ; Media Descriptor byte
Address dd      ?               ; memory address for transfer
Count   dw      ?               ; byte/sector count value
Sector  dw      ?               ; starting sector value
        db      ?               ;
Request ends                    ; end of request header template




NUM_PHY_PAGES	EQU	4			;4 PAGES
phy_page_dir    struc
                ;
        page_handle     DW     -1;              -1 = free, otherwise = owning handle.
        logical_page    db      0;              logical page 
                ;
phy_page_dir    ends

PHY_MAP_LEN	EQU	NUM_PHY_PAGES*TYPE phy_page_dir

handle_dir     struc
                ;
        status  DB      0;              handle status, 0 = free, 0FFh = inuse
    num_pages   DB      0;              size in pages that are allocated to the handle (197 max)
        first   DB      0;              First Logical page
  handle_name   DB      8 DUP(0);       handle name
        SAVED   DB      0;              0=NOTHING IN SAVE AREA, <>0 MAP SAVED 
       MAPSAV   DB      PHY_MAP_LEN dup(0) ;Used in func. 8 & 9 
                ;                    
handle_dir      ends

open_handle     struc
        handle  dw      -1;		-1 = free else handle value
        pages   dw      0;              max of 197 pages
open_handle     ends


gdt_def         struc;
                ;
                DQ      ?;              reserved must be 0
     CGDT_LOC   DQ      ?;              will point to it self must be 0
     SOURCE     DQ      ?;              source_struct is placed at this address
     TARGET     DQ      ?;              target_struct is placed at this address
     BIOS_CS    DQ      ?;		must be 0
     TEMP_SS    DQ      ?;		must be 0
gdt_def         ends
;
source_target    struc
   seg_limit    dw      0;    move one page at a time max
   lo_word      dw      0;      24 bit segment physical address
   hi_byte      db      0;      address  (0 to (16m-1))
data_acc_rights db      0;    access rights byte  (cplo - r/w)
   reserved     dw      0;      reserved must be zero
source_target    ends
;
add_s_t		 struc
   lw		dw	0;
   hb		db	0;	
add_s_t          ends
;
move_xchg       struc
  region_length                 dd      ?
  source_memory_type            db      ?
  source_handle                 dw      ?
  source_initial_offset         dw      ?
  source_initial_seg_page       dw      ?
  dest_memory_type              db      ?
  dest_handle                   dw      ?
  dest_initial_offset           dw      ?
  dest_initial_seg_page         dw      ?
move_xchg       ends 
;***************************************************************************
	log_to_phys_map_struc	struc
		log_page_number		dw	?
		phys_page_number	dw      ? ; this structure would repeat
	log_to_phys_map_struc	ends;		    for each count of CX
	  hand_dir_struct STRUC
		hand_value	dw ?
		hand_name	db 8 Dup(?)
	  hand_dir_struct ENDS
	map_and_jump	struc
		target_add		dd	?
		log_phys_map_len	db	?
		log_phys_map_ptr	dd	?
	map_and_jump	ends
	map_and_call_struct	struc
		target_address		dd	?
		new_page_map_len	db	?
		new_page_map_ptr	dd	?
		old_page_map_len	db	?
		old_page_map_ptr	dd	?
	map_and_call_struct		ends
	requested_partial_page_map	struc
		mappable_segment_count	dw	?
		mappable_segment	dw  4  DUP(?);	   Up to 4 pages
	requested_partial_page_map	ends

	partial	struc
		owning_handle	db	?
		logical_pg	dw	?;
		physical_pg	db	?;	0 - 3
	partial	ends
	saved_partial_page_map 		struc
		num_page_mapped		DB	?
		page0			DB	4 dup(?) ; Partial structure
		page1			DB	4 DUP(?) ; 	Logical_page      word
		page2			DB	4 DUP(?) ; 	phys_page     	  word
		page3			DB	4 DUP(?) ;                            
	saved_partial_page_map		ends
;

PAGE
.LIST

code    segment public 'CODE'
driver  proc    far
assume  cs:code,ds:code,es:code
Max_Cmd equ     16              ; MS-DOS command code maximum
                                ; this is 16 for MS-DOS 3.x
                                ; and 12 for MS-DOS 2.x
RH	EQU	ES:[BX]
;
; Device Driver Header
;
HEADER	DD	-1		; LINK TO NEXT DEVICE, INIT'D=-1
        dw      8000h           ; Device Attribute word
                                ; bit 15 =1 for character devices
                                ; bit 14 =1 if driver can handle IOCTL
                                ; bit 13 =1 if block device & non-IBM format
                                ; bit 12 =0
                                ; bit 11 =1 if OPEN/CLOSE/RM supported (DOS 3.x)
                                ; bit 10 =0           
                                ; bit 9  =0
                                ; bit 8  =0
                                ; bit 7  =0
                                ; bit 6  =0
                                ; bit 5  =0
                                ; bit 4  =0
                                ; bit 3  =1 if CLOCK device
                                ; bit 2  =1 if NUL device
                                ; bit 1  =1 if Standard Output
	                        ; bit 0  =1 if Standard Input
.list
        dw      Strat           ; device "Strategy" entry point
        dw      Intr            ; device "Interrupt" entry point
        db      'EMMXXXX0'      ; character device name, 8 char, or if block
                                ; device, no. of units in first byte followed
                                ; by 7 don't care bytes.
        db      'COPYRIGHT (C) 1989'
        db      'VLSI TECHNOLOGY, INC.'
	db	'EMM driver ver LIM 4.0 '
        db      'Programmer: Randy Stultz'
;.xlist;
; Double-word pointer to Request Header
; Passed to Strategy Routine by MS-DOS
;
RH_Ptr  label dword
RH_PTRO	DW      ?;		OFFSET
RH_PTRS	DW	?;		SEGMENT
        page

;***************************************************************************
; Device Driver "Strategy Routine"
; Each time a request is made for this device, MS-DOS
; first calls the "Strategy routine",  then immediately
; calls the "Interrupt routine".
; The Strategy routine is passed the address of the
; Request Header in ES:BX, which it saves in a local
; variable and then returns to MS-DOS.

        Strat   proc    far  
                                                ; save address of Request Header
                mov     cs:[RH_PTRO],bx
                mov     cs:[RH_PTRS],es
                ret                     ; back to MS-DOS

        Strat   endp

        page


; Device Driver "Interrupt Routine"

; This entry point is called by MS-DOS immediately after
; the call to the "Strategy Routine", which saved the long
; address of the Request Header in the local variable "RH_Ptr".

; The "Interrupt Routine" uses the Command Code passed in
; the Request Header to transfer to the appropriate device
; handling routine.  Each command code routine is responsible
; for putting any necessary information into the Request
; Header, then performs a Near Return with AX = Status.

        Intr    proc  far

                pusha                   ; save general registers
                push    ds
                push    es
                push    cs              ; make local data addressable
                pop     ds
		CLD
                les     di,RH_PTR 	; let ES:DI = Request Header
                                        ; get BX = Command Code
                mov     bl,es:[di.Command]
                xor     bh,bh
                cmp     bx,Max_Cmd      ; make sure it's legal
                jle     Intr1           ; jump, function code is ok
                mov     ax,8003h        ; set Error bit and "Unknown Command" code
                jmp     Intr2
        Intr1:  or      bx,bx           ; check for function 0
                jnz     dummy
                call    init
                jmp     intr1a
        dummy:  xor     ax,ax           ; should return AX = status
        intr1a:
                lDS     BX,CS:RH_PTR   ; restore DS:BX = addr of Request Header
        Intr2:  or      ax,0100h        ; merge Done bit into status, and
                                        ; store into Request Header
                mov     RH.DSTATUS,AX
		pop     es
                pop     ds
                popa  
                ret                     ; back to MS-DOS
        PAGE
        ;
        ; Command Code subroutines called by Interrupt Routine
        ;
        ; These routines are called with ES:DI pointing to the
        ; Request Header.
        ;
        ; They should return AX = 0 if function was completed
        ; successfully, or AX = 8000H + Error code if function failed.
        ;
        ;DUMMY_SUBS PROC NEAR
        ;Media_Chk      Function 1 = Media Check
        ;Build_Bpb      Function 2 = Build BPB
        ;IOCTL_Rd       Function 3 = I/O Control Read
        ;Read           Function 4 = Read
        ;ND_Read        Function 5 = Non-Destructive Read
        ;Inp_Stat       Function 6 = Input Status
        ;Inp_Flush      Function 7 = Flush Input Buffers
        ;Write          Function 8 = Write
        ;Write_Vfy      Function 9 = Write with Verify
        ;Outp_Stat      Function 10 = Output Status
        ;Outp_Flush     Function 11 = Flush Output Buffers
        ;IOCTL_Wrt      Function 12 = I/O Control Write
        ;Dev_Open       Function 13 = Device Open
        ;Dev_Close      Function 14 = Device Close
        ;Rem_Media      Function 15 = Removable Media
        ;Out_Busy       Function 16 = Output Until Busy
        ;       xor     ax,ax
        ;       ret
        ;DUMMY_SUBS     ENDP
        page
;
; This Initialization code for the driver is called only
; once when the driver is loaded.  It is responsible for
; initializing the hardware, setting up any necessary
; interrupt vectors, and it must return the address
; of the first free memory after the driver to MS-DOS.
; If it is a block device driver, Init must also return the
; address of the Bios Parameter Block pointer array; if all
; units are the same, all pointers can point to the same BPB.
; Only MS-DOS services 01-0CH and 30H can be called by the
; Initialization function.

        Init    proc                 ; Function 0 = Initialize Driver
                push    es              ; save address of Request Header
                push    di
                call    setup
                pop     di
                pop     es
		CMP	WPMASK,0		;ARE WE CONV. MEMORY?
		JNE	INIT1			;NO
		MOV	AX,PAGE_FRAME_SEGMENT	;YES, DRIVER_END + 64K 
		ADD	AH,10H			;
                mov     word ptr es:[di.address+2],AX;                          current segment
	        mov     word ptr es:[di.address],10H
		JMP	INIT2      
INIT1:          mov     word ptr es:[di.address],Offset driver_end;             last address used in data.obj file
                mov     word ptr es:[di.address+2],cs;                          current segment
INIT2:          xor     ax,ax;                                                  return status
                RET
        INIT    ENDP 
        intr    endp
;===================================
;
;        db      'End of Driver code'
;
Driver  endp
.list
subttl "INTERRUPT 67H DRIVER CODE SECTION.   START"

page
;***************************************************************************
; Notes:
;       1. This section will follow the install procedure
;       2. All of the Function procedure will be placed after this procedure.
;       3. The Data section will be last.
;
; Enter:        by interrupt 67 hex  only.
;
;               AH = function number
;               AL = subfunction / required data  
;
;               Other registers used depending on which function wanted.
;
;               DX, BX, CX      
;               ES:DI
;               DS:SI
;
;
; Return:       AH = status
;       
;               Other registers returned depending on which function wanted.
;       
;               AL, DX, DX, CX
;               ES:DI
;
; procedure will use the callers stack  
;
vector_table:   dw      function1
                dw      function2
                dw      function3
                dw      function4
                dw      function5
                dw      function6
                dw      function7
                dw      function8
                dw      function9
                dw      function10
                dw      function11
                dw      function12
                dw      function13
                dw      function14
                dw      function15
                dw      function16
                dw      function17 
                dw      function18 
                dw      function19
                dw      function20
                dw      function21
                dw      function22
                dw      function23
                dw      function24
                dw      function25
                dw      function26
                dw      function27
                dw      function28
                dw      function29
                dw      function30;            ah = 5D, al = 00,01,02
;
; debug stuff
	org 	200h
ssax	dw	0
ssbx	dw	0
sscx	dw	0
ssdx	dw	0
sssi	dw	0
ssdi	dw	0
ssds	dw	0
sses	dw	0

dsax	dw	0
dsbx	dw	0
dscx	dw	0
dsdx	dw	0
dssi	dw	0
dsdi	dw	0
dsds	dw	0
dses	dw	0

drv67   proc   

;debug stuff
	CLI
	mov	cs:ssax,ax
	mov	cs:ssbx,bx
	mov	cs:sscx,cx
	mov	cs:ssdx,dx
	mov	cs:sssi,si
	mov	cs:ssdi,di
	mov	cs:ssds,ds
	mov	cs:sses,es

	push	bp
	mov	bp,sp
	push	ax
	mov	ax,ss:[bp+6];		get flag register
	mov	cs:[flags],ax
	pop	ax
	pop	bp
        push    bx
        push    ds;                     SAVE USERS DATA SEGMENT
        mov     bx,cs
        mov     ds,bx;                  set up our data segment
        mov     [old_ax],ax;            save ax
	mov	[old_si],si;		move all users registers to our
	mov	[old_di],di;		temp storage area just incase we
	mov	[old_cx],cx;		need them.
	mov	[old_dx],dx;
	mov	[old_es],es;
        pop     [old_ds];                   
        pop     [old_bx];                     
	mov	ah,[error_flags]
	or	ah,ah
	jz	noerrors
	mov	bx,[old_bx]
	mov	ds,[old_ds]

;debug stuff
	mov	cs:dsax,ax
	mov	cs:dsbx,bx
	mov	cs:dscx,cx
	mov	cs:dsdx,dx
	mov	cs:dssi,si
	mov	cs:dsdi,di
	mov	cs:dsds,ds
	mov	cs:dses,es
	iret

noerrors:
	mov	ax,[old_ax]
        sub     ah,40h;                 Check for valid function code
        jb      error84a;               should be 0-1dh  (40h - 5Dh)
        cmp     ah,1Dh; 
        ja      error84a;               jump if greater.
        xor     bx,bx
        mov     bl,ah
        shl     bX,1
	mov	ax,[old_ax]
        call    WORD PTR [bx+vector_table]	;jump to requested function. 
	mov	ds,cs:[old_ds]			;make sure users DS is restored

;debug stuff
	mov	cs:dsax,ax
	mov	cs:dsbx,bx
	mov	cs:dscx,cx
	mov	cs:dsdx,dx
	mov	cs:dssi,si
	mov	cs:dsdi,di
	mov	cs:dsds,ds
	mov	cs:dses,es
        iret;

error84a:
        mov     ah,84h;                 can not use ERRORS PROCEDURE because
        mov     bx,[old_bx];            it assumes that a Call was made !
        mov     ds,[old_ds]
        iret;
drv67   endp
;                      
;----------------------------------------------------------------------------
SUBTTL "ERROR SECTION."
PAGE 
;*****************************************************************************
; Errors
; All errors found in the program will be sent to this section of code for 
; registor setup and any other required functions before returning to the  
; calling program.
;
;
;
errors proc 

error80:        mov     ah,80h
;                mov     cs:[error_flags],ah
                jmp     error_exit
error81:        mov     ah,81h
;                mov     cs:[error_flags],ah
                jmp     error_exit
error83:        mov     ah,83h
                jmp     error_exit
error84:        mov     ah,84h
                jmp     error_exit
error85:        mov     ah,85h
                jmp     error_exit
error86:        mov     ah,86h
                jmp     error_exit
error87:        mov     ah,87h
                jmp     error_exit
error88:        mov     ah,88h
                jmp     error_exit
error89:        mov     ah,89h
                jmp     error_exit
error8a:        mov     ah,8ah
                jmp     error_exit
error8b:        mov     ah,8bh
                jmp     error_exit
error8c:        mov     ah,8ch
                jmp     error_exit
error8d:        mov     ah,8dh
                jmp     error_exit
error8e:        mov     ah,8eh
                jmp     error_exit
error8f:        mov     ah,8fh
                jmp     error_exit
error90:        mov     ah,90h
                jmp     error_exit
error91:        mov     ah,91h
                jmp     error_exit
error92:        mov     ah,92h
                jmp     error_exit
error93:        mov     ah,93h
                jmp     error_exit
error94:        mov     ah,94h
                jmp     error_exit
error95:        mov     ah,95h
                jmp     error_exit
error96:        mov     ah,96h
                jmp     error_exit
error97:        mov     ah,97h
                jmp     error_exit
error98:        mov     ah,98h
                jmp     error_exit
error99:        mov     ah,99h
                jmp     error_exit
error9a:        mov     ah,9ah
                jmp     error_exit
error9b:        mov     ah,9bh
                jmp     error_exit
error9c:        mov     ah,9ch
                jmp     error_exit
error9d:        mov     ah,9dh
                jmp     error_exit
error9e:        mov     ah,9eh
                jmp     error_exit
error9f:        mov     ah,9fh
                jmp     error_exit
errorA0:        mov     ah,0A0h
                jmp     error_exit
errorA1:        mov     ah,0A1h
                jmp     error_exit
errorA2:        mov     ah,0A2h
                jmp     error_exit
errorA3:        mov     ah,0A3h
                jmp     error_exit
errorA4:        mov     ah,0A4h
error_exit:
	        mov     bx,cs:[old_bx]     
                ret;			will return to main and exit with IRET
errors          endp
page
SUBTTL "FUNCTIONS      "
;******************************************************************************
; Date: May 9 1988                      Program Ver: 4.0 
; Programmer: Randy S. Stultz
;-------------------------------------------------------------------------
; Function 1            GET STATUS
;
; Entry         ah = 40h
; 
; Return        ax = status
;
function1 proc
        xor     ax,ax
        mov     ah,[error_flags]
        mov     bx,[old_bx]
        ret
function1       endp
;--------------------------------------------------------------------------
; Function 2            GET PAGE FRAME ADDRESS
;
; Entry         ah = 41h
;
; Return        ah = status;                    0=successful ,80h,81h,84h=error
;               bx = page frame segment address
;
function2 proc 

        mov     bx,[page_frame_segment]
        xor     ax,ax;                          set status to 0 (successful)
        ret
function2       endp
;----------------------------------------------------------------------------
; Function 3            GET UNALLOCATED PAGE COUNT.
;
; Entry         ah = 42h
;
; Return        ah = status
;               bx = unallocated pages
;               dx = total pages
;
function3 proc  

        mov     bl,[free_pages]
        xor     bh,bh
        xor     dh,dh
        mov     dl,[total_pages]
        xor     ax,ax
        ret
function3       endp
;
;----------------------------------------------------------------------------
; Function 4            ALLOCATE PAGES.
;
; Entry         ah = 43h
;               bx = number of pages to allocate,  must not be 0 
;
; Return        ah = status
;               dx = handle
;               bx = n/c
;
function4 proc
        mov     bx,[old_bx]
        cmp     bx,0;                   check for zero pages?
        jnz     notzero
        jmp     error89;                yes, jump
notzero:
        mov     ax,OPEN_HANDLES
	CMP	AX,MAXHANDLES
        JB      fhandle
        jmp     error85;                yes, jump
fhandle:
	cmp	bh,0
	jne	aller87
        cmp     bl,[total_pages]
        jbe     okpages
aller87: jmp     error87;                yes, jump
okpages:
        cmp     bl,[free_pages]
        jbe     freepages
        jmp     error88;                no, jump
freepages:
        call    allocate_next_handle;   return next free handle in dx, zero value if error
        or      dx,dx;                  check for error
        jnz     handleok
        jmp     error80;                software error!!
handleok:
        xor     ax,ax;                  set status
	mov	bx,[old_bx]
        ret;
function4       endp
;------------------------------------------------------------------------------
; Function 5            MAP/UNMAP HANDLE PAGES
;
; Entry         ah = 44h
;               al = physical page number       0 - 3 (4 - 16k pages)
;               bx = logical page number        0 - ? (max 192 16 k pages for 3 meg)
;                                               FFFFh  Unmap page
;               dx = emm handle                 1-128
;
; Return        ah = status                     0 = successful
;
; MAP:  this function will move the requested logical page 

function5 proc  
        mov     ax,[old_ax];            restore ax value
        mov     bx,[old_bx]
        cmp     al,3
        jng     pagesizeok
        jmp     error8b;                greater than max physical page error
pagesizeok:
        call    check_handle_pages	;check for valid handle number and for
                                 	;number of pages allocated to handle
	cmp	ax,0			;ax = 0 	good, found
	jz	hok
	cmp	ax,8300h		;error 83
        jz      aerror83		;Could not  find handle ?
        jmp     error8a			;Logical page is out of range.
hok:
        mov     ax,[old_ax];            restore ax value
	call	map_unmap
	mov	bx,[old_bx]
	ret
aerror83:       jmp error83
aerror8a:       jmp error8a
MAP_UNMAP:
        cmp     bx,-1;                  UnMap ?
        je      unmap


        ;---------------------------------------------
        ; Map pages
        ;
        ; setup for a block move bios call INT 15h function 87h
        ;
        ; Move logical page to physical page. where logical page
        ; is in extended memory and physical page is within the
        ; first meg of memory.
        ;
        ; phy_page0 - 3 structure
        ;
        ;               page_handle     dw      current using handle (-1 if free)
        ;               logical_page    db
        ;
map:
	PUSH	DS
	PUSH	BX
	PUSH	AX		;UNMAP
	CALL	UNMAP		; THIS
	POP	AX		;  PHY. PAGE IF USED
	POP	BX
	POP	DS
	pusha
        push    es;                 al = phy_page
        push    bx
        push    ax
        push    dx
	call	setup_gtd_struct
	call    get_phy_page_address;           phyical page value in AL
                ;                       return in ax (lo_word) dh (hi_byte)
                ;                       ds:si -> phy_page? structure
        lea     di,TARGET_STRUCT;       move 24 bit address into target struct 
        mov     WORD PTR[di.lo_word],ax; for protected mode memory copy.
        mov     BYTE PTR[di.hi_byte],dh
        pop     dx;                     restore handle
        pop     BX;                     GET PHY. PAGE
        pop     AX;			GET LOG. PAGE
        call    get_log_page_address;   enter al=page number, dx =handle
        ;                               return ax, dh
        lea     di,SOURCE_STRUCT;
        mov     WORD PTR[di.lo_word],ax
        mov     BYTE PTR[di.hi_byte],dh
        lea     si,gdt_struct
	mov	cx,ds
	mov	es,cx
        mov     cx,page_size		;number of BYTES to be moved
	MOV	AH,0
	CALL	MYINT15
        pop     es
	popa
				     ;SET ENTRY IN DESC.
	MOV	AH,TYPE PHY_PAGE_DIR	;# BYTE PER ENTRY
	MUL	AH
	XCHG	BX,AX			;INDEX TO BX, LOG. PAGE TO AL
	LEA	BX,PHY_PAGE0[BX]	;ADDRESS OF THIS ENTRY
	MOV	PAGE_HANDLE[BX],DX	;SET HANDLE
	MOV	LOGICAL_PAGE[BX],AL	;SET LOGICAL PAGE
	xor	ax,ax;				set status 
        ret
        ;----------------------------------------------------------------
        ; UN-MAP
        ;
        ;
unmap:	pusha
        push    es
	PUSH	AX
	XOR	AH,AH
	MOV	BL,TYPE PHY_PAGE_DIR	;# BYTE PER ENTRY
	MUL	BL
	MOV	BX,AX			;INDEX TO THIS PHY PAGE ENTRY
	LEA	BX,PHY_PAGE0[BX]	;ADDRESS OF THIS ENTRY
	MOV	DX,-1
	XCHG	PAGE_HANDLE[BX],DX	;GET HANDLE & CLEAR
	MOV	BL,LOGICAL_PAGE[BX]	;GET LOGICAL PAGE
	XOR	BH,BH
	CMP	DX,-1			;WAS IT ASSIGNED?
	pop	ax			;restore phyical page 
	JNE	UNMAPC1			;YES, SAVE IT	

move_ok2:
	POP	ES			;NO, return
	popa
	xor	ax,ax;				set status 
        ret

UNMAPC1:
	PUSH	BX			;save logical page
	push	dx;			save calling handle value
	call	setup_gtd_struct
        call    get_phy_page_address;           phyical page value in AL
                ;                       return in ax (lo_word) dh (hi_byte)
                ;                       ds:si points to phy_page? structure
        	;				
        lea     di,SOURCE_STRUCT
        mov     WORD PTR[di.lo_word],ax
        mov     BYTE PTR[di.hi_byte],dh
	pop	dx
	POP	AX			;SET AX = LOG. PAGE
        call    get_log_page_address;   enter al=page number, dx =handle
        ;                               return ax, dh
        lea     di,TARGET_STRUCT;
        mov     WORD PTR[di.lo_word],ax
        mov     BYTE PTR[di.hi_byte],dh
        lea     si,gdt_struct
	mov	cx,ds
	mov	es,cx
        mov     cx,page_size		;number of BYTES to be moved
	MOV	AH,0
	CALL	MYINT15
        jmp     move_ok2
function5       endp

;*****************************************************************************
; function 6    deallocate pages
;
; enter:        ah = 45h
;               dx = handle
;
;
function6 proc
deall:
	push	cx
	MOV	CX,0			;INDICATE ALL TO BE DELETED
	CALL	PAGES_DELETE		;DEALLOCATE ALL PAGES
	JNC	GOOD_HANDLE
	pop	cx
	JMP	ERROR83

good_handle:
	OR	DX,DX			;ARE WE TRYING TO DEALL. DOS HANDLE?
	JE	DEALL1			; YES, IGNORE
	DEC	OPEN_HANDLES		;DEC THE COUNT
	MOV	STATUS[BX],0		;FREE THE HANDLE
	MOV	CX,4
	LEA	BX,HANDLE_NAME[BX]

CLEAN_NAME:
	MOV	word ptr[BX],0
	inc	bx
	inc	bx
	LOOP	CLEAN_NAME
DEALL1:	pop	cx
	mov     bx,[old_bx]
	xor	ax,ax;			set status
        ret
function6 endp
;----------------------------------------------------------------------------
; Function 7                    GET VERSION NUMBER
;
; Entry         ah = 46h
;
; Return        al = version number
;
function7 proc

        mov     al,LIM_VER
        mov     ah,0
        mov     bx,[old_bx]
        ret

function7 endp;
;******************************************************************************
; Function 8		SAVE PAGE MAP   
;
; THIS JUST SAVES MAP (DOESN'T UNMAP).  LOGICAL PAGES ARE NOT UPDATED. 
;
; Entry		ah = 47h
;		dx = handle
;
; Return	ah = status
;
function8	 proc
	call	check_handle;		will return zero flag set if valid handle
	jz	pas1
	jmp	error83
pas1:
	MOV	AL,DL
	MOV	BL,TYPE HANDLE_DIR
	MUL	BL			;OFFSET TO THIS HANDLE'S ENTRY
	LEA	BX,HANDLE_DIR_STRUCT
	ADD	BX,AX
	CMP	[BX].SAVED,0		;HAS THIS HANDLE DONE A SAVE?
	JE	pas2			;OK
	jmp	error8d

;SAVE PHY. MAP
pas2:	INC	[BX].SAVED
	pusha 
	PUSH	ES
	MOV	CX,PHY_MAP_LEN		;#BYTES IN SAVE AREA
	PUSH	CS
	POP	ES
	LEA	DI,[BX].MAPSAV		;POINT DI TO SAVE AREA FOR THIS HANDLE
	LEA	SI,PHY_PAGE0		;      SI TO MAP
	CLD
	REP	MOVSB			;SAVE IT
	POP	ES
	popa 
        xor     ax,ax
        mov     bx,[old_bx]
	ret
function8       endp

;******************************************************************************
; Function 9		RESTORE PAGE MAP
;
; THIS WILL UNMAP ANY VALID PAGES.
;
; Entry		ah = 48h
;		dx = handle
;
; Return	ah = status
;
function9 proc    
	call	check_handle;		will return zero flag set if good handle
	jz	pas5
	jmp	error83	
pas5:
	PUSHA
	MOV	AL,DL
	MOV	BL,TYPE HANDLE_DIR
	MUL	BL			;OFFSET TO THIS HANDLE'S ENTRY
	LEA	BX,HANDLE_DIR_STRUCT
	ADD	BX,AX
	LEA	BX,SAVED[BX]
	MOV	AL,0
	CMP	[BX],AL 		;HAS THIS HANDLE DONE A SAVE?
	JNE	RPAS6			;OK
	POPA
	jmp	error8E

;CALL "MAP" TO UNMAP ANY CURRENT VALID PAGES AND MAP ANY NEW PAGES
RPAS6:	MOV	[BX],AL			;CLR SAVED FLAG
	INC	BX			;POINT TO SAVE AREA
	LEA	SI,PHY_PAGE0		;ADDRESS OF MAP
RPAS7:	PUSHA
	PUSH	DS	
	MOV	DX,PAGE_HANDLE[BX]	;GET SAVED ENTRY
	MOV	BL,LOGICAL_PAGE[BX]	;
	XOR	BH,BH			;
	CMP	DX,-1			;WAS SAVED ENTRY A VALID PAGE?
	JNE	RPAS8			;YES, MAP IT.
					;NO, SET UP TO UNMAP THE CURRENT PAGE.
	MOV	DX,PAGE_HANDLE[SI]	;GET CURRENTLY MAPPED PAGE 	
	MOV	BX,-1			;
	CMP	DX,BX			;IS IT VALID?
	JE	RPAS9			;NO, MOVE ON
					;YES, UNMAP IT.
RPAS8:	CALL	MAP_UNMAP
	cmp	ah,0
RPAS9:	POP	DS
	POPA
	jnz	fun9_err
	ADD	BX,TYPE PHY_PAGE_DIR	;POINT TO NEXT SAVED ENTRY
	ADD	SI,TYPE PHY_PAGE_DIR	;  "   "   "   PAGE   "
	INC	AL
	CMP	AL,NUM_PHY_PAGES	;ARE WE DONE?
	JNE	RPAS7
	popa 
        xor     ax,ax
fun9_err:
        mov     bx,[old_bx]
        ret
function9       endp
;********************************************************************
;*    NOT SUPPORTED IN VERSION 4.0                                  *
;********************************************************************
; function 10           reserved       Page mapping I/O array
; function 11           reserved       Page translation array
;
; enter         ah =49 or 4A
;
; return        ax = 0001 for function 10,    same as Intel above board with
;               ax = 005F for function 11,    LIM 4.0
;
function10 proc
        mov     ax,0001
        jmp     resexit
function10 endp
function11 proc
        mov     ax,005fh
resexit:
        mov     bx,[old_bx]
        ret
function11 endp
;***************************************************************************
; function 12           get handle count
;
; enter         ah = 4B
;
; return        ax = status
;               bx = total_open_emm_handles  (always 1 handle open, handle 0 )
;
;
function12 proc
        MOV     bx,OPEN_HANDLES
        xor     ax,ax
        ret
function12 endp
;****************************************************************************
; function 13           Get handle pages
;                       
;                       The get handle pages function returns the number of
;                       pages allocated to a specific EMM handle.
; enter   ah = 4Ch
;         dx = handle
;
; return  ax = status
;         bx = number of pages allocated to the handle.
;
function13 proc
        call    check_handle;           will return Zero flag if good handle
        jz      good_handle13;          and AX with the number of allocated pages
        jmp     error83
good_handle13:  ;                       now get number of pages allocated.
        mov     bx,ax;                  move number of pages 
        xor     ax,ax
        ret
function13 endp
;****************************************************************************
; Function 14           Get all handle pages
;                       
;                       The get all handle pages function returns the number of
;                       pages allocated to all EMM handles.
; enter   ah = 4Dh
;         es:di = pointer to handle page
;
; return  ax = status
;         bx = total open emm handles
;
function14 proc
	PUSHA
	CLD
	MOV	CX,MAXHANDLES
	MOV	BX,OFFSET HANDLE_DIR_STRUCT	;SEARCH FOR OPEN HANDLES
	MOV	DX,0				;HANDLE #
PAS141:	CMP	STATUS[BX],-1			;IS HANDLE IN USE?
	JNE	PAS140
	MOV	AX,DX				;HANDLE
	STOSW
	MOV	AL,NUM_PAGES[BX]
	STOSW
PAS140:	ADD	BX,TYPE HANDLE_DIR		;MOVE TO NEXT HANDLE
	INC	DX
	LOOP	PAS141
	POPA
        mov     BX,OPEN_handles
        xor     ax,ax
        ret
function14      endp
;****************************************************************************
; Function 15           Get/set page map
;                       
;                      
; enter   ax = 4E00h........get page map
;	  ax = 4E01h........set page map
;	  ax = 4E02h........get & set page map
;	  ax = 4E03h........get size of page map save array	
;         es:di = dest page map
;         ds:si = source page map
;
; return  ax = status
;
function15      proc    
	mov	bx,[old_bx]			;get bx back
	cmp	al,3
	JLE	pas16
	jmp 	error8f				;ILLEGAL
pas16:	PUSH	CX
	MOV	CX,PHY_MAP_LEN			;MAP LENGTH
	JE	SAVE_PAR_SIZE			;SUB. 3
	CLD
	pusha;
	LEA	SI,PHY_PAGE0			;MAP LOCATION
	CMP	AL,1
	JE	SET_PAGE_MAP			;SUB. 1 
	
;HERE FOR SUB. 0 or 2
	REP	MOVSB				;MOVE THE MAP
	JL	FUNC15_EXIT			;EXIT IF SUB.0 - GET MAP

;HERE FOR SET or GET_SET, call "map" to umap current and map new
SET_PAGE_MAP:
	popa
	pusha
	XOR	AX,AX
	LEA	DI,PHY_PAGE0		;ADDRESS OF MAP
RPAS15:	PUSHA
	PUSH	DS
	MOV	DS,[OLD_DS]	
	MOV	DX,PAGE_HANDLE[SI]	;GET SAVED ENTRY
	MOV	BL,LOGICAL_PAGE[SI]	;
	XOR	BH,BH			;
	POP	DS
	CMP	DX,-1			;WAS SAVED ENTRY A VALID PAGE?
	JNE	RPAS16			;YES, MAP IT.

	MOV	DX,PAGE_HANDLE[DI]	;GET CURRENTLY MAPPED PAGE 	
	MOV	BX,-1			;
	CMP	DX,BX			;IS IT VALID?
	JE	RPAS17			;NO, MOVE ON
					;YES, UNMAP IT.
RPAS16:	push	es
	push	ds
	CALL	MAP_UNMAP
	pop	ds
	pop	es
	cmp	ah,0
	jnz	fun15_err
RPAS17:	POPA
	ADD	SI,TYPE PHY_PAGE_DIR	;POINT TO NEXT SAVED ENTRY
	ADD	DI,TYPE PHY_PAGE_DIR	;  "   "   "   PAGE   "
	INC	AL
	CMP	AL,NUM_PHY_PAGES	;ARE WE DONE?
	JNE	RPAS15
FUNC15_EXIT:
	popa
	xor	ax,ax
	POP	CX
	ret

SAVE_PAR_SIZE:
	MOV	AL,CL			;SIZE
	mov	AH,0
	POP	CX
	ret

fun15_err:
	mov	[old_ax],ax		;SAVE ERROR CODE
	popa
	mov	ax,[old_ax]
	POP	CX
	ret
function15      endp

;****************************************************************************
; Function 16           Get/set partial page map
;                       
;                      
; enter   ax = 4F00h........get partial page map
;	  ax = 4F01h........set partial page map
;	  ax = 4F02h........get size of partial page map array
;  =========================================================
;         Get map    Set Map
;         al = 0     al = 1
;
;	  DS:SI      n/a     ......... Requested_partial_page_map structure
;	  ES:DI      DS:SI   ......... Saved_partial_page_map structure
;
;	requested_partial_page_map	struc
;		mappable_segment_count	dw	?
;		mappable_segment	dw  4  DUP(?);	   Up to 4 pages
;	requested_partial_page_map	ends
;
;	partial	struc
;		owning_handle	db	?
;		logical_pg	dw	?;
;		physical_pg	db	?;	0 - 3
;	partial	ends
;	saved_partial_page_map 		struc
;		num_page_mapped		DB	?
;		page0			DB	4 dup(?) ; Partial structure
;		page1			DB	4 DUP(?) ; 	Logical_page      word
;		page2			DB	4 DUP(?) ; 	phys_page     	  word
;		page3			DB	4 DUP(?) ;                            
;	saved_partial_page_map		ends
;
	req_map		requested_partial_page_map <>;	used for our storage (temp)
;
; return  ax = status
;--------------------------------------------
function16      proc    
	cmp	al,2
	jnz	get_set
	mov	bx,TYPE saved_partial_page_map;	size of array
	xor	ax,ax
	
	ret;					exit
;--------------------------------------------
; Get or Set 
get_set:
	cmp	al,1;		Set ?
	jnz	get
	jmp	set
get:	pusha;			first move array to our temp storage area
	push	es
	push	ds
	pop	es
	lea	di,req_map;	set up our pointer   es:di
	mov	ds,[old_ds];	user points to his array with the DS:SI
	mov	cx,(TYPE requested_partial_page_map /2);	size in words
	rep	movsw;				move users array to ours
	pop	es
	push	cs
	pop	ds;			restore our DS
	popa;				restore registers
	pusha
	lea	si,req_map
	mov	cx,[si.mappable_segment_count]
	mov	es:[di.num_page_mapped],cl;		save count in user array
	cmp	cx,0;				if count zero just exit
	jnz	get_map
	popa
	xor	ax,ax
	mov	bx,[old_bx]
	ret
get_map:
	mov	bx,0;				offset add 2 every loop
	mov	dx,page0;			offset add 5 every loop
get_map1:
	mov	ax,[si.mappable_segment+bx];	get first segment address
	call	pg_num_from_segment;		al will return 0-3, AH = status
	cmp	ah,0;				
	jz	pg_num_good
	popa
	mov	bx,[old_bx]
	ret
pg_num_good:
	push	si
	cmp	al,0
	jnz	f16_1
	lea	si,phy_page0
	jmp	move_page_to_array
f16_1:	cmp	al,1		
	jnz	f16_2
	lea	si,phy_page1
	jmp	move_page_to_array
f16_2:
	cmp	al,3
	jz	f16_3
	lea	si,phy_page2
	jmp	move_page_to_array
f16_3:	lea	si,phy_page3
;************************************************************************
;  Enter: 	ds:si -> phys_page_dir structure
;		es:di -> saved_parital_map structure
;		al = phys_page number (0-3)
;		dx = requested_map structure pointer
;
move_page_to_array:
	xor	ah,ah
	xchg	bx,dx ;		
	mov	es:[di.physical_pg+bx],al; 	phys page number
	mov	al,ds:[si.logical_page]; 	get logical page number
	mov	es:[di.logical_pg+bx],ax;	save logical page in saved_partial_page_map
	mov	ax,ds:[si.page_handle]
	mov	es:[di.owning_handle+bx],al	
	add	bx,TYPE partial;			point to next area
	add	dx,2;
	xchg	bx,dx
	pop	si;
	dec	cx;
	jz	fun16_exit;		
	jmp	get_map1
fun16_exit:
	popa;
	xor	ax,ax
	mov	bx,cs:[old_bx]
	mov	ds,cs:[old_ds]
	ret
;*********************************************************
; Enter: DS:SI	point to saved structure
;		saved_parital_map structure
;			count		byte	number of valid entrys
;			page0		
;				owning_handle	byte
;			    logical_pg	word
;			   physical_pg  byte
;			page1		
;				owning_handle	byte
;			    logical_pg	word
;			   physical_pg  byte
;			page2		
;				owning_handle	byte
;			    logical_pg	word
;			   physical_pg  byte
;			page3		
;				owning_handle	byte
;			    logical_pg	word
;			   physical_pg  byte
;
;		not all of the pages may be used.
;
;---------------------------
set:
	push	dx
	push	cx
	push	si
	push	es
	mov	es,[old_ds]
	mov	dx,1
	mov	cl,es:[si];		get count
	inc	si;			set SI to point to the first structure
setloop:
	mov	al,es:[si.physical_pg]
	mov	bx,es:[si.logical_pg]
	mov	dl,es:[si.owning_handle]
	xor	dh,dh
	call	Map_UnMap
	cmp	ah,0
	jnz	set_loop_error
	add	si,TYPE partial
	dec	cl
	jnz	setloop
	xor	ax,ax
set_loop_error:
	pop	es
	pop	si
	pop	cx
	pop	dx
	mov	bx,[old_bx]
	ret;				function 17 will set up return registers
	;
function16      endp
;*************************************************
; Enter ax = segment address
;
; return: al = phys page number
;	  ah = status
pg_num_from_segment	proc
	push	bx
	xor	bx,bx
	cmp	ax,page0_seg
	jz	seg_found
	inc	bx
	cmp	ax,page1_seg
	jz	seg_found
	inc	bx
	cmp	ax,page2_seg
	jz	seg_found
	inc	bx
	cmp	ax,page3_seg
	jz	seg_found
	mov	ah,8bh
	pop	bx
	ret
seg_found:
	xchg	ax,bx
	pop	bx
	ret
pg_num_from_segment	endp
;******************************************************************************
; Function 17		map/unmap multiple handle pages
;                      
; enter   ax = 5000h........map/unmap multiple pages, physical page method
;	  ax = 5001h........map/unmap multiple pages, segment address method
;	  dx = handle
;	  cx = logical to physical map len
;
; Return	ah = status
;
;	log_to_phys_map_struc	struc
;		log_page_number		dw	?
;		phys_page_number	dw      ? ; this structure would repeat
;	log_to_phys_map_struc	ends;		    for each count of CX
;
function17      proc    near
	pusha
	cmp	cx,4
	jbe	pas46
	popa
	jmp	error8b
pas46:
	cmp	cx,0
	jnz	pas47
	popa
	xor	ax,ax
	mov	bx,[old_bx]
	ret;				Requested 0 pages, Do nothing, Exit 
pas47:	cmp	al,1			;check error
	jbe	pas45
	pop	cx
	popa
	jmp	error8f
pas45:


	push	es;			At This Point [pusha,push es]
	mov	es,[old_ds];		move users ds to es
	push	si;
	mov	cs:[old_cx],cx;		save value
	jz	mul_seg_map		;jump for seg. method

	;***************************************************************
	; Logical page/physical page method
	;
	;	User ES:SI point to structure
	;		CX  number of entrys in structure
	;		DX  Handle
	;-------------------------------------------------------
	;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	; WE WILL LOOP THIS SECTION TILL ALL OF STRUCTURE IS DONE (cx=0)
	;
mull1:	
	mov	ax,es:[si.phys_page_number]	;phy. page 
	cmp	ax,3				;Check phy. page number
	ja	err8b

pas48:	mov	bx,es:[si.log_page_number]	;Log_page_number
	call	check_handle_pages
	cmp	ax,0				;jump if bad handle 
	jnz	err_fun17s			; or bad log. page
	mov	ax,es:[si.Phys_page_number]	;phy page number back 	
	call	map_unmap			;AL,BX & DX ARE SET
	cmp	ah,0				;Check for return Errors
	jnz	err_fun17s
	add	si,4				;INC. to next Entry
	loop	mull1
	jmp	mul_done

;********************************************************************
; Segment address mode
;
mul_seg_map:
	mov	ax,es:[si.phys_page_number]	;search for phy. page 
	mov	bx,0				;phy page 0
	cmp	ax,[page0_seg]
	jz	pas51
	inc	bx				;phy page 1
	cmp	ax,[page1_seg]
	jz	pas51
	inc	bx				;phy page 2
	cmp	ax,[page2_seg]
	jz	pas51
	inc	bx				;phy page 3
	cmp	ax,[page3_seg]
	jz	pas51
err8b:	pop	si				;error
	pop	es
	popa
	jmp	error8b

pas51:	mov	ax,bx
	mov	bx,es:[si.log_page_number]
	mov	[temp],ax
	call	check_handle_pages
	cmp	ax,0
	jnz	err_fun17s
	mov	ax,[temp]
	call	map_unmap
	cmp	ah,0
	jnz	err_fun17s
	add	si,4
	loop	mul_seg_map
mul_done:
	pop	si
	pop	es
	popa
	xor	ax,ax
	mov	bx,[old_bx]
	ret

;error exits
;
err_fun17s:
	pop	si
	pop	es
	mov	cs:[old_ax],ax
	popa
	mov	ax,[old_ax]
	mov	bx,[old_bx]
	ret
function17      endp

page
;******************************************************************************
; Function 18		reallocate pages
;                      
; enter   ah = 51h
;	  dx = handle
;	  bx = reallocation count
;
; Return	ah = status
;               bx = number of pages allocated to handle after reallocation
;
function18      proc    near
	mov	bx,[old_bx]
	PUSH	DX
	PUSH	CX
	OR	BX,BX			;DEALLOCATE ALL?
	JNZ	PAS56			;NO

;DELETE ALL ALLOCATED PAGES
 	MOV	CX,0
PAS57:	CALL	PAGES_DELETE
	JNC	FUNC18OK
	MOV	AX,8300H
PAS55:	POP	CX
	POP	DX
	jmp	error_exit	

pas56:	PUSH	BX
	MOV	BX,OFFSET HANDLE_DIR_STRUCT	;START OF THE HANDLE DIRECTORY
	MOV	AX,TYPE HANDLE_DIR		;BYTES PER ENTRY
	PUSH	DX
	MUL	DX				; * HANDLE
	POP	DX
	ADD	BX,AX				;BX = POINTER FOR THIS HANDLE
	MOV	CL,NUM_PAGES[BX]
	XOR	CH,CH
	POP	AX				;RELOCATION COUNT (OLD BX)
	SUB	CX,AX
	JE	FUNC18OK			;= RETURN COUNT & GOOD STATUS
	JA	PAS57				;DEALLOCATE THE DIFFERENCE
	NEG	CX				
	CALL	PAGES_ADD			;ADD CX PAGES
	OR	AX,AX
	JNZ	PAS55
FUNC18OK:
	MOV	BL,NUM_PAGES[BX]
	XOR	BH,BH
	POP	CX
	POP	DX
	XOR	AX,AX
        ret
function18      endp

;---------------------------------------------------------------------------
; function 19           get/set handle attribute
function19 proc

        mov     ax,[old_ax]
        cmp     al,01
        jnz     subfun19
        mov     ah,91h;         al =01           
        jmp     f19done;        not supported
subfun19:
	xor	ax,ax
f19done:
        mov     bx,[old_bx]
        ret;                    supports only volatile handles  

function19 endp
;******************************************************************************
; Function 20		get/set handle name
;                      
; enter   ax = 5300h......get handle name
;	  ax = 5301h......set handle name
;	  dx = handle
;	  es:di = pointer to handle name array
;	  ds:si = pointer handle name	
;
; Return	ah = status
;               es:di = handle name array
;
function20      proc    near
	pusha
	push	es
	mov	cx,MAXHANDLES
	cmp	dl,cl;		check if valid handle number
	jng	pas58
	pop	es
	popa
	jmp	error83	
pas58:
	or	al,al
	jz	get_handle_name
	cmp	al,1
	jz	set_handle_name
	jmp	error8f
get_handle_name:
	call	find_handle_name_loc;		DS:SI will point to handle name
	mov	cx,4;				will move 4 words (8 bytes)
	REP movsw	
	jmp	get_name_done
set_handle_name:
	call	find_handle_name_loc;		DS:SI will point to location
	push 	ds
	push	si
	mov	si,[old_si];			Get User's pointers
	mov	ds,[old_ds]
	pop	di;				move our pointers to
	pop	es;				ES:DI
	mov	cx,4
	REP movsw
get_name_done:	
	pop	es
	popa;					restore 
        xor     ax,ax
        mov     bx,CS:[old_bx]
        ret
function20      endp
;******************************************************************************
; Function 21		get handle directory
;                      
; enter   ax = 5400h......get handle directory
;		  es:di = pointer to handle directory
;		  hand_dir_struct STRUC
;			hand_value	dw ?
;			hand_name	db 8 Dup(?)
;		  hand_dir_struct ENDS
;
;	  ax = 5401h......search for named handle
;		  ds:si = handle name	
;	  ax = 5402h......get total handles
;	  dx = handle
;
; Return	ah = status	(All)
;		------------------------ Sub 0
;	        al = number of entries in the handle dir array
;               es:di = handle directory 
;		------------------------ Sub 1
;		dx = value of named handle
;		------------------------ Sub 2
;		bx = total handles
;
function21      proc    near
	or	al,al
	jz	get_handle_dir1
	cmp	al,1
	jz	search_for_named
	cmp	al,2
	jnz	pas60
	jmp	get_total_handles
pas60:	
	jmp	error8f
get_handle_dir1:
;--------------------------------------------------------------------
; function 21 00 
;Get handle directory subfunction
; Enter:
;	ax = 5400h
;    ES:DI = Pointer to handle dir structure
;
;		.hand_value	dw
;		.hand_name	db	dup(8) '8 bytes '
;-----------------------------------------------------------
	pusha;		save all general registers	
	push	es;		
	cld;			clear direction flag 
	mov	ax,0;		count in AL
	mov	dx,0;		start with handle 0
get_dir1:
	push	ax
	call	check_handle;	Enter with DX = handle, Return with 
	;					Zero flag set if good
	;					al = number of pages allocated
	pop	ax
	jnz	nname3;			handle not in use
	inc	ax
	push	ax
	call	find_handle_name_loc;	Enter with DX=handle, Return with 
	;					      DS:SI = handle name address
	;					      
	pop	ax
	mov	cx,4;			count for name (word value/ 8 bytes)
	mov	es:[di],dx;		save handle value
	add	di,2;			move pass the handle word saved
	rep movsw;			move name from ds:si to es:di

nname3:;				Jump Here if handle is not in use
	inc	dx
	cmp	dx,MAXHANDLES
	jng	get_dir1;		loop till all handles are checked
	mov	ah,0;		AL = count of handle entrys
	mov	cs:[old_ax],ax;	save count
	pop 	es
	POPA	   	;
	MOV	BX,[OLD_BX] 	;	
	mov	ax,[old_ax];
	mov	ah,0
	ret
	;******************************************************************
search_for_named:
	push	di
	push	si
	push	es
	mov	es,[old_ds]
	mov	di,[old_si];		Get users pointer in ES:DI
	xor	dx,dx;			set for handle 	0
searchl1:
	call	check_handle;		see if handle is inuse
	jnz	nname1;			jump if not
	call	find_handle_name_loc;	get address in DS:SI of Handle_Name
	mov	bx,0;			count register
name_cmp1:	
	mov	al,es:[di+bx];		Get byte from user's pointer
	cmp	al,ds:[si+bx];		Compare with Byte from Handle_Dir Structure
	jnz	nname1;			Exit if bytes don't Compare.
	inc	bx;			count+1
	cmp	bx,8;			when count Equals 8 then Done
	jz	fname1;			Name was Found.
	jmp	name_cmp1;		loop till bx = 8
nname1:
	inc	dx;			Check next handle
	cmp	dx,MAXHANDLES	;	See we have looked at all handles
	jng	searchl1;		jump if not
	pop	es
	pop	si
	pop	di
	mov	bx,[old_bx]	
	jmp	errora0;		Return ERROR A0 Exit
fname1:
	dec	bx;			set count to 7 (0-7 = 8 places)
name_cmp2:	
	mov	ax,0
	cmp	al,es:[di+bx];		Check User string to Make sure it is 
	jz	error2;			not all Nulls
	dec	bx
	cmp	bx,0
	jnz	name_cmp2
	pop	es
	mov	bx,[old_bx]
	pop	si
	pop	di
	ret
error2:
	pop	es
	pop	si
	pop	di
	mov	bx,[old_bx]
	jmp	errora1
	;************************************************************
get_total_handles:
	mov	bx,MAXHANDLES
        xor     ax,ax
        ret
function21      endp
;******************************************************************************
; Function 22		alter page map & jump
;                      
; enter   ah = 55h
;	  al = 00h......physical page number
;	  al = 01h......segment selector
;	  dx = handle
;	  ds:si = pointer to map and jump structure
;
;		map_and_jump	struc
;			target_add		dd	?
;			log_phys_map_len	db	?
;			log_phys_map_ptr	dd	?
;		map_and_jump	ends
;		log_phys_map_struc	struc
;			log_page		dw	?
;			phys_page_segment	dw      ? ; this structure would repeat
;		log_phys_map_struc	ends;		    for each count of CX
;		
; Return	ah = status
;
function22      proc    near
	push	cx
	push	si
	push	di
	push	es
	push	[old_ds]
	push	ds
	mov	ds,[old_ds];			get users DS
	xor	cx,cx
	mov	cl,[si.log_phys_map_len]
	les	di,[si.log_phys_map_ptr]
	xchg	di,si;				set it so User's DS:SI points
	mov	cs:[old_ds],es;			to log_phys_mal_struc
	pop	ds;				restore our DS
	call	function17
	pop	ds;				stored value is OLD_DS
	pop	es
	pop	di
	pop	si
	pop	cx
	cmp	ah,0
	jnz	func22_ret
	;---------------------------------------------------------------
	;		Ok, before we do the jump we must clear off the stack
	;		this function was called so we have 1 word for the return
	;		to my main INT driver. 
	;		The Int driver was call via a INTerrupt which is returned
	;		with a IRET that is  3 words
	;
	add	sp,6;	6 bytes or 3 words  we add because the stack grows down
	mov	bx,cs:[old_bx]
	popf;			removed the last word from the stack
	jmp 	dword ptr ds:[si]
func22_ret:
	mov	bx,cs:[old_bx];		DS is restored
	ret	
function22      endp
;*****************************************************************************
; Alter page map and call
;
; enter		ah = 56
;		al = phyical page number/segment selector(0 pg number,1 segment)
;		dx = handle
;	     ds:si = pointer to map and call structure
;
;	map_and_call_struct	struc
;		target_address		dd	?
;		new_page_map_len	db	?
;		new_page_map_ptr	dd	?
;		old_page_map_len	db	?
;		old_page_map_ptr	dd	?
;	map_and_call_struct		ends
;
;		where ??? is NEW or OLD
;		???_phys_map_struc	struc
;			log_page		dw	?
;			phys_page_segment	dw      ? ; this structure would repeat
;		???_phys_map_struc	ends;		    for each count of CX
;
function23      proc    near
	cmp	al,2;
	jnz	call_it
	;***********************************************
	; get page map stack space size subfunction
	;
	mov	bx,20;		max number of bytes added to stack
	xor	ax,ax
	ret
	;**********************************************
	;
call_it:
	push	cx
	push	si
	push	di
	push	es
	push	[old_ds]
	push	ds;				save our DS
	mov	ds,[old_ds];			get users DS
	xor	cx,cx
	mov	cl,[si.new_page_map_len]
	les	di,[si.new_page_map_ptr]
	xchg	di,si;				set it so User's DS:SI points
	mov	cs:[old_ds],es;			to log_phys_mal_struc
	pop	ds;				restore our DS
	call	function17
	pop	ds;				stored value is OLD_DS
	pop	es
	pop	di
	pop	si
	pop	cx
	cmp	ah,0
	jz	func23_call
	mov	bx,cs:[old_bx]
	ret
	;---------------------------------------------------------------
	;
func23_call:
	push	cs
	pop	ds;		restore DS
	push	[old_ax]
	push	[old_bx]
	push	[old_cx]
	push	[old_dx]
	push	[old_si]
	push	[old_di]
	push	[old_ds]
	push	[old_es]
	pusha
	mov	ds,[old_ds]
	push	cs:[flags]
	popf
	call	ds:[si+target_address]
	pushf
	pop	cs:[flags]
	push	cs
	pop	ds;		Restore Ds
	popa
	pop	[old_es]
	pop	[old_ds]
	pop	[old_di]
	pop	[old_si]
	pop	[old_dx]
	pop	[old_cx]
	pop	[old_bx]
	pop	[old_ax]
	mov	ds,[old_ds]
	push	cx
	push	si
	push	di
	push	es	
	mov	cl,[si.old_page_map_len]
	les	di,[si.old_page_map_ptr]
	xchg	di,si;				set it so User's DS:SI points
	mov	cs:[old_ds],es;			to log_phys_mal_struc
	push	cs
	pop	ds;				restore our DS
	call	function17
	pop	es
	pop	di
	pop	si
	pop	cx
	mov	bx,cs:[old_bx]
	mov	cs:[old_bp],bp
	mov	bp,sp
	mov	cs:[old_ax],ax
	mov	ax,cs:[flags]
	mov	ss:[bp+6],ax
	mov	bp,cs:[old_bp]
	mov	ax,cs:[old_ax]
	ret
function23      endp


;******************************************************************************
; function 24
;		Move / Exchange Memory Region
;
; Enter:   AX =	5700	Move Memory Region
;		5001	Exchange Memory Region
;	DS:SI =	Pointer to Move/Exchange structure
; Return:	AH = Status
;------------------------------------------------------------------------------
; SetUp Structure    Move/Exchange Memory Region structure
;	move_xchg       struc
;	  region_length                 dd      ?  Max of 1 Meg
;	  source_memory_type            db      ?  0 = Conv.  1 = Expanded
;	  source_handle                 dw      ?  handle number if Expanded Else 0
;	  source_initial_offset         dw      ?  0 to 3fff if Expanded, 0 to ffff if Conv
;	  source_initial_seg_page       dw      ?  Logical page Number if Expanded
;  	  dest_memory_type              db      ?
;	  dest_handle                   dw      ?
;	  dest_initial_offset           dw      ?
;	  dest_initial_seg_page         dw      ?  Segmemt address if Conv
; 	move_xchg       ends 
;
;  Enter:	DS:SI --> Pointing to Structure
;		
LOC_MOV_EX	MOVE_XCHG<,,,,,,,,>	;LOCAL COPY OF THE STRUCTURE
PT_SAVE DB	PHY_MAP_LEN DUP(?)	;SAVE AREA FOR THE PAGE MAP	
MP_SAV	DB	0			;THIS IS <>0 IF THE CURRENT MAP
					;HAD TO BE SAVED, THERFORE NEEDS RESTRD
F24RC	DW	0			;TEMP FOR RETURN CODE 

function24	proc
	MOV	CS:F24RC,0		;CLEAR RETURN CODE
	MOV	CS:MP_SAV,0		;CLEAR MAP SAVED FLAG
	CMP	AL,2			;IS IT A LEGAL FUNCTION?
	JBE	FUNC24_1		;
	JMP	ERROR8F	

FUNC24_1:
	PUSH	ES			;SAVE
	PUSHA
	PUSH	AX
	MOV	SI,[OLD_SI]		;GET POINTER TO CALLER STRUC.
	MOV	DS,[OLD_DS]		;

	MOV	AX,WORD PTR REGION_LENGTH[SI]	;CHECK GO 0 LENGTH
	OR	AX,WORD PTR REGION_LENGTH[SI+2] ;
	POP	AX
	JNZ	FUNC24_2			;CONTINUE
	JMP	CCEXIT1       ;			Region lenght is Zero so exit
			      ;			with Ok code But Do Nothing
FUNC24_2:
	PUSH	CS			;POINT ES:DI TO LOCAL AREA
	POP	ES			;
	MOV	DI,OFFSET LOC_MOV_EX	;
	CLD
	MOV	CX,TYPE MOVE_XCHG	;COPY MOVE STRUCT TO LOCAL AREA
	REP 	MOVSB
	PUSH	CS
	POP	DS;			Restore Data Segment
	cmp	al,0;			Move Region ?
	MOV	BX,OFFSET LOC_MOV_EX
	MOV	AH,SOURCE_MEMORY_TYPE[BX]
	MOV	AL,DEST_MEMORY_TYPE[BX];	AX has source and Dest Memory Type
	jz	Move_region
	JMP	Exchange_region

;INTERPRET MOVE INTO
;	1. CONV > CONV
;	2. CONV > EXP
;	3. EXP  > CONV
;	4. EXP  > EXP
Move_region:
	OR	AX,AX
	JZ	CONV_CONV			;CONV > CONV - NEVER UNMAP
	CMP	AX,0101H
	JNE	F2401
	JMP	EXP_EXP				
F2401:	CALL	SCM				;MAYBE UNMAP
	CMP	AX,0100H
	JNE	F2402
	JMP	EXP_CONV			;EXP  > CONV
F2402:	CMP	AX,0001H
	JNE	aCCERR98
	JMP	CONV_EXP			;CONV > EXP
aCCERR98:
	MOV	F24RC,9800H
	JMP	CCEXIT

PAGE
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
;HERE FOR CONV > CONV
; 1ST CHECK IF MOVE WILL CROSS 1MB BOUNDARY
;
CONV_CONV:
	MOV	AX,SOURCE_INITIAL_SEG_PAGE[BX]	;FORM A 24BIT ADDRESS
	MOV	DX,AX				;
	SHR	DX,12				;
	SHL	AX,4
	ADD	AX,SOURCE_INITIAL_OFFSET[BX]
	ADC	DX,0				;IN DX:AX
	ADD	AX,WORD PTR REGION_LENGTH[BX]	;ADD MOVE REGION
	ADC	DX,WORD PTR REGION_LENGTH[BX+2]	;*
	TEST	DX,0FFF0H			;IS SUM MORE THAN 1MB?
	JNZ	CCERRA2
	MOV	SI,DEST_INITIAL_SEG_PAGE[BX]	;SAME FOR DEST.
	MOV	DI,SI				;
	SHR	DI,12				;
	SHL	SI,4
	ADD	SI,DEST_INITIAL_OFFSET[BX]
	ADC	DI,0				;IN DI:SI
	ADD	SI,WORD PTR REGION_LENGTH[BX]	;ADD MOVE REGION
	ADC	DI,WORD PTR REGION_LENGTH[BX+2]	;*
	TEST	DI,0FFF0H			;IS SUM MORE THAN 1MB?
	JZ	CC09

CCERRA2:
	MOV	F24RC,0A200H
	JMP	CCEXIT1

;CHECK FOR OVERLAP
;
CC09:	SUB	AX,SI				;SOURCE-DEST
	SBB	DX,DI				;
	JNS	CC19				;JUMP IF RESULT IS +
	MOV	SI,AX				;NEGATE THE RESULT
	MOV	AX,0
	MOV	DI,DX
	MOV	DX,0
	JMP	CC09
CC19:	SUB	AX,WORD PTR REGION_LENGTH[BX]	;SUBTRACT THE REGION
	SBB	DX,WORD PTR REGION_LENGTH[BX+2]	;*
	JNS	CCFOR				;JUMP IF REGION DOESN'T OVERLAP
	MOV	F24RC,09200H			;  REPORT OVERLAP
	
;
;CHECK FOR FORWARD OR BACKWARD MOVE
;
CC29:	MOV	AX,SOURCE_INITIAL_SEG_PAGE[BX]
	CMP	AX,DEST_INITIAL_SEG_PAGE[BX]
	JA	CCFOR
	JB	JCCBAK
	MOV	AX,SOURCE_INITIAL_OFFSET[BX]
	CMP	AX,DEST_INITIAL_OFFSET[BX]
JCCBAK:	JB	CCBAK


; ---- FORWARD MOVE LOOP 
;--------------------------------------
;
;CHECK REMAINING OF EACH SEG AND THE COUNT 
;  MOVE THE SMALLEST
;
;--------------------------------------
CCFOR:	MOV	CX,DEST_INITIAL_OFFSET[BX]	
	CMP	CX,SOURCE_INITIAL_OFFSET[BX]
	JAE	CCFOR01				;IF DEST > SOURCE, USE DEST OFF
	MOV	CX,SOURCE_INITIAL_OFFSET[BX]	; ELSE USE SOURCE OFFSET
CCFOR01: NEG	CX				;# OF BYTE LEFT IN SMALLEST SEG
	JNZ	CCFOR02				;IF = 64K
	MOV	CX,WORD PTR REGION_LENGTH[BX]	;  MOVE REGION_LENGTH TO CX 
CCFOR02: CMP	WORD PTR REGION_LENGTH[BX+2],0	;IF REM. REGION > 64K
	JNZ	CC05				;JMP TO MOVE REM. CX BYTES
	CMP	CX,WORD PTR REGION_LENGTH[BX]	;IF REM. REGION > REM. SEG.
	JBE	CC05				;JMP TO MOVE REM. SEG.
	MOV	CX,WORD PTR REGION_LENGTH[BX]	; ELSE MOVE REM. REGION
CC05:	PUSH	DS
	OR	CX,CX
	STC					;SET CARRY IS MOVE IS 64K
	JZ	CC051
	SUB	WORD PTR REGION_LENGTH[BX],CX
CC051:	SBB	WORD PTR REGION_LENGTH[BX+2],0
	MOV	ES,DEST_INITIAL_SEG_PAGE[BX]
	MOV	DI,DEST_INITIAL_OFFSET[BX]
	MOV	SI,SOURCE_INITIAL_OFFSET[BX]
	MOV	DS,SOURCE_INITIAL_SEG_PAGE[BX]
	CLD
	MOVSB					;1ST BYTE
	DEC	CX				;
	REP	MOVSB				;REST
	POP	DS
	MOV	DEST_INITIAL_OFFSET[BX],DI		 ;UPDATE DEST.
	OR	DI,DI					 ;*
	JNZ	CC7					 ;*
	ADD	BYTE PTR DEST_INITIAL_SEG_PAGE[BX],10H   ;*
CC7:	MOV	SOURCE_INITIAL_OFFSET[BX],SI		 ;UPDATE SOURCE
	OR	SI,SI					 ;*
	JNZ	CC8					 ;*
	ADD	BYTE PTR SOURCE_INITIAL_SEG_PAGE[BX],10H ;*
CC8:	MOV	CX, WORD PTR REGION_LENGTH[BX+2]	;CHECK FOR DONE
	OR	CX,WORD PTR REGION_LENGTH[BX]		;*
	JNZ	CCFOR
	JMP	CCEXIT1

;-----------------------------------------------------------------------------
; COMMON EXIT CODE
;
CCEXIT:	CMP	MP_SAV,0
	JE	CCEXIT1
	MOV	AX,4E01H		;IF MAP WAS SAVED, RESTORE MAP
	MOV	SI,OFFSET PT_SAVE	;
	PUSH	DS
	CALL	FUNC15		
	POP	DS
CCEXIT1: POPA				;IF MAP WAS NOT SAVED
	POP	ES			;
	MOV	AX,CS:[F24RC]		;RETURN WITH CODE IN AX
	MOV	BX,CS:[OLD_BX]
	RET



; ---- BACKWARD MOVE LOOP 
;--------------------------------------
;CALCULATE THE ENDING ADDRESS FOR SOURCE AND
; DESTINATION.
;CHECK REMAINING OF EACH SEG AND THE COUNT 
;  MOVE THE SMALLEST
;
;--------------------------------------
CCBAK:	MOV	CX,WORD PTR REGION_LENGTH[BX+2]	;HIGH COUNT
	MOV	AX,WORD PTR REGION_LENGTH[BX]	;LOW COUNT
	SUB	AX,1				; -1
	SBB	CX,0				;
	SHL	CX,12				;SEG .TO THE HIGH NIBBLE
	ADD	DEST_INITIAL_OFFSET[BX],AX	;DEST. END OFFSET
	ADC	DEST_INITIAL_SEG_PAGE[BX],CX	;ADD TO DEST. SEG.
	ADD	SOURCE_INITIAL_OFFSET[BX],AX	;SOURCE END OFFSET
	ADC	SOURCE_INITIAL_SEG_PAGE[BX],CX	;ADD TO SOURCE SEG.
CCBAK0:
	MOV	CX,DEST_INITIAL_OFFSET[BX]	
	CMP	CX,SOURCE_INITIAL_OFFSET[BX]
	JBE	CCBAK01				;IF DEST > SOURCE, USE DEST OFF
	MOV	CX,SOURCE_INITIAL_OFFSET[BX]	; ELSE USE SOURCE OFFSET
CCBAK01: INC	CX				;# OF BYTE LEFT IN SMALLEST SEG
	JNZ	CCBAK02				;IF = 64K
	MOV	CX,WORD PTR REGION_LENGTH[BX] 	; COUNT = REGION
CCBAK02: CMP	WORD PTR REGION_LENGTH[BX+2],0	;IF REM. REGION > 64K
	JNZ	CC04				;JMP TO MOVE REM. SEG
	CMP	CX,WORD PTR REGION_LENGTH[BX]	;IF REM. REGION > REM. SEG.
	JB	CC04				;JMP TO MOVE REM. SEG.
	MOV	CX,WORD PTR REGION_LENGTH[BX] 	; ELSE MOVE REM. REGION
CC04:	PUSH	DS
	OR	CX,CX
	STC					;SET CARRY IS MOVE IS 64K
	JZ	CC041
	SUB	WORD PTR REGION_LENGTH[BX],CX
CC041:	SBB	WORD PTR REGION_LENGTH[BX+2],0
	MOV	ES,DEST_INITIAL_SEG_PAGE[BX]
	MOV	DI,DEST_INITIAL_OFFSET[BX]
	MOV	SI,SOURCE_INITIAL_OFFSET[BX]
	MOV	DS,SOURCE_INITIAL_SEG_PAGE[BX]
	STD
	MOVSB					;1ST BYTE
	DEC	CX				;
	REP	MOVSB				;REST
	POP	DS
	MOV	DEST_INITIAL_OFFSET[BX],DI		;UPDATE DESTINATION
	CMP	DI,0FFFFH				;*
	JNE	CC2					;*
	SUB	BYTE PTR DEST_INITIAL_SEG_PAGE[BX],10H	;*
CC2:	MOV	SOURCE_INITIAL_OFFSET[BX],SI		;UPDATE SOURCE
	CMP	SI,0FFFFH				;*	
	JNZ	CC3					;*
	SUB	BYTE PTR SOURCE_INITIAL_SEG_PAGE[BX],10H;UPDATE SEGMENT
CC3:	MOV	CX, WORD PTR REGION_LENGTH[BX+2]	;CHECK FOR DONE
	OR	CX,WORD PTR REGION_LENGTH[BX]		;*
	JNZ	CCBAK0
	JMP	CCEXIT1

PAGE
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
;HERE FOR CONV > EXP
;
CONV_EXP:					;CHECK SOURCE
	MOV	AX,SOURCE_INITIAL_OFFSET[BX]	;FORM A 24 BIT ADDRESS
	MOV	DX,SOURCE_INITIAL_SEG_PAGE[BX]	;
	MOV	CX,DX				;
	SHL	DX,4				;
	SHR	CX,12				;
	ADD	AX,DX				;
	ADC	CX,0				;IN CX:AX
	ADD	AX,WORD PTR REGION_LENGTH[BX]	;ADD MOVE REGION
	ADC	CX,WORD PTR REGION_LENGTH[BX+2]	;*
	TEST	CX,0FFF0H			;IS SUM MORE THAN 1MB?
	JZ	CE01
	JMP	CCERRA2
						;CHECK DESTINATION
CE01:	TEST	DEST_INITIAL_OFFSET[BX],0C000H	;IS OFFSET 0-3FFFH?
	JZ	CE03
	MOV	F24RC,9500H
	JMP	CCEXIT

CE03:	LEA	SI,HANDLE_DIR_STRUCT		;FIND DIR ENTRY FOR THIS HANDLE
	MOV	AX,DEST_HANDLE[BX]		;
	XOR	AH,AH				;
	MOV	CL,TYPE HANDLE_DIR		;
	MUL	CL				;
	ADD	SI,AX				;POINTER TO THE HANDLE
	TEST	STATUS[SI],0FFH
	JNZ	CE02
	MOV	F24RC,8300H			;HANDLE'S NOT INUSE
	JMP	CCEXIT				;ERROR

CE02:	MOV	AL,NUM_PAGES[SI]		;CALCULATE THE SPACE LEFT 
	XOR	AH,AH				; FROM INIT. PAGE.OFFSET
	SUB	AX,DEST_INITIAL_SEG_PAGE[BX]	; TO THE END OF HIS PAGES
	DEC	AX				; = NUMBER OF FULL PAGES
	JS	CEERR93				;ERROR IF < 0
	MOV	CX,4000H
	MUL	CX				;DX.AX = # BYTES IN FULL PAGES
	SUB	CX,DEST_INITIAL_OFFSET[BX]	; 
	ADD	AX,CX				;  + THE PARTIAL PAGE
	ADC	DX,0				;DX.AX = TOTAL SPACE IN BYTES
	SUB	AX,WORD PTR REGION_LENGTH[BX]
	SBB	DX,WORD PTR REGION_LENGTH[BX+2]
	JNS	CE09
CEERR93:
	MOV	F24RC,9300H			;NOT ENOUGH SPACE IN DEST.
	JMP	CCEXIT				;ERROR

; ---- MOVE LOOP 
;--------------------------------------
;MOVE THE REMAINDER OF THE CURRENT EXP. PAGE
;		 OR
;     THE REMAINDER OF THE CURRENT SEGMENT 
;                OR 
;     THE REMAINDER OF THE REGION 
;WHICHEVER IS LESS
;--------------------------------------
CE09:	MOV	CX,4000H			;REMAINDER OF CURRENT PAGE
	SUB	CX,DEST_INITIAL_OFFSET[BX]	;
	MOV	AX,SOURCE_INITIAL_OFFSET[BX]	;SEG. OFFSET
	NEG	AX				;REMAINDER OF CURRENT SEG.
	JZ	CE091				;IF = 64K, LEAVE CX ALONE
  	CMP	AX,CX
	JAE	CE091				;JMP IF AX >= CX
	MOV	CX,AX	
CE091:	CMP	WORD PTR REGION_LENGTH[BX+2],0	;IF REM. REGION > 64K,
	JNZ	CE05				;JMP TO MOVE REM. PAGE
	CMP	CX,WORD PTR REGION_LENGTH[BX]	;IF REM. REGION > REM. PAGE
	JBE	CE05				;JMP TO MOVE REM. PAGE
	MOV	CX,WORD PTR REGION_LENGTH[BX] 	; ELSE MOVE REM. REGION
CE05:	CALL	SETUP_GTD_STRUCT		;INITIALIZE BIOS STRUCTURE
	MOV	AX,SOURCE_INITIAL_SEG_PAGE[BX]	;INIT. SOURCE ADDR
	MOV	DH,AH
	SHR	DH,4				;SEG UPPER NIBBLE
	SHL	AX,4				;SEG LOWER 3 NIBBLES
	ADD	AX,SOURCE_INITIAL_OFFSET[BX]	; + OFFSET
	ADC	DH,0				; + CARRY
	MOV	SOURCE_STRUCT.LO_WORD,AX	;SOURCE INTO BIOS STRUCTURE
	MOV	SOURCE_STRUCT.HI_BYTE,DH	;*

	MOV	DX,DEST_HANDLE[BX]		;INIT. TARGET ADDR
	MOV	AX,DEST_INITIAL_SEG_PAGE[BX]	;
	CALL	GET_LOG_PAGE_ADDRESS		;DH.AX = PAGE ADDRESS
	ADD	AX,DEST_INITIAL_OFFSET[BX]	;      + OFFSET
	MOV	TARGET_STRUCT.LO_WORD,AX	;TARGET INTO BIOS STRUCTURE
	MOV	TARGET_STRUCT.HI_BYTE,DH	;*

	ADD	SOURCE_INITIAL_OFFSET[BX],CX		;UPDATE POINTERS
	JNC	CE050					;
	ADD	SOURCE_INITIAL_SEG_PAGE[BX],1000H	;
CE050:	ADD	DEST_INITIAL_OFFSET[BX],CX		;
	ADD	DEST_INITIAL_OFFSET[BX],0C000H		;
	ADC	DEST_INITIAL_SEG_PAGE[BX],0		;
	AND	DEST_INITIAL_OFFSET[BX],03FFFH		;
	SUB	WORD PTR REGION_LENGTH[BX],CX		;UPDATE THE COUNT
	SBB	WORD PTR REGION_LENGTH[BX+2],0		;*

;MOVE BYTES
	LEA	SI,GDT_STRUCT
	MOV	AH,00
	CALL	MYINT15
	MOV	CX,WORD PTR REGION_LENGTH[BX+2]	;CHECK FOR DONE
	OR	CX,WORD PTR REGION_LENGTH[BX]		;*
	JNZ	CE09
	JMP	CCEXIT
	
PAGE
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
;HERE FOR EXP > CONV
;
EXP_CONV:					;CHECK DESTINATION
	MOV	AX,DEST_INITIAL_OFFSET[BX]	;FORM A 24 BIT ADDRESS
	MOV	DX,DEST_INITIAL_SEG_PAGE[BX]	;
	MOV	CX,DX				;
	SHL	DX,4				;
	SHR	CX,12				;
	ADD	AX,DX				;
	ADC	CX,0				;IN CX:AX
	ADD	AX,WORD PTR REGION_LENGTH[BX]	;ADD MOVE REGION
	ADC	CX,WORD PTR REGION_LENGTH[BX+2]	;*
	TEST	CX,0FFF0H			;IS SUM MORE THAN 1MB?
	JZ	EC01
	JMP	CCERRA2
						;CHECK SOURCE
EC01:	TEST	SOURCE_INITIAL_OFFSET[BX],0C000H	;IS OFFSET 0-3FFFH?
	JZ	EC03
	MOV	F24RC,9500H
	JMP	CCEXIT

EC03:	LEA	SI,HANDLE_DIR_STRUCT		;FIND DIR ENTRY FOR THIS HANDLE
	MOV	AX,SOURCE_HANDLE[BX]		;
	XOR	AH,AH				;
	MOV	CL,TYPE HANDLE_DIR		;
	MUL	CL				;
	ADD	SI,AX				;POINTER TO THE HANDLE
	TEST	STATUS[SI],0FFH
	JNZ	EC02
	MOV	F24RC,8300H			;HANDLE'S NOT INUSE
	JMP	CCEXIT				;ERROR

EC02:	MOV	AL,NUM_PAGES[SI]		;CALCULATE THE SPAEC LEFT 
	XOR	AH,AH				; FROM INIT. PAGE.OFFSET
	SUB	AX,SOURCE_INITIAL_SEG_PAGE[BX]	; TO THE END OF HIS PAGES
	DEC	AX				; = NUMBER OF FULL PAGES
	JNS	EC06
	JMP	CEERR93				;ERROR IF < 0
EC06:	MOV	CX,4000H
	MUL	CX				;DX.AX = # BYTES IN FULL PAGES
	SUB	CX,SOURCE_INITIAL_OFFSET[BX]	; 
	ADD	AX,CX				;  + THE PARTIAL PAGE
	ADC	DX,0				;DX.AX = TOTAL SPAEC IN BYTES
	SUB	AX,WORD PTR REGION_LENGTH[BX]
	SBB	DX,WORD PTR REGION_LENGTH[BX+2]
	JNS	EC09
ECERR93:
	MOV	F24RC,9300H			;NOT ENOUGH SPAEC IN SOURCE.
	JMP	CCEXIT				;ERROR

; ---- MOVE LOOP 
;--------------------------------------
;MOVE THE REMAINDER OF THE CURRENT EXP. PAGE
;		 OR
;     THE REMAINDER OF THE CURRENT SEGMENT 
;                OR 
;     THE REMAINDER OF THE REGION 
;WHICHEVER IS LESS
;--------------------------------------
EC09:	MOV	CX,4000H			;REMAINDER OF CURRENT PAGE
	SUB	CX,SOURCE_INITIAL_OFFSET[BX]	;
	MOV	AX,DEST_INITIAL_OFFSET[BX]	;SEG. OFFSET
	NEG	AX				;REMAINDER OF CURRENT SEG.
	JZ	EC091				;IF = 64K, LEAVE CX ALONE
  	CMP	AX,CX
	JAE	EC091				;JMP IF AX >= CX
	MOV	CX,AX	
EC091:	CMP	WORD PTR REGION_LENGTH[BX+2],0	;IF REM. REGION > 64K,
	JNZ	EC05				;JMP TO MOVE REM. PAGE
	CMP	CX,WORD PTR REGION_LENGTH[BX]	;IF REM. REGION > REM. PAGE
	JBE	EC05				;JMP TO MOVE REM. PAGE
	MOV	CX,WORD PTR REGION_LENGTH[BX] 	; ELSE MOVE REM. REGION
EC05:	CALL	SETUP_GTD_STRUCT		;INITIALIZE BIOS STRUCTURE
	MOV	AX,DEST_INITIAL_SEG_PAGE[BX]	;INIT. DEST ADDR
	MOV	DH,AH
	SHR	DH,4				;SEG UPPER NIBBLE
	SHL	AX,4				;SEG LOWER 3 NIBBLES
	ADD	AX,DEST_INITIAL_OFFSET[BX]	; + OFFSET
	ADC	DH,0				; + CARRY
	MOV	TARGET_STRUCT.LO_WORD,AX	;DEST INTO BIOS STRUCTURE
	MOV	TARGET_STRUCT.HI_BYTE,DH	;*

	MOV	DX,SOURCE_HANDLE[BX]		;INIT. TARGET ADDR
	MOV	AX,SOURCE_INITIAL_SEG_PAGE[BX]	;
	CALL	GET_LOG_PAGE_ADDRESS		;DH.AX = PAGE ADDRESS
	ADD	AX,SOURCE_INITIAL_OFFSET[BX]	;      + OFFSET
	MOV	SOURCE_STRUCT.LO_WORD,AX	;SOURCE INTO BIOS STRUCTURE
	MOV	SOURCE_STRUCT.HI_BYTE,DH	;*

	ADD	DEST_INITIAL_OFFSET[BX],CX		;UPDATE POINTERS
	JNC	EC050					;
	ADD	DEST_INITIAL_SEG_PAGE[BX],1000H		;
EC050:	ADD	SOURCE_INITIAL_OFFSET[BX],CX		;
	ADD	SOURCE_INITIAL_OFFSET[BX],0C000H	;
	ADC	SOURCE_INITIAL_SEG_PAGE[BX],0		;
	AND	SOURCE_INITIAL_OFFSET[BX],03FFFH	;
	SUB	WORD PTR REGION_LENGTH[BX],CX	;UPDATE THE COUNT
	SBB	WORD PTR REGION_LENGTH[BX+2],0	;*

	LEA	SI,GDT_STRUCT
	MOV	AH,00
	CALL	MYINT15
	MOV	CX, WORD PTR REGION_LENGTH[BX+2]	;CHECK FOR DONE
	OR	CX,WORD PTR REGION_LENGTH[BX]		;*
	JNZ	EC09
	JMP	CCEXIT


PAGE
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
;HERE FOR EXP > EXP
;
;*************************************************************************
;	Move Expanded to Expanded
;
;	1. IF SOURCE AND DEST. HANDLES ARE DIFFERENT - CALL BIOS MOVE
;	2. IF MOVE IS NOT OVERLAPPED                 - CALL BIOS MOVE
;	3. IF SOURCE > DEST. (FORWARD MOVE)	     - CALL BIOS MOVE
; ELSE IT'S A BACKWARD/OVERLAPPED MOVE 
;	1. SAVE CURRENT MAP
;	2. Move the source page to phy0
;	3. Move the target page to phy1
;	4. Move the source page section starting from the offset to the 
;	   target page starting from its offset
;	5. When the target page is complete Return it.
;
;
EXP_EXP:
	TEST	SOURCE_INITIAL_OFFSET[BX],0C000H	;IS OFFSET 0-3FFFH?
	JNZ	ED03
	TEST	DEST_INITIAL_OFFSET[BX],0C000H
	JZ	ED031
ED03:	MOV	F24RC,9500H			;ERROR
	JMP	CCEXIT
ED031:	MOV	AX,SOURCE_HANDLE[BX]		;IF HANDLES EQUAL, CHECK 
	CMP	AX,DEST_HANDLE[BX]		; FOR MOVE DIRECTION
	JNE	EE001				;JMP IF HANDLES ARE <>
	MOV	AX,SOURCE_INITIAL_SEG_PAGE[BX]
	MOV	CX,SOURCE_INITIAL_OFFSET[BX]
	ROR	AX,2
	PUSH	AX
	AND	AX,0C000H
	OR	CX,AX
	POP	AX
	AND	AH,3FH				;AX.CX = LOGICAL SOURCE ADDR.
	MOV	DX,DEST_INITIAL_SEG_PAGE[BX]
	MOV	DI,DEST_INITIAL_OFFSET[BX]
	ROR	DX,2
	PUSH	DX
	AND	DX,0C000H
	OR	DI,DX
	POP	DX
	AND	DH,3FH				;DX.DI = LOGICAL DEST ADDR.
	SUB	DI,CX				;SUB DEST. FROM SOURCE
	SBB	DX,AX				;	
	JS	EE001				;SOURCE > DEST. - BIOS MOVE
						;DX.DI = DIFFERENT 
	SUB	DI,WORD PTR REGION_LENGTH[BX]	;COMPARE DIFF. TO REG.LENGTH
	SBB	DX,WORD PTR REGION_LENGTH[BX+1]	;*
	JNS	EE001				;NO OVERLAP - BIOS MOVE
	JMP	EEDIR				;BACKWARD/OVERLAPPED - DO IT

;BIOS MOVE
;check source handle
;
EE001:	LEA	SI,HANDLE_DIR_STRUCT		;FIND DIR ENTRY FOR THIS HANDLE
	MOV	AX,SOURCE_HANDLE[BX]		;
	XOR	AH,AH				;
	MOV	CL,TYPE HANDLE_DIR		;
	MUL	CL				;
	ADD	SI,AX				;POINTER TO THE HANDLE
	TEST	STATUS[SI],0FFH
	JZ	EDERR83

ED02:	MOV	AL,NUM_PAGES[SI]		;CALCULATE THE SPACE LEFT 
	XOR	AH,AH				; FROM INIT. PAGE.OFFSET
	SUB	AX,SOURCE_INITIAL_SEG_PAGE[BX]	; TO THE END OF HIS PAGES
	DEC	AX				; = NUMBER OF FULL PAGES
	JS	EDERR93				;ERROR IF < 0
	MOV	CX,4000H
	MUL	CX				;DX.AX = # BYTES IN FULL PAGES
	SUB	CX,SOURCE_INITIAL_OFFSET[BX]	; 
	ADD	AX,CX				;  + THE PARTIAL PAGE
	ADC	DX,0				;DX.AX = TOTAL SPAEC IN BYTES
	SUB	AX,WORD PTR REGION_LENGTH[BX]
	SBB	DX,WORD PTR REGION_LENGTH[BX+2]
	JS	EDERR93

;check destination handle
	LEA	SI,HANDLE_DIR_STRUCT		;FIND DIR ENTRY FOR THIS HANDLE
	MOV	AX,DEST_HANDLE[BX]		;
	XOR	AH,AH				;
	MOV	CL,TYPE HANDLE_DIR		;
	MUL	CL				;
	ADD	SI,AX				;POINTER TO THE HANDLE
	TEST	STATUS[SI],0FFH
	JNZ	ED021
EDERR83:
	MOV	F24RC,8300H			;HANDLE'S NOT INUSE
	JMP	CCEXIT				;ERROR

ED021:	MOV	AL,NUM_PAGES[SI]		;CALCULATE THE SPACE LEFT 
	XOR	AH,AH				; FROM INIT. PAGE.OFFSET
	SUB	AX,DEST_INITIAL_SEG_PAGE[BX]	; TO THE END OF HIS PAGES
	DEC	AX				; = NUMBER OF FULL PAGES
	JS	EDERR93				;ERROR IF < 0
	MOV	CX,4000H
	MUL	CX				;DX.AX = # BYTES IN FULL PAGES
	SUB	CX,DEST_INITIAL_OFFSET[BX]	; 
	ADD	AX,CX				;  + THE PARTIAL PAGE
	ADC	DX,0				;DX.AX = TOTAL SPACE IN BYTES
	SUB	AX,WORD PTR REGION_LENGTH[BX]
	SBB	DX,WORD PTR REGION_LENGTH[BX+2]
	JNS	ED09
EDERR93:
	MOV	F24RC,9300H			;NOT ENOUGH SPAEC IN SOURCE.
	JMP	CCEXIT				;ERROR


; ---- MOVE LOOP 
;--------------------------------------
;MOVE THE REMAINDER OF THE SOURCE PAGE
;		 OR
;     THE REMAINDER OF THE DESTINATION PAGE
;                OR 
;     THE REMAINDER OF THE REGION 
;WHICHEVER IS LESS
;--------------------------------------
ED09:	MOV	CX,4000H			;REMAINDER OF SOURCE PAGE
	SUB	CX,SOURCE_INITIAL_OFFSET[BX]	;
	MOV	AX,4000H			;     "    "  DEST.   "
	SUB	AX,DEST_INITIAL_OFFSET[BX]	;
  	CMP	AX,CX
	JAE	ED091				;JMP IF AX >= CX
	MOV	CX,AX	
ED091:	CMP	WORD PTR REGION_LENGTH[BX+2],0	;IF REM. REGION > 64K,
	JNZ	ED05				;JMP TO MOVE REM. PAGE
	CMP	CX,WORD PTR REGION_LENGTH[BX]	;IF REM. REGION > REM. PAGE
	JBE	ED05				;JMP TO MOVE REM. PAGE
	MOV	CX,WORD PTR REGION_LENGTH[BX] 	; ELSE MOVE REM. REGION
ED05:	CALL	SETUP_GTD_STRUCT		;INITIALIZE BIOS STRUCTURE

	MOV	DX,DEST_HANDLE[BX]		;INIT. TARGET ADDR
	MOV	AX,DEST_INITIAL_SEG_PAGE[BX]	;
	CALL	GET_LOG_PAGE_ADDRESS		;DH.AX = PAGE ADDRESS
	ADD	AX,DEST_INITIAL_OFFSET[BX]	;      + OFFSET
	MOV	TARGET_STRUCT.LO_WORD,AX	;SOURCE INTO BIOS STRUCTURE
	MOV	TARGET_STRUCT.HI_BYTE,DH	;*

	MOV	DX,SOURCE_HANDLE[BX]		;INIT. SOURCE ADDR
	MOV	AX,SOURCE_INITIAL_SEG_PAGE[BX]	;
	CALL	GET_LOG_PAGE_ADDRESS		;DH.AX = PAGE ADDRESS
	ADD	AX,SOURCE_INITIAL_OFFSET[BX]	;      + OFFSET
	MOV	SOURCE_STRUCT.LO_WORD,AX	;SOURCE INTO BIOS STRUCTURE
	MOV	SOURCE_STRUCT.HI_BYTE,DH	;*

	ADD	DEST_INITIAL_OFFSET[BX],CX		;
	ADD	DEST_INITIAL_OFFSET[BX],0C000H		;
	ADC	DEST_INITIAL_SEG_PAGE[BX],0		;
	AND	DEST_INITIAL_OFFSET[BX],03FFFH		;

	ADD	SOURCE_INITIAL_OFFSET[BX],CX		;
	ADD	SOURCE_INITIAL_OFFSET[BX],0C000H	;
	ADC	SOURCE_INITIAL_SEG_PAGE[BX],0		;
	AND	SOURCE_INITIAL_OFFSET[BX],03FFFH	;
	SUB	WORD PTR REGION_LENGTH[BX],CX	;UPDATE THE COUNT
	SBB	WORD PTR REGION_LENGTH[BX+2],0	;*

	LEA	SI,GDT_STRUCT
	MOV	AH,00
	CALL	MYINT15
	MOV	CX, WORD PTR REGION_LENGTH[BX+2]	;CHECK FOR DONE
	OR	CX,WORD PTR REGION_LENGTH[BX]		;*
	JNZ	JED09
	JMP	CCEXIT
JED09:	JMP	ED09
	
;-------------------------------------------------------------------------
; HERE FOR BACKWARD & OVERLAPPED
; 
EEDIR:	CALL	SCMX				;UNMAP CURRENT
	MOV	AX,SOURCE_INITIAL_OFFSET[BX];	FIND THE LAST PAGE OFFSET
	ADD	AX,WORD PTR REGION_LENGTH[BX];	ADDRESS + REGION LOW
	dec	ax			     ;  -1	
	PUSH	AX 
	AND	AX,3FFFH			;REQUIRED
	MOV	SOURCE_INITIAL_OFFSET[BX],AX	;LOW 14 BITS
	POP	AX
	SHR	AX,14				;UPPER 2 BITS (OVER FLOW)
	MOV	CX,WORD PTR REGION_LENGTH[BX+2] ;+ UPPER COUNT (SHIFTED 2 BITS)
	SHL	CX,2
	ADD	AX,CX
	ADD	SOURCE_INITIAL_SEG_PAGE[BX],AX	;+ TO PAGE
	MOV	AX,DEST_INITIAL_OFFSET[BX]	;FIND THE LAST PAGE OFFSET
	ADD	AX,WORD PTR REGION_LENGTH[BX];	 ADDRESS
	DEC	AX
	PUSH	AX 
	AND	AX,3FFFH;				REQUIRED
	MOV	DEST_INITIAL_OFFSET[BX],AX
	POP	AX
	SHR	AX,14
	MOV	CX,WORD PTR REGION_LENGTH[BX+2]
	SHL	CX,2
	ADD	AX,CX
	ADD	DEST_INITIAL_SEG_PAGE[BX],AX
	;-----------------------------------------
	;   MOVE INTO PHY AREA
	;
	PUSH	BX
	MOV	AX,4400H
	MOV	DX,SOURCE_HANDLE[BX]
	MOV	BX,SOURCE_INITIAL_SEG_PAGE[BX]
	CALL	FUNC5
	POP	BX
	CMP	AH,0
	JZ	EEM01
EEM02:	MOV	F24RC,8000H
	JMP	CCEXIT
EEM01:	PUSH	BX
	MOV	AX,4401H
	MOV	DX,DEST_HANDLE[BX]
	MOV	BX,DEST_INITIAL_SEG_PAGE[BX]
	CALL	FUNC5
	POP	BX
	CMP	AH,0
	JNZ	EEM02

EEBAK0:
	MOV	CX,DEST_INITIAL_OFFSET[BX]	
	CMP	CX,SOURCE_INITIAL_OFFSET[BX]
	JB	EEBAK01				;IF DEST > SOURCE, USE DEST OFF
	MOV	CX,SOURCE_INITIAL_OFFSET[BX]	; ELSE USE SOURCE OFFSET
EEBAK01:
	inc	cx				;# OF BYTE LEFT IN SMALLEST SEG
	CMP	WORD PTR REGION_LENGTH[BX+2],0	;IF REM. REGION > 64K
	JNZ	EE04				;JMP TO MOVE REM. SEG
	CMP	CX,WORD PTR REGION_LENGTH[BX]	;IF REM. REGION > REM. SEG.
	JB	EE04				;JMP TO MOVE REM. SEG.
	MOV	CX,WORD PTR REGION_LENGTH[BX] 	; ELSE MOVE REM. REGION
EE04:	PUSH	DS
	OR	CX,CX
	STC
	JZ	EE041
	SUB	WORD PTR REGION_LENGTH[BX],CX
EE041:	SBB	WORD PTR REGION_LENGTH[BX+2],0
	MOV	AX,[PAGE_FRAME_SEGMENT]
	ADD	AX,400H
	MOV	DS,AX
	MOV	DI,DEST_INITIAL_OFFSET[BX]
	MOV	SI,SOURCE_INITIAL_OFFSET[BX]
	MOV	DS,[PAGE_FRAME_SEGMENT]
	STD
	MOVSB					;1ST BYTE
	DEC	CX				;
	REP	MOVSB				;REST
	POP	DS
	AND	DI,3FFFH			;16K OFFSET
	MOV	DEST_INITIAL_OFFSET[BX],DI	;UPDATE OFFSET
	CMP	DI,03FFFH
	JNE	EE2
	DEC	DEST_INITIAL_SEG_PAGE[BX]	;UPDATE SEGMENT
	PUSH	BX
	MOV	AX,4401H
	MOV	DX,DEST_HANDLE[BX]
	MOV	BX,DEST_INITIAL_SEG_PAGE[BX]
	CALL	FUNC5;				MAP AND REMAP PAGES
	POP	BX
	CMP	AH,0
	JNZ	EEM02

EE2:	AND	SI,3FFFH			;16K OFFSET
	MOV	SOURCE_INITIAL_OFFSET[BX],SI
	CMP	SI,03FFFH
	JNZ	EE3
	DEC	SOURCE_INITIAL_SEG_PAGE[BX]	;UPDATE SEGMENT
	PUSH	BX
	MOV	AX,4400H
	MOV	DX,SOURCE_HANDLE[BX]
	MOV	BX,SOURCE_INITIAL_SEG_PAGE[BX]
	CALL	FUNC5;				MAP AND REMAP PAGES
	POP	BX
	CMP	AH,0
	JZ	EE3
	JMP	EEM02
EE3:	MOV	CX, WORD PTR REGION_LENGTH[BX+2]	;CHECK FOR DONE
	OR	CX,WORD PTR REGION_LENGTH[BX]		;*
	JNZ	JEEBAK0
	JMP	CCEXIT
JEEBAK0: JMP	EEBAK0

PAGE
;------------------------------------------------------------------------------
;HERE FOR EXCHANGE
;
EXCHANGE_REGION:
;
;	1. CONV > CONV
;	2. CONV > EXP
;	3. EXP  > CONV
;	4. EXP  > EXP

	OR	AX,AX
	JZ	EXCH_CONV_CONV			;CONV > CONV
	CALL	SCMX				;SAVE MAP FOR ALL EXP. EXCH'S
	CMP	AX,0100H
	JNE	F24e2
	JMP	EXCH_EXP_CONV			;EXP  > CONV
F24e2:	CMP	AX,0001H
	JNE	F24e3
	JMP	EXCH_CONV_EXP			;CONV > EXP
F24e3:	CMP	AX,0101H
	JNE	CCERR98
;	JMP	EXCH_EXP_EXP			;EXP  > EXP
CCERR98:
	MOV	F24RC,9800H
	JMP	CCEXIT

;************************************************
EXCH_CONV_CONV:
	
	mov	ax,source_initial_seg_page[bx]
	mov	dx,ax
	shr	dx,12;				Form 24 bit address
	shl	ax,4
	add	ax,source_initial_offset[bx]
	adc	dx,0
	add	ax,WORD PTR region_length[bx];	add move region
	adc	dx,WORD PTR REGION_LENGTH[BX+2]
	test	dx,0FFF0h;			Is sum more than 1 Meg
	JNZ	eccerra2;			jump if error
	mov	si,dest_initial_seg_page[bx]
	mov	di,si
	shr	di,12;				Form 24 bit address
	shl	si,4
	add	si,dest_initial_offset[bx]
	adc	di,0
	add	si,WORD PTR region_length[bx];	add move region
	adc	di,WORD PTR REGION_LENGTH[BX+2]
	test	di,0FFF0h;			Is sum more than 1 Meg
	JZ	ecc01
eccerra2:;-------------------------- move over 1 meg boundary
	mov	f24rc,0a200h
	jmp	ccexit


;--------------------------------
;CHECK FOR OVERLAP
;
ECC01:	SUB	AX,SI				;SOURCE-DEST
	SBB	DX,DI				;
	JNS	ECC19				;JUMP IF RESULT IS +
	MOV	SI,AX				;NEGATE THE RESULT
	MOV	AX,0
	MOV	DI,DX
	MOV	DX,0
	JMP	ECC01
ECC19:	SUB	AX,WORD PTR REGION_LENGTH[BX]	;SUBTRACT THE REGION
	SBB	DX,WORD PTR REGION_LENGTH[BX+2]	;*
	JNS	ECC29				;REGION DOESN'T OVERLAP
	MOV	F24RC,9700H			;   "     "        "
	JMP	CCEXIT				;ERROR

;
ECC29:						;set up for Exchange will have
						; to loop if
	mov	cx,dest_initial_offset[bx]	; greater than 65k block
	cmp	cx,source_initial_offset[bx];
	jae	ecc02;				if dest > source use dest offset
	mov	cx,source_initial_offset[bx];	else use source offset
ecc02:	neg	cx;				# of bytes left in smallest
	cmp	WORD PTR REGION_LENGTH[BX+2],0
	jnz	ecc03
	cmp	cx,WORD PTR region_length[bx]
	jbe	ecc03
	mov	cx,WORD PTR region_length[bx]
ecc03:	push	ds
	OR	CX,CX
	STC
	JZ	ECC031
	sub	word ptr region_length[bx],cx
ECC031:	sbb	word ptr REGION_LENGTH[BX+2],0
	mov	es,source_initial_seg_page[bx]
	mov	di,source_initial_offset[bx]
	mov	si,dest_initial_offset[bx]
	mov	ds,dest_initial_seg_page[bx]
	call	ExchC
	pop	ds
	mov	dest_initial_offset[bx],si
	or	si,si
	jnz	ecc04
	ADD	BYTE PTR dest_initial_seg_page[bx+1],10H
ecc04:	mov	source_initial_offset[bx],di
	or	di,di
	jnz	ecc05
	ADD	BYTE PTR source_initial_seg_page[bx+1],10H
ecc05:	MOV	CX, WORD PTR REGION_LENGTH[BX+2]	;CHECK FOR DONE
	OR	CX,WORD PTR REGION_LENGTH[BX]		;*
	JNZ	ECC29
	JMP	CCEXIT


;************************************************
EXCH_CONV_EXP:  
	
	mov	ax,source_initial_seg_page[bx]
	mov	dx,ax
	shr	dx,12;				Form 24 bit address
	shl	ax,4
	add	ax,source_initial_offset[bx]
	adc	dx,0
	add	ax,WORD PTR region_length[bx];	add move region
	adc	dx,WORD PTR REGION_LENGTH[BX+2]
	test	dx,0FFF0h;			Is sum more than 1 Meg
	jz	ece00
ecerra2:;-------------------------- move over 1 meg boundary
	mov	f24rc,0a200h
	jmp	ccexit

ece00:	TEST	dest_initial_offset[bx],0C000h;
	jz	ece01
	mov	f24rc,9500h
	jmp	ccexit
ece01:	LEA	SI,HANDLE_DIR_STRUCT		;FIND DIR ENTRY FOR THIS HANDLE
	MOV	AX,DEST_HANDLE[BX]		;
	XOR	AH,AH				;
	MOV	CL,TYPE HANDLE_DIR		;
	MUL	CL				;
	ADD	SI,AX				;POINTER TO THE HANDLE
	TEST	STATUS[SI],0FFH
	JNZ	ECE02
	MOV	F24RC,8300H			;HANDLE'S NOT INUSE
	JMP	CCEXIT				;ERROR

ECE02:	MOV	AL,NUM_PAGES[SI]		;CALCULATE THE SPACE LEFT 
	XOR	AH,AH				; FROM INIT. PAGE.OFFSET
	SUB	AX,DEST_INITIAL_SEG_PAGE[BX]	; TO THE END OF HIS PAGES
	DEC	AX				; = NUMBER OF FULL PAGES
	JNS	ECE06
	JMP	ECERR93a				;ERROR IF < 0
ECE06:	MOV	CX,4000H
	MUL	CX				;DX.AX = # BYTES IN FULL PAGES
	SUB	CX,DEST_INITIAL_OFFSET[BX]	; 
	ADD	AX,CX				;  + THE PARTIAL PAGE
	ADC	DX,0				;DX.AX = TOTAL SPACE IN BYTES
	SUB	AX,WORD PTR REGION_LENGTH[BX]
	SBB	DX,WORD PTR REGION_LENGTH[BX+2]
	JNS	ECE09
ecerr93a:
	MOV	F24RC,9300H			;NOT ENOUGH SPACE IN DEST.
	JMP	CCEXIT				;ERROR

	;-----------------------------------------------------------------
	; now move Dest page to phy page 0
	;
	;
ECE09:	push	bx
	mov	ax,4400h;
	mov	dx,dest_handle[bx]
	mov	bx,dest_initial_seg_page[bx];	move page number in
	call	function5;			MAP PAGE
	pop	bx
	cmp	ah,0
	jz	ece10
	mov	f24rc,ax
	jmp	ccexit

;
;MOVE THE LEAST OF:
;	REGION LENGTH
;	AREA LEFT IN THE PAGE
;	AREA LEFT IN THE SEG	

ece10:	MOV	CX,4000H
	SUB	CX,DEST_INITIAL_OFFSET[BX]	;SPACE LEFT IN THE PAGE
	XOR	DX,DX
	SUB	DX,SOURCE_INITIAL_OFFSET[BX]	;SPACE LEFT IN THE SEG.
	CMP	CX,DX
	JB	ECE11
	MOV	CX,DX
ECE11:	CMP	WORD PTR REGION_LENGTH[BX+2],0	;DON'T COMP. LOW COUNT
	JNZ	ECE12				;IF REGION > 64K
	CMP	CX,WORD PTR REGION_LENGTH[BX]	;CMP LOW REGION
	JB	ECE12
	MOV	CX,WORD PTR REGION_LENGTH[BX]	;GET LOW REGION

ECE12:	push	ds
	OR	CX,CX
	STC
	JZ	ECE121
	sub	word ptr region_length[bx],cx
ECE121:	sbb	word ptr REGION_LENGTH[BX+2],0
	mov	es,source_initial_seg_page[bx]
	mov	di,source_initial_offset[bx]
	mov	si,dest_initial_offset[bx]
	mov	ds,[PAGE_FRAME_SEGMENT]
	call	ExchC
	pop	ds
	AND	SI,3FFFH
	mov	dest_initial_offset[bx],si
	or	si,si
	jnz	ecc13
	ADD	BYTE PTR dest_initial_seg_page[bx+1],10H
ecc13:	mov	source_initial_offset[bx],di
	or	di,di
	jnz	ecc14
	ADD	BYTE PTR source_initial_seg_page[bx+1],10H
ecc14:	MOV	CX, WORD PTR REGION_LENGTH[BX+2]	;CHECK FOR DONE
	OR	CX,WORD PTR REGION_LENGTH[BX]		;*
	JNZ	ECE10
	JMP	CCEXIT


;************************************************
;EXCHANGE EXP > CONV IS SAME AS CONV > EXP IF WE 
;  SWAP SOURCE AND DEST. FIELDS 

EXCH_EXP_CONV:  
	mov	ax,dest_initial_seg_page[bx]	;xchg page
	xchg	ax,source_initial_seg_page[bx]
	mov	dest_initial_seg_page[bx],ax
	mov	ax,dest_initial_offset[bx]	;xchg offset
	xchg	ax,source_initial_offset[bx]
	mov	dest_initial_offset[bx],ax
	mov	ax,dest_handle[bx]		;xchg handle
	xchg	ax,source_handle[bx]
	mov	dest_handle[bx],ax
	jmp	exch_conv_exp			;goto other exch

function24	ENDP



;******************************************************************
; Exchange Memory Conventional to Conventional  No OverLaping ALLOWED
;
; Enter:	DS:SI	-> Area 1
;		ES:DI	-> Area 2
;		CX	= Number of bytes  Can not extend over a segment end
;------------------------------------------------------------------
; Exchange Memory Expanded to Conventional or Conventional to Expanded
;
; Enter:	DS:SI	-> Phy page 0 + offset
;		ES:DI	-> Conventional area + offset
;		CX      = Number of bytes but not more that to the End of a page
;-------------------------------------------------------------------
; Exchange Memory Expanded to Expanded
;
; Enter:	DS:SI	-> Phy page 0 + Offset
;		ES:DI	-> Phy page 1 + Offset
;		CX	= Number of Bytes but not more than to the End of 
;			  one of the two phy pages
;
; Return:	None
;
ExchC	Proc	Near
	push	ax
	cld
Exch_lp:lodsb			;load into al the byte pointed to by DS:SI
	Xchg	es:[di],al
	mov	[si-1],al;	Store exchange data
	inc	di
	loop	exch_lp
	pop	ax
	ret
ExchC	Endp

FUNC15	proc
	push	old_ds
	mov	[old_ds],ds
	call	function15
	pop	cs:[old_ds]
	ret
FUNC15	endp

FUNC5	PROC
	PUSH	OLD_AX
	PUSH	OLD_BX
	MOV	OLD_AX,AX
	MOV	OLD_BX,BX
	CALL	FUNCTION5
	POP	OLD_BX
	POP	OLD_AX
	RET
FUNC5	ENDP

;----------------------------------------
; SUBROUTINE TO SAVE THE CURRENT MAP IF EITHER THE SOURCE OR
; DESTINATION HANDLES ARE MAPPED
SCM:	PUSHA
	LEA	SI,PHY_PAGE0		;ADDRESS OF PHY. PAGE TABLE
	MOV	CX,3			;CHECK IF ANY MAPPED PAGES 
SCM2:	MOV	DI,PAGE_HANDLE[SI]	; INVOLVE THE SOURCE/DEST. HANDLES
	CMP	DI,SOURCE_HANDLE[BX]	
	JE	SCM1			;UNMAP ALL PAGES IF =
	CMP	DI,DEST_HANDLE[BX]
	JE	SCM1			;UNMAP ALL PAGES IF =
	ADD	SI,TYPE PHY_PAGE_DIR	;NEXT ENTRY
	LOOP	SCM2
	POPA
	RET				;NONE - EXIT	

SCMX:	PUSHA
SCM1:	PUSH	DS	
	MOV	MP_SAV,-1		;MARK THE MAP SAVED
	MOV	AX,4E00H
	MOV	DI,OFFSET PT_SAVE
	CALL	FUNC15			;SAVE THE CURRENT MAP
	MOV	CX,4
	MOV	AL,0
CLP:	CALL	UNMAP			;UNMAP ANY VALID PAGES
	INC	AL
	LOOP	CLP
	POP	DS
	POPA
	RET


	PAGE
;----------------------------------------------------------------------------
; MYINT15
;  THIS ROUTINE MOVE AND EXCHANGES TO ANY AREA IN THE 16MB ADDRESS SPACE.
;  THE GDT MUST BE SET UP SAME FUNCTION AS THE BIOS INT 15 W/AH=87H (BLK MOVE)
; 	 ES:SI POINTS TO THE GDT
;
; THE DIFERENCES ARE:
;	CX = NUMBER OF BYTES TO BE MOVED/EXCHANGED (CX=0 IS MAX. 64KB)
;	AH = 0 MOVE FORWARD, SOURCE AND TARGET ARE INCREMENTED
;	   = 1 MOVE BACKWARD,  "     "     "    "  DECREMENTED
;	   = 2 EXCAHNGE (ALWAYS FORWARD) 
MYINT15:
	CLI
	PUSHA	
	PUSH	DS
	PUSH	ES
;
;SET KYBD A20GATE IF 12MHZ CHIPSET
; PORT A WILL DO 16MHZ
;	CMP	CS:PAGE_FRAME_SEGMENT,09FFFH	;IS IT 12 OR 16MHZ
;	NOP
;	NOP
;	JA	MY10
	MOV	BX,0FD02H	;SET BH=AND MASK, BL=OR VALUE 
	CALL	OUTPORT		; A20GATE WILL SET IN < 20uSEC

	MOV	CS:SAH,AH	;SAVE THE FUNCTION
	MOV	AX,0040H
	MOV	DS,AX
	PUSH	DS:[67H]		;SAVE OLD VECTORS
	PUSH	DS:[69H]		;
	MOV	AX,CS			;INIT FAR JUMP CS
	LEA	BX,EMM_SHUTA
	MOV	DS:[67H],BX		;SET NEW SHUT A VECTOR
	MOV	DS:[69H],AX		;
	PUSH	ES			;SET DS = ES
	POP	DS
	MOV	CS:USS,SS		;SAVE STACK POINTERS
	MOV	CS:USP,SP		;

;
;SETUP GDT DESC.
;
	MOV	AX,ES			;FORM A 24 BIT GDT POINTER
	MOV	DH,AH			;
	SHR	DH,4			;
	SHL	AX,4			;
	ADD	AX,SI			;
	ADC	DH,0			;
	MOV	CGDT_LOC.SEG_LIMIT[SI],-1	;GDT - SEG LIMIT = MAX
	MOV	CGDT_LOC.LO_WORD[SI],AX		;    - BASE LOW
	MOV	CGDT_LOC.HI_BYTE[SI],DH		;    - BASE HIGH
	MOV	CGDT_LOC.RESERVED[SI],0		;    - RESERVED
;
;SETUP CODE DESC.
;
	MOV	AX,CS
	MOV	DH,AH
	SHR	DH,4
	SHL	AX,4
	MOV	BIOS_CS.SEG_LIMIT[SI],-1	;CODE - SEG LIMIT = MAX
	MOV	BIOS_CS.LO_WORD[SI],AX		;     - BASE LOW
	MOV	BIOS_CS.HI_BYTE[SI],DH		;     - BASE HIGH
	MOV	BIOS_CS.DATA_ACC_RIGHTS[SI],9BH	;     - BASE HIGH
	MOV	BIOS_CS.RESERVED[SI],0		;     - RESERVED
;
;SETUP STACK DESC.
;
	MOV	AX,SS
	MOV	DH,AH
	SHR	DH,4
	SHL	AX,4
	MOV	TEMP_SS.SEG_LIMIT[SI],-1	;CODE - SEG LIMIT = MAX
	MOV	TEMP_SS.LO_WORD[SI],AX		;     - BASE LOW
	MOV	TEMP_SS.HI_BYTE[SI],DH		;     - BASE HIGH
	MOV	TEMP_SS.DATA_ACC_RIGHTS[SI],93H	;     - BASE HIGH
;
;SETUP IDT LOC.
;
	MOV	AX,CS
	MOV	DH,AH			;
	SHR	DH,4			;
	SHL	AX,4			;
	ADD	AX,OFFSET IDT_BEG	;
	ADC	DH,0			;
	MOV	CS:IDT_LO,AX		;    - BASE LOW
	MOV	CS:IDT_HI,DH		;    - BASE HIGH
;
;SET CMOS FOR SHUTDOWN A
;	
MY10:	MOV	AL,8FH
	OUT	70H,AL		;DISABLE MNI & SET TO SHUTDOWN
	MOV	AL,0AH
	JMP 	MY11
MY11:	OUT	71H,AL		;SHUT A
	MOV	AL,0
	OUT	80H,AL		;CLR EXCEPTION
;
;SET IDT AND GDT
;
	MOV	BP,OFFSET EMM_IDT_LOC
	DB	2EH			;SEGOV CS
	DB	0FH			;LIDT
??1	LABEL	BYTE			;*
	MOV	BX,WORD PTR[BP]		;*
??2	LABEL	BYTE			;*
	ORG	OFFSET CS:??1		;*
	DB	01H			;*
	ORG	OFFSET CS:??2		;*

	DB	0FH			;LGDT
??3	LABEL	BYTE			;*
	MOV	DX,WORD PTR CGDT_LOC[SI];*
??4	LABEL	BYTE			;*
	ORG	OFFSET CS:??3		;*
	DB	01H			;*
	ORG	OFFSET CS:??4		;*

;
;SWITCH TO VIRTUAL MODE
;
	MOV	AX,1
	DB	0FH,01H,0F0H	;LMSW
	DB	0EAH		;FAR JUMP TO CLR PREFETCH QUEUE
	DW	OFFSET VIR
	DW	BIOS_CS
;
;INIT POINTERS AND DO THE MOVE
;
VIR:	MOV	AX,TEMP_SS
	MOV	SS,AX
	MOV	AX,SOURCE
	MOV	DS,AX
	MOV	AX,TARGET
	MOV	ES,AX

;TEST FUNCTION
	CMP	CS:SAH,01
	JB	VIRF		;MOVE FORWARD
	JE	VIRB		;MOVE BACKWARD

;EXCHANGE	
	SUB	SI,SI
	SUB	DI,DI
VIRE1:	MOV	AL,[SI]
	XCHG	AL,ES:[DI]
	MOV	[SI],AL
	INC	SI
	INC	DI
	DEC	CX
	JNZ	VIRE1	
	JMP	SHUTIT

;BACKWARD MOVE
VIRB:	STD
	MOV	SI,CX		;SI TO END
	DEC	SI
	MOV	DI,CX		;DI TO END
	DEC	DI
	REP	MOVSB
	JMP	SHUTIT		

;FORWARD MOVE
VIRF:	CLD
	SUB	DI,DI		;START AT 0
	SUB	SI,SI		;  "
	REP	MOVSB		;MOVE 

;
;SHUTDOWN - PORT A WILL GO 1ST IF IT EXISTS
;
SHUTIT:	MOV	AL,3
;	OUT	92H,AL		;PORT A
SHUT1:	IN	AL,64H
	TEST	AL,02
	LOOPNZ	SHUT1
	MOV	AL,0FEH
	OUT	64H,AL		;KEYBD
	HLT

	
EMM_SHUTA:
	MOV	AX,CS		;RESET SS.SP
	MOV	DS,AX		;
	MOV	SS,USS		;
	MOV	SP,USP		;
	MOV	AX,0040H
	MOV	DS,AX
	POP	DS:[69H]
	POP	DS:[67H]
	MOV	BX,0FD00H
	CALL	OUTPORT		;TURN OFF A20GATE
	POP	ES
	POP	DS
	POPA
	RET


;---------------------------------------------------------
;ROUTINE TO CHANGE A BIT/BITS OF THE KEYBOARD OUTPUT PORT 
; THE PORT IS READ, AND'D WITH BH, OR'D WITH BL, OR'D WITH 
; D1h AND WRITTEN BACK.
OUTPORT:
	PUSH	CX
	PUSH	AX
	XOR	CX,CX
MY09:	IN	AL,64H		;WAIT FOR IBMT
	TEST	AL,02		;*
	LOOPNZ	MY09		;*
	MOV	AL,0D0H		;READ OUTPUT PORT
	OUT	64H,AL		;*
	XOR	CX,CX	
MY08:	IN	AL,64H		;WAIT FOR OBF
	TEST	AL,01		;*
	LOOPZ	MY08		;*
	IN	AL,60H		;GET BITS
	MOV	AH,AL
MY07:	IN	AL,64H		;WAIT FOR IBMT
	TEST	AL,02		;*
	LOOPNZ	MY07		;*
	MOV	AL,0D1H		;WRITE OUTPUT PORT
	OUT	64H,AL		;*
	XOR	CX,CX
MY06:	IN	AL,64H		;WAIT FOR IBMT
	TEST	AL,02		;*	
	LOOPNZ	MY06		;*
	MOV	AL,AH
	AND	AL,BH		;AND WITH BH
	OR	AL,BL		;OR WITH BL
	OR	AL,0D1H		;CLOCK, DATA, IRQ & RESET = 1
	OUT	60H,AL		;SET/RESET BIT/BITS
	XOR	CX,CX
MY05:	IN	AL,64H		;WAIT FOR IBMT
	TEST	AL,02		;*	
	LOOPNZ	MY05		;*
	POP	AX
	POP	CX
	RET

;LOCAL SAVE AREA
USS	DW	?
USP	DW	?
SAH	DB	?

;IDT
EMM_IDT_LOC:
	DW	IDT_END-IDT_BEG		;LENGTH OFF TABLE 
IDT_LO	DW	?			;LOW ADDRESS
IDT_HI	DB	?			;HIGH ADDRESS
	DB	0			;RES.

IDTVECT	STRUC
	DW	SHUTIT
	DW	BIOS_CS
	DB	0
	DB	87H
	DW	0
IDTVECT	ENDS

IDT_BEG: IDTVECT 32 DUP(<,,,,>)
IDT_END:



;******************************************************************************
; Function 25		get mappable physical address array
;                      
; enter   ax = 5800h......get mappable physical address array
;	  ax = 5801h......get mappable physical address array entries
;	  ds:si = mappable phys page
;
; Return	ah = status
;		cx = number of entries in mappable phys pages
;
function25      proc    near
	or	al,al
	jz	get_mappa
	cmp	al,1
	jz	get_ent
	jmp	error8f
get_mappa:	
	;call	get_page_seg
	mov	ax,[page0_seg]
	mov	es:[di],ax
	mov	word ptr es:[di+2],0
	mov	ax,[page1_seg]
	mov	es:[di+4],ax
	mov	word ptr es:[di+6],1
	mov	ax,[page2_seg]
	mov	es:[di+8],ax
	mov	word ptr es:[di+10],2
	mov	ax,[page3_seg]
	mov	es:[di+12],ax
	mov	word ptr es:[di+14],3
get_ent:
	mov	cx,4	
        xor     ax,ax
        mov     bx,[old_bx]
        ret
function25      endp
;************************************************************************
;function 26    get expanded memory hardware information
;                       get unallocated raw page count.
;
; entry         ax = 5900       get expanded memory hardware info
;               ax = 5901       get unallocated raw page count
;
;            es:di = pointer wher to put hardware info
;                       format:
;                               hardware_info_struct    
;                                       raw_page_size           dw
;                                       alternate_register_sets dw
;                                       context_save_area_size  dw
;                                       DMA_register_sets       dw
;                                       DMA_Channel_operation   dw
;                               hardware_info_struct    ends
;   return   structure data  (00)
;
;               dx = total raw pages   (01)
;               bx = free raw pages
;
function26 proc
	mov	al,[access];		check access byte
	cmp	al,55h;
	jz	access_ok_26
	jmp	errora4;		access denied
access_ok_26:
        xor     ax,ax
        xor     bh,bh
        cmp     [old_ax],5901h			;raw page count
        jz      raw_page_count
        mov     word ptr es:[di],page_size/16	;page size in bytes/16 (par)
        mov     word ptr es:[di+2],ax		;alt reg set = 0
        mov     bl,PHY_MAP_LEN
        mov     es:[di+4],bx			;context save area
        mov     word ptr es:[di+6],ax		;dma reg. set
        mov     word ptr es:[di+8],ax		;dma channel operation
        mov     bx,[old_bx]
        ret
raw_page_count:
        mov     bl,[free_pages]
        mov     dl,[total_pages]
        xor     bh,bh
        ret
function26 endp
;**************************************************************************
; function 27           allocate standard or raw pages
;
;                       this function can allocate Zero pages.
;
;                       standard and raw pages are the same size in this 
;                       version of software.
;
; entry         ax = 5A00h or 5A01  we don't care which, because pages are all 
;                                       the same size
;               bx = number of pages to allocate
;
; return        dx = handle
;
function27 proc
        mov     bx,[old_bx]
        jmp     notzero;                This is function 4  Allocate pages
        ;                               but jumping into this location will allow
        ;                               allocating zero pages.
function27 endp
;**********************************************************
; Function 28           Alternate Map Register set
;
; Enter         ax = 5B00h	Get Alt Map Save area
;		     5B01h	Set Alt Map Save area
;		     5B02h	Get Alt Map Save area Size
;		     5B03h	Allocate Alt Map Register
;
;		Subfunctions 04 thru 08 are not supported.
;
; Return        ah = status
;               bl = 0 ......... pointer to a map register save area
;                                has been returned.
;               bl <> 0 ........ no pointer is returned. Current active
;                                alternate map register set number.
;               ES:DI = pointer.
;
;
function28 proc
        
	mov	bx,old_bx
        cmp     access,0;              if access = 0 then is denied.
        jne     access_ok
        jmp     errora4
access_ok:
	cmp	al,08;			Error IF greater than 8
	jle	f28_support
	JMP	ERROR8F

F28E9C:	JMP	error9c			;sub function 4-8 are not supported
	;********************************************************************
f28_support:
	cmp	al,6
	jae	f28s4678		;sub func 6,7,8
	dec	al
	js	f28s0			;sub func 0
	dec	al
	js	f28s1			;sub func 1
	dec	al
	js	f28s2			;sub func 2
	dec	al
	js	f28s35			;sub func 3
	dec	al
	js	f28s4678			;sub func 4

;sub 5 & 3
f28s35:	mov	bx,0			;NO alt. Map Reg. Supported
F28EXIT: xor	ax,ax
	ret

;sub 4,6,7,8
f28s4678:
	cmp	bl,0
	jne	f28e9c			;error
	jmp	f28exit


;SUB 2
f28s2:	mov	DX,PHY_MAP_LEN		;Subfunction 2 Get Size
	jmp	f28exit

;SUB 1
F28S1:	MOV	SAVE_SET,BL
	CMP	BL,0
	JNE	F28E9C
	MOV	SAVE_ARRAY_ES,ES	;SAVE THE POINTER
	MOV	SAVE_ARRAY_DI,DI	;*
	MOV	AX,ES			;CHECK FOR A ZERO POINTER
	OR	AX,DI			;*
	JZ	F28EXIT			;ALL DONE
	MOV	AL,1			;CALL SET PAGE MAP
	JMP	CALL_FUN15		;*

;SUB 0
F28S0:	MOV	BL,SAVE_SET		;HAS A "SET ALT" BEEN DONE WITH BL=0
	OR	BL,BL			;*
	JNE	F28EXIT			;NO, RETURN NUMBER
	MOV	AX,SAVE_ARRAY_ES	;GET THE SAVED POINTER
	MOV	ES,AX			;*
	MOV	DI,SAVE_ARRAY_DI	;*
	OR	AX,DI			;WAS POINTER = 0?
	JZ	F28EXIT			;YES, EXIT
	MOV	AL,0			;CALL GET PAGE MAP
;    FALL THRU TO CALL_FUN15
;		|
;		|
;-----------------------------------------
; Setup to Call to Function 15. Function 15 will do the mapping/Unmapping
; required and then return.
call_fun15:
	pusha
	push	[old_ds];		Function 28 requires the structure address
	push	[old_si];		in the ES:DI Registers
	push	[old_di]
	push	[old_es]
	mov	[old_ds],es		;call Function 15 so ds=es & di=si
	mov	[old_si],di		;		
	mov	si,di			;
	push	ds			;
	call	function15		;get/set page map  
	pop	ds
	pop	[old_es]
	pop	[old_di]
	pop	[old_si]
	pop	[old_ds]
	mov	[old_ax],ax;		save status that was returned
	popa	
	mov	ax,[old_ax]
	ret

SAVE_SET	DB	0	;SET NUMBER
Save_Array_ES	DW	0	;Set To Zero At Start
SAVE_ARRAY_DI	DW	0	;*
function28 endp


;*****************************************************************************
; Function 29           Prepare expanded memory hardware for warm boot.
;
; Enter         ah = 5ch
;
;               THIS FUNCTION IS NOT SUPPORTED !!!!
;
function29      proc    

        xor     ax,ax
	MOV	BX,[OLD_BX]	
        ret

function29      endp
;*****************************************************************************
; Function 30           Enable/Disable OS/E Function set functions
;
; Enter         ax = 5D00h .............Enable
;               ax = 5D01h .............Disable
;            bx,cx = access key if not the first time function was accessed
;
; Return        ah = status     
;            bx,cx = access key if the first time or first reenable
;
; Enter         ax = 5D02h ..............Return access key      
;            bx,cx = access key required.
;
; Return-        ah = status     
;       
function30 proc
	mov	bx,[old_bx]
        mov     al,[first_time];        if first_time is not zero (0) then first time.
        or      al,al
        jz      not_first
        xor     ax,ax
        mov     [first_time],al
        call    accesskey;              get new access key value in bx,cx
not_first:
        cmp     cx,access_key[0]
        jz      ck2
        jmp     errora4;                bad access key value
ck2:    cmp     bx,access_key[2]
        jz      keygood
        jmp     errora4;                bad access key value
keygood:
        mov     ax,[old_ax];            restore ax
        cmp     al,0;
        jz      enable_os
        cmp     al,1
        jz      disable_os
        cmp     al,2
        jz      release_key
        jmp     error8f;                invalid subfunction number.
;-------------
; release key
release_key:
        xor     ax,ax
        mov     [access],55h;           set enable flag
        mov     [first_time],55h;               set first time flag
        jmp	fun30_exit
disable_os:
        xor     ax,ax
        mov     [access],al
        jmp	fun30_exit
enable_os:
        xor     ax,ax
        mov     [access],55h;           set enable flag
fun30_exit:
	ret	
function30      endp
;*****************************************************
; get_new_access_key
;
;
; return        cx,bx = access key value
;
accesskey       proc
	push	dx    
        mov     ah,2ch;                 get system Time
        int     21h;                    returns in cx,dx
        mul     dx
        add     ax,cx
        mov     cx,ax
        mov     access_key[0],cx
        mov     access_key[2],dx
	mov	bx,dx
	pop	dx
        ret;
accesskey       endp
;
subttl "subprogram section Called from functions.'
page
;***************************************************************************
; get page segment address
;
;	sub program is call at initization
;
get_page_seg    proc
	push	bx
        push	ax
	mov	ax,[page_frame_segment];	base segment address
	mov	[page0_seg],ax
	mov	bx,400h;			
	add	ax,bx
	mov	[page1_seg],ax
	add	ax,bx
	mov	[page2_seg],ax
	add	ax,bx
	mov	[page3_seg],ax
	pop	ax
	pop	bx
	ret
get_page_seg	endp
;**************************************************************************
; check_handle_pages
;
; Will check for valid handle number and the if the logical page number was
; allocated to the handle.
;
; entry:        bx =    logical page number (zero rel) 
;               dx =    handle;    
;
; return:       ax = 0	 handle found and logical page number was allocated
;		ax = 83h handle not found
;		ax = 8ah logical page out of range
;
check_handle_pages  proc  near

        push	cx;
	push	dx
	push	bx
	push    bx;     
        mov     cx,OPEN_HANDLES
        cmp     dl,cl;          check if valid handle number 
        ja      badhandle
        xor     ax,ax
        mov     al,type handle_dir_struct ;   offset value
        mul     dl              
        lea     bx,handle_dir_struct; start address of dir struct.
        add     bx,ax
        mov     al,BYTE PTR[bx];        get status byte for the handle
        cmp     al,0ffh;                if al=ff then handle is inuse
        jz      lpage
badhandle:
        mov	ax,8300h		;error
        pop     bx
        pop	bx
	pop	dx
	pop	cx
        ret
lpage:  mov     dx,bx;          move structure address to dx
        pop     bx;             restore logical page number
        xchg    dx,bx
        inc     bx;             point to size
        mov     al,[bx]
	cmp	dx,-1;		set for Unmap
	jz	correct_pg
        cmp     dl,al;          DL must be Equal or less than value in al

	Jbe	CORRECT_PG
	mov	ax,8a00h
	jmp	chpexit
CORRECT_PG:
        xor	ax,ax;		set ax to zero
chpexit:
        pop     bx
	pop	dx
	pop	cx
        ret;
check_handle_pages endp
;***************************************************************************
; allocate_next_handle
;
; will allocate next free handle.
;
; enter:        bx   number of pages to allocate to the page.
;
; return:       dx      handle number.
;               dx   =  0 if error
;
allocate_next_handle    proc    near
        push    ax
        push    cx
        push    si
        push    bx;             save number of pages so that we can get them when needed
        mov     cx,MAXHANDLES	;     count buffer
        xor     ax,ax
        xor     bx,bx
        mov     dx,ax
        mov     bl,type handle_dir_struct
        lea     si,handle_dir_struct
free:   add     si,bx;                  add status offset to point to handle 1
        inc     dl;                     current handle number
        cmp     al,[si]
        loopnz  free;                   loop till first free handle
        jz      found
        ;-------------- error no free handles ?
        xor     dx,dx
	pop	bx
        jmp     ex
found:  mov     byte ptr[si],-1;        set in use flag
        pop     bx;                     get number of pages,  bh = 0 bl = number of pages
        inc     si;                     offset
        mov     [si],bl;
        INC	OPEN_HANDLES
        sub     [free_pages],bl		;subtract allocated pages
        inc     si;                     set pointer to handle_dir_struct.first
	cmp	bl,0
	jz	ex;			Zero Pages Requested.
        call    setup_fat;              mark up the structure location (first) and
        ;                               fat locations that they are in use
ex:     pop     si
        pop     cx
        pop     ax
        ret
allocate_next_handle    endp



;***************************************************************************
; DEALLOCATE PAGES FROM HANDLE
;       
;               DELETES PHYSICAL PAGES ASSIGNED TO A HANDLE
; enter         dx = handle
;		CX <> 0 = # OF PAGES TO DELETE (MUST <= THE TOTAL #)
;		CX = 0 DETELE ALL PAGES ASSIGNED TO HANLED
; return        BX = HANDLE'S DIR STRUCTURE
;		CARRY = 1 IF ERROR
;
;
PAGES_delete proc

;UNASSIGN ANY MAPPED PAGES ASSIGNED TO THIS HANDLE
	PUSH	AX
	PUSH	DX
	PUSH	CX
	MOV	CX,NUM_PHY_PAGES
	LEA	BX,PHY_PAGE0		;
OPENHAN10:
	CMP	[BX].PAGE_HANDLE,DX	;DOES THIS PAGE BELONG TO THIS HANDLE
	JNE	OPENHAN20
	MOV	[BX].PAGE_HANDLE,-1	;CLEAR ENTRY
	MOV	[BX].LOGICAL_PAGE,0	;CLEAR ENTRY
OPENHAN20:
	ADD	BX,TYPE PHY_PAGE_DIR
	LOOP	OPENHAN10

;DELETE CX PAGES
	POP	CX
	MOV	BX,OFFSET HANDLE_DIR_STRUCT	;START OF THE HANDLE DIRECTORY
	MOV	AX,TYPE HANDLE_DIR		;BYTES PER ENTRY
	MUL	DX				; * HANDLE
	ADD	BX,AX				;BX = POINTER FOR THIS HANDLE
	PUSH	BX
	CMP	STATUS[BX],-1			;IS THIS HANDLE IN USE?
	STC
	JNE	PG_T99				;NO, RETURN ERROR
	OR	CX,CX				;DETELE ALL ASSIGNED PAGES?
	JNZ	PG_T10				;NO, CL PAGES
	MOV	CL,NUM_PAGES[BX]		;YES, SET CL = # OF PAGES
	OR	CL,CL				;DOES HE HAVE ANY PAGES?
	JZ	PG_T50				;NO. DONE
PG_T10: ADD	FREE_PAGES,CL			;ADD TO THE POOL
	SUB	NUM_PAGES[BX],CL

;FREE PAGES IN THE FAT
	PUSH	SI
	MOV	AL,FIRST[BX]			;OFFSET TO THIS HANDLE'S 
	MOV	AH,0				; 1ST PAGE 
	MOV	BX,OFFSET LOGICAL_PAGE_FAT	;ADDRESS FAT
	JZ	PG_T40				;JUMP IF WE'RE FREEING ALL PGS

;KEEP THE 1ST NUM_PAGES AND FREE THE REST
	MOV	CL,NUM_PAGES[BX]
	MOV	CH,0
PG_T30:	MOV	SI,AX				;ADDRESS 1ST PAGE
	MOV	AL,[BX+SI]
	LOOP	PG_T30
	MOV	BYTE PTR [BX+SI],-1		;MARK LAST
PG_T40:	MOV	SI,AX				;ADDRESS 1ST PAGE TO BE FREED
	MOV	AL,[BX+SI]
	MOV	[BX+SI],AH			; (0) FREE IT
	CMP	AL,-1				;WAS THIS THE LAST?
	JNE	PG_T40				;NO
	POP	SI
PG_T50:	CLC
PG_T99: POP	BX
	POP	DX
	POP	AX
        ret
PAGES_delete endp

PAGE
;***************************************************************************
; ALLOCATE PAGES TO A HANDLE
;       
;               ADDS PAGES TO A HANDLE
; enter         bx = pointer to handle's dir entry
;		CX > 0 = # OF PAGES TO ADD
; return	AX = IF GOOD
;		   = 8300H - BAD EMM HANDLE
;		   = 8700H - NOT ENOUGH PAGES IN SYSTEM
;		   = 8800H - NOT ENOUGH UNALLOC. PAGES 
PAGES_ADD proc
	CMP	STATUS[BX],-1			;IS THIS HANDLE IN USE?
	MOV	AX,8300H
	JNE	PA_T99				;NO, RETURN ERROR
	CMP	CL,MAX_PAGES			;ARE THERE ENOUGH IN THE SYSTEM
	MOV	AX,8700H
	JA	PA_T99
	CMP	CL,FREE_PAGES			;ARE THERE ENOUGH UNALLOC?
	MOV	AX,8800H			
	JA	PA_T99				;NO
	SUB	FREE_PAGES,CL			;SUB FROM UNALLOC. COUNT
	MOV	AL,NUM_PAGES[BX]		;CURRENT NUMBER OF PAGES
	ADD	NUM_PAGES[BX],CL		;ADD CL PAGES TO HANDLES COUNT

;FIND THE HANDLES LAST PAGE
	PUSH	DI
	PUSH	SI
	LEA	SI,LOGICAL_PAGE_FAT		;SI = FAT POINTER		
	LEA	DI,FIRST[BX]			;DI=HANDLE'S LOG. PAGE POINTER
	XOR	AH,AH
	CMP	AL,0				;HAVE ANY PAGES BEEN ALLOC.?
	JE	PA_T05				;NO	
PA_T03:	MOV	AL,BYTE PTR [DI]		;LAST PAGE?
	CMP	AL,-1				;*
	JE	PA_T05				;YES
	MOV	DI,SI				;NO, POINT DI TO NEXT LOG. PAGE
	ADD	DI,AX				;
	JMP	PA_T03

;DI=POINTER TO HANDLES CURRENT LAST PAGE
;FIND 1ST FREE PAGE IN THE FAT 
PA_T04:	INC	SI
PA_T05:	CMP	BYTE PTR[SI],0			;IS THIS ENTRY FREE?
	JNZ	PA_T04				;NO, CHECK NEXT
	MOV	AX,SI				;SET AL = PAGE #
	SUB	AX,OFFSET LOGICAL_PAGE_FAT	;*
	MOV	[DI],AL				;SET FAT ENTRY
	MOV	DI,SI				;SAVE POINTER
	LOOP	PA_T04				;LOOP FOR ALL PAGES
	DEC	BYTE PTR[SI]			;FLAG NEW LAST PAGE
	XOR	AX,AX				;GOOD
	POP	SI
	POP	DI
PA_T99:	ret
PAGES_ADD endp



;***************************************************************************
; find_handle_name_loc
;
; enter:        dx      handle
;
; return        ds:si   points to handle name loc address
;
;
find_handle_name_loc    proc    near

        push    bx;     
        mov     cx,MAXHANDLES
        xor     ax,ax
        mov     al,type handle_dir_struct;   offset value
        mul     dl              
        add     al,handle_name
        lea     bx,handle_dir_struct; start address of dir struct.
        add     bx,ax;                  bx points to name address location
        mov     si,bx;                  ds points to the correct data segment.
        pop     bx;
        ret
find_handle_name_loc    endp


;***************************************************************************
; BUILD 24 BIT ADDRESS  THIS FUNCTION IS ONLY GOOD FOR MEMORY 1MEG AND LESS
;
;                       MAX ADDRESS   FFFF:FFFF = 10FFEF OR 1.114095 MEG
;
; enter         es:si = segment:offset address to convert
;
; return        ax = lo word value
;               dh = high byte
;
;
;build_24_bit_address proc
;        ;
;        mov     ax,es
;        mov     dh,ah;                  build high byte of 24 bit address
; 	 shr     dh,4;		        use only high nibble shift 4
;        shl     ax,4;        		strip high nibble from ax
;        add     ax,si;                  add offset to develop low word
;        adc     dh,0;                   adjust high byte if carry from low
;        ret;                            
;build_24_bit_address endp


;*****************************************************************************
; setup GDT_DEF
;                       clear area with zero's
;                       move source and target structures into GDT_DEF locations
;
setup_gtd_struct proc
        pusha
        mov     bx,OFFSET gdt_struct
        xor     ax,ax;			fill structure with zero's
	mov	cx,TYPE GDT_STRUCT   ;   size of structure  
x1:     mov     [bx],al
	inc	bx
        loop    x1
	mov	bx,offset source_struct;	point to source_structure
	mov	cx,2
x2:	mov	word ptr[bx],16384;		size of page
		;				setup source structure on the 
		;				first loop and the target structure
	        ;				on the second loop.
	mov	byte ptr[bx.data_acc_rights],93h
	mov	bx,offset target_struct
	loop	x2
        popa
        ret
setup_gtd_struct  endp
;***************************************************************************
; get phyical page address
;
; enter:        al = page number 0 -3
;
; return:       ax = low word
;               dh = Hi byte      24 bit address
;
;       NO ERROR CHECKING IS DONE !
;
get_phy_page_address proc
        push    bx
        xor     ah,ah;                  set upper byte to 0
	MOV	BX,PAGE_SIZE
        IMUL    BX			;DL.AX = OFFSET
        mov     BX,[page_frame_segment]
	MOV	DH,BH
	SHR	DH,4
	SHL	BX,4
	ADD	AX,BX
	ADC	DH,DL			;DH.AX = ADDRESS
	POP	BX
        ret
get_phy_page_address endp
;**************************************************************************
; get logical page address    RETURNS A 24 BIT TRUE ADDRESS.
;
; enter:        al = page number      
;               dx = handle number
;
; return:       ax = Low word
;               dh = High byte    dl =lost
;
;       NO ERROR CHECKING IS DONE !
;     handle dir struct -> ds:si
;-----------------------------------------------------------
; logical page address start above the first meg location so the standard addressing
; mode segment:offset does not work. What is done is there are 3 meg of extended memory
; available on the VLSI board. 
; 
get_log_page_address proc

        push    bx
        push    cx
        push    si
        push    es
        push    ax
        lea     si,HANDLE_DIR_STRUCT.first;           point to Handle page zero
        ;                                               Logical page number
        MOV     AL,DL
        mov     bh,TYPE HANDLE_DIR;             number of bytes in each structure entry
        xor     ah,ah;                          AL HAS handle NUMBER
        mul     bh;                             this value will be multiplied by the address in
        add     si,ax;                             si register
 	   ;            AH = HANDLE PAGE NUMBER VALUE 0 REL
           ;            HANDLE_DIR_STRUCT.FIRST WILL POINT TO THE FIRST LOGICAL
           ;            PAGE THAT IS USED BY THE HANDLE. THE FAT WILL POINT TO 
           ;            THE NEXT LOGICAL PAGE. THE LAST PAGE WILL BE
           ;            MARKED WITH 0FFhex.
           ;
        mov     al,[si];                     get page 0 true logical page number.
        pop     cx;                             pop ax value to cx
	mov	ch,0
        cmp     cl,0;                           page 0 ?
        jz      found_log_page
READ_NEXT:				
        lea     bx,logical_page_fat;            get address of the FAT
        add     bx,ax;                          point to the second logical page used by this handle
        inc     ch;                             find next logical page will have to search all 
                  ;                             of the handles pages untill the one requested is
        mov     al,[bx];                     located.
	
        cmp     ch,cl;                          have we found it ?
        jz      found_log_page;                 yes
        jmp     read_next 
found_log_page:;
	cmp	al,-1;				are we at the last page?
	jnz	not_last
	dec	bx
	mov	al,[bx]
	add	al,1
not_last:
        xor     dx,dx;                          now compute the 24 bit address for the logical page.
        xor     ah,ah;                          clear upper byte, AL has logical page number
        mov     bx,16384;                       page size
        mul     bx;                             compute low_word
        add     dl,high_byte;                  hi_byte is in DL and Low_word in AX
        mov     dh,dl
        pop     es
        pop     si
        pop     cx
        pop     bx
        ret
get_log_page_address endp
;****************************************************************************
; check handle
;
; enter         dx = handle
;
; return        zero flag set if good
;		al = number of pages allocated
;
check_handle  proc  near

        push	cx
	push	dx
	push	bx
	mov     cx,MAXHANDLES
        cmp     dl,cl;          check if valid handle number 
        jg      badh
        xor     ax,ax
        mov     al,type handle_dir_struct;   offset value
        mul     dl              
        lea     bx,handle_dir_struct; start address of dir struct.
        add     bx,ax
        mov     al,[bx];        get status byte for the handle
        cmp     al,-1;		see if handle is in use
	mov	al,[bx.num_pages]
badh:
        pop	bx
	pop	dx
	pop	cx
        ret
CHECK_HANDLE    ENDP
;*****************************************************************************
; set up FAT map for new handle OR reallocate
;
; called from:  allocate_next_handle
;
;
; enter:        si -> handle_dir_struct.first OR Last Fat Entry if Reallocate pages
;               bl =  requested pages
;
; return:       none    si,bl nochange
;
;     NO ERROR CHECKING DONE !
;
setup_fat proc
        push    si
        push    bx
        push    cx
        push    ax
        push    dx
        mov     al,bl;          move requested pages to AL
        xor     bx,bx;          enter find_fat_free with bx = 0 so it know its 
        ;                       the first time in.
        call    find_fat_free;  will return in bx pointer to a free FAT entry
                             ;  and in cl Logical page number.
        mov     cs:[si],cl;     set first to the logical page number
        dec     al
        jz      last_page
next_fat_page:
        mov     si,bx;          save pointer to fat entry
        call    find_fat_free;  will return in bx pointer to a free FAT entry
                             ;  and in cl Logical page number.
        mov     cs:[si],cl;        move this free fat location in the last one found
                       ;        so it points to the next one
        dec     al
        jz      last_page
        jmp     next_fat_page
last_page:
        mov     ah,-1
        mov     [bx],ah;        mark the last one found as the end.
        pop     dx
        pop     ax
        pop     cx
        pop     bx
        pop     si
        ret
setup_fat endp

logical_page_number     db      0
fat_loc                 dw      0
;========================================
; enter with bx = 0 the first time in.
;
find_fat_free proc
        cmp     bx,0
        jnz     not_first_time
        mov     bx,OFFSET logical_page_fat;
        mov     cl,0;                           logical page 0
        jmp     fat
not_first_time:
        mov     bx,[fat_loc];                   address of the last fat location used
        inc     bx;                             move to next fat location
        mov     cl,[logical_page_number];       last logical page used
	inc	cl;				next page number
fat:;                           
        cmp     BYTE ptr [bx],00
        jz      found_free
        inc     bx
        inc     cl
        jmp     fat
found_free:
        mov     [fat_loc],bx
        mov     [logical_page_number],cl
        ret

find_fat_free endp      
;**********************************************************************
; set up phyical page directory entrys
; 
; there are 4 phyical pages 0-3 and 4 directory entrys
; the structure format is:
;
;			page_handle	dw;	the handle value of the owning handle
;			logical_page	db;	logical page value in ref to handle
;  enter:
;		dx = handle
;		bl = logical page value (0-max that the handle owns or 255)
;		al = phyical page value (0-3)
;
;  return:	none,   all registers saved.
;
;	NO ERROR CHECKING IS DONE !!!!
;
set_phy_page	proc
	push	si	
	cmp	al,0
	lea	si,phy_page0
	jz	write_to_struct
	cmp	al,1
	lea	si,phy_page1
	jz	write_to_struct
	cmp	al,2
	lea	si,phy_page2
	jz	write_to_struct
	lea	si,phy_page3
write_to_struct:
	mov	[si],dx;			move handle value to structure
	inc	si
	inc	si;			point to logical_page location
	mov	[si],bl
	pop	si
	ret
set_phy_page	endp


;*************************************************************************
; get logical page value 
;
; used in unmapping
;
; enter:	al = phyical page
;		dx = handle requesting unmap
; return:	bx = logical page value 
;		bx = -1 if handle does not own the phy page
;
get_log_value	proc
	push	si
	cmp	al,0
	lea	si,phy_page0
	jz	read_struct
	cmp	al,1
	lea	si,phy_page1
	jz	read_struct
	cmp	al,2
	lea	si,phy_page2
	jz	read_struct
	lea	si,phy_page3
read_struct:
	mov	bx,[si]	;			get handle value
	cmp	bx,dx
	jnz	error_handle
	inc	si
	inc	si
	xor	bx,bx
	mov	bl,[si]
	pop	si
	ret
error_handle:
	mov	bx,-1
	pop	si
	ret
get_log_value	endp
page
SUBTTL "DATA STORAGE SECTION OF DRIVER."
;****************************************************************
; Data storage section of the TSR section of the driver.
; last section of code.
;
;

sign_on         db	lf,cr
		db      'ͻ',cr,lf
                db      ' LIM 4.0 Expanded Memory Manager  ',cr,lf
                db      ' Version ',PROG_VER,'   ',PROGRAM_DATE,'   ',cr,lf
                db      '     VLSI TECHNOLOGY, INC.        ',cr,lf
                DB      'ͼ',cr,lf,eom
copyright	db	'COPYRIGHT 1989 VLSI TECHNOLOGY, INC.'
programmer      db      'Randy S. Stultz,     Moonlighting Software.'
sign_off        db      'Have a good day.',cr,lf,eom
high_byte	db	emmhi_byte
page_frame_segment      dw      ?		;base address of page frame. 
						; size of the frame is 64k,
						; will have 4 16k pages.
total_pages             db      ?		;default at max for on board 
						; memory. value will change at
						; startup if there is a 
						; difference in memory size.
OPEN_HANDLES            dw      ?		; current number IN USE
free_pages              db      ?		; NUMBER AVAILABLE
old_ds                  dw      ?
old_si                  dw      ?
old_es                  dw      ?
old_di                  dw      ?
old_ax                  dw      ?
old_bx                  dw      ?
old_cx			dw	?
old_dx			dw	?
old_bp			dw	?
flags			dw	?
temp			dw	?
page0_seg		dw	?
page1_seg		dw	?
page2_seg		dw	?
page3_seg		dw	?
error_flags             db      ?;    will be set to standard LIM 4.0 Errors
                         ;      00h .........No error
                         ;      80h .........Memory Manager software error.
                         ;      81h .........Expanded memory hardware error.
                         ;
access_key              dw 2 dup(?)
first_time              db 55h
access                  db 55h
phy_page0             phy_page_dir      <-1,0>
phy_page1             phy_page_dir      <-1,0>
phy_page2             phy_page_dir      <-1,0>
phy_page3             phy_page_dir      <-1,0>
;register0	      phy_page_dir	4 dup(<-1,0>)
subttl	"Structures. The sizes may change."
page
;******************************************************************************
;              NOTE:   do not change any thing in this area
;			there are ORG statments that change the addressing structure
;			of the program and must stay this way      
;
gdt_struct      gdt_def <0,0,,,0,0>
gdt_end		equ $
	;
        ORG gdt_struct.source;	this will setup the structure addressing correctly
	;			so that changes made to source_struct will be done 
	;			in the 'gdt_struct.source_struct'
	;
source_struct    source_target  <16384,0,0,93h.0>;
	;
        ORG gdt_struct.target;
	;
target_struct    source_target  <16384,0,0,93h,0>
	;
	ORG  gdt_end
;------------------------------------------------------------------------------
handle_dir_struct       handle_dir       maxhandles dup(<?>);      copy structure for the maxhandles
logical_page_fat        db      max_pages dup(0);        0 = free, 0ffh = last page allocated for this handle
                        db      'Driver_end'
DRIVER_END      DW      $;      LAST ENTRY OF DRIVER CODE. DO NOT ADD ANY MODULE
                ;               AFTER THIS LOCATION, OR IT WILL BE LOST
	subttl	'Temp data section '
	page
;-----------------------------------------------
; THIS DATA SECTION IS LOST AFTER INSTALL.
;
NOWINDOW	DB	'Error: Specified EMS segment is write-protected',cr,lf
		DB	'       May be configured as Shadow Ram',cr,lf,eom
membad		DB	'Error: Cannot read/write the EMS segment',cr,lf
		DB	'       Shadow Ram Map jumper may be incorrect',cr,lf,eom		 
noexpmem        db      'Error: No expanded Memory found !',cr,lf,eom
ver_old         db      'Wrong Dos version. Must be 3.0 or greater.',cr,lf
not_installed   db      'LIM Driver not installed !',cr,lf,eom
software        db      'Error: Software Error found when installing.',cr,lf,eom
Hardware        db      'Error: Hardware Error found when installing.',cr,lf,eom
memoryerror     db      '       Memory test of physical pages location was found to have errors.',cr,lf,eom
expmemerror     db      '       Memory test of Logical pages location was found to have errors.',cr,lf,eom
expanderror     db      '       Invalid amount of expanded memory reported by system.',lf,cr,eom
installed       db      'Installed driver with '
ipages          db      '    '
ipage_end       equ     $-1
                db      ' pages.',cr,lf
		db	'4 Physical pages @ segment:    '
iseg_end	equ	$-1
		db	cr,lf,eom
bad_option      db      cr,lf,07h,'Bad Command Line option. Page Frame Segment address will stay at the',cr,lf
                db      'default of E000 hex.',cr,lf
		db	'Syntax:   DEVICE = VEMM.SYS /B:E000',CR,LF
		db	'                               D000',cr,lf
		db	'                               C000',cr,lf
		db	'                               B000',cr,lf
		db	'                               A000',cr,lf
		db	'                               ????',CR,LF,eom
bad_int_vect    db      'Could not install new interrupt vector address for INT 67h',cr,lf,eom
CMD_LINE_MSG	DB	'CONFIG.SYS COMMAND LINE ADDRESS = '
SEG_ADR_MSG	DB	'0000:'
OFF_ADR_MSG	DB	'0000',LF,CR,EOM
WPMASK		DB	10H ;MASK FOR TESTING THE READ ENABLE AND WRITE PROT.
;---------------------------------------------
handle0_name	db	'VLSI_EMM'
;
subttl "setup.asm"
page
;*******************************************************************
; This section of code will set up all required memory structures and
; do the required memory checks to see if and how much memory is installed
; 
; This section of code will be lost after the installation is complete.
;
;
;
setup   proc    near
        pusha;                  save all registers
	call	cmd_line
	JC	ERR1
        mov     ah,30h
        int     21h;            get dos version number.
        cmp     al,3;           must be greater that 3.0
        jae     version_ok
        mov     dx,OFFSET ver_old
ERR1:   jmp     errormsg_exit

version_ok:
        mov     ah,88h;         check for memory above 1024k
        int     15h
        or      ax,ax;          we are assuming that if memory is installed
        jnz     extended_mem;   there is at least 16k (one page)
        mov     dx,OFFSET noexpmem
        jmp     errormsg_exit

extended_mem:
	xor     dx,dx;                  clear out registers
        mov     bx,16;                  page size
        div     Bx
        mov     [total_pages],al;               move number of pages in memory 
        mov     [free_pages],al;                set up free page value
        xor     dx,dx
        mov     cx,10;                          base 10
        lea     si,ipage_end
        call    BIN_TO_ASC
        xor     al,al
        mov     [error_flags],al;                       clear error flag
;
; CHECK SHADOW RAM READ ENABLE/WRITE PROTECT FLAGS
;
	CMP	WPMASK,0	;ARE WE USING CONV. RAM AS THE EMS WINDOW
	JE	CONT1
	CLI
	MOV	CX,9		;READ READ ENABLE AND WRITE PROTECT BITS
WP1:	IN	AL,09FH		; FROM THE 82C202 (8+1 TIMES) 	
	LOOP	WP1
	MOV	AH,AL		;SAVE READ ENABLE BITS
	IN	AL,09FH		;READ THE WRITE PROTECT BITS
	STI
	TEST	AL,WPMASK	;IF WRITE PROTECTED, ASSUME IT'S ROM SHADOW
	JZ	WP2		;OTHERWISE WE CAN USE IT.
	MOV	DX,OFFSET NOWINDOW
	JMP	ERRORMSG_EXIT
WP2:	OR	AH,WPMASK	;MAKE SURE IT'S READ ENABLED
	XCHG	AL,AH		;SWAP TO WRITE BACK
	MOV	CX,9
	CLI
WP3:	OUT	9FH,AL		;WRITE THE NEW READ ENABLES (8+1 TIMES)	
	LOOP	WP3
	MOV	AL,AH
	OUT	9FH,AL		;WRITE THE NEW WRITE PROTECTS
	STI

;TRIVIAL TEST OF THE EMS WINDOW
;
	PUSH	ES
	MOV	AX,PAGE_FRAME_SEGMENT
	MOV	ES,AX
	MOV	CX,0		;64KB
	MOV	BX,0
MEMT1:	MOV	ES:[BX],BL	;WRITE A PATTERN
	INC	BX
	LOOP	MEMT1
	MOV	BX,0
MEMT2:	CMP	ES:[BX],BL
	JNE	MEM_FAIL
	INC	BX
	LOOP	MEMT2
	POP	ES
	JMP	CONT1
MEM_FAIL:
	POP	ES
	MOV	DX,OFFSET MEMBAD
	JMP	ERRORMSG_EXIT


CONT1:
; set interrupt vector
;
        mov     ax,2567h;               function 25h interrupt number 67h
        lea     dx,drv67
        int     21h;		address in DS:DX
        mov     ax,3567h;               check vector value
        int     21h;		returns address in ES:BX
        cmp     dx,bx;		compare offset addresss
        jz     offsetok
	jmp	bad_int
offsetok:
        mov     bx,es;		compare segment address
        mov     dx,ds
        cmp     dx,bx;		should be zero
        jz     interrupt_ok
bad_int:
        mov     dx,offset bad_int_vect
        jmp     errormsg_exit
interrupt_ok:
	mov	ax,cs
	mov	ds,ax;			reset data segment just incase
;-------------------------------------------------------- 
; set Cmos ram extended memory size storage location to 0 
; interrupts must be turned off during this section. 
; 
	cli;				turn off interrupts 
	mov	al,30h 
	out	70h,al 
	mov	al,0 
	out	71h,al;			set low order byte to 0 
	mov	al,31h 
	out	70h,al 
	mov	al,0 
	out	71h,al;			set high order byte to 0 
	sti;				restore interrupts 
;---------------------------------------------------------
; Set up HANDLE_DIR_STRUCT
;	for DOS handle 0.
;	Inital setup will be with 24 pages allocated.
;
	MOV	AL,0
	MOV	BX,OFFSET HANDLE_DIR_STRUCT
	mov	STATUS[BX],0FFH			;set status to In use
	mov	NUM_PAGES[BX],HANDL_0_PGS 	;handle zero pages
	mov	FIRST[BX],AL			
	MOV	[OPEN_HANDLES],1		;INIT OPEN HANDLE COUNT
	SUB	[FREE_PAGES],HANDL_0_PGS	;DEC THE FREE PAGE COUNT

	MOV	BX,OFFSET LOGICAL_PAGE_FAT	;
	MOV	CX,HANDL_0_PGS			;INITIAL THE FAT
	DEC	CX
	JS	FINIT1				;JUMP IF NO PAGES ASSIGNED
	JMP	FINIT2				;START LOOP END (1 PAGE CASE)
FAT_INIT:					;
	INC	AL				;
	MOV	[BX],AL				;
	INC	BX				;
FINIT2:	LOOP	FAT_INIT			;
	MOV	BYTE PTR[BX],0FFH		;MARK THE END
FINIT1:	lea	si,handle0_name
	lea	di,handle_dir_struct.handle_name
	PUSH	DS
	POP	ES					;set the ES to DS
	mov	cx,8					;move 8 bytes
	rep	movsb					;move name.
	;
	call	get_page_seg;				setup page segments
;--------------------------------------------------------
        mov     ah,9
        mov     dx,OFFSET sign_on
        int     21h
        mov     ah,9
        mov     dx,OFFSET installed
        int     21h
        popa
        ret
errormsg_exit:
        mov     ah,9
        int     21h
ERR_EXT1:
        mov     ah,9
        mov     dx,OFFSET not_installed
        int     21h
        mov     ah,9
        mov     dx,OFFSET sign_off
        int     21h                     
        popa
        ret
setup   endp
;*******************************************************
; Cmd_Line
; THIS SETS THE VARIABLE "PAGE_FRAME_SEGMENT" & "WPMASK"
;
;	Syntax is:
;	DEVICE = VEMM.SYS /B:E000  DEFAULT
;			    :D000
;			    :C000
;			    :B000
;			    :A000
;			    :????  FOR 12MHZ CHIPSET - CONV. MEMORY IS USED  
;
cmd_line	proc
	les	di,[rh_ptr]
	les	di,es:[di+18];		Now the ES:DI registers have the address
	mov	dx,0E000H

find_delimiter:
	mov	al,es:[di]
	inc	di
	cmp	al,'/';	
	jz	found_delimiter
	cmp	al,lf;			check for end of line
	jz	NEW_BASE
	cmp	al,cr;
	jnz	find_delimiter
found_delimiter:
	cmp	BYTE PTR es:[di],'B';		BaseSeg address
	jz	Base_seg

	;----------------------------------------
	; Error on command line.
cmd_Error:
	lea	dx,bad_option
	STC
	ret

Base_seg:
	inc	di
	cmp	BYTE PTR es:[di],':'
	jnz	cmd_Error
	inc	di
	mov	al,es:[di]
	mov	dx,0E000H
	cmp	al,'E'
	jz	new_base
	mov	dx,0D000h
	SHR	WPMASK,1
	cmp	al,'D'
	jz	new_base
	mov	dx,0C000h
	SHR	WPMASK,1
	cmp	al,'C'
	jz	new_base
	mov	dx,0B000h
	SHR	WPMASK,1
	cmp	al,'B'
	jz	new_base
	mov	dx,0A000h
	SHR	WPMASK,1
	cmp	al,'B'
	jz	new_base
	cmp	al,'?'
	jnz	cmd_error
	MOV	WPMASK,0		;12MHZ CHIPSET - USE CONV. MEMORY
	MOV	DX,OFFSET DRIVER_END	;SET BASE TO DRIVER END
	SHR	DX,4			;*
	INC	DX			;*
	MOV	AX,CS			;*
	ADD	DX,AX			;*
new_base:
	mov	[page_frame_segment],dx
	mov	ax,dx
        xor     dx,dx
        mov     cx,16;                          base 10
        lea     si,iseg_end
        call    BIN_TO_ASC
	CLC
	RET
cmd_line	endp

;
; Convert 32 bit binary value to ASCII string.
;
; Call with  DX:AX = signed 32 bit value
;            CX    = radix
;            SI    = last byte of area to store resulting string
;                    (make sure enough room is available to store
;                     the string in the radix you have selected.)
;
; Destroys AX, BX, CX, DX, and SI.
;
bin_to_asc proc            ;convert DX:AX to ASCII.
                                ;force storage of at least 1 digit.
        mov     byte ptr [si],'0' 
        or      dx,dx           ;test sign of 32 bit value,
        pushf                   ;and save sign on stack.
        jns     bin1            ;jump if it was positive.
        not     dx              ;it was negative, take 2's complement
        not     ax              ;of the value. 
        add     ax,1
        adc     dx,0
bin1:                           ;divide the 32 bit value by the radix 
                                ;to extract the next digit for the
                                ;forming string.
        mov     bx,ax           ;is the value zero yet?
        or      bx,dx
        jz      bin3            ;yes, we are done converting.
        call    divide          ;no, divide by radix.
        add     bl,'0'          ;convert the remainder to an ASCII digit.
        cmp     bl,'9'          ;we might be converting to hex ASCII,
        jle     bin2            ;jump if in range 0-9,
        add     bl,'A'-'9'-1    ;correct it if in range A-F.
bin2:   mov     [si],bl         ;store this character into string.
        dec     si              ;back up through string,
        jmp     bin1            ;and do it again.
bin3:                           ;restore sign flag,
        popf                    ;was original value negative?
        jns     bin4            ;no, jump
                                ;yes,store sign into output string.
        mov     byte ptr [si],'-'
bin4:   ret                     ;back to caller.
bin_to_asc endp
;
;
; General purpose 32 bit by 16 bit unsigned divide.
; This must be used instead of the plain machine unsigned divide
; for cases where the quotient may overflow 16 bits (for example,
; dividing 100,000 by 2).  If called with a zero divisor, this
; routine returns the dividend unchanged and gives no warning.
;
; Call with DX:AX = 32 bit dividend
;           CX    = divisor
;
; Returns   DX:AX = quotient
;           BX    = remainder
;           CX    = divisor (unchanged)
;
divide  proc    near            ; Divide DX:AX by CX
        jcxz    div1            ; exit if divide by zero
        push    ax              ; 0:dividend_upper/divisor
        mov     ax,dx
        xor     dx,dx
        div     cx
        mov     bx,ax           ; BX = quotient1
        pop     ax              ; remainder1:dividend_lower/divisor
        div     cx
        xchg    bx,dx           ; DX:AX = quotient1:quotient2
div1:   ret                     ; BX = remainder2
divide  endp
	db	'COPYRIGHT 1989 VLSI TECHNOLOGY, INC.'
        db      'Randy S. Stultz,     Moonlighting Software.'
        db      'Have a good day.'
code    ends
        end
