/* keydefit.h */

/*
 * history
 * 26 apr 02: tom ehlert - creation
 */

#define NAME(x) x##_IT


#include <dos.h>
#include "mkeyb.h"

/********************************************************
 * ITALIAN keyboard mappings				*
 ********************************************************/

/* keyboard image (by arkady)

Standard layout characters+scancodes:
ͻ
~29!02@03#04$05%06^07&08*09(0A)0B-0C=0DBacksp 0E
Ķ
Tab 0Fq10w11e12r13t14y15u16i17o18p19[1A]1B      
 < 
 Caps 3Aa1Es1Fd20f21g22h23j24k25l26;27'28Enter 1C
Ķ
 Shift 2A z2Cx2Dc2Ev2Fb30n31m32,33.34/35 Shift 36 
Ķ
 Ctrl 1D Alt 38\56    Spacebar 39    \2BAlt E38Ctrl E1D
ͼ
*/

/* copied mostly from portugese,
   changed

	  3 2 #34  .  .  .
	  4 3     .  .  .
	  5 4  $   .  .  .
	  8 7  /   .  .  .
	  9 8  (   .  .  .
	 10 9  )   .  .  .
	 11 0  =   .  .  .
	 12 '  ?  #31 .  .
	 13   ^   .  .  .
	 26     #27 .  [
	 27 +  *  #29 .  ]
	 39      .  .  @
	 40      .  . #35
	 41 \  |  #28 .  .
	 43  #21  .  .  .
	 53 -  _   .  .  .
	E53 /  /   .  .  .
	 54 /  /   .  .
*/

uchar NAME(scancodetable)[] = {

 /* 2 */ PUNCT		(0x03, '2', '"'		) /*  3 2 #34  .  . . */
 /* 3 */ PUNCT		(0x04, '3',0x9C		) /*  4 3     .  . . */
//* 4 */ PUNCT		(0x05, '4', '$'		) /*  5 4  $   .  . . */
 /* 5 */       ALTGR(0x06,           '') /*  6               */
 /* 6 */ PUNCT_CTRL	(0x07, '6', '&',0x1E	) /*  7 6  &  #30 . . */
 /* 7 */ PUNCT		(0x08, '7', '/'		) /*  8 7  /   .  . . */
 /* 8 */ PUNCT		(0x09, '8', '('		) /*  9 8  (   .  . . */
 /* 9 */ PUNCT		(0x0A, '9', ')'		) /* 10 9  )   .  . . */
 /* 0 */ PUNCT		(0x0B, '0', '='		) /* 11 0  =   .  . . */
 /* - */ PUNCT_CTRL	(0x0C,'\'','?',0x1F	) /* 12 '  ?  #31 . . */
 /* = */ PUNCT		(0x0D,0x8D, '^'		) /* 13   ^   .  . . */


 /* E */       ALTGR	(0x12,               '') /* 18               */
 /* [ */ PUNCT_ALTGR	(0x1A,0x8A,0x82,     '[') /* 26     #27 .  [ */
 /* ] */ PUNCT_ALTGR	(0x1B, '+', '*',     ']') /* 27 +  *  #29 .  ] */
 /* ; */ PUNCT_ALTGR	(0x27,0x95,0x87,     '@') /* 39      .  .  @ */
 /* ' */ PUNCT_ALTGR	(0x28,0x85,0xF8,     '#') /* 40      .  . #35 */
 /* ~ */ PUNCT_CTRL	(0x29, '\\','|',0x1C	) /* 41 \  |  #28 .  . */
 /* \ */ PUNCT		(0x2B,0x97,0x15		) /* 43  #21  .  .  . */
 /* , */ PUNCT		(0x33, ',', ';'		) /* 51 ,  ;   .  .  . */
 /* . */ PUNCT		(0x34, '.', ':'		) /* 52 .  :   .  .  . */
 /* / */ PUNCT		(0x35, '-', '_'		) /* 53 -  _   .  .  . */
 /*   */ PUNCT_CTRL	(0x56, '<', '>',0x1C	) /* 86 <  >   .  .  . */
	 0
};

struct KeyboardDefinition NAME(Keyboard) = {
	"IT",                                          //char LanguageShort[4];			// "GR",                    
	"ITALY - italiano keyboardo (by tom)",  //char *Description;				// created by, "with combis"
	DRIVER_FUNCTION_NORMAL,                        //char DriverFunctionRequired;                                  
	NAME(scancodetable),                           //char *ScancodeTable;                                          
#ifdef COMBI
	{	NAME(combi1table),NAME(combi2table),NAME(combi3table),
		NAME(combi4table),NAME(combi5table),NAME(combi6table) },
#else
	{ 0 },
#endif			
	0,                                             //char DezimalDingsbums;                                        
	0,                                             //char DefaultLayoutUS;			// TRUE for russian             
	} ;
