/*
 * SMC8416 data definition
 */

#include "cfgstrgs.h"

Data_Definition IFN_8416_SMC {

	/* ------------------- */
	/* REQUIRED Attributes */
	/* ------------------- */

	DRIVER_REQUIREMENTS("smc8000","smc8000Prb",IFN_8416_SMC)

	/* -------------------------- */
	/* DEVICE SPECIFIC Attributes */
	/* -------------------------- */

	Attribute P_MEDIATYPE {
		Type Decimal Length 1;
		Mode ReadOnly;
		Default CFG_MEDIA_ETHER;
	}

	Attribute P_IOADDRESS {
		Prompt "I/O Address (200 - 380 by 20 hex) : " ;
		Type Hex Length 0x20;
		Mode ReadWrite ;
		Restrict {
			value >= 0x200 ;
			value <= 0x380 ;
			value % 0x20 == 0 ;
		} : "I/O Address must be 200 to 380 by 20 hex ";
		Default 0x340 ;
	}

	Attribute P_RAMADDRESS {
		Prompt "RAM Address (0xC0000 to 0xEC000 by 0x2000 hex) : " ;
		Type Hex Length 0x2000;
		Mode ReadWrite ;
		Restrict {
			value >= 0xC0000 ;
			value <= 0xEC000 ;
			value % 0x2000 == 0 ;
		} : "RAM Address must be 0xC0000 to 0xEC000 by 0x2000 hex" ;
		Default 0xC8000 ;
	}

	
	Attribute P_ROMADDRESS {
		Prompt "ROM Address (0xC0000 to 0xEE000 by 0x2000 hex) : " ;
		Type Hex Length 0x2000;
		Mode ReadWrite ;
		Restrict {
			value >= 0xC0000 ;
			value <= 0xEE000 ;
			value % 0x2000 == 0 ;  
		} : "ROM Address must be 0xC0000 to 0xEE000 by 0x2000 hex" ;
		Default 0xC0000 ;
	}

	Attribute P_INTCHANNEL {
		Prompt "Int Level (2,3,5,7,10,11,15) : " ;
		Type Decimal Length 1 ;
		Mode ReadWrite ;
		Restrict {
			( value == 2 ) || 
			( value == 3 ) || 
			( value == 5 ) || 
			( value == 7 ) || 
			( value == 10 ) || 
			( value == 11 ) || 
			( value == 15 ) ; 
		} : "Interrupt Channel Must be 2,3,5,7,10,11,15" ;
		Default 15;
	}

	Attribute P_BUS {
		Type Decimal Length 1; 
		Mode ReadOnly; 
		Default 0; 
	}  

	Attribute P_DOWNLOAD {
		Type Decimal Length 1;
		Mode ReadOnly;
		Default 0;              
	}
}





