/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;

public class SELRecord {
    private int recordID;
    private byte recordType;
    private byte[] timeStamp;
    private byte[] generatorID;
    private byte evMRev;
    private byte sensorType;
    private byte sensorNumber;
    private byte eventDir;
    private byte eventType;
    private byte eventData1;
    private byte eventData2;
    private byte eventData3;
    private byte[] raw;

    public static SELRecord fromRaw(byte[] raw) {
        SELRecord selRecord = new SELRecord();
        if (raw.length != 16) {
            return null;
        }
        int b1 = raw[1] & 0xFF;
        int b0 = raw[0] & 0xFF;
        selRecord.recordID = (b1 << 8) + b0;
        selRecord.recordType = raw[2];
        selRecord.timeStamp = new byte[4];
        System.arraycopy(raw, 3, selRecord.timeStamp, 0, 4);
        selRecord.generatorID = new byte[2];
        selRecord.generatorID[0] = raw[7];
        selRecord.generatorID[1] = raw[8];
        selRecord.evMRev = raw[9];
        selRecord.sensorType = raw[10];
        selRecord.sensorNumber = raw[11];
        selRecord.eventDir = (byte)(raw[12] & 0xFFFFFF80);
        selRecord.eventType = (byte)(raw[12] & 0x7F);
        selRecord.eventData1 = raw[13];
        selRecord.eventData2 = raw[14];
        selRecord.eventData3 = raw[15];
        selRecord.raw = new byte[16];
        System.arraycopy(raw, 0, selRecord.raw, 0, 16);
        return selRecord;
    }

    public void setRecordID(int recordID) {
        this.recordID = recordID;
    }

    public void setRecordType(byte recordType) {
        this.recordType = recordType;
    }

    public void setTimeStamp(byte[] timeStamp) {
        this.timeStamp = timeStamp;
    }

    public void setGeneratorID(byte[] generatorID) {
        this.generatorID = generatorID;
    }

    public void setEvMRev(byte evMRev) {
        this.evMRev = evMRev;
    }

    public void setSensorType(byte sensorType) {
        this.sensorType = sensorType;
    }

    public void setSensorNumber(byte sensorNumber) {
        this.sensorNumber = sensorNumber;
    }

    public void setEventDir(byte eventDir) {
        this.eventDir = eventDir;
    }

    public void setEventType(byte eventType) {
        this.eventType = eventType;
    }

    public void setEventData1(byte eventData1) {
        this.eventData1 = eventData1;
    }

    public void setEventData2(byte eventData2) {
        this.eventData2 = eventData2;
    }

    public void setEventData3(byte eventData3) {
        this.eventData3 = eventData3;
    }

    public void setRaw(byte[] raw) {
        this.raw = raw;
    }

    public int getRecordID() {
        return this.recordID;
    }

    public byte getRecordType() {
        return this.recordType;
    }

    public byte[] getTimeStamp() {
        return this.timeStamp;
    }

    public byte[] getGeneratorID() {
        return this.generatorID;
    }

    public byte getEvMRev() {
        return this.evMRev;
    }

    public byte getSensorType() {
        return this.sensorType;
    }

    public byte getSensorNumber() {
        return this.sensorNumber;
    }

    public byte getEventDir() {
        return this.eventDir;
    }

    public byte getEventType() {
        return this.eventType;
    }

    public byte getEventData1() {
        return this.eventData1;
    }

    public byte getEventData2() {
        return this.eventData2;
    }

    public byte getEventData3() {
        return this.eventData3;
    }

    public byte[] getRaw() {
        return this.raw;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Record ID     = " + this.recordID + "\n");
        sb.append("Record Type   = " + ByteUtility.byteToHex(this.recordType) + "h \n");
        sb.append("Timestamp     = " + ByteUtility.fourByteToDateFormat2(this.timeStamp) + "\n");
        sb.append("GeneratorID   = " + ByteUtility.bytesToHex(this.generatorID) + "h \n");
        sb.append("EvM Rev       = " + ByteUtility.byteToHex(this.evMRev) + "h \n");
        sb.append("Sensor Type   = " + ByteUtility.byteToHex(this.sensorType) + "h \n");
        sb.append("Sensor Number = " + ByteUtility.byteToHex(this.sensorNumber) + "h \n");
        sb.append("Event Dir     = " + ByteUtility.byteToHex(this.eventDir) + "h \n");
        sb.append("Event Type    = " + ByteUtility.byteToHex(this.eventType) + "h \n");
        sb.append("Event Data 1  = " + ByteUtility.byteToHex(this.eventData1) + "h \n");
        sb.append("Event Data 2  = " + ByteUtility.byteToHex(this.eventData2) + "h \n");
        sb.append("Event Data 3  = " + ByteUtility.byteToHex(this.eventData3) + "h \n");
        sb.append("Raw data      = " + ByteUtility.bytesToHex(this.raw) + "\n");
        return sb.toString();
    }
}

