/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.task;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.task.BTask;
import com.supermicro.ipmi.task.BTaskManager;
import com.supermicro.ipmi.task.BTaskVariable;
import com.supermicro.ipmi.text.Command;
import com.supermicro.ipmi.text.CommandIncompleteException;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.MOutFactory;
import com.supermicro.ipmi.text.Parser;

public class BTaskFlow
extends BTask {
    String[][] cmdStringArray;

    public BTaskFlow(String ip, String id, String pw, String[][] cmdStringArray) {
        this.ip = ip;
        this.id = id;
        this.pw = pw;
        this.cmdStringArray = cmdStringArray;
    }

    @Override
    public void runTask() {
        Command command = null;
        this.parser = new Parser();
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(this.ip);
        config.setUserName(this.id);
        config.setPassword(this.pw);
        this.aMout = MOutFactory.createMOutInstanceWtihBufferOutput();
        MOut.addMOut(this.parser, this.aMout);
        for (int i = 0; i < this.cmdStringArray.length; ++i) {
            this.replaceVariable(this.cmdStringArray[i]);
            this.cmdString = this.cmdStringArray[i];
            this.aMout.println("\n" + (i + 1) + " >" + this.getCommandString());
            try {
                command = this.parser.parse(this.parser.getArgumentRoot(), this.cmdStringArray[i]);
            }
            catch (CommandIncompleteException e) {
                // empty catch block
            }
            if (command == null) {
                this.exitCode = 180;
                break;
            }
            if (!command.isSupportBackgroundModeForTaskRunCommand) {
                this.exitCode = 154;
                break;
            }
            command.setConfig(config);
            command.setOriginalParser(this.parser);
            try {
                command.execute();
                this.exitCode = command.getStatusCode();
                this.aMout.println("[Exit Code =" + this.exitCode + "]");
                if (command.getStatusCode() == 0) continue;
            }
            catch (Exception ex) {
                MOut.G(command).println(ex.getMessage());
            }
            break;
        }
    }

    public void replaceVariable(String[] cmdString) {
        BTaskVariable bTaskVariable = BTaskManager.getInstance().getBTaskVariable(this.taskID);
        if (bTaskVariable == null) {
            return;
        }
        String[] variables = bTaskVariable.getNames();
        for (int i = 0; i < cmdString.length; ++i) {
            for (int j = 0; j < variables.length; ++j) {
                if (cmdString[i].indexOf("$DATETIME") != -1) {
                    cmdString[i] = cmdString[i].replace("$DATETIME", ByteUtility.getDateTimeShortString());
                }
                if (cmdString[i].indexOf("$DATE") != -1) {
                    cmdString[i] = cmdString[i].replace("$DATE", ByteUtility.getDateShortString());
                }
                if (cmdString[i].indexOf("$TIME") != -1) {
                    cmdString[i] = cmdString[i].replace("$TIME", ByteUtility.getTimeShortString());
                }
                if (cmdString[i].indexOf(variables[j]) == -1) continue;
                cmdString[i] = cmdString[i].replace(variables[j], bTaskVariable.get(variables[j]));
            }
        }
    }

    @Override
    public String getMessageDisplay(boolean tag) {
        String content = "No Message";
        if (this.getMOut() != null) {
            content = this.getMOut().getBufferContent();
        }
        String result = "";
        if (tag) {
            result = "TaskID : " + this.taskID + " [" + this.getStateString() + "]" + "\n";
        }
        result = result + content + "\n";
        if (tag) {
            result = result + "TaskID : " + this.taskID + " [" + this.getStateString() + "]" + "\n";
        }
        return result;
    }

    public static void main(String[] args) {
        String a = "$AAA_CC_DDD_BBBB";
        System.out.println(a.replace("$AAA", "TODAY"));
    }
}

