/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ConfigAccessor;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMIOEMPortServiceCommand;
import com.supermicro.ipmi.stunnel.StunnelUtility;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;

public class ATENKVMCommand
extends SuperBladeCommand {
    public static final int timeout = 5;

    public ATENKVMCommand() {
        this.isSupportBackgroundModeForTaskRunCommand = false;
    }

    @Override
    public void runCommand() throws Exception {
        int vmType = 2;
        String ip = this.config.getIp();
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (IPMIMessagingCommand.isATENAspeedGUID(guid) || IPMIMessagingCommand.isSAS3_946E90GUID(guid) || IPMIMessagingCommand.isAST2400GUID(guid) || IPMIMessagingCommand.isAST2500GUID(guid) || IPMIMessagingCommand.isP8DTUGUID(guid)) {
            vmType = 0;
        }
        if (!this.isATENKVMSupported()) {
            this.printUnavailableMessage();
            return;
        }
        boolean result = GraphicsEnvironment.isHeadless();
        if (result) {
            MOut.G(this).print("No graphic environment here !");
            return;
        }
        File f = new File("iKVM.jar");
        if (!f.exists()) {
            MOut.G(this).println("Cannot find iKVM.jar");
            this.statusCode = 149;
            return;
        }
        IPMIOEMPortServiceCommand ipmiOEMPortServiceCommand = new IPMIOEMPortServiceCommand(null);
        ipmiOEMPortServiceCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        String port = "5900";
        try {
            port = String.valueOf(ipmiOEMPortServiceCommand.getPort((byte)2));
        }
        catch (IPMIException e) {
            // empty catch block
        }
        ConfigAccessor ca = new ConfigAccessor(".", "SMCIPMITool.properties");
        if (ca.getProperty("bmc_security") == null) {
            ca.setProperty("bmc_security", "on");
        }
        String isUseStunnel = ca.getProperty("bmc_security");
        boolean isStunnelSupport = ipmiOEMPortServiceCommand.checkStunnelSupport();
        boolean isIPv6 = false;
        if ("on".equals(isUseStunnel) && isStunnelSupport) {
            String kvmPort = "3520";
            boolean isDynamicPort = ipmiOEMPortServiceCommand.isDynamicStunnelPort();
            if (isDynamicPort) {
                try {
                    kvmPort = String.valueOf(ipmiOEMPortServiceCommand.getPort((byte)2));
                }
                catch (IPMIException e) {
                    kvmPort = "3520";
                }
            }
            MOut.G(this).println("This device support stunnel.");
            String OS = StunnelUtility.checkOS();
            String localIP = "127.0.0.1";
            isIPv6 = StunnelUtility.isIPv6(ip);
            if (isIPv6) {
                localIP = "::1";
            }
            if (OS.indexOf("Windows") == -1 && (localIP = StunnelUtility.getFirstNonLoopbackAddress(!isIPv6, isIPv6).getHostAddress()) == null) {
                localIP = isIPv6 ? "::1" : "127.0.0.1";
            }
            try {
                port = StunnelUtility.configAndStartStunnel(ip, localIP, "iKVM", kvmPort);
                this.startKVM(vmType, port, localIP, this.config.getUserName(), this.config.getPassword(), ip);
            }
            catch (Exception e) {
                MOut.G(this).println("Config stunnel or start stunnel fail " + e);
            }
        } else {
            ip = this.config.getIp();
            this.startKVM(vmType, port, ip, this.config.getUserName(), this.config.getPassword());
        }
    }

    public void printUnavailableMessage() {
        MOut.G(this).println("This function is unavailable for this device.");
    }

    public boolean isATENKVMSupported() {
        boolean result = false;
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (guid == null) {
            result = false;
        } else if (IPMIMessagingCommand.isATENGUID(guid) || IPMIMessagingCommand.isATENAspeedGUID(guid) || IPMIMessagingCommand.isMicroBladeNodeGUID(guid) || IPMIMessagingCommand.isATENSuperBladeGUID(guid) || IPMIMessagingCommand.isSAS3_946E90GUID(guid) || IPMIMessagingCommand.isAST2400GUID(guid) || IPMIMessagingCommand.isAST2500GUID(guid) || IPMIMessagingCommand.isP8DTUGUID(guid)) {
            result = true;
        }
        return result;
    }

    public void startKVM(int vmType, String port, String ip, String id, String pw) {
        MOut.G(this).print("Starting iKVM Process...");
        File jre = new File("jre");
        String execString = jre.isDirectory() ? (System.getProperty("os.name").indexOf("Windows") >= 0 ? ".\\jre\\bin\\java -Djava.library.path=. -jar iKVM.jar " + ip + " " + id + " " + pw + " null " + port + " 623 " + vmType + " 0" : "./jre/bin/java -Djava.library.path=. -jar iKVM.jar " + ip + " " + id + " " + pw + " null " + port + " 623 " + vmType + " 0") : "java -Djava.library.path=. -jar iKVM.jar " + ip + " " + id + " " + pw + " null " + port + " 623 " + vmType + " 0";
        try {
            Process p = Runtime.getRuntime().exec(execString);
        }
        catch (IOException ex) {
            MOut.G(this).println(" Failed " + ex);
            return;
        }
        MOut.G(this).println("Done");
        MOut.G(this).println("Please wait for iKVM window");
    }

    public void startKVM(int vmType, String port, String ip, String id, String pw, String BMCIP) {
        MOut.G(this).print("Starting iKVM Process...");
        File jre = new File("jre");
        String execString = jre.isDirectory() ? (System.getProperty("os.name").indexOf("Windows") >= 0 ? ".\\jre\\bin\\java -Djava.library.path=. -jar iKVM.jar " + ip + " " + id + " " + pw + " null " + port + " 623 " + vmType + " 0" + " --BMCIP" + BMCIP : "./jre/bin/java -Djava.library.path=. -jar iKVM.jar " + ip + " " + id + " " + pw + " null " + port + " 623 " + vmType + " 0" + " --BMCIP" + BMCIP) : "java -Djava.library.path=. -jar iKVM.jar " + ip + " " + id + " " + pw + " null " + port + " 623 " + vmType + " 0" + " --BMCIP" + BMCIP;
        try {
            Process p = Runtime.getRuntime().exec(execString);
        }
        catch (IOException ex) {
            MOut.G(this).println(" Failed " + ex);
            return;
        }
        MOut.G(this).println("Done");
        MOut.G(this).println("Please wait for iKVM window");
    }
}

