/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMB;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.blade.BladeEntity;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class BladeBMCUserDeleteCommand
extends SuperBladeCommand {
    byte userID;

    @Override
    public boolean preValidate() {
        int maxBladeSize = this.getBladeMaxSize();
        byte bladeIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (bladeIndex < 1 || bladeIndex > maxBladeSize) {
            MOut.G(this).println("blade Index out of range");
            return false;
        }
        String usage = "Usage: user delete <user id> \n";
        if (this.parameters == null || this.parameters.length != 1) {
            MOut.G(this).println(usage);
            return false;
        }
        try {
            this.userID = Byte.parseByte(this.parameters[0]);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).println("user id should be number");
            MOut.G(this).println(usage);
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        if (!this.isMaster) {
            this.printSlaveCMMUnavailableMessage();
            this.statusCode = 150;
            return;
        }
        BladeSystemEntity bladeSystem = new BladeSystemEntity(this.config);
        bladeSystem.setEnableAllQuery(false);
        bladeSystem.setIsQueryBladeEntity(true);
        bladeSystem.getData();
        if (!bladeSystem.isLoginSuccessful) {
            MOut.G(this).println("Login error!");
            this.statusCode = 146;
            return;
        }
        byte bladeIndex = Byte.parseByte((String)this.preParameters.get(1));
        BladeEntity bladeEntity = bladeSystem.getBlades()[bladeIndex - 1];
        if (bladeEntity.getPresent() == 0) {
            MOut.G(this).println("Blade " + bladeIndex + " is not presented");
            this.statusCode = 151;
            return;
        }
        if (bladeEntity.isSimCardDetectPin()) {
            IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(null);
            ipmiMessagingCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
            IPMB ipmb = new IPMB(ipmiMessagingCommand.getIPMIInterface());
            ipmb.setIpmbType(1);
            ipmiMessagingCommand.setIPMIInterface(ipmb);
            byte index = Byte.parseByte((String)this.preParameters.get(1));
            ipmb.setChannel(index);
            boolean b2 = ipmiMessagingCommand.setUserPasswordByID(this.userID, "");
            if (!b2) {
                MOut.G(this).println("Set user password failed");
                this.statusCode = 149;
                return;
            }
            boolean b3 = ipmiMessagingCommand.setUserPrivilegeByID(this.userID, (byte)15);
            if (!b3) {
                MOut.G(this).println("clear user privilege failed");
                this.statusCode = 149;
                return;
            }
            boolean b4 = ipmiMessagingCommand.setDisableUserByID(this.userID);
            if (!b4) {
                MOut.G(this).println("disable user failed");
                this.statusCode = 149;
                return;
            }
            boolean b5 = ipmiMessagingCommand.setDisableUserPlusByID(this.userID, (byte)15);
            if (!b5) {
                MOut.G(this).println("disable user(+) failed");
                this.statusCode = 149;
                return;
            }
            byte[] guid = ipmiMessagingCommand.getSystemGUID();
            boolean b1 = IPMIMessagingCommand.isAMIGUID(guid) || IPMIMessagingCommand.isAMISIMBLGUID(guid) || IPMIMessagingCommand.isAMIX9GUID(guid) ? ipmiMessagingCommand.clearUserNameByFill0XFF(this.userID) : ipmiMessagingCommand.setUserNameByID(this.userID, "");
            if (!b1) {
                MOut.G(this).println("clear user name failed");
                this.statusCode = 149;
                return;
            }
            MOut.G(this).println("Done");
            this.statusCode = 0;
        } else {
            MOut.G(this).println("BMC Not Installed");
            this.statusCode = 149;
        }
    }
}

